/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.xpath.XPathException;

public class Reverser
extends ComputedExpression {
    private Expression base;

    public Reverser(Expression expression) {
        this.base = expression;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public Expression simplify() throws XPathException {
        this.base = this.base.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.base = this.base.analyze(staticContext);
        return this;
    }

    public ItemType getItemType() {
        return this.base.getItemType();
    }

    public int computeSpecialProperties() {
        int n = this.base.getSpecialProperties();
        if ((n & 0x40000) != 0) {
            return n & 0xFFFBFFFF | 0x20000;
        }
        if ((n & 0x20000) != 0) {
            return n & 0xFFFDFFFF | 0x40000;
        }
        return n;
    }

    public int computeCardinality() {
        return this.base.getCardinality();
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.base};
        return expressionArray;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.base = this.base.promote(promotionOffer);
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.base.iterate(xPathContext);
        if (sequenceIterator instanceof ReversibleIterator) {
            return ((ReversibleIterator)sequenceIterator).getReverseIterator();
        }
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        return sequenceExtent.reverseIterate();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.base.effectiveBooleanValue(xPathContext);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "reverse order");
        this.base.display(n + 1, namePool);
    }
}

