// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

/*
Package database is a generated protocol buffer package.

It is generated from these files:
	google/spanner/admin/database/v1/spanner_database_admin.proto

It has these top-level messages:
	Database
	ListDatabasesRequest
	ListDatabasesResponse
	CreateDatabaseRequest
	CreateDatabaseMetadata
	GetDatabaseRequest
	UpdateDatabaseDdlRequest
	UpdateDatabaseDdlMetadata
	DropDatabaseRequest
	GetDatabaseDdlRequest
	GetDatabaseDdlResponse
*/
package database

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_iam_v11 "google.golang.org/genproto/googleapis/iam/v1"
import google_iam_v1 "google.golang.org/genproto/googleapis/iam/v1"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Indicates the current state of the database.
type Database_State int32

const (
	// Not specified.
	Database_STATE_UNSPECIFIED Database_State = 0
	// The database is still being created. Operations on the database may fail
	// with `FAILED_PRECONDITION` in this state.
	Database_CREATING Database_State = 1
	// The database is fully created and ready for use.
	Database_READY Database_State = 2
)

var Database_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
}
var Database_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
}

func (x Database_State) String() string {
	return proto.EnumName(Database_State_name, int32(x))
}
func (Database_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

// A Cloud Spanner database.
type Database struct {
	// Required. The name of the database. Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>`,
	// where `<database>` is as specified in the `CREATE DATABASE`
	// statement. This name can be passed to other API methods to
	// identify the database.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Output only. The current database state.
	State Database_State `protobuf:"varint,2,opt,name=state,enum=google.spanner.admin.database.v1.Database_State" json:"state,omitempty"`
}

func (m *Database) Reset()                    { *m = Database{} }
func (m *Database) String() string            { return proto.CompactTextString(m) }
func (*Database) ProtoMessage()               {}
func (*Database) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Database) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Database) GetState() Database_State {
	if m != nil {
		return m.State
	}
	return Database_STATE_UNSPECIFIED
}

// The request for [ListDatabases][google.spanner.admin.database.v1.DatabaseAdmin.ListDatabases].
type ListDatabasesRequest struct {
	// Required. The instance whose databases should be listed.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Number of databases to be returned in the response. If 0 or less,
	// defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.database.v1.ListDatabasesResponse.next_page_token] from a
	// previous [ListDatabasesResponse][google.spanner.admin.database.v1.ListDatabasesResponse].
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListDatabasesRequest) Reset()                    { *m = ListDatabasesRequest{} }
func (m *ListDatabasesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDatabasesRequest) ProtoMessage()               {}
func (*ListDatabasesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ListDatabasesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatabasesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatabasesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [ListDatabases][google.spanner.admin.database.v1.DatabaseAdmin.ListDatabases].
type ListDatabasesResponse struct {
	// Databases that matched the request.
	Databases []*Database `protobuf:"bytes,1,rep,name=databases" json:"databases,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListDatabases][google.spanner.admin.database.v1.DatabaseAdmin.ListDatabases] call to fetch more
	// of the matching databases.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListDatabasesResponse) Reset()                    { *m = ListDatabasesResponse{} }
func (m *ListDatabasesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDatabasesResponse) ProtoMessage()               {}
func (*ListDatabasesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListDatabasesResponse) GetDatabases() []*Database {
	if m != nil {
		return m.Databases
	}
	return nil
}

func (m *ListDatabasesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
type CreateDatabaseRequest struct {
	// Required. The name of the instance that will serve the new database.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. A `CREATE DATABASE` statement, which specifies the ID of the
	// new database.  The database ID must conform to the regular expression
	// `[a-z][a-z0-9_\-]*[a-z0-9]` and be between 2 and 30 characters in length.
	// If the database ID is a reserved word or if it contains a hyphen, the
	// database ID must be enclosed in backticks (`` ` ``).
	CreateStatement string `protobuf:"bytes,2,opt,name=create_statement,json=createStatement" json:"create_statement,omitempty"`
	// An optional list of DDL statements to run inside the newly created
	// database. Statements can create tables, indexes, etc. These
	// statements execute atomically with the creation of the database:
	// if there is an error in any statement, the database is not created.
	ExtraStatements []string `protobuf:"bytes,3,rep,name=extra_statements,json=extraStatements" json:"extra_statements,omitempty"`
}

func (m *CreateDatabaseRequest) Reset()                    { *m = CreateDatabaseRequest{} }
func (m *CreateDatabaseRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateDatabaseRequest) ProtoMessage()               {}
func (*CreateDatabaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *CreateDatabaseRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatabaseRequest) GetCreateStatement() string {
	if m != nil {
		return m.CreateStatement
	}
	return ""
}

func (m *CreateDatabaseRequest) GetExtraStatements() []string {
	if m != nil {
		return m.ExtraStatements
	}
	return nil
}

// Metadata type for the operation returned by
// [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
type CreateDatabaseMetadata struct {
	// The database being created.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
}

func (m *CreateDatabaseMetadata) Reset()                    { *m = CreateDatabaseMetadata{} }
func (m *CreateDatabaseMetadata) String() string            { return proto.CompactTextString(m) }
func (*CreateDatabaseMetadata) ProtoMessage()               {}
func (*CreateDatabaseMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *CreateDatabaseMetadata) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

// The request for [GetDatabase][google.spanner.admin.database.v1.DatabaseAdmin.GetDatabase].
type GetDatabaseRequest struct {
	// Required. The name of the requested database. Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetDatabaseRequest) Reset()                    { *m = GetDatabaseRequest{} }
func (m *GetDatabaseRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDatabaseRequest) ProtoMessage()               {}
func (*GetDatabaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GetDatabaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Enqueues the given DDL statements to be applied, in order but not
// necessarily all at once, to the database schema at some point (or
// points) in the future. The server checks that the statements
// are executable (syntactically valid, name tables that exist, etc.)
// before enqueueing them, but they may still fail upon
// later execution (e.g., if a statement from another batch of
// statements is applied first and it conflicts in some way, or if
// there is some data-related problem like a `NULL` value in a column to
// which `NOT NULL` would be added). If a statement fails, all
// subsequent statements in the batch are automatically cancelled.
//
// Each batch of statements is assigned a name which can be used with
// the [Operations][google.longrunning.Operations] API to monitor
// progress. See the
// [operation_id][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.operation_id] field for more
// details.
type UpdateDatabaseDdlRequest struct {
	// Required. The database to update.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// DDL statements to be applied to the database.
	Statements []string `protobuf:"bytes,2,rep,name=statements" json:"statements,omitempty"`
	// If empty, the new update request is assigned an
	// automatically-generated operation ID. Otherwise, `operation_id`
	// is used to construct the name of the resulting
	// [Operation][google.longrunning.Operation].
	//
	// Specifying an explicit operation ID simplifies determining
	// whether the statements were executed in the event that the
	// [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] call is replayed,
	// or the return value is otherwise lost: the [database][google.spanner.admin.database.v1.UpdateDatabaseDdlRequest.database] and
	// `operation_id` fields can be combined to form the
	// [name][google.longrunning.Operation.name] of the resulting
	// [longrunning.Operation][google.longrunning.Operation]: `<database>/operations/<operation_id>`.
	//
	// `operation_id` should be unique within the database, and must be
	// a valid identifier: `[a-z][a-z0-9_]*`. Note that
	// automatically-generated operation IDs always begin with an
	// underscore. If the named operation already exists,
	// [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl] returns
	// `ALREADY_EXISTS`.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
}

func (m *UpdateDatabaseDdlRequest) Reset()                    { *m = UpdateDatabaseDdlRequest{} }
func (m *UpdateDatabaseDdlRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateDatabaseDdlRequest) ProtoMessage()               {}
func (*UpdateDatabaseDdlRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *UpdateDatabaseDdlRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *UpdateDatabaseDdlRequest) GetStatements() []string {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *UpdateDatabaseDdlRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

// Metadata type for the operation returned by
// [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
type UpdateDatabaseDdlMetadata struct {
	// The database being modified.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
	// For an update this list contains all the statements. For an
	// individual statement, this list contains only that statement.
	Statements []string `protobuf:"bytes,2,rep,name=statements" json:"statements,omitempty"`
	// Reports the commit timestamps of all statements that have
	// succeeded so far, where `commit_timestamps[i]` is the commit
	// timestamp for the statement `statements[i]`.
	CommitTimestamps []*google_protobuf3.Timestamp `protobuf:"bytes,3,rep,name=commit_timestamps,json=commitTimestamps" json:"commit_timestamps,omitempty"`
}

func (m *UpdateDatabaseDdlMetadata) Reset()                    { *m = UpdateDatabaseDdlMetadata{} }
func (m *UpdateDatabaseDdlMetadata) String() string            { return proto.CompactTextString(m) }
func (*UpdateDatabaseDdlMetadata) ProtoMessage()               {}
func (*UpdateDatabaseDdlMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *UpdateDatabaseDdlMetadata) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *UpdateDatabaseDdlMetadata) GetStatements() []string {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *UpdateDatabaseDdlMetadata) GetCommitTimestamps() []*google_protobuf3.Timestamp {
	if m != nil {
		return m.CommitTimestamps
	}
	return nil
}

// The request for [DropDatabase][google.spanner.admin.database.v1.DatabaseAdmin.DropDatabase].
type DropDatabaseRequest struct {
	// Required. The database to be dropped.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
}

func (m *DropDatabaseRequest) Reset()                    { *m = DropDatabaseRequest{} }
func (m *DropDatabaseRequest) String() string            { return proto.CompactTextString(m) }
func (*DropDatabaseRequest) ProtoMessage()               {}
func (*DropDatabaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *DropDatabaseRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

// The request for [GetDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.GetDatabaseDdl].
type GetDatabaseDdlRequest struct {
	// Required. The database whose schema we wish to get.
	Database string `protobuf:"bytes,1,opt,name=database" json:"database,omitempty"`
}

func (m *GetDatabaseDdlRequest) Reset()                    { *m = GetDatabaseDdlRequest{} }
func (m *GetDatabaseDdlRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDatabaseDdlRequest) ProtoMessage()               {}
func (*GetDatabaseDdlRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *GetDatabaseDdlRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

// The response for [GetDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.GetDatabaseDdl].
type GetDatabaseDdlResponse struct {
	// A list of formatted DDL statements defining the schema of the database
	// specified in the request.
	Statements []string `protobuf:"bytes,1,rep,name=statements" json:"statements,omitempty"`
}

func (m *GetDatabaseDdlResponse) Reset()                    { *m = GetDatabaseDdlResponse{} }
func (m *GetDatabaseDdlResponse) String() string            { return proto.CompactTextString(m) }
func (*GetDatabaseDdlResponse) ProtoMessage()               {}
func (*GetDatabaseDdlResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GetDatabaseDdlResponse) GetStatements() []string {
	if m != nil {
		return m.Statements
	}
	return nil
}

func init() {
	proto.RegisterType((*Database)(nil), "google.spanner.admin.database.v1.Database")
	proto.RegisterType((*ListDatabasesRequest)(nil), "google.spanner.admin.database.v1.ListDatabasesRequest")
	proto.RegisterType((*ListDatabasesResponse)(nil), "google.spanner.admin.database.v1.ListDatabasesResponse")
	proto.RegisterType((*CreateDatabaseRequest)(nil), "google.spanner.admin.database.v1.CreateDatabaseRequest")
	proto.RegisterType((*CreateDatabaseMetadata)(nil), "google.spanner.admin.database.v1.CreateDatabaseMetadata")
	proto.RegisterType((*GetDatabaseRequest)(nil), "google.spanner.admin.database.v1.GetDatabaseRequest")
	proto.RegisterType((*UpdateDatabaseDdlRequest)(nil), "google.spanner.admin.database.v1.UpdateDatabaseDdlRequest")
	proto.RegisterType((*UpdateDatabaseDdlMetadata)(nil), "google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata")
	proto.RegisterType((*DropDatabaseRequest)(nil), "google.spanner.admin.database.v1.DropDatabaseRequest")
	proto.RegisterType((*GetDatabaseDdlRequest)(nil), "google.spanner.admin.database.v1.GetDatabaseDdlRequest")
	proto.RegisterType((*GetDatabaseDdlResponse)(nil), "google.spanner.admin.database.v1.GetDatabaseDdlResponse")
	proto.RegisterEnum("google.spanner.admin.database.v1.Database_State", Database_State_name, Database_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DatabaseAdmin service

type DatabaseAdminClient interface {
	// Lists Cloud Spanner databases.
	ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error)
	// Creates a new Cloud Spanner database and starts to prepare it for serving.
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<database_name>/operations/<operation_id>` and
	// can be used to track preparation of the database. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata]. The
	// [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets the state of a Cloud Spanner database.
	GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// Updates the schema of a Cloud Spanner database by
	// creating/altering/dropping tables, columns, indexes, etc. The returned
	// [long-running operation][google.longrunning.Operation] will have a name of
	// the format `<database_name>/operations/<operation_id>` and can be used to
	// track execution of the schema change(s). The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].  The operation has no response.
	UpdateDatabaseDdl(ctx context.Context, in *UpdateDatabaseDdlRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Drops (aka deletes) a Cloud Spanner database.
	DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Returns the schema of a Cloud Spanner database as a list of formatted
	// DDL statements. This method does not show pending schema updates, those may
	// be queried using the [Operations][google.longrunning.Operations] API.
	GetDatabaseDdl(ctx context.Context, in *GetDatabaseDdlRequest, opts ...grpc.CallOption) (*GetDatabaseDdlResponse, error)
	// Sets the access control policy on a database resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.databases.setIamPolicy` permission on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a database resource. Returns an empty
	// policy if a database exists but does not have a policy set.
	//
	// Authorization requires `spanner.databases.getIamPolicy` permission on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Returns permissions that the caller has on the specified database resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner database will result in
	// a NOT_FOUND error if the user has `spanner.databases.list` permission on
	// the containing Cloud Spanner instance. Otherwise returns an empty set of
	// permissions.
	TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error)
}

type databaseAdminClient struct {
	cc *grpc.ClientConn
}

func NewDatabaseAdminClient(cc *grpc.ClientConn) DatabaseAdminClient {
	return &databaseAdminClient{cc}
}

func (c *databaseAdminClient) ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error) {
	out := new(ListDatabasesResponse)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/ListDatabases", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/CreateDatabase", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabase", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) UpdateDatabaseDdl(ctx context.Context, in *UpdateDatabaseDdlRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateDatabaseDdl", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) DropDatabase(ctx context.Context, in *DropDatabaseRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/DropDatabase", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetDatabaseDdl(ctx context.Context, in *GetDatabaseDdlRequest, opts ...grpc.CallOption) (*GetDatabaseDdlResponse, error) {
	out := new(GetDatabaseDdlResponse)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabaseDdl", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseAdminClient) TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error) {
	out := new(google_iam_v11.TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.spanner.admin.database.v1.DatabaseAdmin/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for DatabaseAdmin service

type DatabaseAdminServer interface {
	// Lists Cloud Spanner databases.
	ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error)
	// Creates a new Cloud Spanner database and starts to prepare it for serving.
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<database_name>/operations/<operation_id>` and
	// can be used to track preparation of the database. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata]. The
	// [response][google.longrunning.Operation.response] field type is
	// [Database][google.spanner.admin.database.v1.Database], if successful.
	CreateDatabase(context.Context, *CreateDatabaseRequest) (*google_longrunning.Operation, error)
	// Gets the state of a Cloud Spanner database.
	GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error)
	// Updates the schema of a Cloud Spanner database by
	// creating/altering/dropping tables, columns, indexes, etc. The returned
	// [long-running operation][google.longrunning.Operation] will have a name of
	// the format `<database_name>/operations/<operation_id>` and can be used to
	// track execution of the schema change(s). The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].  The operation has no response.
	UpdateDatabaseDdl(context.Context, *UpdateDatabaseDdlRequest) (*google_longrunning.Operation, error)
	// Drops (aka deletes) a Cloud Spanner database.
	DropDatabase(context.Context, *DropDatabaseRequest) (*google_protobuf2.Empty, error)
	// Returns the schema of a Cloud Spanner database as a list of formatted
	// DDL statements. This method does not show pending schema updates, those may
	// be queried using the [Operations][google.longrunning.Operations] API.
	GetDatabaseDdl(context.Context, *GetDatabaseDdlRequest) (*GetDatabaseDdlResponse, error)
	// Sets the access control policy on a database resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.databases.setIamPolicy` permission on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(context.Context, *google_iam_v11.SetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Gets the access control policy for a database resource. Returns an empty
	// policy if a database exists but does not have a policy set.
	//
	// Authorization requires `spanner.databases.getIamPolicy` permission on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(context.Context, *google_iam_v11.GetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Returns permissions that the caller has on the specified database resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner database will result in
	// a NOT_FOUND error if the user has `spanner.databases.list` permission on
	// the containing Cloud Spanner instance. Otherwise returns an empty set of
	// permissions.
	TestIamPermissions(context.Context, *google_iam_v11.TestIamPermissionsRequest) (*google_iam_v11.TestIamPermissionsResponse, error)
}

func RegisterDatabaseAdminServer(s *grpc.Server, srv DatabaseAdminServer) {
	s.RegisterService(&_DatabaseAdmin_serviceDesc, srv)
}

func _DatabaseAdmin_ListDatabases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).ListDatabases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/ListDatabases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).ListDatabases(ctx, req.(*ListDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_CreateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).CreateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/CreateDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).CreateDatabase(ctx, req.(*CreateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetDatabase(ctx, req.(*GetDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_UpdateDatabaseDdl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatabaseDdlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).UpdateDatabaseDdl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/UpdateDatabaseDdl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).UpdateDatabaseDdl(ctx, req.(*UpdateDatabaseDdlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_DropDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DropDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).DropDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/DropDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).DropDatabase(ctx, req.(*DropDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetDatabaseDdl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseDdlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetDatabaseDdl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/GetDatabaseDdl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetDatabaseDdl(ctx, req.(*GetDatabaseDdlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).SetIamPolicy(ctx, req.(*google_iam_v11.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).GetIamPolicy(ctx, req.(*google_iam_v11.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.database.v1.DatabaseAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseAdminServer).TestIamPermissions(ctx, req.(*google_iam_v11.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatabaseAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.admin.database.v1.DatabaseAdmin",
	HandlerType: (*DatabaseAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDatabases",
			Handler:    _DatabaseAdmin_ListDatabases_Handler,
		},
		{
			MethodName: "CreateDatabase",
			Handler:    _DatabaseAdmin_CreateDatabase_Handler,
		},
		{
			MethodName: "GetDatabase",
			Handler:    _DatabaseAdmin_GetDatabase_Handler,
		},
		{
			MethodName: "UpdateDatabaseDdl",
			Handler:    _DatabaseAdmin_UpdateDatabaseDdl_Handler,
		},
		{
			MethodName: "DropDatabase",
			Handler:    _DatabaseAdmin_DropDatabase_Handler,
		},
		{
			MethodName: "GetDatabaseDdl",
			Handler:    _DatabaseAdmin_GetDatabaseDdl_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DatabaseAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DatabaseAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DatabaseAdmin_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/spanner/admin/database/v1/spanner_database_admin.proto",
}

func init() {
	proto.RegisterFile("google/spanner/admin/database/v1/spanner_database_admin.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1033 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x96, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0xc7, 0x19, 0xa7, 0xa9, 0x92, 0x17, 0x27, 0x75, 0x06, 0x1c, 0xb9, 0x5b, 0x5a, 0xcc, 0x82,
	0x2a, 0xd7, 0x12, 0xbb, 0xd8, 0x69, 0x48, 0x30, 0x0a, 0x22, 0xb5, 0x5d, 0xd7, 0x12, 0xb4, 0x96,
	0xed, 0x56, 0x02, 0x59, 0xb2, 0x26, 0xf6, 0xb0, 0xda, 0xe2, 0xfd, 0xc1, 0xce, 0xb8, 0x6a, 0x8b,
	0x7a, 0x41, 0xe2, 0xc0, 0x19, 0x90, 0xb8, 0x81, 0x38, 0x70, 0xe0, 0xc4, 0x0d, 0x89, 0x23, 0x47,
	0xae, 0xfc, 0x01, 0x5c, 0xf8, 0x43, 0xd0, 0xcc, 0xee, 0xd8, 0xeb, 0x75, 0x12, 0xdb, 0x1c, 0xb8,
	0x79, 0xdf, 0xfb, 0xbe, 0x79, 0x9f, 0x79, 0x3b, 0xdf, 0xf1, 0xc2, 0xb1, 0xe5, 0x79, 0xd6, 0x88,
	0x9a, 0xcc, 0x27, 0xae, 0x4b, 0x03, 0x93, 0x0c, 0x1d, 0xdb, 0x35, 0x87, 0x84, 0x93, 0x53, 0xc2,
	0xa8, 0xf9, 0xa4, 0xa4, 0x32, 0x7d, 0x15, 0xeb, 0x4b, 0x89, 0xe1, 0x07, 0x1e, 0xf7, 0x70, 0x3e,
	0x2c, 0x37, 0x22, 0x91, 0x11, 0xe6, 0x94, 0xd4, 0x78, 0x52, 0xd2, 0x5e, 0x8d, 0x1a, 0x10, 0xdf,
	0x36, 0x89, 0xeb, 0x7a, 0x9c, 0x70, 0xdb, 0x73, 0x59, 0x58, 0xaf, 0xdd, 0x88, 0xb2, 0x36, 0x71,
	0x44, 0x2f, 0x9b, 0x38, 0x7d, 0xdf, 0x1b, 0xd9, 0x83, 0x67, 0x51, 0x5e, 0x9b, 0xcd, 0xcf, 0xe4,
	0xde, 0x88, 0x72, 0x23, 0xcf, 0xb5, 0x82, 0xb1, 0xeb, 0xda, 0xae, 0x65, 0x7a, 0x3e, 0x0d, 0x66,
	0x1a, 0x5c, 0x8b, 0x44, 0xf2, 0xe9, 0x74, 0xfc, 0xa9, 0x49, 0x1d, 0x9f, 0xab, 0x15, 0x5e, 0x4b,
	0x26, 0xb9, 0xed, 0x50, 0xc6, 0x89, 0xe3, 0x87, 0x02, 0xfd, 0x07, 0x04, 0x1b, 0xb5, 0x68, 0x33,
	0x18, 0xc3, 0x25, 0x97, 0x38, 0x34, 0x87, 0xf2, 0xa8, 0xb0, 0xd9, 0x96, 0xbf, 0xf1, 0x5d, 0x58,
	0x67, 0x9c, 0x70, 0x9a, 0x4b, 0xe5, 0x51, 0x61, 0xa7, 0xfc, 0xb6, 0xb1, 0x68, 0x1e, 0x86, 0x5a,
	0xce, 0xe8, 0x88, 0xba, 0x76, 0x58, 0xae, 0x1f, 0xc2, 0xba, 0x7c, 0xc6, 0x59, 0xd8, 0xed, 0x74,
	0x4f, 0xba, 0xf5, 0xfe, 0xc3, 0xfb, 0x9d, 0x56, 0xbd, 0xda, 0xbc, 0xdb, 0xac, 0xd7, 0x32, 0x2f,
	0xe1, 0x34, 0x6c, 0x54, 0xdb, 0xf5, 0x93, 0x6e, 0xf3, 0x7e, 0x23, 0x83, 0xf0, 0x26, 0xac, 0xb7,
	0xeb, 0x27, 0xb5, 0x8f, 0x33, 0x29, 0xfd, 0x31, 0xbc, 0xf2, 0xa1, 0xcd, 0xb8, 0x5a, 0x95, 0xb5,
	0xe9, 0xe7, 0x63, 0xca, 0x38, 0xde, 0x83, 0xcb, 0x3e, 0x09, 0xa8, 0xcb, 0x23, 0xdc, 0xe8, 0x09,
	0x5f, 0x83, 0x4d, 0x9f, 0x58, 0xb4, 0xcf, 0xec, 0xe7, 0x34, 0xb7, 0x96, 0x47, 0x85, 0xf5, 0xf6,
	0x86, 0x08, 0x74, 0xec, 0xe7, 0x14, 0x5f, 0x07, 0x90, 0x49, 0xee, 0x7d, 0x46, 0xdd, 0xdc, 0x25,
	0x59, 0x28, 0xe5, 0x5d, 0x11, 0xd0, 0xbf, 0x46, 0x90, 0x4d, 0x34, 0x63, 0xbe, 0xe7, 0x32, 0x8a,
	0xef, 0xc1, 0xa6, 0xda, 0x23, 0xcb, 0xa1, 0xfc, 0x5a, 0x61, 0xab, 0x5c, 0x5c, 0x7e, 0x14, 0xed,
	0x69, 0x31, 0xbe, 0x09, 0x57, 0x5c, 0xfa, 0x94, 0xf7, 0x63, 0x1c, 0x29, 0xc9, 0xb1, 0x2d, 0xc2,
	0xad, 0x09, 0xcb, 0x57, 0x08, 0xb2, 0xd5, 0x80, 0x12, 0x4e, 0x27, 0xab, 0x2c, 0xd8, 0xf9, 0x2d,
	0xc8, 0x0c, 0x64, 0x41, 0x5f, 0x8e, 0xdc, 0x11, 0x8a, 0x70, 0xe9, 0x2b, 0x61, 0xbc, 0xa3, 0xc2,
	0x42, 0x4a, 0x9f, 0xf2, 0x80, 0x4c, 0x95, 0x2c, 0xb7, 0x96, 0x5f, 0x13, 0x52, 0x19, 0x9f, 0x28,
	0x99, 0x7e, 0x1b, 0xf6, 0x66, 0x31, 0x3e, 0xa2, 0x9c, 0x88, 0xed, 0x60, 0x0d, 0x36, 0xd4, 0xb6,
	0x22, 0x92, 0xc9, 0xb3, 0x5e, 0x00, 0xdc, 0xa0, 0x3c, 0x49, 0x7e, 0xc6, 0x01, 0xd3, 0x9f, 0x41,
	0xee, 0xa1, 0x3f, 0x8c, 0xad, 0x5f, 0x1b, 0x8e, 0x94, 0xfe, 0x82, 0x0e, 0xf8, 0x06, 0x40, 0x0c,
	0x3e, 0x25, 0xe1, 0x63, 0x11, 0xfc, 0x3a, 0xa4, 0x27, 0x5e, 0xe9, 0xdb, 0x43, 0x79, 0x14, 0x36,
	0xdb, 0x5b, 0x93, 0x58, 0x73, 0xa8, 0xff, 0x88, 0xe0, 0xea, 0x5c, 0xef, 0x65, 0xb6, 0xb7, 0xb0,
	0x79, 0x03, 0x76, 0x07, 0x9e, 0xe3, 0xd8, 0xbc, 0x3f, 0x31, 0x5c, 0x38, 0xe0, 0xad, 0xb2, 0xa6,
	0x8e, 0x8d, 0xf2, 0xa4, 0xd1, 0x55, 0x92, 0x76, 0x26, 0x2c, 0x9a, 0x04, 0x98, 0x5e, 0x82, 0x97,
	0x6b, 0x81, 0xe7, 0x27, 0x07, 0x79, 0xd1, 0xe8, 0xf7, 0x21, 0x1b, 0x1b, 0xfd, 0x72, 0xd3, 0xd4,
	0x8f, 0x60, 0x2f, 0x59, 0x14, 0x9d, 0xfc, 0xd9, 0xad, 0xa2, 0xe4, 0x56, 0xcb, 0xdf, 0xa5, 0x61,
	0x5b, 0xd5, 0x9d, 0x08, 0x07, 0xe0, 0xdf, 0x10, 0x6c, 0xcf, 0xb8, 0x08, 0xbf, 0xb3, 0xd8, 0x2a,
	0x67, 0x79, 0x5c, 0x3b, 0x5c, 0xb9, 0x2e, 0x84, 0xd6, 0x0f, 0xbe, 0xfc, 0xeb, 0x9f, 0x6f, 0x52,
	0x26, 0x7e, 0x4b, 0xdc, 0xa9, 0x5f, 0x84, 0xfe, 0x38, 0xf6, 0x03, 0xef, 0x31, 0x1d, 0x70, 0x66,
	0x16, 0x4d, 0xdb, 0x65, 0x9c, 0xb8, 0x03, 0xca, 0xcc, 0xe2, 0x0b, 0x73, 0xea, 0xcd, 0x9f, 0x10,
	0xec, 0xcc, 0x1e, 0x76, 0xbc, 0x04, 0xc2, 0x99, 0x2e, 0xd5, 0xae, 0xab, 0xc2, 0xd8, 0xed, 0x6d,
	0x3c, 0x50, 0xa7, 0x4f, 0x3f, 0x92, 0x84, 0x65, 0x7d, 0x35, 0xc2, 0x0a, 0x2a, 0xe2, 0x9f, 0x11,
	0x6c, 0xc5, 0xde, 0x15, 0xbe, 0xbd, 0x98, 0x70, 0xde, 0x8a, 0xda, 0x0a, 0xb7, 0x57, 0x62, 0x9a,
	0xc2, 0xb5, 0xe7, 0x90, 0x4e, 0x41, 0xcd, 0xe2, 0x0b, 0xfc, 0x2b, 0x82, 0xdd, 0x39, 0x7b, 0xe1,
	0xca, 0xe2, 0xc6, 0xe7, 0xdd, 0x07, 0x8b, 0x66, 0xfa, 0x81, 0xe4, 0xac, 0x94, 0x0f, 0x24, 0xa7,
	0x5a, 0x71, 0x19, 0x56, 0x73, 0x38, 0x1c, 0x89, 0xd9, 0x7e, 0x8f, 0x20, 0x1d, 0xf7, 0x1b, 0x3e,
	0x58, 0x62, 0x4c, 0xf3, 0xfe, 0xd4, 0xf6, 0xe6, 0x4c, 0x5e, 0x17, 0xff, 0xca, 0xfa, 0xbb, 0x92,
	0x70, 0xbf, 0x58, 0x5a, 0x99, 0x10, 0xff, 0x81, 0x60, 0x67, 0xd6, 0xa2, 0xcb, 0x9c, 0xcd, 0x33,
	0x6f, 0x02, 0xed, 0x68, 0xf5, 0xc2, 0xc8, 0x58, 0xc7, 0x72, 0x03, 0x87, 0xf8, 0xbf, 0x8d, 0x18,
	0x7f, 0x8b, 0x20, 0xdd, 0xa1, 0xbc, 0x49, 0x9c, 0x96, 0xfc, 0xd0, 0xc1, 0xba, 0x22, 0xb1, 0x89,
	0x23, 0xda, 0xc6, 0x93, 0x8a, 0x36, 0x9b, 0xd0, 0x84, 0x59, 0xbd, 0x29, 0x51, 0xaa, 0xfa, 0xfb,
	0x12, 0x25, 0xa0, 0xcc, 0x1b, 0x07, 0x83, 0xa5, 0x50, 0x2a, 0x2c, 0xd6, 0x45, 0xbc, 0x76, 0x81,
	0xd5, 0xb8, 0x08, 0xab, 0xf1, 0xbf, 0x60, 0x59, 0x09, 0xac, 0xdf, 0x11, 0xe0, 0x2e, 0x65, 0x32,
	0x48, 0x03, 0xc7, 0x66, 0x4c, 0x7c, 0xf7, 0xe1, 0x42, 0xa2, 0xf1, 0xbc, 0x44, 0x21, 0xde, 0x5a,
	0x42, 0x19, 0xbd, 0xd8, 0x07, 0x12, 0xbb, 0xa9, 0xd7, 0x56, 0xc7, 0xe6, 0x73, 0xab, 0x56, 0x50,
	0xf1, 0xce, 0xdf, 0x08, 0xde, 0x1c, 0x78, 0xce, 0xc2, 0x93, 0x76, 0xe7, 0x6a, 0x27, 0x4c, 0xcd,
	0xfc, 0x89, 0xb4, 0x84, 0x6f, 0x5a, 0xe8, 0x93, 0x7b, 0x51, 0xb9, 0xe5, 0x8d, 0x88, 0x6b, 0x19,
	0x5e, 0x60, 0x99, 0x16, 0x75, 0xa5, 0xab, 0xcc, 0x30, 0x45, 0x7c, 0x9b, 0x9d, 0xff, 0x71, 0xff,
	0x9e, 0xfa, 0xfd, 0x4b, 0xea, 0x66, 0x23, 0x5c, 0xaa, 0x3a, 0xf2, 0xc6, 0x43, 0x23, 0x6a, 0x6a,
	0xc8, 0x6e, 0xd3, 0x6f, 0xd6, 0x47, 0xa5, 0x3f, 0x95, 0xb0, 0x27, 0x85, 0xbd, 0x48, 0xd8, 0x93,
	0xc2, 0x9e, 0x12, 0xf6, 0x1e, 0x95, 0x4e, 0x2f, 0x4b, 0x8c, 0xfd, 0x7f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0x1d, 0xbc, 0x89, 0x54, 0x62, 0x0c, 0x00, 0x00,
}
