/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _nbio_7_11_0_OFFSET_HEADER
#define _nbio_7_11_0_OFFSET_HEADER



// addressBlock: nbio_iohub_nb_nbcfg_nb_cfgdec
// base address: 0x0
#define cfgNBCFG_SCRATCH_0                                                                              0x0068
#define cfgNBCFG_SCRATCH_1                                                                              0x006c
#define cfgNBCFG_SCRATCH_2                                                                              0x0070
#define cfgNBCFG_SCRATCH_3                                                                              0x0074
#define cfgNBCFG_SCRATCH_4                                                                              0x0078


// addressBlock: nbio_iohub_iommu_l2_iommul2cfg
// base address: 0x0


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x0
#define cfgPCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV                                                     0x0580


// addressBlock: nbio_iohub_nb_nbcfg_nb_cfgdec
// base address: 0x13b00000
#define regNB_NBCFG0_NB_VENDOR_ID                                                                       0xe80000
#define regNB_NBCFG0_NB_VENDOR_ID_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_DEVICE_ID                                                                       0xe80000
#define regNB_NBCFG0_NB_DEVICE_ID_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_COMMAND                                                                         0xe80001
#define regNB_NBCFG0_NB_COMMAND_BASE_IDX                                                                5
#define regNB_NBCFG0_NB_STATUS                                                                          0xe80001
#define regNB_NBCFG0_NB_STATUS_BASE_IDX                                                                 5
#define regNB_NBCFG0_NB_SUB_CLASS                                                                       0xe80002
#define regNB_NBCFG0_NB_SUB_CLASS_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_BASE_CODE                                                                       0xe80002
#define regNB_NBCFG0_NB_BASE_CODE_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_CACHE_LINE                                                                      0xe80003
#define regNB_NBCFG0_NB_CACHE_LINE_BASE_IDX                                                             5
#define regNB_NBCFG0_NB_LATENCY                                                                         0xe80003
#define regNB_NBCFG0_NB_LATENCY_BASE_IDX                                                                5
#define regNB_NBCFG0_NB_HEADER                                                                          0xe80003
#define regNB_NBCFG0_NB_HEADER_BASE_IDX                                                                 5
#define regNB_NBCFG0_NB_ADAPTER_ID                                                                      0xe8000b
#define regNB_NBCFG0_NB_ADAPTER_ID_BASE_IDX                                                             5
#define regNB_NBCFG0_NB_CAPABILITIES_PTR                                                                0xe8000d
#define regNB_NBCFG0_NB_CAPABILITIES_PTR_BASE_IDX                                                       5
#define regNB_NBCFG0_NB_HEADER_W                                                                        0xe80012
#define regNB_NBCFG0_NB_HEADER_W_BASE_IDX                                                               5
#define regNB_NBCFG0_NB_PCI_CTRL                                                                        0xe80013
#define regNB_NBCFG0_NB_PCI_CTRL_BASE_IDX                                                               5
#define regNB_NBCFG0_NB_ADAPTER_ID_W                                                                    0xe80014
#define regNB_NBCFG0_NB_ADAPTER_ID_W_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_0                                                                    0xe8001a
#define regNB_NBCFG0_NBCFG_SCRATCH_0_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_1                                                                    0xe8001b
#define regNB_NBCFG0_NBCFG_SCRATCH_1_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_2                                                                    0xe8001c
#define regNB_NBCFG0_NBCFG_SCRATCH_2_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_3                                                                    0xe8001d
#define regNB_NBCFG0_NBCFG_SCRATCH_3_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_4                                                                    0xe8001e
#define regNB_NBCFG0_NBCFG_SCRATCH_4_BASE_IDX                                                           5
#define regNB_NBCFG0_NB_PCI_ARB                                                                         0xe80021
#define regNB_NBCFG0_NB_PCI_ARB_BASE_IDX                                                                5
#define regNB_NBCFG0_NB_DRAM_SLOT1_BASE                                                                 0xe80022
#define regNB_NBCFG0_NB_DRAM_SLOT1_BASE_BASE_IDX                                                        5
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX0                                                               0xe8002a
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX0_BASE_IDX                                                      5
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX1                                                               0xe8002b
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX1_BASE_IDX                                                      5
#define regNB_NBCFG0_NB_VENDOR_ID_W                                                                     0xe80040
#define regNB_NBCFG0_NB_VENDOR_ID_W_BASE_IDX                                                            5
#define regNB_NBCFG0_NB_DEVICE_ID_W                                                                     0xe80040
#define regNB_NBCFG0_NB_DEVICE_ID_W_BASE_IDX                                                            5


// addressBlock: nbio_iohub_nb_fastreg_fastreg_cfgdec
// base address: 0x13b07000
#define regFASTREG_APERTURE                                                                             0xe81c00
#define regFASTREG_APERTURE_BASE_IDX                                                                    5


// addressBlock: nbio_iohub_nb_misc_misc_cfgdec
// base address: 0x13b10000
#define regNB_CNTL                                                                                      0xe84000
#define regNB_CNTL_BASE_IDX                                                                             5
#define regNB_SPARE1                                                                                    0xe84003
#define regNB_SPARE1_BASE_IDX                                                                           5
#define regNB_SPARE2                                                                                    0xe84004
#define regNB_SPARE2_BASE_IDX                                                                           5
#define regNB_REVID                                                                                     0xe84005
#define regNB_REVID_BASE_IDX                                                                            5
#define regNBIO_LCLK_DS_MASK                                                                            0xe84009
#define regNBIO_LCLK_DS_MASK_BASE_IDX                                                                   5
#define regNB_BUS_NUM_CNTL                                                                              0xe84015
#define regNB_BUS_NUM_CNTL_BASE_IDX                                                                     5
#define regNB_MMIOBASE                                                                                  0xe84019
#define regNB_MMIOBASE_BASE_IDX                                                                         5
#define regNB_MMIOLIMIT                                                                                 0xe8401a
#define regNB_MMIOLIMIT_BASE_IDX                                                                        5
#define regNB_LOWER_TOP_OF_DRAM2                                                                        0xe8401b
#define regNB_LOWER_TOP_OF_DRAM2_BASE_IDX                                                               5
#define regNB_UPPER_TOP_OF_DRAM2                                                                        0xe8401c
#define regNB_UPPER_TOP_OF_DRAM2_BASE_IDX                                                               5
#define regNB_LOWER_DRAM2_BASE                                                                          0xe8401d
#define regNB_LOWER_DRAM2_BASE_BASE_IDX                                                                 5
#define regNB_UPPER_DRAM2_BASE                                                                          0xe8401e
#define regNB_UPPER_DRAM2_BASE_BASE_IDX                                                                 5
#define regSB_LOCATION                                                                                  0xe8401f
#define regSB_LOCATION_BASE_IDX                                                                         5
#define regSW_US_LOCATION                                                                               0xe84020
#define regSW_US_LOCATION_BASE_IDX                                                                      5
#define regSW_NMI_CNTL                                                                                  0xe84042
#define regSW_NMI_CNTL_BASE_IDX                                                                         5
#define regSW_SMI_CNTL                                                                                  0xe84043
#define regSW_SMI_CNTL_BASE_IDX                                                                         5
#define regSW_SCI_CNTL                                                                                  0xe84044
#define regSW_SCI_CNTL_BASE_IDX                                                                         5
#define regAPML_SW_STATUS                                                                               0xe84045
#define regAPML_SW_STATUS_BASE_IDX                                                                      5
#define regSW_GIC_SPI_CNTL                                                                              0xe84047
#define regSW_GIC_SPI_CNTL_BASE_IDX                                                                     5
#define regSW_SYNCFLOOD_CNTL                                                                            0xe84049
#define regSW_SYNCFLOOD_CNTL_BASE_IDX                                                                   5
#define regNB_TOP_OF_DRAM3                                                                              0xe8404e
#define regNB_TOP_OF_DRAM3_BASE_IDX                                                                     5
#define regCAM_CONTROL                                                                                  0xe84052
#define regCAM_CONTROL_BASE_IDX                                                                         5
#define regCAM_TARGET_INDEX_ADDR_BOTTOM                                                                 0xe84053
#define regCAM_TARGET_INDEX_ADDR_BOTTOM_BASE_IDX                                                        5
#define regCAM_TARGET_INDEX_ADDR_TOP                                                                    0xe84054
#define regCAM_TARGET_INDEX_ADDR_TOP_BASE_IDX                                                           5
#define regCAM_TARGET_INDEX_DATA                                                                        0xe84055
#define regCAM_TARGET_INDEX_DATA_BASE_IDX                                                               5
#define regCAM_TARGET_INDEX_DATA_MASK                                                                   0xe84056
#define regCAM_TARGET_INDEX_DATA_MASK_BASE_IDX                                                          5
#define regCAM_TARGET_DATA_ADDR_BOTTOM                                                                  0xe84057
#define regCAM_TARGET_DATA_ADDR_BOTTOM_BASE_IDX                                                         5
#define regCAM_TARGET_DATA_ADDR_TOP                                                                     0xe84059
#define regCAM_TARGET_DATA_ADDR_TOP_BASE_IDX                                                            5
#define regCAM_TARGET_DATA                                                                              0xe8405a
#define regCAM_TARGET_DATA_BASE_IDX                                                                     5
#define regCAM_TARGET_DATA_MASK                                                                         0xe8405b
#define regCAM_TARGET_DATA_MASK_BASE_IDX                                                                5
#define regPCIE_VDM_NODE0_CTRL4                                                                         0xe84064
#define regPCIE_VDM_NODE0_CTRL4_BASE_IDX                                                                5
#define regPCIE_VDM_CNTL2                                                                               0xe8408c
#define regPCIE_VDM_CNTL2_BASE_IDX                                                                      5
#define regPCIE_VDM_CNTL3                                                                               0xe8408d
#define regPCIE_VDM_CNTL3_BASE_IDX                                                                      5
#define regSTALL_CONTROL_XBARPORT0_0                                                                    0xe84090
#define regSTALL_CONTROL_XBARPORT0_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT0_1                                                                    0xe84091
#define regSTALL_CONTROL_XBARPORT0_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT1_0                                                                    0xe84093
#define regSTALL_CONTROL_XBARPORT1_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT1_1                                                                    0xe84094
#define regSTALL_CONTROL_XBARPORT1_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT2_0                                                                    0xe84096
#define regSTALL_CONTROL_XBARPORT2_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT2_1                                                                    0xe84097
#define regSTALL_CONTROL_XBARPORT2_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT3_0                                                                    0xe84099
#define regSTALL_CONTROL_XBARPORT3_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT3_1                                                                    0xe8409a
#define regSTALL_CONTROL_XBARPORT3_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT4_0                                                                    0xe8409c
#define regSTALL_CONTROL_XBARPORT4_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT4_1                                                                    0xe8409d
#define regSTALL_CONTROL_XBARPORT4_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT5_0                                                                    0xe8409f
#define regSTALL_CONTROL_XBARPORT5_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT5_1                                                                    0xe840a0
#define regSTALL_CONTROL_XBARPORT5_1_BASE_IDX                                                           5
#define regNB_DRAM3_BASE                                                                                0xe840b1
#define regNB_DRAM3_BASE_BASE_IDX                                                                       5
#define regPSP_BASE_ADDR_LO                                                                             0xe840b8
#define regPSP_BASE_ADDR_LO_BASE_IDX                                                                    5
#define regPSP_BASE_ADDR_HI                                                                             0xe840b9
#define regPSP_BASE_ADDR_HI_BASE_IDX                                                                    5
#define regSMU_BASE_ADDR_LO                                                                             0xe840ba
#define regSMU_BASE_ADDR_LO_BASE_IDX                                                                    5
#define regSMU_BASE_ADDR_HI                                                                             0xe840bb
#define regSMU_BASE_ADDR_HI_BASE_IDX                                                                    5
#define regFASTREG_BASE_ADDR_LO                                                                         0xe840c0
#define regFASTREG_BASE_ADDR_LO_BASE_IDX                                                                5
#define regFASTREG_BASE_ADDR_HI                                                                         0xe840c1
#define regFASTREG_BASE_ADDR_HI_BASE_IDX                                                                5
#define regFASTREGCNTL_BASE_ADDR_LO                                                                     0xe840c2
#define regFASTREGCNTL_BASE_ADDR_LO_BASE_IDX                                                            5
#define regFASTREGCNTL_BASE_ADDR_HI                                                                     0xe840c3
#define regFASTREGCNTL_BASE_ADDR_HI_BASE_IDX                                                            5
#define regMISC0_BASE_ADDR_LO                                                                           0xe840d8
#define regMISC0_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC0_BASE_ADDR_HI                                                                           0xe840d9
#define regMISC0_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regMISC1_BASE_ADDR_LO                                                                           0xe840da
#define regMISC1_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC1_BASE_ADDR_HI                                                                           0xe840db
#define regMISC1_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regMISC2_BASE_ADDR_LO                                                                           0xe840dc
#define regMISC2_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC2_BASE_ADDR_HI                                                                           0xe840dd
#define regMISC2_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regMISC3_BASE_ADDR_LO                                                                           0xe840de
#define regMISC3_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC3_BASE_ADDR_HI                                                                           0xe840df
#define regMISC3_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regSCRATCH_4                                                                                    0xe840fc
#define regSCRATCH_4_BASE_IDX                                                                           5
#define regSCRATCH_5                                                                                    0xe840fd
#define regSCRATCH_5_BASE_IDX                                                                           5
#define regSMU_BLOCK_CPU                                                                                0xe840fe
#define regSMU_BLOCK_CPU_BASE_IDX                                                                       5
#define regSMU_BLOCK_CPU_STATUS                                                                         0xe840ff
#define regSMU_BLOCK_CPU_STATUS_BASE_IDX                                                                5
#define regTRAP_STATUS                                                                                  0xe84100
#define regTRAP_STATUS_BASE_IDX                                                                         5
#define regTRAP_REQUEST0                                                                                0xe84101
#define regTRAP_REQUEST0_BASE_IDX                                                                       5
#define regTRAP_REQUEST1                                                                                0xe84102
#define regTRAP_REQUEST1_BASE_IDX                                                                       5
#define regTRAP_REQUEST2                                                                                0xe84103
#define regTRAP_REQUEST2_BASE_IDX                                                                       5
#define regTRAP_REQUEST3                                                                                0xe84104
#define regTRAP_REQUEST3_BASE_IDX                                                                       5
#define regTRAP_REQUEST4                                                                                0xe84105
#define regTRAP_REQUEST4_BASE_IDX                                                                       5
#define regTRAP_REQUEST5                                                                                0xe84106
#define regTRAP_REQUEST5_BASE_IDX                                                                       5
#define regTRAP_REQUEST_DATASTRB0                                                                       0xe84108
#define regTRAP_REQUEST_DATASTRB0_BASE_IDX                                                              5
#define regTRAP_REQUEST_DATASTRB1                                                                       0xe84109
#define regTRAP_REQUEST_DATASTRB1_BASE_IDX                                                              5
#define regTRAP_REQUEST_DATA0                                                                           0xe84110
#define regTRAP_REQUEST_DATA0_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA1                                                                           0xe84111
#define regTRAP_REQUEST_DATA1_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA2                                                                           0xe84112
#define regTRAP_REQUEST_DATA2_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA3                                                                           0xe84113
#define regTRAP_REQUEST_DATA3_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA4                                                                           0xe84114
#define regTRAP_REQUEST_DATA4_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA5                                                                           0xe84115
#define regTRAP_REQUEST_DATA5_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA6                                                                           0xe84116
#define regTRAP_REQUEST_DATA6_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA7                                                                           0xe84117
#define regTRAP_REQUEST_DATA7_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA8                                                                           0xe84118
#define regTRAP_REQUEST_DATA8_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA9                                                                           0xe84119
#define regTRAP_REQUEST_DATA9_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA10                                                                          0xe8411a
#define regTRAP_REQUEST_DATA10_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA11                                                                          0xe8411b
#define regTRAP_REQUEST_DATA11_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA12                                                                          0xe8411c
#define regTRAP_REQUEST_DATA12_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA13                                                                          0xe8411d
#define regTRAP_REQUEST_DATA13_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA14                                                                          0xe8411e
#define regTRAP_REQUEST_DATA14_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA15                                                                          0xe8411f
#define regTRAP_REQUEST_DATA15_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_CONTROL                                                                        0xe84130
#define regTRAP_RESPONSE_CONTROL_BASE_IDX                                                               5
#define regTRAP_RESPONSE0                                                                               0xe84131
#define regTRAP_RESPONSE0_BASE_IDX                                                                      5
#define regTRAP_RESPONSE_DATA0                                                                          0xe84140
#define regTRAP_RESPONSE_DATA0_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA1                                                                          0xe84141
#define regTRAP_RESPONSE_DATA1_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA2                                                                          0xe84142
#define regTRAP_RESPONSE_DATA2_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA3                                                                          0xe84143
#define regTRAP_RESPONSE_DATA3_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA4                                                                          0xe84144
#define regTRAP_RESPONSE_DATA4_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA5                                                                          0xe84145
#define regTRAP_RESPONSE_DATA5_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA6                                                                          0xe84146
#define regTRAP_RESPONSE_DATA6_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA7                                                                          0xe84147
#define regTRAP_RESPONSE_DATA7_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA8                                                                          0xe84148
#define regTRAP_RESPONSE_DATA8_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA9                                                                          0xe84149
#define regTRAP_RESPONSE_DATA9_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA10                                                                         0xe8414a
#define regTRAP_RESPONSE_DATA10_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA11                                                                         0xe8414b
#define regTRAP_RESPONSE_DATA11_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA12                                                                         0xe8414c
#define regTRAP_RESPONSE_DATA12_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA13                                                                         0xe8414d
#define regTRAP_RESPONSE_DATA13_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA14                                                                         0xe8414e
#define regTRAP_RESPONSE_DATA14_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA15                                                                         0xe8414f
#define regTRAP_RESPONSE_DATA15_BASE_IDX                                                                5
#define regTRAP0_CONTROL0                                                                               0xe84200
#define regTRAP0_CONTROL0_BASE_IDX                                                                      5
#define regTRAP0_ADDRESS_LO                                                                             0xe84202
#define regTRAP0_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP0_ADDRESS_HI                                                                             0xe84203
#define regTRAP0_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP0_COMMAND                                                                                0xe84204
#define regTRAP0_COMMAND_BASE_IDX                                                                       5
#define regTRAP0_ADDRESS_LO_MASK                                                                        0xe84206
#define regTRAP0_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP0_ADDRESS_HI_MASK                                                                        0xe84207
#define regTRAP0_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP0_COMMAND_MASK                                                                           0xe84208
#define regTRAP0_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP1_CONTROL0                                                                               0xe84210
#define regTRAP1_CONTROL0_BASE_IDX                                                                      5
#define regTRAP1_ADDRESS_LO                                                                             0xe84212
#define regTRAP1_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP1_ADDRESS_HI                                                                             0xe84213
#define regTRAP1_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP1_COMMAND                                                                                0xe84214
#define regTRAP1_COMMAND_BASE_IDX                                                                       5
#define regTRAP1_ADDRESS_LO_MASK                                                                        0xe84216
#define regTRAP1_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP1_ADDRESS_HI_MASK                                                                        0xe84217
#define regTRAP1_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP1_COMMAND_MASK                                                                           0xe84218
#define regTRAP1_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP2_CONTROL0                                                                               0xe84220
#define regTRAP2_CONTROL0_BASE_IDX                                                                      5
#define regTRAP2_ADDRESS_LO                                                                             0xe84222
#define regTRAP2_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP2_ADDRESS_HI                                                                             0xe84223
#define regTRAP2_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP2_COMMAND                                                                                0xe84224
#define regTRAP2_COMMAND_BASE_IDX                                                                       5
#define regTRAP2_ADDRESS_LO_MASK                                                                        0xe84226
#define regTRAP2_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP2_ADDRESS_HI_MASK                                                                        0xe84227
#define regTRAP2_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP2_COMMAND_MASK                                                                           0xe84228
#define regTRAP2_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP3_CONTROL0                                                                               0xe84230
#define regTRAP3_CONTROL0_BASE_IDX                                                                      5
#define regTRAP3_ADDRESS_LO                                                                             0xe84232
#define regTRAP3_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP3_ADDRESS_HI                                                                             0xe84233
#define regTRAP3_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP3_COMMAND                                                                                0xe84234
#define regTRAP3_COMMAND_BASE_IDX                                                                       5
#define regTRAP3_ADDRESS_LO_MASK                                                                        0xe84236
#define regTRAP3_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP3_ADDRESS_HI_MASK                                                                        0xe84237
#define regTRAP3_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP3_COMMAND_MASK                                                                           0xe84238
#define regTRAP3_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP4_CONTROL0                                                                               0xe84240
#define regTRAP4_CONTROL0_BASE_IDX                                                                      5
#define regTRAP4_ADDRESS_LO                                                                             0xe84242
#define regTRAP4_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP4_ADDRESS_HI                                                                             0xe84243
#define regTRAP4_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP4_COMMAND                                                                                0xe84244
#define regTRAP4_COMMAND_BASE_IDX                                                                       5
#define regTRAP4_ADDRESS_LO_MASK                                                                        0xe84246
#define regTRAP4_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP4_ADDRESS_HI_MASK                                                                        0xe84247
#define regTRAP4_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP4_COMMAND_MASK                                                                           0xe84248
#define regTRAP4_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP5_CONTROL0                                                                               0xe84250
#define regTRAP5_CONTROL0_BASE_IDX                                                                      5
#define regTRAP5_ADDRESS_LO                                                                             0xe84252
#define regTRAP5_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP5_ADDRESS_HI                                                                             0xe84253
#define regTRAP5_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP5_COMMAND                                                                                0xe84254
#define regTRAP5_COMMAND_BASE_IDX                                                                       5
#define regTRAP5_ADDRESS_LO_MASK                                                                        0xe84256
#define regTRAP5_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP5_ADDRESS_HI_MASK                                                                        0xe84257
#define regTRAP5_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP5_COMMAND_MASK                                                                           0xe84258
#define regTRAP5_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP6_CONTROL0                                                                               0xe84260
#define regTRAP6_CONTROL0_BASE_IDX                                                                      5
#define regTRAP6_ADDRESS_LO                                                                             0xe84262
#define regTRAP6_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP6_ADDRESS_HI                                                                             0xe84263
#define regTRAP6_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP6_COMMAND                                                                                0xe84264
#define regTRAP6_COMMAND_BASE_IDX                                                                       5
#define regTRAP6_ADDRESS_LO_MASK                                                                        0xe84266
#define regTRAP6_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP6_ADDRESS_HI_MASK                                                                        0xe84267
#define regTRAP6_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP6_COMMAND_MASK                                                                           0xe84268
#define regTRAP6_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP7_CONTROL0                                                                               0xe84270
#define regTRAP7_CONTROL0_BASE_IDX                                                                      5
#define regTRAP7_ADDRESS_LO                                                                             0xe84272
#define regTRAP7_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP7_ADDRESS_HI                                                                             0xe84273
#define regTRAP7_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP7_COMMAND                                                                                0xe84274
#define regTRAP7_COMMAND_BASE_IDX                                                                       5
#define regTRAP7_ADDRESS_LO_MASK                                                                        0xe84276
#define regTRAP7_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP7_ADDRESS_HI_MASK                                                                        0xe84277
#define regTRAP7_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP7_COMMAND_MASK                                                                           0xe84278
#define regTRAP7_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP8_CONTROL0                                                                               0xe84280
#define regTRAP8_CONTROL0_BASE_IDX                                                                      5
#define regTRAP8_ADDRESS_LO                                                                             0xe84282
#define regTRAP8_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP8_ADDRESS_HI                                                                             0xe84283
#define regTRAP8_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP8_COMMAND                                                                                0xe84284
#define regTRAP8_COMMAND_BASE_IDX                                                                       5
#define regTRAP8_ADDRESS_LO_MASK                                                                        0xe84286
#define regTRAP8_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP8_ADDRESS_HI_MASK                                                                        0xe84287
#define regTRAP8_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP8_COMMAND_MASK                                                                           0xe84288
#define regTRAP8_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP9_CONTROL0                                                                               0xe84290
#define regTRAP9_CONTROL0_BASE_IDX                                                                      5
#define regTRAP9_ADDRESS_LO                                                                             0xe84292
#define regTRAP9_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP9_ADDRESS_HI                                                                             0xe84293
#define regTRAP9_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP9_COMMAND                                                                                0xe84294
#define regTRAP9_COMMAND_BASE_IDX                                                                       5
#define regTRAP9_ADDRESS_LO_MASK                                                                        0xe84296
#define regTRAP9_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP9_ADDRESS_HI_MASK                                                                        0xe84297
#define regTRAP9_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP9_COMMAND_MASK                                                                           0xe84298
#define regTRAP9_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP10_CONTROL0                                                                              0xe842a0
#define regTRAP10_CONTROL0_BASE_IDX                                                                     5
#define regTRAP10_ADDRESS_LO                                                                            0xe842a2
#define regTRAP10_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP10_ADDRESS_HI                                                                            0xe842a3
#define regTRAP10_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP10_COMMAND                                                                               0xe842a4
#define regTRAP10_COMMAND_BASE_IDX                                                                      5
#define regTRAP10_ADDRESS_LO_MASK                                                                       0xe842a6
#define regTRAP10_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP10_ADDRESS_HI_MASK                                                                       0xe842a7
#define regTRAP10_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP10_COMMAND_MASK                                                                          0xe842a8
#define regTRAP10_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP11_CONTROL0                                                                              0xe842b0
#define regTRAP11_CONTROL0_BASE_IDX                                                                     5
#define regTRAP11_ADDRESS_LO                                                                            0xe842b2
#define regTRAP11_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP11_ADDRESS_HI                                                                            0xe842b3
#define regTRAP11_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP11_COMMAND                                                                               0xe842b4
#define regTRAP11_COMMAND_BASE_IDX                                                                      5
#define regTRAP11_ADDRESS_LO_MASK                                                                       0xe842b6
#define regTRAP11_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP11_ADDRESS_HI_MASK                                                                       0xe842b7
#define regTRAP11_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP11_COMMAND_MASK                                                                          0xe842b8
#define regTRAP11_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP12_CONTROL0                                                                              0xe842c0
#define regTRAP12_CONTROL0_BASE_IDX                                                                     5
#define regTRAP12_ADDRESS_LO                                                                            0xe842c2
#define regTRAP12_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP12_ADDRESS_HI                                                                            0xe842c3
#define regTRAP12_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP12_COMMAND                                                                               0xe842c4
#define regTRAP12_COMMAND_BASE_IDX                                                                      5
#define regTRAP12_ADDRESS_LO_MASK                                                                       0xe842c6
#define regTRAP12_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP12_ADDRESS_HI_MASK                                                                       0xe842c7
#define regTRAP12_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP12_COMMAND_MASK                                                                          0xe842c8
#define regTRAP12_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP13_CONTROL0                                                                              0xe842d0
#define regTRAP13_CONTROL0_BASE_IDX                                                                     5
#define regTRAP13_ADDRESS_LO                                                                            0xe842d2
#define regTRAP13_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP13_ADDRESS_HI                                                                            0xe842d3
#define regTRAP13_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP13_COMMAND                                                                               0xe842d4
#define regTRAP13_COMMAND_BASE_IDX                                                                      5
#define regTRAP13_ADDRESS_LO_MASK                                                                       0xe842d6
#define regTRAP13_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP13_ADDRESS_HI_MASK                                                                       0xe842d7
#define regTRAP13_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP13_COMMAND_MASK                                                                          0xe842d8
#define regTRAP13_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP14_CONTROL0                                                                              0xe842e0
#define regTRAP14_CONTROL0_BASE_IDX                                                                     5
#define regTRAP14_ADDRESS_LO                                                                            0xe842e2
#define regTRAP14_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP14_ADDRESS_HI                                                                            0xe842e3
#define regTRAP14_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP14_COMMAND                                                                               0xe842e4
#define regTRAP14_COMMAND_BASE_IDX                                                                      5
#define regTRAP14_ADDRESS_LO_MASK                                                                       0xe842e6
#define regTRAP14_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP14_ADDRESS_HI_MASK                                                                       0xe842e7
#define regTRAP14_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP14_COMMAND_MASK                                                                          0xe842e8
#define regTRAP14_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP15_CONTROL0                                                                              0xe842f0
#define regTRAP15_CONTROL0_BASE_IDX                                                                     5
#define regTRAP15_ADDRESS_LO                                                                            0xe842f2
#define regTRAP15_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP15_ADDRESS_HI                                                                            0xe842f3
#define regTRAP15_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP15_COMMAND                                                                               0xe842f4
#define regTRAP15_COMMAND_BASE_IDX                                                                      5
#define regTRAP15_ADDRESS_LO_MASK                                                                       0xe842f6
#define regTRAP15_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP15_ADDRESS_HI_MASK                                                                       0xe842f7
#define regTRAP15_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP15_COMMAND_MASK                                                                          0xe842f8
#define regTRAP15_COMMAND_MASK_BASE_IDX                                                                 5
#define regSB_COMMAND                                                                                   0xe85000
#define regSB_COMMAND_BASE_IDX                                                                          5
#define regSB_SUB_BUS_NUMBER_LATENCY                                                                    0xe85001
#define regSB_SUB_BUS_NUMBER_LATENCY_BASE_IDX                                                           5
#define regSB_IO_BASE_LIMIT                                                                             0xe85002
#define regSB_IO_BASE_LIMIT_BASE_IDX                                                                    5
#define regSB_MEM_BASE_LIMIT                                                                            0xe85003
#define regSB_MEM_BASE_LIMIT_BASE_IDX                                                                   5
#define regSB_PREF_BASE_LIMIT                                                                           0xe85004
#define regSB_PREF_BASE_LIMIT_BASE_IDX                                                                  5
#define regSB_PREF_BASE_UPPER                                                                           0xe85005
#define regSB_PREF_BASE_UPPER_BASE_IDX                                                                  5
#define regSB_PREF_LIMIT_UPPER                                                                          0xe85006
#define regSB_PREF_LIMIT_UPPER_BASE_IDX                                                                 5
#define regSB_IO_BASE_LIMIT_HI                                                                          0xe85007
#define regSB_IO_BASE_LIMIT_HI_BASE_IDX                                                                 5
#define regSB_IRQ_BRIDGE_CNTL                                                                           0xe85008
#define regSB_IRQ_BRIDGE_CNTL_BASE_IDX                                                                  5
#define regSB_EXT_BRIDGE_CNTL                                                                           0xe85009
#define regSB_EXT_BRIDGE_CNTL_BASE_IDX                                                                  5
#define regSB_PMI_STATUS_CNTL                                                                           0xe8500a
#define regSB_PMI_STATUS_CNTL_BASE_IDX                                                                  5
#define regSB_SLOT_CAP                                                                                  0xe8500b
#define regSB_SLOT_CAP_BASE_IDX                                                                         5
#define regSB_ROOT_CNTL                                                                                 0xe8500c
#define regSB_ROOT_CNTL_BASE_IDX                                                                        5
#define regSB_DEVICE_CNTL2                                                                              0xe8500d
#define regSB_DEVICE_CNTL2_BASE_IDX                                                                     5
#define regUSB_QoS_CNTL                                                                                 0xe85011
#define regUSB_QoS_CNTL_BASE_IDX                                                                        5
#define regMCA_SMN_INT_REQ_ADDR                                                                         0xe85020
#define regMCA_SMN_INT_REQ_ADDR_BASE_IDX                                                                5
#define regMCA_SMN_INT_MCM_ADDR                                                                         0xe85021
#define regMCA_SMN_INT_MCM_ADDR_BASE_IDX                                                                5
#define regMCA_SMN_INT_APERTUREID                                                                       0xe85022
#define regMCA_SMN_INT_APERTUREID_BASE_IDX                                                              5
#define regMCA_SMN_INT_CONTROL                                                                          0xe85023
#define regMCA_SMN_INT_CONTROL_BASE_IDX                                                                 5


// addressBlock: nbio_iohub_nb_rascfg_ras_cfgdec
// base address: 0x13b20000
#define regPARITY_CONTROL_0                                                                             0xe88000
#define regPARITY_CONTROL_0_BASE_IDX                                                                    5
#define regPARITY_CONTROL_1                                                                             0xe88001
#define regPARITY_CONTROL_1_BASE_IDX                                                                    5
#define regPARITY_SEVERITY_CONTROL_UNCORR_0                                                             0xe88002
#define regPARITY_SEVERITY_CONTROL_UNCORR_0_BASE_IDX                                                    5
#define regPARITY_SEVERITY_CONTROL_CORR_0                                                               0xe88004
#define regPARITY_SEVERITY_CONTROL_CORR_0_BASE_IDX                                                      5
#define regPARITY_SEVERITY_CONTROL_UCP_0                                                                0xe88006
#define regPARITY_SEVERITY_CONTROL_UCP_0_BASE_IDX                                                       5
#define regMISC_SEVERITY_CONTROL                                                                        0xe88037
#define regMISC_SEVERITY_CONTROL_BASE_IDX                                                               5
#define regMISC_RAS_CONTROL                                                                             0xe88038
#define regMISC_RAS_CONTROL_BASE_IDX                                                                    5
#define regRAS_SCRATCH_0                                                                                0xe88039
#define regRAS_SCRATCH_0_BASE_IDX                                                                       5
#define regRAS_SCRATCH_1                                                                                0xe8803a
#define regRAS_SCRATCH_1_BASE_IDX                                                                       5
#define regSYNCFLOOD_STATUS                                                                             0xe88200
#define regSYNCFLOOD_STATUS_BASE_IDX                                                                    5
#define regNMI_STATUS                                                                                   0xe88201
#define regNMI_STATUS_BASE_IDX                                                                          5
#define regINTERNAL_POISON_STATUS                                                                       0xe88206
#define regINTERNAL_POISON_STATUS_BASE_IDX                                                              5
#define regINTERNAL_POISON_MASK                                                                         0xe88207
#define regINTERNAL_POISON_MASK_BASE_IDX                                                                5
#define regEGRESS_POISON_STATUS_LO                                                                      0xe88208
#define regEGRESS_POISON_STATUS_LO_BASE_IDX                                                             5
#define regEGRESS_POISON_STATUS_HI                                                                      0xe88209
#define regEGRESS_POISON_STATUS_HI_BASE_IDX                                                             5
#define regEGRESS_POISON_MASK_LO                                                                        0xe8820a
#define regEGRESS_POISON_MASK_LO_BASE_IDX                                                               5
#define regEGRESS_POISON_MASK_HI                                                                        0xe8820b
#define regEGRESS_POISON_MASK_HI_BASE_IDX                                                               5
#define regEGRESS_POISON_SEVERITY_DOWN                                                                  0xe8820c
#define regEGRESS_POISON_SEVERITY_DOWN_BASE_IDX                                                         5
#define regEGRESS_POISON_SEVERITY_UPPER                                                                 0xe8820d
#define regEGRESS_POISON_SEVERITY_UPPER_BASE_IDX                                                        5
#define regAPML_STATUS                                                                                  0xe88370
#define regAPML_STATUS_BASE_IDX                                                                         5
#define regAPML_CONTROL                                                                                 0xe88371
#define regAPML_CONTROL_BASE_IDX                                                                        5
#define regAPML_TRIGGER                                                                                 0xe88372
#define regAPML_TRIGGER_BASE_IDX                                                                        5


// addressBlock: nbio_iohub_nb_psprascfg_pspras_cfgdec
// base address: 0x13b23000
#define regPSP_INTERNAL_POISON_STATUS                                                                   0xe88c02
#define regPSP_INTERNAL_POISON_STATUS_BASE_IDX                                                          5
#define regPSP_EGRESS_POISON_STATUS_LO                                                                  0xe88c04
#define regPSP_EGRESS_POISON_STATUS_LO_BASE_IDX                                                         5
#define regPSP_EGRESS_POISON_STATUS_HI                                                                  0xe88c05
#define regPSP_EGRESS_POISON_STATUS_HI_BASE_IDX                                                         5


// addressBlock: nbio_iohub_nb_intSBdevindcfg0_devind_cfgdecp
// base address: 0x13b3c000
#define regNB_INTSBDEVINDCFG0_STEERING_CNTL                                                             0xe8f003
#define regNB_INTSBDEVINDCFG0_STEERING_CNTL_BASE_IDX                                                    5
#define regNB_INTSBDEVINDCFG0_SW_LATENCY                                                                0xe8f004
#define regNB_INTSBDEVINDCFG0_SW_LATENCY_BASE_IDX                                                       5


// addressBlock: nbio_iohub_nb_PCIE0rcbdg_indcfg0_pciercbdgind_cfgdec
// base address: 0x13b7d600
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_INDEX                                                           0xe9f5b8
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_INDEX_BASE_IDX                                                  5
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_DATA                                                            0xe9f5b9
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_DATA_BASE_IDX                                                   5


// addressBlock: nbio_iohub_nb_PCIE0rcbdg_indcfg1_pciercbdgind_cfgdec
// base address: 0x13b7d700
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_INDEX                                                           0xe9f5f8
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_INDEX_BASE_IDX                                                  5
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_DATA                                                            0xe9f5f9
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_DATA_BASE_IDX                                                   5


// addressBlock: nbio_iohub_nb_PCIE0rcbdg_indcfg2_pciercbdgind_cfgdec
// base address: 0x13b7d800
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_INDEX                                                           0xe9f638
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_INDEX_BASE_IDX                                                  5
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_DATA                                                            0xe9f639
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_DATA_BASE_IDX                                                   5


// addressBlock: nbio_iohub_iommu_l2a_l2acfg
// base address: 0x15700000
#define regL2_PERF_CNTL_0                                                                               0x1580000
#define regL2_PERF_CNTL_0_BASE_IDX                                                                      5
#define regL2_PERF_COUNT_0                                                                              0x1580001
#define regL2_PERF_COUNT_0_BASE_IDX                                                                     5
#define regL2_PERF_COUNT_1                                                                              0x1580002
#define regL2_PERF_COUNT_1_BASE_IDX                                                                     5
#define regL2_PERF_CNTL_1                                                                               0x1580003
#define regL2_PERF_CNTL_1_BASE_IDX                                                                      5
#define regL2_PERF_COUNT_2                                                                              0x1580004
#define regL2_PERF_COUNT_2_BASE_IDX                                                                     5
#define regL2_PERF_COUNT_3                                                                              0x1580005
#define regL2_PERF_COUNT_3_BASE_IDX                                                                     5
#define regL2_STATUS_0                                                                                  0x1580008
#define regL2_STATUS_0_BASE_IDX                                                                         5
#define regL2_CONTROL_0                                                                                 0x158000c
#define regL2_CONTROL_0_BASE_IDX                                                                        5
#define regL2_CONTROL_1                                                                                 0x158000d
#define regL2_CONTROL_1_BASE_IDX                                                                        5
#define regL2_DTC_CONTROL                                                                               0x1580010
#define regL2_DTC_CONTROL_BASE_IDX                                                                      5
#define regL2_DTC_HASH_CONTROL                                                                          0x1580011
#define regL2_DTC_HASH_CONTROL_BASE_IDX                                                                 5
#define regL2_DTC_WAY_CONTROL                                                                           0x1580012
#define regL2_DTC_WAY_CONTROL_BASE_IDX                                                                  5
#define regL2_ITC_CONTROL                                                                               0x1580014
#define regL2_ITC_CONTROL_BASE_IDX                                                                      5
#define regL2_ITC_HASH_CONTROL                                                                          0x1580015
#define regL2_ITC_HASH_CONTROL_BASE_IDX                                                                 5
#define regL2_ITC_WAY_CONTROL                                                                           0x1580016
#define regL2_ITC_WAY_CONTROL_BASE_IDX                                                                  5
#define regL2_PTC_A_CONTROL                                                                             0x1580018
#define regL2_PTC_A_CONTROL_BASE_IDX                                                                    5
#define regL2_PTC_A_HASH_CONTROL                                                                        0x1580019
#define regL2_PTC_A_HASH_CONTROL_BASE_IDX                                                               5
#define regL2_PTC_A_WAY_CONTROL                                                                         0x158001a
#define regL2_PTC_A_WAY_CONTROL_BASE_IDX                                                                5
#define regL2_CREDIT_CONTROL_2                                                                          0x1580020
#define regL2_CREDIT_CONTROL_2_BASE_IDX                                                                 5
#define regL2A_UPDATE_FILTER_CNTL                                                                       0x1580022
#define regL2A_UPDATE_FILTER_CNTL_BASE_IDX                                                              5
#define regL2_ERR_RULE_CONTROL_3                                                                        0x1580030
#define regL2_ERR_RULE_CONTROL_3_BASE_IDX                                                               5
#define regL2_ERR_RULE_CONTROL_4                                                                        0x1580031
#define regL2_ERR_RULE_CONTROL_4_BASE_IDX                                                               5
#define regL2_ERR_RULE_CONTROL_5                                                                        0x1580032
#define regL2_ERR_RULE_CONTROL_5_BASE_IDX                                                               5
#define regL2_L2A_PGSIZE_CONTROL                                                                        0x1580034
#define regL2_L2A_PGSIZE_CONTROL_BASE_IDX                                                               5
#define regL2_L2A_MEMPWR_GATE_1                                                                         0x1580035
#define regL2_L2A_MEMPWR_GATE_1_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_2                                                                         0x1580036
#define regL2_L2A_MEMPWR_GATE_2_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_3                                                                         0x1580037
#define regL2_L2A_MEMPWR_GATE_3_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_4                                                                         0x1580038
#define regL2_L2A_MEMPWR_GATE_4_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_5                                                                         0x1580039
#define regL2_L2A_MEMPWR_GATE_5_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_6                                                                         0x158003a
#define regL2_L2A_MEMPWR_GATE_6_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_7                                                                         0x158003b
#define regL2_L2A_MEMPWR_GATE_7_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_8                                                                         0x158003c
#define regL2_L2A_MEMPWR_GATE_8_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_9                                                                         0x158003d
#define regL2_L2A_MEMPWR_GATE_9_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_10                                                                        0x158003f
#define regL2_L2A_MEMPWR_GATE_10_BASE_IDX                                                               5
#define regL2_ECO_CNTRL_0                                                                               0x1580042
#define regL2_ECO_CNTRL_0_BASE_IDX                                                                      5


// addressBlock: nbio_iohub_nb_ioapiccfg_ioapic_cfgdec
// base address: 0x14300000
#define regFEATURES_ENABLE                                                                              0x1080000
#define regFEATURES_ENABLE_BASE_IDX                                                                     5


// addressBlock: nbio_pcie0_pciedir
// base address: 0x11180000
#define regPCIE_USB4_TXAL_CNTL1                                                                         0x420160
#define regPCIE_USB4_TXAL_CNTL1_BASE_IDX                                                                5
#define regPCIE_USB4_RXAL_CNTL1                                                                         0x420168
#define regPCIE_USB4_RXAL_CNTL1_BASE_IDX                                                                5
#define regPCIE_USB4_AL_CNTL1                                                                           0x420170
#define regPCIE_USB4_AL_CNTL1_BASE_IDX                                                                  5
#define regPCIE_USB4_AL_CNTL2                                                                           0x420171
#define regPCIE_USB4_AL_CNTL2_BASE_IDX                                                                  5
#define regPCIE_USB4_AL_HYSTERESIS                                                                      0x420172
#define regPCIE_USB4_AL_HYSTERESIS_BASE_IDX                                                             5
#define regPCIE_USB4_AL_HYSTERESIS_2                                                                    0x420173
#define regPCIE_USB4_AL_HYSTERESIS_2_BASE_IDX                                                           5
#define regPCIE_USB4_ERR_CNTL5                                                                          0x420178
#define regPCIE_USB4_ERR_CNTL5_BASE_IDX                                                                 5
#define regPCIE_USB4_LC_CNTL1                                                                           0x420179
#define regPCIE_USB4_LC_CNTL1_BASE_IDX                                                                  5
#define regBIF_BIF256_CI256_RC3X4_USB4_CPM_CONTROL                                                      0x420118
#define regBIF_BIF256_CI256_RC3X4_USB4_CPM_CONTROL_BASE_IDX                                             5
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_CNTL2                                                       0x42001c
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_CNTL2_BASE_IDX                                              5
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_TX_POWER_CTRL_1                                             0x420187
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_TX_POWER_CTRL_1_BASE_IDX                                    5
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_MST_CTRL_3                                                  0x4201c6
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_MST_CTRL_3_BASE_IDX                                         5


// addressBlock: nbio_nbif0_bif_cfg_dev0_rc_bifcfgdecp
// base address: 0x10100000
#define regBIF_CFG_DEV0_RC0_VENDOR_ID                                                                   0x0000
#define regBIF_CFG_DEV0_RC0_VENDOR_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_DEVICE_ID                                                                   0x0000
#define regBIF_CFG_DEV0_RC0_DEVICE_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_COMMAND                                                                     0x0001
#define regBIF_CFG_DEV0_RC0_COMMAND_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_STATUS                                                                      0x0001
#define regBIF_CFG_DEV0_RC0_STATUS_BASE_IDX                                                             5
#define regBIF_CFG_DEV0_RC0_REVISION_ID                                                                 0x0002
#define regBIF_CFG_DEV0_RC0_REVISION_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_PROG_INTERFACE                                                              0x0002
#define regBIF_CFG_DEV0_RC0_PROG_INTERFACE_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_SUB_CLASS                                                                   0x0002
#define regBIF_CFG_DEV0_RC0_SUB_CLASS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_BASE_CLASS                                                                  0x0002
#define regBIF_CFG_DEV0_RC0_BASE_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_CACHE_LINE                                                                  0x0003
#define regBIF_CFG_DEV0_RC0_CACHE_LINE_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_LATENCY                                                                     0x0003
#define regBIF_CFG_DEV0_RC0_LATENCY_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_HEADER                                                                      0x0003
#define regBIF_CFG_DEV0_RC0_HEADER_BASE_IDX                                                             5
#define regBIF_CFG_DEV0_RC0_BIST                                                                        0x0003
#define regBIF_CFG_DEV0_RC0_BIST_BASE_IDX                                                               5
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_1                                                                 0x0004
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_1_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_2                                                                 0x0005
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY                                                      0x0006
#define regBIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT                                                               0x0007
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_SECONDARY_STATUS                                                            0x0007
#define regBIF_CFG_DEV0_RC0_SECONDARY_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_MEM_BASE_LIMIT                                                              0x0008
#define regBIF_CFG_DEV0_RC0_MEM_BASE_LIMIT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_PREF_BASE_LIMIT                                                             0x0009
#define regBIF_CFG_DEV0_RC0_PREF_BASE_LIMIT_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PREF_BASE_UPPER                                                             0x000a
#define regBIF_CFG_DEV0_RC0_PREF_BASE_UPPER_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PREF_LIMIT_UPPER                                                            0x000b
#define regBIF_CFG_DEV0_RC0_PREF_LIMIT_UPPER_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI                                                            0x000c
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_CAP_PTR                                                                     0x000d
#define regBIF_CFG_DEV0_RC0_CAP_PTR_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_ROM_BASE_ADDR                                                               0x000e
#define regBIF_CFG_DEV0_RC0_ROM_BASE_ADDR_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_INTERRUPT_LINE                                                              0x000f
#define regBIF_CFG_DEV0_RC0_INTERRUPT_LINE_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_INTERRUPT_PIN                                                               0x000f
#define regBIF_CFG_DEV0_RC0_INTERRUPT_PIN_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL                                                             0x000f
#define regBIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_EXT_BRIDGE_CNTL                                                             0x0010
#define regBIF_CFG_DEV0_RC0_EXT_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PMI_CAP_LIST                                                                0x0014
#define regBIF_CFG_DEV0_RC0_PMI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_PMI_CAP                                                                     0x0014
#define regBIF_CFG_DEV0_RC0_PMI_CAP_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_PMI_STATUS_CNTL                                                             0x0015
#define regBIF_CFG_DEV0_RC0_PMI_STATUS_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PCIE_CAP_LIST                                                               0x0016
#define regBIF_CFG_DEV0_RC0_PCIE_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_CAP                                                                    0x0016
#define regBIF_CFG_DEV0_RC0_PCIE_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP                                                                  0x0017
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL                                                                 0x0018
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS                                                               0x0018
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_LINK_CAP                                                                    0x0019
#define regBIF_CFG_DEV0_RC0_LINK_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_LINK_CNTL                                                                   0x001a
#define regBIF_CFG_DEV0_RC0_LINK_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_LINK_STATUS                                                                 0x001a
#define regBIF_CFG_DEV0_RC0_LINK_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_SLOT_CAP                                                                    0x001b
#define regBIF_CFG_DEV0_RC0_SLOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL                                                                   0x001c
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS                                                                 0x001c
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_ROOT_CNTL                                                                   0x001d
#define regBIF_CFG_DEV0_RC0_ROOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_ROOT_CAP                                                                    0x001d
#define regBIF_CFG_DEV0_RC0_ROOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_ROOT_STATUS                                                                 0x001e
#define regBIF_CFG_DEV0_RC0_ROOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP2                                                                 0x001f
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL2                                                                0x0020
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS2                                                              0x0020
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_LINK_CAP2                                                                   0x0021
#define regBIF_CFG_DEV0_RC0_LINK_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_LINK_CNTL2                                                                  0x0022
#define regBIF_CFG_DEV0_RC0_LINK_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_LINK_STATUS2                                                                0x0022
#define regBIF_CFG_DEV0_RC0_LINK_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_SLOT_CAP2                                                                   0x0023
#define regBIF_CFG_DEV0_RC0_SLOT_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL2                                                                  0x0024
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS2                                                                0x0024
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_CAP_LIST                                                                0x0028
#define regBIF_CFG_DEV0_RC0_MSI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_CNTL                                                                0x0028
#define regBIF_CFG_DEV0_RC0_MSI_MSG_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_LO                                                             0x0029
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_LO_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_HI                                                             0x002a
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_HI_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA                                                                0x002a
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA                                                            0x002a
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA_64                                                             0x002b
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA_64                                                         0x002b
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_RC0_SSID_CAP_LIST                                                               0x0030
#define regBIF_CFG_DEV0_RC0_SSID_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_SSID_CAP                                                                    0x0031
#define regBIF_CFG_DEV0_RC0_SSID_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST                                                            0x0032
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP                                                                 0x0032
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                           0x0040
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                  5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR                                                    0x0041
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC1                                                       0x0042
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC2                                                       0x0043
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST                                                        0x0044
#define regBIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1                                                       0x0045
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2                                                       0x0046
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL                                                           0x0047
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_STATUS                                                         0x0047
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_STATUS_BASE_IDX                                                5
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP                                                       0x0048
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL                                                      0x0049
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS                                                    0x004a
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP                                                       0x004b
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL                                                      0x004c
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS                                                    0x004d
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                            0x0050
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW1                                                     0x0051
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW2                                                     0x0052
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                               0x0054
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS                                                      0x0055
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK                                                        0x0056
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY                                                    0x0057
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS                                                        0x0058
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK                                                          0x0059
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL                                                       0x005a
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG0                                                               0x005b
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG1                                                               0x005c
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG2                                                               0x005d
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG3                                                               0x005e
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG3_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD                                                           0x005f
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS                                                        0x0060
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID                                                             0x0061
#define regBIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG0                                                        0x0062
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG1                                                        0x0063
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG2                                                        0x0064
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG3                                                        0x0065
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST                                                 0x009c
#define regBIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3                                                             0x009d
#define regBIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS                                                      0x009e
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL                                               0x009f
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL                                               0x009f
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL                                               0x00a0
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL                                               0x00a0
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL                                               0x00a1
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL                                               0x00a1
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL                                               0x00a2
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL                                               0x00a2
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL                                               0x00a3
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL                                               0x00a3
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL                                              0x00a4
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL                                              0x00a4
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL                                              0x00a5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL                                              0x00a5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL                                              0x00a6
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL                                              0x00a6
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST                                                       0x00a8
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CAP                                                                0x00a9
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CAP_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CNTL                                                               0x00a9
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_DLF_ENH_CAP_LIST                                                       0x0100
#define regBIF_CFG_DEV0_RC0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_CAP                                                       0x0101
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_STATUS                                                    0x0102
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_PHY_16GT_ENH_CAP_LIST                                                  0x0104
#define regBIF_CFG_DEV0_RC0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LINK_CAP_16GT                                                               0x0105
#define regBIF_CFG_DEV0_RC0_LINK_CAP_16GT_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_LINK_CNTL_16GT                                                              0x0106
#define regBIF_CFG_DEV0_RC0_LINK_CNTL_16GT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_LINK_STATUS_16GT                                                            0x0107
#define regBIF_CFG_DEV0_RC0_LINK_STATUS_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                           0x0108
#define regBIF_CFG_DEV0_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT                                            0x0109
#define regBIF_CFG_DEV0_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT                                            0x010a
#define regBIF_CFG_DEV0_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_RC0_LANE_0_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_1_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_2_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_3_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_4_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_5_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_6_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_7_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_8_EQUALIZATION_CNTL_16GT                                               0x010e
#define regBIF_CFG_DEV0_RC0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_9_EQUALIZATION_CNTL_16GT                                               0x010e
#define regBIF_CFG_DEV0_RC0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_10_EQUALIZATION_CNTL_16GT                                              0x010e
#define regBIF_CFG_DEV0_RC0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_11_EQUALIZATION_CNTL_16GT                                              0x010e
#define regBIF_CFG_DEV0_RC0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_12_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_13_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_14_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_15_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_MARGINING_ENH_CAP_LIST                                                 0x0114
#define regBIF_CFG_DEV0_RC0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_CAP                                                          0x0115
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_CAP_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_STATUS                                                       0x0115
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_CNTL                                                  0x0116
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_STATUS                                                0x0116
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_CNTL                                                  0x0117
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_STATUS                                                0x0117
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_CNTL                                                  0x0118
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_STATUS                                                0x0118
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_CNTL                                                  0x0119
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_STATUS                                                0x0119
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_CNTL                                                  0x011a
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_STATUS                                                0x011a
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_CNTL                                                  0x011b
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_STATUS                                                0x011b
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_CNTL                                                  0x011c
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_STATUS                                                0x011c
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_CNTL                                                  0x011d
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_STATUS                                                0x011d
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_CNTL                                                  0x011e
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_STATUS                                                0x011e
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_CNTL                                                  0x011f
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_STATUS                                                0x011f
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_CNTL                                                 0x0120
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_STATUS                                               0x0120
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_CNTL                                                 0x0121
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_STATUS                                               0x0121
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_CNTL                                                 0x0122
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_STATUS                                               0x0122
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_CNTL                                                 0x0123
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_STATUS                                               0x0123
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_CNTL                                                 0x0124
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_STATUS                                               0x0124
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_CNTL                                                 0x0125
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_STATUS                                               0x0125
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_RTR_ENH_CAP_LIST                                                       0x015c
#define regBIF_CFG_DEV0_RC0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_RTR_DATA1                                                                   0x015d
#define regBIF_CFG_DEV0_RC0_RTR_DATA1_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_RTR_DATA2                                                                   0x015e
#define regBIF_CFG_DEV0_RC0_RTR_DATA2_BASE_IDX                                                          5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x10140000
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_ID                                                                0x10000
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_ID                                                                0x10000
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_COMMAND                                                                  0x10001
#define regBIF_CFG_DEV0_EPF0_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_STATUS                                                                   0x10001
#define regBIF_CFG_DEV0_EPF0_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_0_REVISION_ID                                                              0x10002
#define regBIF_CFG_DEV0_EPF0_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_PROG_INTERFACE                                                           0x10002
#define regBIF_CFG_DEV0_EPF0_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_SUB_CLASS                                                                0x10002
#define regBIF_CFG_DEV0_EPF0_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_BASE_CLASS                                                               0x10002
#define regBIF_CFG_DEV0_EPF0_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_CACHE_LINE                                                               0x10003
#define regBIF_CFG_DEV0_EPF0_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_LATENCY                                                                  0x10003
#define regBIF_CFG_DEV0_EPF0_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_HEADER                                                                   0x10003
#define regBIF_CFG_DEV0_EPF0_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_0_BIST                                                                     0x10003
#define regBIF_CFG_DEV0_EPF0_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_1                                                              0x10004
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_2                                                              0x10005
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_3                                                              0x10006
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_4                                                              0x10007
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_5                                                              0x10008
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_6                                                              0x10009
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID                                                               0x1000b
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_ROM_BASE_ADDR                                                            0x1000c
#define regBIF_CFG_DEV0_EPF0_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_CAP_PTR                                                                  0x1000d
#define regBIF_CFG_DEV0_EPF0_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_LINE                                                           0x1000f
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_PIN                                                            0x1000f
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_MIN_GRANT                                                                0x1000f
#define regBIF_CFG_DEV0_EPF0_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_MAX_LATENCY                                                              0x1000f
#define regBIF_CFG_DEV0_EPF0_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_CAP_LIST                                                          0x10012
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID_W                                                             0x10013
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP_LIST                                                             0x10014
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP                                                                  0x10014
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_PMI_STATUS_CNTL                                                          0x10015
#define regBIF_CFG_DEV0_EPF0_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP_LIST                                                            0x10019
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP                                                                 0x10019
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP                                                               0x1001a
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL                                                              0x1001b
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS                                                            0x1001b
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP                                                                 0x1001c
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL                                                                0x1001d
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS                                                              0x1001d
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP2                                                              0x10022
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL2                                                             0x10023
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS2                                                           0x10023
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP2                                                                0x10024
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL2                                                               0x10025
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS2                                                             0x10025
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_CAP_LIST                                                             0x10028
#define regBIF_CFG_DEV0_EPF0_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_CNTL                                                             0x10028
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_LO                                                          0x10029
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_HI                                                          0x1002a
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA                                                             0x1002a
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA                                                         0x1002a
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK                                                                 0x1002b
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA_64                                                          0x1002b
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA_64                                                      0x1002b
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK_64                                                              0x1002c
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING                                                              0x1002c
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING_64                                                           0x1002d
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_CAP_LIST                                                            0x10030
#define regBIF_CFG_DEV0_EPF0_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_MSG_CNTL                                                            0x10030
#define regBIF_CFG_DEV0_EPF0_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_TABLE                                                               0x10031
#define regBIF_CFG_DEV0_EPF0_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_PBA                                                                 0x10032
#define regBIF_CFG_DEV0_EPF0_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x10040
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x10041
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC1                                                    0x10042
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC2                                                    0x10043
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC_ENH_CAP_LIST                                                     0x10044
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG1                                                    0x10045
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG2                                                    0x10046
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CNTL                                                        0x10047
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CNTL_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_STATUS                                                      0x10047
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CAP                                                    0x10048
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CNTL                                                   0x10049
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_STATUS                                                 0x1004a
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CAP                                                    0x1004b
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CNTL                                                   0x1004c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_STATUS                                                 0x1004d
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                         0x10050
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW1                                                  0x10051
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW2                                                  0x10052
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x10054
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_STATUS                                                   0x10055
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_MASK                                                     0x10056
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x10057
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_STATUS                                                     0x10058
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_MASK                                                       0x10059
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1005a
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG0                                                            0x1005b
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG1                                                            0x1005c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG2                                                            0x1005d
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG3                                                            0x1005e
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG0                                                     0x10062
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG1                                                     0x10063
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG2                                                     0x10064
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG3                                                     0x10065
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR_ENH_CAP_LIST                                                    0x10080
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CAP                                                            0x10081
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CNTL                                                           0x10082
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CAP                                                            0x10083
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CNTL                                                           0x10084
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CAP                                                            0x10085
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CNTL                                                           0x10086
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CAP                                                            0x10087
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CNTL                                                           0x10088
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CAP                                                            0x10089
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CNTL                                                           0x1008a
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CAP                                                            0x1008b
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CNTL                                                           0x1008c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x10090
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x10091
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA                                                     0x10092
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_CAP                                                      0x10093
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_ENH_CAP_LIST                                                    0x10094
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CAP                                                             0x10095
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_LATENCY_INDICATOR                                               0x10096
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_STATUS                                                          0x10097
#define regBIF_CFG_DEV0_EPF0_0_PCIE_D