/* math-display.c generated by valac 0.18.1, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <atk/atk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_NUMBER_MODE (number_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MathDisplay {
	GtkViewport parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkViewportClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	GtkTextView* text_view;
	GtkTextBuffer* info_buffer;
	GtkSpinner* spinner;
};

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;


static gpointer math_display_parent_class = NULL;

GType math_display_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
#define MATH_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_DISPLAY, MathDisplayPrivate))
enum  {
	MATH_DISPLAY_DUMMY_PROPERTY,
	MATH_DISPLAY_EQUATION
};
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event);
static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void __lambda9_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda10_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event);
MathEquation* math_display_get_equation (MathDisplay* self);
void math_equation_solve (MathEquation* self);
void math_equation_clear (MathEquation* self);
void math_equation_insert_numeric_point (MathEquation* self);
void math_equation_insert (MathEquation* self, const gchar* text);
void math_equation_insert_subtract (MathEquation* self);
void math_equation_insert_exponent (MathEquation* self);
void math_equation_factorize (MathEquation* self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
gchar* math_equation_get_status (MathEquation* self);
gboolean math_equation_get_in_solve (MathEquation* self);
guint math_equation_get_error_token_end (MathEquation* self);
guint math_equation_get_error_token_start (MathEquation* self);
static void math_display_finalize (GObject* obj);
static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = math_display_key_press_cb (self, event);
	return result;
}


static void __lambda9_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_status_changed_cb (self);
}


static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda9_ (self, pspec);
}


static void __lambda10_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_error_status_changed_cb (self);
}


static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda10_ (self, pspec);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


MathDisplay* math_display_construct (GType object_type, MathEquation* equation) {
	MathDisplay * self = NULL;
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* main_box;
	GtkBox* _tmp3_;
	MathEquation* _tmp4_;
	GtkTextView* _tmp5_;
	GtkTextView* _tmp6_;
	GtkTextView* _tmp7_;
	GtkTextView* _tmp8_;
	GtkTextView* _tmp9_;
	GtkTextView* _tmp10_;
	GtkTextView* _tmp11_;
	GtkStyle* _tmp12_ = NULL;
	PangoFontDescription* _tmp13_;
	PangoFontDescription* _tmp14_ = NULL;
	PangoFontDescription* font_desc;
	PangoFontDescription* _tmp15_;
	GtkTextView* _tmp16_;
	PangoFontDescription* _tmp17_;
	GtkTextView* _tmp18_;
	GtkTextView* _tmp19_;
	AtkObject* _tmp20_ = NULL;
	GtkTextView* _tmp21_;
	GtkBox* _tmp22_;
	GtkTextView* _tmp23_;
	GtkBox* _tmp24_;
	GtkBox* info_box;
	GtkBox* _tmp25_;
	GtkBox* _tmp26_;
	GtkTextView* _tmp27_;
	GtkTextView* info_view;
	GtkTextView* _tmp28_;
	GtkTextView* _tmp29_;
	GtkTextView* _tmp30_;
	GtkTextView* _tmp31_;
	GtkTextView* _tmp32_;
	GtkBox* _tmp33_;
	GtkTextView* _tmp34_;
	GtkTextView* _tmp35_;
	GtkTextBuffer* _tmp36_ = NULL;
	GtkTextBuffer* _tmp37_;
	GtkSpinner* _tmp38_;
	GtkBox* _tmp39_;
	GtkSpinner* _tmp40_;
	GtkTextView* _tmp41_;
	GtkStyle* _tmp42_ = NULL;
	GtkBox* _tmp53_;
	GtkTextView* _tmp54_;
	GtkTextView* _tmp55_;
	GtkBox* _tmp56_;
	MathEquation* _tmp57_;
	MathEquation* _tmp58_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, NULL);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	main_box = _tmp2_;
	_tmp3_ = main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = equation;
	_tmp5_ = (GtkTextView*) gtk_text_view_new_with_buffer ((GtkTextBuffer*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->text_view);
	self->priv->text_view = _tmp5_;
	_tmp6_ = self->priv->text_view;
	gtk_text_view_set_accepts_tab (_tmp6_, FALSE);
	_tmp7_ = self->priv->text_view;
	gtk_text_view_set_pixels_above_lines (_tmp7_, 8);
	_tmp8_ = self->priv->text_view;
	gtk_text_view_set_pixels_below_lines (_tmp8_, 2);
	_tmp9_ = self->priv->text_view;
	gtk_text_view_set_justification (_tmp9_, GTK_JUSTIFY_RIGHT);
	_tmp10_ = self->priv->text_view;
	gtk_widget_ensure_style ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->text_view;
	_tmp12_ = gtk_widget_get_style ((GtkWidget*) _tmp11_);
	_tmp13_ = _tmp12_->font_desc;
	_tmp14_ = pango_font_description_copy (_tmp13_);
	font_desc = _tmp14_;
	_tmp15_ = font_desc;
	pango_font_description_set_size (_tmp15_, 16 * PANGO_SCALE);
	_tmp16_ = self->priv->text_view;
	_tmp17_ = font_desc;
	gtk_widget_modify_font ((GtkWidget*) _tmp16_, _tmp17_);
	_tmp18_ = self->priv->text_view;
	gtk_buildable_set_name ((GtkBuildable*) _tmp18_, "displayitem");
	_tmp19_ = self->priv->text_view;
	_tmp20_ = gtk_widget_get_accessible ((GtkWidget*) _tmp19_);
	atk_object_set_role (_tmp20_, ATK_ROLE_EDITBAR);
	_tmp21_ = self->priv->text_view;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "key-press-event", (GCallback) _math_display_key_press_cb_gtk_widget_key_press_event, self, 0);
	_tmp22_ = main_box;
	_tmp23_ = self->priv->text_view;
	gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, TRUE, TRUE, (guint) 0);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp24_);
	info_box = _tmp24_;
	_tmp25_ = main_box;
	_tmp26_ = info_box;
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, FALSE, TRUE, (guint) 0);
	_tmp27_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp27_);
	info_view = _tmp27_;
	_tmp28_ = info_view;
	gtk_text_view_set_wrap_mode (_tmp28_, GTK_WRAP_WORD);
	_tmp29_ = info_view;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp29_, TRUE);
	_tmp30_ = info_view;
	gtk_text_view_set_cursor_visible (_tmp30_, FALSE);
	_tmp31_ = info_view;
	gtk_text_view_set_editable (_tmp31_, FALSE);
	_tmp32_ = info_view;
	gtk_text_view_set_justification (_tmp32_, GTK_JUSTIFY_RIGHT);
	_tmp33_ = info_box;
	_tmp34_ = info_view;
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 0);
	_tmp35_ = info_view;
	_tmp36_ = gtk_text_view_get_buffer (_tmp35_);
	_tmp37_ = _g_object_ref0 (_tmp36_);
	_g_object_unref0 (self->priv->info_buffer);
	self->priv->info_buffer = _tmp37_;
	_tmp38_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp38_;
	_tmp39_ = info_box;
	_tmp40_ = self->priv->spinner;
	gtk_box_pack_end (_tmp39_, (GtkWidget*) _tmp40_, FALSE, FALSE, (guint) 0);
	_tmp41_ = info_view;
	_tmp42_ = gtk_widget_get_style ((GtkWidget*) _tmp41_);
	gtk_widget_set_style ((GtkWidget*) self, _tmp42_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp43_;
			_tmp43_ = TRUE;
			while (TRUE) {
				gboolean _tmp44_;
				gint _tmp46_;
				gint _tmp47_;
				GtkStyle* _tmp48_;
				GtkStyle* _tmp49_;
				GdkColor* _tmp50_;
				gint _tmp50__length1;
				gint _tmp51_;
				GdkColor _tmp52_;
				_tmp44_ = _tmp43_;
				if (!_tmp44_) {
					gint _tmp45_;
					_tmp45_ = i;
					i = _tmp45_ + 1;
				}
				_tmp43_ = FALSE;
				_tmp46_ = i;
				if (!(_tmp46_ < 5)) {
					break;
				}
				_tmp47_ = i;
				_tmp48_ = gtk_widget_get_style ((GtkWidget*) self);
				_tmp49_ = _tmp48_;
				_tmp50_ = _tmp49_->base;
				_tmp50__length1 = -1;
				_tmp51_ = i;
				_tmp52_ = _tmp50_[_tmp51_];
				gtk_widget_modify_bg ((GtkWidget*) self, _tmp47_, &_tmp52_);
			}
		}
	}
	_tmp53_ = info_box;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	_tmp54_ = info_view;
	gtk_widget_show ((GtkWidget*) _tmp54_);
	_tmp55_ = self->priv->text_view;
	gtk_widget_show ((GtkWidget*) _tmp55_);
	_tmp56_ = main_box;
	gtk_widget_show ((GtkWidget*) _tmp56_);
	_tmp57_ = equation;
	g_signal_connect_object ((GObject*) _tmp57_, "notify::status", (GCallback) ___lambda9__g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	_tmp58_ = equation;
	g_signal_connect_object ((GObject*) _tmp58_, "notify::error-token-end", (GCallback) ___lambda10__g_object_notify, self, 0);
	_g_object_unref0 (info_view);
	_g_object_unref0 (info_box);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (main_box);
	return self;
}


MathDisplay* math_display_new (MathEquation* equation) {
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}


static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathDisplay * self;
	gboolean result = FALSE;
	GtkTextView* _tmp0_;
	GdkEventKey _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (MathDisplay*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->text_view;
	_tmp1_ = *event;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "key-press-event", &_tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event) {
	gboolean result = FALSE;
	guint new_keyval;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GdkEventKey _tmp7_;
	GdkModifierType _tmp8_;
	GdkModifierType state;
	GdkEventKey _tmp9_;
	guint _tmp10_;
	guint32 _tmp11_ = 0U;
	guint32 c;
	gboolean _tmp12_ = FALSE;
	GdkEventKey _tmp13_;
	guint _tmp14_;
	gboolean _tmp17_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GdkEventKey _tmp23_;
	guint _tmp24_;
	gboolean _tmp26_;
	gboolean _tmp32_;
	gboolean _tmp38_;
	GdkEventKey _tmp41_;
	guint _tmp42_;
	GdkModifierType _tmp45_;
	GdkModifierType _tmp55_;
	GdkModifierType _tmp78_;
	gboolean _tmp85_ = FALSE;
	GdkModifierType _tmp86_;
	gboolean _tmp91_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	new_keyval = (guint) 0;
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	switch (_tmp1_) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = (guint) GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = (guint) GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = (guint) GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = (guint) GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = (guint) GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = (guint) GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = (guint) GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = (guint) GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = (guint) GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = (guint) GDK_KEY_9;
			break;
		}
		default:
		break;
	}
	_tmp2_ = new_keyval;
	if (_tmp2_ != ((guint) 0)) {
		GdkEventKey _tmp3_;
		GdkEventKey new_event;
		guint _tmp4_;
		GdkEventKey _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = *event;
		new_event = _tmp3_;
		_tmp4_ = new_keyval;
		new_event.keyval = _tmp4_;
		_tmp5_ = new_event;
		g_signal_emit_by_name ((GtkWidget*) self, "key-press-event", &_tmp5_, &_tmp6_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = *event;
	_tmp8_ = _tmp7_.state;
	state = _tmp8_ & (GDK_CONTROL_MASK | GDK_MOD1_MASK);
	_tmp9_ = *event;
	_tmp10_ = _tmp9_.keyval;
	_tmp11_ = gdk_keyval_to_unicode (_tmp10_);
	c = _tmp11_;
	_tmp13_ = *event;
	_tmp14_ = _tmp13_.keyval;
	if (_tmp14_ == ((guint) GDK_KEY_Return)) {
		_tmp12_ = TRUE;
	} else {
		GdkEventKey _tmp15_;
		guint _tmp16_;
		_tmp15_ = *event;
		_tmp16_ = _tmp15_.keyval;
		_tmp12_ = _tmp16_ == ((guint) GDK_KEY_KP_Enter);
	}
	_tmp17_ = _tmp12_;
	if (_tmp17_) {
		MathEquation* _tmp18_;
		MathEquation* _tmp19_;
		_tmp18_ = math_display_get_equation (self);
		_tmp19_ = _tmp18_;
		math_equation_solve (_tmp19_);
		result = TRUE;
		return result;
	}
	_tmp23_ = *event;
	_tmp24_ = _tmp23_.keyval;
	if (_tmp24_ == ((guint) GDK_KEY_Escape)) {
		GdkModifierType _tmp25_;
		_tmp25_ = state;
		_tmp22_ = _tmp25_ == 0;
	} else {
		_tmp22_ = FALSE;
	}
	_tmp26_ = _tmp22_;
	if (_tmp26_) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		GdkEventKey _tmp28_;
		guint _tmp29_;
		gboolean _tmp31_;
		_tmp28_ = *event;
		_tmp29_ = _tmp28_.keyval;
		if (_tmp29_ == ((guint) GDK_KEY_BackSpace)) {
			GdkModifierType _tmp30_;
			_tmp30_ = state;
			_tmp27_ = _tmp30_ == GDK_CONTROL_MASK;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp31_ = _tmp27_;
		_tmp21_ = _tmp31_;
	}
	_tmp32_ = _tmp21_;
	if (_tmp32_) {
		_tmp20_ = TRUE;
	} else {
		gboolean _tmp33_ = FALSE;
		GdkEventKey _tmp34_;
		guint _tmp35_;
		gboolean _tmp37_;
		_tmp34_ = *event;
		_tmp35_ = _tmp34_.keyval;
		if (_tmp35_ == ((guint) GDK_KEY_Delete)) {
			GdkModifierType _tmp36_;
			_tmp36_ = state;
			_tmp33_ = _tmp36_ == GDK_SHIFT_MASK;
		} else {
			_tmp33_ = FALSE;
		}
		_tmp37_ = _tmp33_;
		_tmp20_ = _tmp37_;
	}
	_tmp38_ = _tmp20_;
	if (_tmp38_) {
		MathEquation* _tmp39_;
		MathEquation* _tmp40_;
		_tmp39_ = math_display_get_equation (self);
		_tmp40_ = _tmp39_;
		math_equation_clear (_tmp40_);
		result = TRUE;
		return result;
	}
	_tmp41_ = *event;
	_tmp42_ = _tmp41_.keyval;
	if (_tmp42_ == ((guint) GDK_KEY_KP_Decimal)) {
		MathEquation* _tmp43_;
		MathEquation* _tmp44_;
		_tmp43_ = math_display_get_equation (self);
		_tmp44_ = _tmp43_;
		math_equation_insert_numeric_point (_tmp44_);
		result = TRUE;
		return result;
	}
	_tmp45_ = state;
	if (_tmp45_ == 0) {
		guint32 _tmp46_;
		guint32 _tmp49_;
		guint32 _tmp52_;
		_tmp46_ = c;
		if (_tmp46_ == ((guint32) '*')) {
			MathEquation* _tmp47_;
			MathEquation* _tmp48_;
			_tmp47_ = math_display_get_equation (self);
			_tmp48_ = _tmp47_;
			math_equation_insert (_tmp48_, "×");
			result = TRUE;
			return result;
		}
		_tmp49_ = c;
		if (_tmp49_ == ((guint32) '/')) {
			MathEquation* _tmp50_;
			MathEquation* _tmp51_;
			_tmp50_ = math_display_get_equation (self);
			_tmp51_ = _tmp50_;
			math_equation_insert (_tmp51_, "÷");
			result = TRUE;
			return result;
		}
		_tmp52_ = c;
		if (_tmp52_ == ((guint32) '-')) {
			MathEquation* _tmp53_;
			MathEquation* _tmp54_;
			_tmp53_ = math_display_get_equation (self);
			_tmp54_ = _tmp53_;
			math_equation_insert_subtract (_tmp54_);
			result = TRUE;
			return result;
		}
	}
	_tmp55_ = state;
	if (_tmp55_ == GDK_CONTROL_MASK) {
		GdkEventKey _tmp56_;
		guint _tmp57_;
		_tmp56_ = *event;
		_tmp57_ = _tmp56_.keyval;
		switch (_tmp57_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp58_;
				MathEquation* _tmp59_;
				_tmp58_ = math_display_get_equation (self);
				_tmp59_ = _tmp58_;
				math_equation_insert (_tmp59_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp60_;
				MathEquation* _tmp61_;
				_tmp60_ = math_display_get_equation (self);
				_tmp61_ = _tmp60_;
				math_equation_insert (_tmp61_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp62_;
				MathEquation* _tmp63_;
				_tmp62_ = math_display_get_equation (self);
				_tmp63_ = _tmp62_;
				math_equation_insert_exponent (_tmp63_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp64_;
				MathEquation* _tmp65_;
				_tmp64_ = math_display_get_equation (self);
				_tmp65_ = _tmp64_;
				math_equation_factorize (_tmp65_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp66_;
				MathEquation* _tmp67_;
				_tmp66_ = math_display_get_equation (self);
				_tmp67_ = _tmp66_;
				math_equation_insert (_tmp67_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp68_;
				MathEquation* _tmp69_;
				_tmp68_ = math_display_get_equation (self);
				_tmp69_ = _tmp68_;
				math_equation_insert (_tmp69_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp70_;
				MathEquation* _tmp71_;
				_tmp70_ = math_display_get_equation (self);
				_tmp71_ = _tmp70_;
				math_equation_insert (_tmp71_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp72_;
				MathEquation* _tmp73_;
				_tmp72_ = math_display_get_equation (self);
				_tmp73_ = _tmp72_;
				math_equation_insert (_tmp73_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp74_;
				MathEquation* _tmp75_;
				_tmp74_ = math_display_get_equation (self);
				_tmp75_ = _tmp74_;
				math_equation_insert (_tmp75_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp76_;
				MathEquation* _tmp77_;
				_tmp76_ = math_display_get_equation (self);
				_tmp77_ = _tmp76_;
				math_equation_insert (_tmp77_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp78_ = state;
	if (_tmp78_ == GDK_MOD1_MASK) {
		GdkEventKey _tmp79_;
		guint _tmp80_;
		_tmp79_ = *event;
		_tmp80_ = _tmp79_.keyval;
		switch (_tmp80_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp81_;
				MathEquation* _tmp82_;
				_tmp81_ = math_display_get_equation (self);
				_tmp82_ = _tmp81_;
				math_equation_insert (_tmp82_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp83_;
				MathEquation* _tmp84_;
				_tmp83_ = math_display_get_equation (self);
				_tmp84_ = _tmp83_;
				math_equation_insert (_tmp84_, "⌋");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp86_ = state;
	if (_tmp86_ == GDK_CONTROL_MASK) {
		_tmp85_ = TRUE;
	} else {
		MathEquation* _tmp87_;
		MathEquation* _tmp88_;
		NumberMode _tmp89_;
		NumberMode _tmp90_;
		_tmp87_ = math_display_get_equation (self);
		_tmp88_ = _tmp87_;
		_tmp89_ = math_equation_get_number_mode (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp85_ = _tmp90_ == NUMBER_MODE_SUPERSCRIPT;
	}
	_tmp91_ = _tmp85_;
	if (_tmp91_) {
		GdkEventKey _tmp92_;
		guint _tmp93_;
		_tmp92_ = *event;
		_tmp93_ = _tmp92_.keyval;
		switch (_tmp93_) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp94_;
				MathEquation* _tmp95_;
				_tmp94_ = math_display_get_equation (self);
				_tmp95_ = _tmp94_;
				math_equation_insert (_tmp95_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp96_;
				MathEquation* _tmp97_;
				_tmp96_ = math_display_get_equation (self);
				_tmp97_ = _tmp96_;
				math_equation_insert (_tmp97_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp98_;
				MathEquation* _tmp99_;
				_tmp98_ = math_display_get_equation (self);
				_tmp99_ = _tmp98_;
				math_equation_insert (_tmp99_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp100_;
				MathEquation* _tmp101_;
				_tmp100_ = math_display_get_equation (self);
				_tmp101_ = _tmp100_;
				math_equation_insert (_tmp101_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp102_;
				MathEquation* _tmp103_;
				_tmp102_ = math_display_get_equation (self);
				_tmp103_ = _tmp102_;
				math_equation_insert (_tmp103_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp104_;
				MathEquation* _tmp105_;
				_tmp104_ = math_display_get_equation (self);
				_tmp105_ = _tmp104_;
				math_equation_insert (_tmp105_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp106_;
				MathEquation* _tmp107_;
				_tmp106_ = math_display_get_equation (self);
				_tmp107_ = _tmp106_;
				math_equation_insert (_tmp107_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp108_;
				MathEquation* _tmp109_;
				_tmp108_ = math_display_get_equation (self);
				_tmp109_ = _tmp108_;
				math_equation_insert (_tmp109_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp110_;
				MathEquation* _tmp111_;
				_tmp110_ = math_display_get_equation (self);
				_tmp111_ = _tmp110_;
				math_equation_insert (_tmp111_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp112_;
				MathEquation* _tmp113_;
				_tmp112_ = math_display_get_equation (self);
				_tmp113_ = _tmp112_;
				math_equation_insert (_tmp113_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp114_ = FALSE;
		GdkModifierType _tmp115_;
		gboolean _tmp120_;
		_tmp115_ = state;
		if (_tmp115_ == GDK_MOD1_MASK) {
			_tmp114_ = TRUE;
		} else {
			MathEquation* _tmp116_;
			MathEquation* _tmp117_;
			NumberMode _tmp118_;
			NumberMode _tmp119_;
			_tmp116_ = math_display_get_equation (self);
			_tmp117_ = _tmp116_;
			_tmp118_ = math_equation_get_number_mode (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp114_ = _tmp119_ == NUMBER_MODE_SUBSCRIPT;
		}
		_tmp120_ = _tmp114_;
		if (_tmp120_) {
			GdkEventKey _tmp121_;
			guint _tmp122_;
			_tmp121_ = *event;
			_tmp122_ = _tmp121_.keyval;
			switch (_tmp122_) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp123_;
					MathEquation* _tmp124_;
					_tmp123_ = math_display_get_equation (self);
					_tmp124_ = _tmp123_;
					math_equation_insert (_tmp124_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp125_;
					MathEquation* _tmp126_;
					_tmp125_ = math_display_get_equation (self);
					_tmp126_ = _tmp125_;
					math_equation_insert (_tmp126_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp127_;
					MathEquation* _tmp128_;
					_tmp127_ = math_display_get_equation (self);
					_tmp128_ = _tmp127_;
					math_equation_insert (_tmp128_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp129_;
					MathEquation* _tmp130_;
					_tmp129_ = math_display_get_equation (self);
					_tmp130_ = _tmp129_;
					math_equation_insert (_tmp130_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp131_;
					MathEquation* _tmp132_;
					_tmp131_ = math_display_get_equation (self);
					_tmp132_ = _tmp131_;
					math_equation_insert (_tmp132_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp133_;
					MathEquation* _tmp134_;
					_tmp133_ = math_display_get_equation (self);
					_tmp134_ = _tmp133_;
					math_equation_insert (_tmp134_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp135_;
					MathEquation* _tmp136_;
					_tmp135_ = math_display_get_equation (self);
					_tmp136_ = _tmp135_;
					math_equation_insert (_tmp136_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp137_;
					MathEquation* _tmp138_;
					_tmp137_ = math_display_get_equation (self);
					_tmp138_ = _tmp137_;
					math_equation_insert (_tmp138_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp139_;
					MathEquation* _tmp140_;
					_tmp139_ = math_display_get_equation (self);
					_tmp140_ = _tmp139_;
					math_equation_insert (_tmp140_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp141_;
					MathEquation* _tmp142_;
					_tmp141_ = math_display_get_equation (self);
					_tmp142_ = _tmp141_;
					math_equation_insert (_tmp142_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void math_display_status_changed_cb (MathDisplay* self) {
	GtkTextBuffer* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_;
	MathEquation* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_buffer;
	_tmp1_ = math_display_get_equation (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_tmp7_ = math_display_get_equation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GtkSpinner* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = self->priv->spinner;
		_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp13_ = _tmp6_;
	if (_tmp13_) {
		GtkSpinner* _tmp14_;
		GtkSpinner* _tmp15_;
		_tmp14_ = self->priv->spinner;
		gtk_widget_show ((GtkWidget*) _tmp14_);
		_tmp15_ = self->priv->spinner;
		gtk_spinner_start (_tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		MathEquation* _tmp17_;
		MathEquation* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp23_;
		_tmp17_ = math_display_get_equation (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = math_equation_get_in_solve (_tmp18_);
		_tmp20_ = _tmp19_;
		if (!_tmp20_) {
			GtkSpinner* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp21_ = self->priv->spinner;
			_tmp22_ = gtk_widget_get_visible ((GtkWidget*) _tmp21_);
			_tmp16_ = _tmp22_;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp23_ = _tmp16_;
		if (_tmp23_) {
			GtkSpinner* _tmp24_;
			GtkSpinner* _tmp25_;
			_tmp24_ = self->priv->spinner;
			gtk_widget_hide ((GtkWidget*) _tmp24_);
			_tmp25_ = self->priv->spinner;
			gtk_spinner_stop (_tmp25_);
		}
	}
}


static void math_display_error_status_changed_cb (MathDisplay* self) {
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	MathEquation* _tmp4_;
	MathEquation* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_;
	MathEquation* _tmp9_;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_;
	MathEquation* _tmp12_;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_;
	MathEquation* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	MathEquation* _tmp18_;
	MathEquation* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	MathEquation* _tmp22_;
	MathEquation* _tmp23_;
	GtkTextIter _tmp24_;
	GtkTextIter _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_display_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_display_get_equation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
	_tmp7_ = _tmp6_;
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
		return;
	}
	_tmp8_ = math_display_get_equation (self);
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
	start = _tmp10_;
	_tmp11_ = math_display_get_equation (self);
	_tmp12_ = _tmp11_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	_tmp14_ = math_display_get_equation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
	_tmp18_ = math_display_get_equation (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
	_tmp22_ = math_display_get_equation (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
}


MathEquation* math_display_get_equation (MathDisplay* self) {
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


static void math_display_class_init (MathDisplayClass * klass) {
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathDisplayPrivate));
	GTK_WIDGET_CLASS (klass)->key_press_event = math_display_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_display_instance_init (MathDisplay * self) {
	self->priv = MATH_DISPLAY_GET_PRIVATE (self);
}


static void math_display_finalize (GObject* obj) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->info_buffer);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}


GType math_display_get_type (void) {
	static volatile gsize math_display_type_id__volatile = 0;
	if (g_once_init_enter (&math_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
		GType math_display_type_id;
		math_display_type_id = g_type_register_static (GTK_TYPE_VIEWPORT, "MathDisplay", &g_define_type_info, 0);
		g_once_init_leave (&math_display_type_id__volatile, math_display_type_id);
	}
	return math_display_type_id__volatile;
}


static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



