#include <winpr/crt.h>
#include <winpr/print.h>

#include "../ncrush.h"

static const BYTE TEST_BELLS_DATA[] = "for.whom.the.bell.tolls,.the.bell.tolls.for.thee!";

static const BYTE TEST_BELLS_NCRUSH[] =
    "\xfb\x1d\x7e\xe4\xda\xc7\x1d\x70\xf8\xa1\x6b\x1f\x7d\xc0\xbe\x6b"
    "\xef\xb5\xef\x21\x87\xd0\xc5\xe1\x85\x71\xd4\x10\x16\xe7\xda\xfb"
    "\x1d\x7e\xe4\xda\x47\x1f\xb0\xef\xbe\xbd\xff\x2f";

static BOOL test_NCrushCompressBells(void)
{
	BOOL rc = FALSE;
	int status = 0;
	UINT32 Flags = 0;
	const BYTE* pDstData = NULL;
	BYTE OutputBuffer[65536] = { 0 };
	const UINT32 SrcSize = sizeof(TEST_BELLS_DATA) - 1;
	const BYTE* pSrcData = TEST_BELLS_DATA;
	const UINT32 expectedSize = sizeof(TEST_BELLS_NCRUSH) - 1;
	UINT32 DstSize = sizeof(OutputBuffer);
	NCRUSH_CONTEXT* ncrush = ncrush_context_new(TRUE);

	if (!ncrush)
		return rc;

	status = ncrush_compress(ncrush, pSrcData, SrcSize, OutputBuffer, &pDstData, &DstSize, &Flags);

	if (status < 0)
		goto fail;

	printf("status: %d Flags: 0x%08" PRIX32 " DstSize: %" PRIu32 "\n", status, Flags, DstSize);

	if (DstSize != expectedSize)
	{
		printf("NCrushCompressBells: output size mismatch: Actual: %" PRIu32 ", Expected: %" PRIu32
		       "\n",
		       DstSize, expectedSize);
		printf("Actual\n");
		BitDump(__func__, WLOG_INFO, pDstData, DstSize * 8, 0);
		printf("Expected\n");
		BitDump(__func__, WLOG_INFO, TEST_BELLS_NCRUSH, expectedSize * 8, 0);
		goto fail;
	}

	if (memcmp(pDstData, TEST_BELLS_NCRUSH, DstSize) != 0)
	{
		printf("NCrushCompressBells: output mismatch\n");
		printf("Actual\n");
		BitDump(__func__, WLOG_INFO, pDstData, DstSize * 8, 0);
		printf("Expected\n");
		BitDump(__func__, WLOG_INFO, TEST_BELLS_NCRUSH, expectedSize * 8, 0);
		goto fail;
	}

	rc = TRUE;
fail:
	ncrush_context_free(ncrush);
	return rc;
}

static BOOL test_NCrushDecompressBells(void)
{
	BOOL rc = FALSE;
	int status = 0;
	UINT32 Flags = 0;
	const BYTE* pSrcData = NULL;
	UINT32 SrcSize = 0;
	UINT32 DstSize = 0;
	UINT32 expectedSize = 0;
	const BYTE* pDstData = NULL;
	NCRUSH_CONTEXT* ncrush = ncrush_context_new(FALSE);

	if (!ncrush)
		return rc;

	SrcSize = sizeof(TEST_BELLS_NCRUSH) - 1;
	pSrcData = (const BYTE*)TEST_BELLS_NCRUSH;
	Flags = PACKET_COMPRESSED | 2;
	expectedSize = sizeof(TEST_BELLS_DATA) - 1;
	status = ncrush_decompress(ncrush, pSrcData, SrcSize, &pDstData, &DstSize, Flags);

	if (status < 0)
		goto fail;

	printf("Flags: 0x%08" PRIX32 " DstSize: %" PRIu32 "\n", Flags, DstSize);

	if (DstSize != expectedSize)
	{
		printf("NCrushDecompressBells: output size mismatch: Actual: %" PRIu32
		       ", Expected: %" PRIu32 "\n",
		       DstSize, expectedSize);
		goto fail;
	}

	if (memcmp(pDstData, TEST_BELLS_DATA, DstSize) != 0)
	{
		printf("NCrushDecompressBells: output mismatch\n");
		goto fail;
	}

	rc = TRUE;
fail:
	ncrush_context_free(ncrush);
	return rc;
}

int TestFreeRDPCodecNCrush(int argc, char* argv[])
{
	WINPR_UNUSED(argc);
	WINPR_UNUSED(argv);

	if (!test_NCrushCompressBells())
		return -1;

	if (!test_NCrushDecompressBells())
		return -1;

	return 0;
}
