.\" dpkg manual page - dpkg-genchanges(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2016 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2010 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-genchanges 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-genchanges \- Créer des fichiers «\ .changes\ ».
.
.SH SYNOPSIS
\fBdpkg\-genchanges\fP [\fIoption\fP...]
.br
.
.SH DESCRIPTION
\fBdpkg\-genchanges\fP lit les informations à la fois dans une arborescence
debian dépaquetée et déjà construite et à partir des fichiers qui ont été
créés, et il crée un fichier de contrôle pour la mise en place dans
l'archive Debian (c'est le fichier \fB.changes\fP).
.
.SH OPTIONS
.TP 
\fB\-\-build=\fP\fItype\fP
Indique le \fItype\fP de construction à partir d'une liste, séparée par des
virgules, de composants (depuis dpkg\ 1.18.5).

Les valeurs autorisées sont\ :
.RS
.TP 
\fBsource\fP
Envoyer le paquet source.
.TP 
\fBany\fP
Envoyer les paquets binaires spécifiques à l'architecture.
.TP 
\fBall\fP
Envoyer les paquets binaires indépendants de l'architecture.
.TP 
\fBbinary\fP
Envoyer les paquets binaires spécifiques et indépendants de
l'architecture. C'est un alias pour \fBany,all\fP.
.TP 
\fBfull\fP
Envoyer tout. C'est un alias de \fBsource,any,all\fP et identique au cas par
défaut où aucune option de construction n'est indiquée.
.RE
.TP 
\fB\-g\fP
Équivalent de \fB\-\-build=source,all\fP (depuis dpkg\ 1.17.11).
.TP 
\fB\-G\fP
Équivalent de \fB\-\-build=source,any\fP (depuis dpkg\ 1.17.11).
.TP 
\fB\-b\fP
Équivalent de \fB\-\-build=binary\fP ou \fB\-\-build=any,all\fP.
.TP 
\fB\-B\fP
Équivalent de \fB\-\-build=any\fP
.TP 
\fB\-A\fP
Équivalent de \fB\-\-build=all\fP.
.TP 
\fB\-S\fP
Équivalent à \fB\-\-build=source\fP.
.PP
Les options \fB\-s\fP\fIx\fP contrôlent si l'archive source d'origine est incluse
dans l'installation produite si un paquet source est créé (c'est\-à\-dire que
les options \fB\-b\fP ou \fB\-B\fP n'ont pas été utilisées).
.TP 
\fB\-si\fP
Par défaut, ou quand l'option est indiquée, les sources d'origine sont
incluses uniquement si le numéro de version majeur (c'est\-à\-dire la version
sans les parties epoch et «\ révision Debian\ ») diffère de la version
précédente indiquée dans le fichier de changelog.
.TP 
\fB\-sa\fP
Force l'inclusion des sources d'origine.
.TP 
\fB\-sd\fP
Force l'exclusion des sources d'origine et inclut seulement le «\ diff\ ».
.fi
.TP 
\fB\-v\fP\fIversion\fP
Force l'utilisation des informations contenues dans le fichier «\ changelog\ »
et qui concernent toutes les versions strictement plus récentes que
\fIversion\fP.
.TP 
\fB\-C\fP\fIdescription\-des\-changements\fP
Lit la description des changements dans le fichier
\fIdescription\-des\-changements\fP plutôt que dans le fichier «\ changelog\ » de
l'arborescence source.
.TP 
\fB\-m\fP\fIadresse\-du\-responsable\fP
Utilise \fIadresse\-du\-responsable\fP comme nom et adresse électronique du
responsable de paquet plutôt que d'utiliser les informations contenues dans
le fichier «\ control\ » de l'arborescence source.
.TP 
\fB\-e\fP\fIadresse\-du\-responsable\fP
Utilise \fIadresse\-du\-responsable\fP comme nom et adresse électronique du
responsable de paquet pour cette mise en place, plutôt que d'utiliser les
informations contenues dans le fichier «\ changelog\ » de l'arborescence
source.
.TP 
\fB\-V\fP\fInom\fP\fB=\fP\fIvaleur\fP
Fixe la valeur d'une variable de substitution. Consultez \fBdeb\-substvars\fP(5)
pour une discussion sur la valeur de substitution.
.TP 
\fB\-T\fP\fIfichier\-substvars\fP
Lecture des variables de substitution depuis \fIfichier\-substvars\fP\ ; la
valeur par défaut est \fBdebian/substvars\fP. Aucune substitution de variable
n'est faite sur les champs de sortie, sauf pour les contenus extraits de
chaque champ \fBDescription\fP du paquet binaire (depuis dpkg\ 1.19.0),
cependant la variable spéciale \fIFormat\fP remplacera le champ qui porte le
même nom. Cette option peut être utilisée plusieurs fois pour lire les
variables de substitution depuis plusieurs fichiers (depuis dpkg\ 1.15.6).

.TP 
\fB\-D\fP\fIchamp\fP\fB=\fP\fIvaleur\fP
Remplace ou ajoute en sortie un champ dans le fichier de contrôle.
.TP 
\fB\-U\fP\fIchamp\fP
Supprime en sortie un champ dans le fichier de contrôle.
.TP 
\fB\-c\fP\fIfichier/control\fP
Indique le principal fichier de contrôle des sources où trouver des
renseignements. Par défaut, c'est le fichier \fBdebian/control\fP.
.TP 
\fB\-l\fP\fIfichier\-des\-changements\fP
Indique le fichier des changements où trouver des renseignements. Par
défaut, c'est le fichier \fBdebian/changelog\fP.
.TP 
\fB\-f\fP\fIfichier/liste\-des\-fichiers\fP
Lit ou écrit la liste des fichiers qui doivent être envoyés vers l'archive
dans ce fichier plutôt que dans le fichier \fBdebian/files\fP.
.TP 
\fB\-F\fP\fIformat\-du\-fichier\-des\-changements\fP
Indique le format du fichier des changements. Voir \fBdpkg\-parsechangelog\fP(1)
pour plus d'informations à propos des formats gérés.
.TP 
\fB\-u\fP\fIrépertoire\-des\-fichiers\-à\-installer\fP
Cherche les fichiers à installer dans \fIrépertoire\-des\-fichiers\-à\-installer\fP
plutôt que dans \fB..\fP (\fBdpkg\-genchanges\fP doit trouver ces fichiers de
manière à mettre leurs tailles et leurs sommes de contrôle dans le fichier
\&\fB.changes\fP).
.TP 
\fB\-q\fP
\fBdpkg\-genchanges\fP affiche habituellement des messages d'information sur la
sortie d'erreur standard\ ; par exemple, combien de fichiers source du paquet
sont en cours d'installation. \fB\-q\fP supprime ces messages.
.TP 
\fB\-O\fP[\fInom\-de\-fichier\fP]
Affiche le fichier des modifications sur la sortie standard (par défaut) ou
dans \fInom\-de\-fichier\fP s'il est indiqué (depuis dpkg\ 1.18.5).
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.
.SH FICHIERS
.TP 
\fBdebian/files\fP
La liste des fichiers créés qui seront envoyés sur le
serveur. \fBdpkg\-genchanges\fP lit dans ce fichier les données nécessaires à la
création du fichier \fB.changes\fP.
.
.SH "VOIR AUSSI"
.ad l
\fBdeb\-substvars\fP(5), \fBdeb\-src\-control\fP(5), \fBdeb\-src\-files\fP(5),
\fBdeb\-changelog\fP(5), \fBdeb\-changes\fP(5).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
