/*
 
 *****************************************************************************
 * Author:                                                                   *
 * ------                                                                    *
 *  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  *
 *  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    *
 *  Jozef Stefan Institute                          Fax: x 386 1 477 3811    *
 *  Jamova 39, SI-1000 Ljubljana                                             *
 *  SLOVENIA                                                                 *
 *                                                                           *
 * Source: $XCRYSDEN_TOPDIR/C/cryTogl.c
 * ------                                                                    *
 * Copyright (c) 1996-2003 by Anton Kokalj                                   *
 *****************************************************************************

*/


#include "togl.h"
#include "struct.h"
#include "xcfunc.h"

extern void crySetProjection( NEW_WIN_CONTEXT *wc, struct Togl *togl );
extern NEW_WIN_CONTEXT *FindWinContextByTogl(struct Togl *togl);

/* ------------------------------------------------------------------------
 *
 * $togl cry_toglzoom zoom-factor
 *
 * ------------------------------------------------------------------------ */
int
CRY_ToglZoomCb(struct Togl *togl, int argc, char *argv[]) {
  Tcl_Interp *interp = Togl_Interp (togl);
  double     zoom;

  if ( argc != 3 ) {
    interp->result = "Usage: toglName cry_toglzoom zoom-factor";
    return TCL_ERROR;
  }

  if ( Tcl_GetDouble(interp, argv[2], &zoom) == TCL_ERROR ) {
    sprintf(interp->result,"wanted integer, but got \"%s\"", argv[2]);
    return TCL_ERROR;
  }

  if (zoom < -(1-1e-8) ) {
    sprintf(interp->result,"zoom factor %f out of range", zoom);
    return TCL_ERROR;
  }

  if ( togl != Togl_FindTogl(".mesa") ) {
    NEW_WIN_CONTEXT *wc = FindWinContextByTogl (togl);
    wc->tr.zoom *= (1.0 + zoom);
    crySetProjection (wc, togl);      
  } else {
    tr.zoom *= (1.0 + zoom);
    xcViewPort();
    LoadLights();
  }
  
  /* now update the display */
  Togl_PostRedisplay(togl);
  
  return TCL_OK; 
}
