/*   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.codehaus.annogen.override;



/**
 * <p>Provides a proxied, modifiable view of a JSR175 annotation.
 * Implementations of this interface are usually code-generated by the
 * AnnogenTask.</p>
 *
 * @author Patrick Calahan &lt;email: pcal-at-bea-dot-com&gt;
 */
public interface AnnoBean {

  // ========================================================================
  // Constants

  /**
   * <p>Name of the member of annotations which have only a single member.
   * As specified in JSR175, that name is "value", but you should use
   * this constant to prevent typos.</p>
   */
  public static final String SINGLE_MEMBER_NAME = "value";

  // ========================================================================
  // Public methods

  public boolean setValue(String name, Object value);

  /**
   * Returns an instance of an AnnoBean for the given annotation type
   * which can be used as an AnnoBean for a nested annotation value.
   * This does NOT 'add' the nested annotation to this AnnoBean - it is
   * expected that the caller will later pass it as the value parameter
   * of a subsequent call to setValue.
   *
   * Note that this can also be used for constructing elements of an
   * array of nested annotation values.
   */
  public AnnoBean createNestableBean(Class beanOrAnnoType);


  //uncomment these when have time to implement them

  /**
   */
  //public Object getValue(String name);

  //public boolean isDefaultValueUsed(String valueName);


}




