/* pathjumpop.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2012-2013 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "pathjumpop.hh"
#include "listermode.h"
#include "pathjumpui.hh"
#include "nmspecialsourceext.hh"
#include "worker.h"
#include "worker_locale.h"
#include "fileentry.hh"
#include "argclass.hh"
#include "nwc_path.hh"
#include "virtualdirmode.hh"

const char *PathJumpOp::name = "PathJumpOp";

PathJumpOp::PathJumpOp() : FunctionProto()
{
    m_category = FunctionProto::CAT_CURSOR;
}

PathJumpOp::~PathJumpOp()
{
}

PathJumpOp *PathJumpOp::duplicate() const
{
    PathJumpOp *ta = new PathJumpOp();
    return ta;
}

bool PathJumpOp::isName(const char *str)
{
    if ( strcmp( str, name ) == 0 )
        return true;
    else
        return false;
}

const char *PathJumpOp::getName()
{
    return name;
}

int PathJumpOp::run( WPUContext *wpu, ActionMessage *msg )
{
    Lister *l1;
    ListerMode *lm1;
    
    l1 = msg->getWorker()->getActiveLister();
    if ( l1 == NULL )
        return 1;

    msg->getWorker()->setWaitCursor();

    PathJumpUI ui( *Worker::getAGUIX(),
                   msg->getWorker()->getPathStore(),
                   *msg->getWorker() );

    lm1 = l1->getActiveMode();
    if ( lm1 ) {
        std::list< NM_specialsourceExt > sellist;
        lm1->getSelFiles( sellist, ListerMode::LM_GETFILES_ONLYACTIVE );
            
        std::string dirname, basename;

        dirname = lm1->getCurrentDirectory();

        if ( sellist.empty() == false ) {
            if ( (*sellist.begin()).entry() != NULL ) {
                basename = (*sellist.begin()).entry()->name;
                dirname = NWC::Path::dirname( sellist.begin()->entry()->fullname );
            }
        }
            
        ui.setCurrentDirname( dirname );
        ui.setCurrentBasename( basename );
    }

    int res = ui.mainLoop();

    if ( res == 1 ) {
        std::string sel_path = ui.getSelectedPath();

        std::list< RefCount< ArgClass > > args;

        if ( lm1 ) {
            args.push_back( new StringArg( sel_path ) );
            lm1->runCommand( "enter_dir", args );

            // if ( highlight_entry.empty() == false ) {
            //     nm1->activateEntry( highlight_entry );
            // }
        }
    } else if ( res == 2 ) {
        std::unique_ptr< NWC::Dir > resdir = ui.getResultsAsDir();

        l1->switch2Mode( 0 );

        VirtualDirMode *vdm = dynamic_cast< VirtualDirMode* >( l1->getActiveMode() );
        if ( vdm != NULL ) {
            vdm->newTab();

            vdm->showDir( resdir );
        }
    }

    msg->getWorker()->unsetWaitCursor();
    return 0;
}

const char *PathJumpOp::getDescription()
{
    return catalog.getLocaleCom( 60 );
}
