/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.UnsupportedComponentException;
import org.web3d.vrml.lang.UnsupportedNodeException;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.sav.VRMLParseException;

public class PlainTextErrorReporter
implements ErrorReporter {
    private HashSet ignoredExceptionTypes;

    public PlainTextErrorReporter() {
        this.messageReport("Xj3D Version: 2_M1\n");
        this.ignoredExceptionTypes = new HashSet();
        this.ignoredExceptionTypes.add(InvalidFieldException.class);
        this.ignoredExceptionTypes.add(InvalidFieldFormatException.class);
        this.ignoredExceptionTypes.add(InvalidFieldValueException.class);
        this.ignoredExceptionTypes.add(FileNotFoundException.class);
        this.ignoredExceptionTypes.add(IOException.class);
        this.ignoredExceptionTypes.add(UnknownHostException.class);
        this.ignoredExceptionTypes.add(IllegalArgumentException.class);
        this.ignoredExceptionTypes.add(InvalidFieldConnectionException.class);
        this.ignoredExceptionTypes.add(VRMLParseException.class);
        this.ignoredExceptionTypes.add(UnsupportedComponentException.class);
        this.ignoredExceptionTypes.add(UnsupportedNodeException.class);
        this.ignoredExceptionTypes.add(UnsupportedProfileException.class);
        this.ignoredExceptionTypes.add(ClassNotFoundException.class);
    }

    public void partialReport(String string) {
        System.out.print(string);
    }

    public void messageReport(String string) {
        System.out.print("Message: ");
        System.out.println(string);
    }

    public void warningReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Warning: ");
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)exception).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = exception.getClass().getName();
            }
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                stringBuffer.append(stringWriter.toString());
            }
        }
        System.out.println(stringBuffer.toString());
    }

    public void errorReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Error: ");
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)exception).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = exception.getClass().getName();
            }
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                stringBuffer.append(stringWriter.toString());
            }
        }
        System.out.println(stringBuffer.toString());
    }

    public void fatalErrorReport(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Fatal Error: ");
        if (exception instanceof VRMLParseException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((VRMLParseException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((VRMLParseException)exception).getColumnNumber());
            stringBuffer.append('\n');
        } else if (exception instanceof InvalidFieldFormatException) {
            stringBuffer.append(" Line: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getLineNumber());
            stringBuffer.append(" Column: ");
            stringBuffer.append(((InvalidFieldFormatException)exception).getColumnNumber());
            stringBuffer.append('\n');
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 == null) {
                string2 = exception.getClass().getName();
            }
            stringBuffer.append(string2);
            stringBuffer.append('\n');
            if (!this.ignoredExceptionTypes.contains(exception.getClass())) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                stringBuffer.append(stringWriter.toString());
            }
        }
        System.out.println(stringBuffer.toString());
    }
}

