/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

public class StringArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int DEFAULT_INCREMENT = 256;
    private int valueCount;
    private String[] array;
    private final int incrementSize;

    public StringArray() {
        this(512, 256);
    }

    public StringArray(int n) {
        this(n, 256);
    }

    public StringArray(int n, int n2) {
        this.incrementSize = n2;
        this.array = new String[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        for (int i = this.valueCount - 1; i >= 0; --i) {
            this.array[i] = null;
        }
        this.valueCount = 0;
    }

    public void add(String string) {
        if (this.valueCount == this.array.length) {
            String[] stringArray = new String[this.array.length + this.incrementSize];
            System.arraycopy(this.array, 0, stringArray, 0, this.array.length);
            this.array = stringArray;
        }
        this.array[this.valueCount++] = string;
    }

    public void add(String[] stringArray) {
        int n = this.valueCount + stringArray.length;
        if (n >= this.array.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(this.array, 0, stringArray2, 0, this.array.length);
            this.array = stringArray2;
        }
        System.arraycopy(stringArray, 0, this.array, this.valueCount, stringArray.length);
        this.valueCount = n;
    }

    public String get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, String string) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = string;
    }

    public String remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        String string = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return string;
    }

    public String[] toArray() {
        String[] stringArray = new String[this.valueCount];
        System.arraycopy(this.array, 0, stringArray, 0, this.valueCount);
        return stringArray;
    }

    public String[] toArray(String[] stringArray) {
        String[] stringArray2 = null;
        stringArray2 = stringArray.length >= this.valueCount ? stringArray : new String[this.valueCount];
        System.arraycopy(this.array, 0, stringArray2, 0, this.valueCount);
        return stringArray2;
    }
}

