#! /bin/bash

# compile all examples

for f in $@
do
  body=$(basename $f .cc)
  common_flags="-Ofast -std=c++11 -march=native -pthread"

  echo compiling $body with:

  echo g++ $common_flags -Wno-abi -o$body $f -lvigraimpex
  g++ $common_flags -Wno-abi -o$body $f -lvigraimpex
  
  echo g++ -DUSE_VC $common_flags -Wno-abi -o$body $f -lVc -lvigraimpex
  g++ -DUSE_VC $common_flags -Wno-abi -o$body $f -lVc -lvigraimpex

  echo clang++ $common_flags -o$body $f -lvigraimpex
  clang++ $common_flags -o$body $f -lvigraimpex
  
  echo clang++ -DUSE_VC $common_flags -o$body $f -lVc -lvigraimpex
  clang++ -DUSE_VC $common_flags -o$body $f -lVc -lvigraimpex

done
