/*
 * Decompiled with CFR 0.152.
 */
package rdr;

import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import rdr.Exception;
import rdr.InStream;

public class ZlibInStream
extends InStream {
    static final int defaultBufSize = 16384;
    private InStream underlying;
    private int bufSize;
    private int ptrOffset;
    private Inflater inflater;
    private int bytesIn;

    public ZlibInStream(int bufSize_) {
        this.bufSize = bufSize_;
        this.b = new byte[this.bufSize];
        this.ptrOffset = 0;
        this.end = 0;
        this.ptr = 0;
        this.inflater = new Inflater();
    }

    public ZlibInStream() {
        this(16384);
    }

    public void setUnderlying(InStream is, int bytesIn_) {
        this.underlying = is;
        this.bytesIn = bytesIn_;
        this.end = 0;
        this.ptr = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void reset() {
        this.end = 0;
        this.ptr = 0;
        if (this.underlying != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.decompress();
            this.end = 0;
lbl7:
            // 2 sources

            ** while (this.bytesIn > 0)
        }
lbl8:
        // 1 sources

        this.underlying = null;
    }

    public int pos() {
        return this.ptrOffset + this.ptr;
    }

    protected int overrun(int itemSize, int nItems) {
        if (itemSize > this.bufSize) {
            throw new Exception("ZlibInStream overrun: max itemSize exceeded");
        }
        if (this.underlying == null) {
            throw new Exception("ZlibInStream overrun: no underlying stream");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.ptrOffset += this.ptr;
        this.end -= this.ptr;
        this.ptr = 0;
        while (this.end < itemSize) {
            this.decompress();
        }
        if (itemSize * nItems > this.end) {
            nItems = this.end / itemSize;
        }
        return nItems;
    }

    private void decompress() {
        try {
            this.underlying.check(1);
            int avail_in = this.underlying.getend() - this.underlying.getptr();
            if (avail_in > this.bytesIn) {
                avail_in = this.bytesIn;
            }
            if (this.inflater.needsInput()) {
                this.inflater.setInput(this.underlying.getbuf(), this.underlying.getptr(), avail_in);
            }
            int n = this.inflater.inflate(this.b, this.end, this.bufSize - this.end);
            this.end += n;
            if (this.inflater.needsInput()) {
                this.bytesIn -= avail_in;
                this.underlying.setptr(this.underlying.getptr() + avail_in);
            }
        }
        catch (DataFormatException e) {
            throw new Exception("ZlibInStream: inflate failed");
        }
    }
}

