# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#-------------------------------------------------------------------------------------------------------------
# Reste à faire :
#-------------------------------------------------------------------------------------------------------------

#Standards Modules
import subprocess
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp     # use by windows version for mplayer -wid parameter

#Modules from Videoporama project
from main_winDLG import *
from GlobalDefines import *
from SoundProcess import *

class RenderDlgSound() :
    def __init__(self,VideoporamaInstance,RenderDlg,StartRenderSequence=0):
      self.VideoporamaInstance = VideoporamaInstance  # Instance of the Application
      self.RenderDlg           = RenderDlg            # Instance of the Render Dialog Box
      self.StartRenderSequence = StartRenderSequence  # Number of the first sequence to render

    def ConvertSound(self):
      NbrFrameToConvert= float(self.RenderDlg.totimage)

      #Preview mode : send 2 sec special black frame to MPlayer to force it to start
      if self.RenderDlg.IsPreview==True : 
        if ExecuteCommande("\""+self.VideoporamaInstance.S+"sox\" -V3 -r 48000 -n \""+self.VideoporamaInstance.T+"nul-sound.tmp.wav"+\
        "\" fade 00:00:00.000 00:00:02.000 00:00:00.000 channels 2",self.RenderDlg)==False:
          return False

      # Prepare input sound file
      CurrentProgress  = 0
      self.RenderDlg.DoRenderInfoSound(self.VideoporamaInstance.qtapp.translate("Render","Converting input sound file"),CurrentProgress)
      return self.MakeMusicSoundTrack(0,45)

    #----------------------------------------------------------------------------------------------------------------
    # Produce Music track for all items
    # CurrentProgress    = Start for progress indicator
    # MaxCurrentProgress = End for progress indicator for this process
    #----------------------------------------------------------------------------------------------------------------
    def MakeMusicSoundTrack(self,StartProgress,MaxCurrentProgress):
      CurrentProgress  = 0
      CurrentFrame     = 0
      #------------------------------------------------------
      # Get music information
      #------------------------------------------------------
      InputSoundFile="-n"    # Default : -n = null sound for sox
      # Create sound file as define in sound mix tool
      try :
        xmlSound = self.VideoporamaInstance.ProjectXMLObject.getElementsByTagName(u"sound")[0]
      except :
        xmlSound = None
      self.soundProcess = SND_Process(self.VideoporamaInstance, self.RenderDlg)
      self.soundProcess.setSoundToProcess(xmlSound, self.VideoporamaInstance.T+u"audio.tmp.wav", self.RenderDlg.SeqFrameDurationToString(self.RenderDlg.totimage))
      return self.soundProcess.run() 
 