/* 
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * Update to VDK 0.5.0
 * by mm 12.13.1998
 * ===========================
 * 
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *  
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */


#include "vdk/tables.h"
#include "vdk/forms.h"

VDKTable::VDKTable(VDKForm* owner,
		   int rows, int cols, 
		   int homogeneous):
  VDKObjectContainer(owner),
  ColSpacing("ColSpacing",this,1,&VDKTable::SetColSpacings),
  RowSpacing("RowSpacing",this,1,&VDKTable::SetRowSpacings)
{
  widget = gtk_table_new(rows,cols,homogeneous);
  gtk_table_set_row_spacings(GTK_TABLE(widget),1);
  gtk_table_set_col_spacings(GTK_TABLE(widget),1);
}
/*
 */
VDKTable::~VDKTable()
{
}
/*
Simple attachment, (use defaults)
 */
void
VDKTable::Add(VDKObject* obj, 
	    int left_attach,
	    int right_attach,
	    int top_attach,
	    int bot_attach)
{
  gtk_table_attach_defaults(GTK_TABLE(widget),
			    obj->Widget(),
			    left_attach,
			    right_attach,
			    top_attach,
			    bot_attach);
  VDKObjectContainer::Add(obj,0,0,0,0);
}

/*
Easier attachment that use
same args both for x,y direction. 
Args:
row,col: table cell coordinates where put object
opt: if you like to fill/expand (valid for both x,y)
padding: if you want pad or not (both x,y)
For more precise adding use AddExt()
 */
void VDKTable:: AddToCell(VDKObject* obj, 
		   int row, 
		   int col, 
		   int opt, 
		   int padding)
{
  gtk_table_attach(GTK_TABLE(widget),
		   obj->Widget(),
		   col,col+1,row,row+1,
		   GtkAttachOptions(opt),
		   GtkAttachOptions(opt),
		   padding,padding);
  VDKObjectContainer::Add(obj,0,0,0,0);
}

/*
Extended attachment all args set
by user
 */
void 
VDKTable::AddExt(VDKObject* obj, 
		 int l_a, // left attach
		 int r_a, // right attach
		 int t_a, //top attach
		 int b_a, // bottom attach
		 int x_o, // x options
		 int y_o, // y options
		 int x_p, // x padding 
		 int y_p) // y padding
{
  gtk_table_attach(GTK_TABLE(widget),
		   obj->Widget(),
		   l_a,r_a,t_a,b_a,
		   GtkAttachOptions(x_o),
		   GtkAttachOptions(y_o),x_p,y_p);
  VDKObjectContainer::Add(obj,0,0,0,0);
}

 


 



