// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
/****************************************************************************/
/*																			*/
/* File:	  shades.h														*/
/*																			*/
/* Purpose:   patterns for shading polygons                                     */
/*																			*/
/*																			*/
/* Author:	  Michael Lampe                                                                                 */
/*			  Institut fuer Computeranwendungen III                                                 */
/*			  Universitaet Stuttgart										*/
/*			  Pfaffenwaldring 27											*/
/*			  70569 Stuttgart												*/
/*			  email: ug@ica3.uni-stuttgart.de						        */
/*																			*/
/* History:   10 .97 begin                                                                              */
/*																			*/
/* Remarks:                                                                                                                             */
/*																			*/
/****************************************************************************/


/* RCS_ID
   $Header$
 */

/****************************************************************************/
/*																			*/
/* auto include mechanism and other include files							*/
/*																			*/
/****************************************************************************/

#ifndef __SHADES__
#define __SHADES__

#define NO_PATTERNS  65
#define PATTERN_SIZE 8

static unsigned char pattern_data[NO_PATTERNS][8] = {
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  {0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  {0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00},
  {0x88, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00},
  {0x88, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00},
  {0x88, 0x00, 0x20, 0x00, 0x88, 0x00, 0x00, 0x00},
  {0x88, 0x00, 0x20, 0x00, 0x88, 0x00, 0x02, 0x00},
  {0x88, 0x00, 0x22, 0x00, 0x88, 0x00, 0x02, 0x00},
  {0x88, 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00},
  {0xa8, 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00},
  {0xa8, 0x00, 0x22, 0x00, 0x8a, 0x00, 0x22, 0x00},
  {0xaa, 0x00, 0x22, 0x00, 0x8a, 0x00, 0x22, 0x00},
  {0xaa, 0x00, 0x22, 0x00, 0xaa, 0x00, 0x22, 0x00},
  {0xaa, 0x00, 0xa2, 0x00, 0xaa, 0x00, 0x22, 0x00},
  {0xaa, 0x00, 0xa2, 0x00, 0xaa, 0x00, 0x2a, 0x00},
  {0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, 0x2a, 0x00},
  {0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00},
  {0xaa, 0x40, 0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00},
  {0xaa, 0x40, 0xaa, 0x00, 0xaa, 0x04, 0xaa, 0x00},
  {0xaa, 0x44, 0xaa, 0x00, 0xaa, 0x04, 0xaa, 0x00},
  {0xaa, 0x44, 0xaa, 0x00, 0xaa, 0x44, 0xaa, 0x00},
  {0xaa, 0x44, 0xaa, 0x10, 0xaa, 0x44, 0xaa, 0x00},
  {0xaa, 0x44, 0xaa, 0x10, 0xaa, 0x44, 0xaa, 0x01},
  {0xaa, 0x44, 0xaa, 0x11, 0xaa, 0x44, 0xaa, 0x01},
  {0xaa, 0x44, 0xaa, 0x11, 0xaa, 0x44, 0xaa, 0x11},
  {0xaa, 0x54, 0xaa, 0x11, 0xaa, 0x44, 0xaa, 0x11},
  {0xaa, 0x54, 0xaa, 0x11, 0xaa, 0x45, 0xaa, 0x11},
  {0xaa, 0x55, 0xaa, 0x11, 0xaa, 0x45, 0xaa, 0x11},
  {0xaa, 0x55, 0xaa, 0x11, 0xaa, 0x55, 0xaa, 0x11},
  {0xaa, 0x55, 0xaa, 0x51, 0xaa, 0x55, 0xaa, 0x11},
  {0xaa, 0x55, 0xaa, 0x51, 0xaa, 0x55, 0xaa, 0x15},
  {0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x15},
  {0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55},
  {0xea, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55},
  {0xea, 0x55, 0xaa, 0x55, 0xae, 0x55, 0xaa, 0x55},
  {0xee, 0x55, 0xaa, 0x55, 0xae, 0x55, 0xaa, 0x55},
  {0xee, 0x55, 0xaa, 0x55, 0xee, 0x55, 0xaa, 0x55},
  {0xee, 0x55, 0xba, 0x55, 0xee, 0x55, 0xaa, 0x55},
  {0xee, 0x55, 0xba, 0x55, 0xee, 0x55, 0xab, 0x55},
  {0xee, 0x55, 0xbb, 0x55, 0xee, 0x55, 0xab, 0x55},
  {0xee, 0x55, 0xbb, 0x55, 0xee, 0x55, 0xbb, 0x55},
  {0xfe, 0x55, 0xbb, 0x55, 0xee, 0x55, 0xbb, 0x55},
  {0xfe, 0x55, 0xbb, 0x55, 0xef, 0x55, 0xbb, 0x55},
  {0xff, 0x55, 0xbb, 0x55, 0xef, 0x55, 0xbb, 0x55},
  {0xff, 0x55, 0xbb, 0x55, 0xff, 0x55, 0xbb, 0x55},
  {0xff, 0x55, 0xfb, 0x55, 0xff, 0x55, 0xbb, 0x55},
  {0xff, 0x55, 0xfb, 0x55, 0xff, 0x55, 0xbf, 0x55},
  {0xff, 0x55, 0xff, 0x55, 0xff, 0x55, 0xbf, 0x55},
  {0xff, 0x55, 0xff, 0x55, 0xff, 0x55, 0xff, 0x55},
  {0xff, 0xd5, 0xff, 0x55, 0xff, 0x55, 0xff, 0x55},
  {0xff, 0xd5, 0xff, 0x55, 0xff, 0x5d, 0xff, 0x55},
  {0xff, 0xdd, 0xff, 0x55, 0xff, 0x5d, 0xff, 0x55},
  {0xff, 0xdd, 0xff, 0x55, 0xff, 0xdd, 0xff, 0x55},
  {0xff, 0xdd, 0xff, 0x75, 0xff, 0xdd, 0xff, 0x55},
  {0xff, 0xdd, 0xff, 0x75, 0xff, 0xdd, 0xff, 0x57},
  {0xff, 0xdd, 0xff, 0x77, 0xff, 0xdd, 0xff, 0x57},
  {0xff, 0xdd, 0xff, 0x77, 0xff, 0xdd, 0xff, 0x77},
  {0xff, 0xfd, 0xff, 0x77, 0xff, 0xdd, 0xff, 0x77},
  {0xff, 0xfd, 0xff, 0x77, 0xff, 0xdf, 0xff, 0x77},
  {0xff, 0xff, 0xff, 0x77, 0xff, 0xdf, 0xff, 0x77},
  {0xff, 0xff, 0xff, 0x77, 0xff, 0xff, 0xff, 0x77},
  {0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0x77},
  {0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0x7f},
  {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f},
  {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}
};

#endif
