[vset VERSION 0.1]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin canvas::edit::points n [vset VERSION]]
[keywords canvas]
[keywords editing]
[keywords {point cloud}]
[keywords points]
[moddesc   {Variations on a canvas}]
[titledesc {Editing a cloud of points on a canvas}]
[require Tcl 8.5]
[require Tk 8.5]
[require canvas::edit::points [opt [vset VERSION]]]
[description]

This package provides a class whose instances handle editing a cloud
of point markers on a canvas. Instances can be configured with regard
to the visual appearance of markers (regular, and highlighted). Note
that instances do not store the edited points themselves, but delegate
this to a configurable object.

[section {Class API}]

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd ::canvas::edit] [method points] [arg objectName] [arg canvas] [arg options]...]

This, the class command, creates and configures a new instance of a
point cloud editor, named [arg objectName]. The instance will be
connected to the specified [arg canvas] widget.

[para] The result of the command is the fully qualified name of the
instance command.

[para] The options accepted here, and their values, are explained in
the section [sectref Options].

[list_end]

[section {Instance API}]

Instances of the point cloud editors provide the following API:

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method destroy]]

This method destroys the point cloud editor and releases all its
internal resources.

[para] Note that this operation does not destroy the items of the
point markers the editor managed on the attached canvas, nor the
canvas itself.

[para] The result of the method is an empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method enable]]

This method activates editing of the point cloud on the canvas. This
is the default after instance creation. A call is ignored if the
editor is already active.

[para] The result of the method is an empty string.

[para] The complementary method is [method disable]. The interogatory
method for the current state is [method active].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method disable]]

This method disables editing of the point cloud on the canvas. A call
is ignored if the editor is already disabled.

[para] The result of the method is an empty string.

[para] The complementary method is [method enable]. The interogatory
method for the current state is [method active].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method active]]

This method queries the editor state.

[para] The result of the method is a boolean value, [const true] if
the editor is active, and [const false] otherwise, i.e. disabled.

[para] The methods to change the state are [method enable] and
[method disable].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method add] [arg x] [arg y]]

This method programmatically creates a point at the specified location.

[para] The result of the method is an empty string.

[para] Note that this method goes through the whole set of callbacks
invoked when the user interactively creates a point, i.e.
[option -create-cmd], and, more importantly, [option -data-cmd].

[para] This is the method through which to load pre-existing points
into an editor instance.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd objectName] [method clear]]

This method programmatically removes all points from the editor.

[para] The result of the method is an empty string.

[para] Note that this method goes through the same callback invoked
when the user interactively removes a point, i.e. [option -data-cmd].

[list_end]

[section Options]

The class command accepts the following options

[list_begin options]
[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -tag [arg string]]

The value of this option is the name of the canvas tag with which to
identify all items of all points managed by the editor.

[para] This option can only be set at construction time.

[para] If not specified it defaults to [const POINT]

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -create-cmd [arg command-prefix]]

The value of this option is a command prefix the editor will invoke
when it has to create a new point.

[para] This option can only be set at construction time.

[para] If not specified it defaults to a command which will create a
black-bordered blue circle of radius 3 centered on the location of the
new point.

[para] The signature of this command prefix is

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd createCmd] [arg canvas] [arg x] [arg y]]

The result of the command prefix [emph must] be a list of the canvas
items it created to represent the marker. Note here that the visual
representation of a "point" may consist of multiple canvas items in an
arbitrary shape.

[para] The returned list of items is allowed to be empty, and such is
taken as signal that the callback vetoed the creation of the point.

[list_end]

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -highlight-cmd [arg command-prefix]]

The value of this option is a command prefix the editor will invoke
when it has to (un)highlight a point.

[para] This option can only be set at construction time.

[para] If not specified it defaults to a command which will re-color
the item to highlight in red (and restores the color for
unhighlighting).

[para] The two signatures of this command prefix are

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd highlightCmd] [method on] [arg canvas] [arg item]]

[para] This method of the command prefix has to perform whatever is
needed to highlight the point the [arg item] is a part of (remember
the note above about points allowed to be constructed from multiple
canvas items).

[para] The result of the command can be anything and will be passed as
is as argument [arg state] to the [method off] method.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd highlightCmd] [method off] [arg canvas] [arg state]]

[para] This method is invoked to unhighlight a point described by the
[arg state], which is the unchanged result of the [method on] method
of the command prefix. The result of this method is ignored.

[para] Note any interaction between dragging and highlighting of
points is handled within the editor, and that the callback bears no
responsibility for doing such.

[list_end]

[comment {= = == === ===== ======== ============= =====================}]
[comment {= = == === ===== ======== ============= =====================}]
[opt_def -data-cmd [arg command-prefix]]

The value of this option is a command prefix the editor will invoke
when a point was edited in some way. This is how the editor delegates
the actual storage of point information to an outside object.

[para] This option can only be set at construction time.

[para] If not specified it defaults to an empty string and is ignored
by the editor, i.e. not invoked.

[para] The signatures of this command prefix are

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method add] [arg editorObj] [arg id] [arg x] [arg y]]

This callback is invoked when a new point was added to the instance,
either interactively, or programmatically.

See instance method [method add] for the latter.

[para] The [arg id] identifies the point within the editor and will be
used by the two other callbacks to specify which point to modify.

[para] The last two arguments [arg x] and [arg y] specify the location
of the new point in canvas coordinates.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method remove] [arg editorObj] [arg id]]

This callback is invoked when a point removed from the editor
instance.

[para] The [arg id] identifies the removed point within the editor.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method {move start}] [arg editorObj] [arg id]]

This callback is invoked when the movement of a point in the editor
instance has started.

[para] The [arg id] identifies the point within the editor about to be
moved.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method {move delta}] [arg editorObj] [arg id] [arg x] [arg y] [arg dx] [arg dy]]

This callback is invoked when the point moved in the editor instance.

[para] The [arg id] identifies the moved point within the editor, and
the remaining arguments [arg x], [arg y], [arg dx], and [arg dy]
provide the new absolute location of the point, and full delta to the
original location.

[para] At the time of the calls the system is [emph not] committed to
the move yet. Only after method [method {move done}] was invoked and
has accepted or rejected the last position will the editor update its
internal data structures, either committing to the new location, or
rolling the move back to the original one.

[para] Given this the location data provided here should be saved only
in temporary storage until then.

[para] The result of this method is ignored.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd dataCmd] [method {move done}] [arg editorObj] [arg id]]

This callback is invoked when the movement of a point in the editor
instance is complete.

[para] The [arg id] identifies the moved point within the editor.

[para] The result of this method must be a boolean value. If the
method returns [const false] the move is vetoed and rollbed back.

[list_end][comment callback-signatures]
[list_end][comment options]
[vset CATEGORY canvas]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
