/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.sim;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.StringTokenizer;
import net.tinyos.sim.InputVariables;
import net.tinyos.sim.OutputVariables;

public class LinkLayerModel {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            LinkLayerModel.usage();
            return;
        }
        InputVariables inputVariables = new InputVariables();
        LinkLayerModel.readFile(stringArray[0], inputVariables);
        if (inputVariables.top == 4) {
            LinkLayerModel.obtainNumNodes(inputVariables.topFile, inputVariables);
        }
        OutputVariables outputVariables = new OutputVariables(inputVariables.numNodes);
        System.out.print("Topology ...\t\t\t");
        LinkLayerModel.obtainTopology(inputVariables, outputVariables);
        System.out.println("done");
        System.out.print("Radio Pt and Pn ...\t\t");
        LinkLayerModel.obtainRadioPtPn(inputVariables, outputVariables);
        System.out.println("done");
        System.out.print("Links Gain .....\t\t");
        LinkLayerModel.obtainLinkGain(inputVariables, outputVariables);
        System.out.println("done");
        System.out.print("Printing Output File ...\t");
        LinkLayerModel.printFile(inputVariables, outputVariables);
        System.out.println("done");
    }

    protected static boolean readFile(String string, InputVariables inputVariables) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.equals("") || string2.startsWith("%")) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, " =;\t");
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        if (string3.equals("PATH_LOSS_EXPONENT")) {
                            inputVariables.n = Double.valueOf(string4);
                            if (!(inputVariables.n < 0.0)) continue;
                            System.out.println("Error: value of PATH_LOSS_EXPONENT must be positive");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("SHADOWING_STANDARD_DEVIATION")) {
                            inputVariables.sigma = Double.valueOf(string4);
                            if (!(inputVariables.sigma < 0.0)) continue;
                            System.out.println("Error: value of SHADOWING_STANDARD_DEVIATION must be positive");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("PL_D0")) {
                            inputVariables.pld0 = Double.valueOf(string4);
                            if (!(inputVariables.pld0 < 0.0)) continue;
                            System.out.println("Error: value of PL_D0 must be positive");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("D0")) {
                            inputVariables.d0 = Double.valueOf(string4);
                            if (!(inputVariables.d0 <= 0.0)) continue;
                            System.out.println("Error: value of D0 must be greater than zero");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("NOISE_FLOOR")) {
                            inputVariables.pn = Double.valueOf(string4);
                            continue;
                        }
                        if (string3.equals("WHITE_GAUSSIAN_NOISE")) {
                            inputVariables.wgn = Double.valueOf(string4);
                            if (!(inputVariables.wgn < 0.0)) continue;
                            System.out.println("Error: value of WHITE_GAUSSIAN_NOISE must be greater equal than 0");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("S11")) {
                            inputVariables.s11 = Double.valueOf(string4);
                            if (!(inputVariables.s11 < 0.0)) continue;
                            System.out.println("Error: value of S11 must be greater equal than 0");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("S12")) {
                            inputVariables.s12 = Double.valueOf(string4);
                            continue;
                        }
                        if (string3.equals("S21")) {
                            inputVariables.s21 = Double.valueOf(string4);
                            continue;
                        }
                        if (string3.equals("S22")) {
                            inputVariables.s22 = Double.valueOf(string4);
                            if (!(inputVariables.s22 < 0.0)) continue;
                            System.out.println("Error: value of S22 must be greater equal than 0");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("NUMBER_OF_NODES")) {
                            inputVariables.numNodes = Integer.parseInt(string4);
                            if (inputVariables.numNodes > 0) continue;
                            System.out.println("Error: value of NUMBER_OF_NODES must be positive");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("TOPOLOGY")) {
                            inputVariables.top = Integer.parseInt(string4);
                            if (!(inputVariables.top < 1 | inputVariables.top > 4)) continue;
                            System.out.println("Error: value of TOPOLOGY must be between 1 and 4");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("GRID_UNIT")) {
                            inputVariables.grid = Double.valueOf(string4);
                            continue;
                        }
                        if (string3.equals("TOPOLOGY_FILE")) {
                            inputVariables.topFile = string4;
                            continue;
                        }
                        if (string3.equals("TERRAIN_DIMENSIONS_X")) {
                            inputVariables.Xterr = Double.valueOf(string4);
                            if (!(inputVariables.Xterr < 0.0)) continue;
                            System.out.println("Error: value of TERRAIN_DIMENSIONS_X must be positive");
                            System.exit(1);
                            continue;
                        }
                        if (string3.equals("TERRAIN_DIMENSIONS_Y")) {
                            inputVariables.Yterr = Double.valueOf(string4);
                            if (inputVariables.Yterr < 0.0) {
                                System.out.println("Error: value of TERRAIN_DIMENSIONS_Y must be positive");
                                System.exit(1);
                            }
                            inputVariables.area = inputVariables.Xterr * inputVariables.Yterr;
                            continue;
                        }
                        System.out.println("Error: undefined parameter " + string3 + ", please review your configuration file");
                        System.exit(1);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error1: " + exception);
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                System.out.println("Error2: " + exception);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.out.println("Error Failed to Open file " + string + exception);
            System.exit(1);
        }
        return true;
    }

    protected static boolean obtainTopology(InputVariables inputVariables, OutputVariables outputVariables) {
        Random random = new Random();
        if (inputVariables.numNodes <= 0) {
            System.out.println("\nError: value of NUMBER_OF_NODES must be positive");
            System.exit(1);
        }
        switch (inputVariables.top) {
            case 1: {
                int n;
                if (inputVariables.grid < inputVariables.d0) {
                    System.out.println("\nError: value of GRID_UNIT must be equal or greater than D0");
                    System.exit(1);
                }
                if ((double)(n = (int)Math.sqrt(inputVariables.numNodes)) != Math.sqrt(inputVariables.numNodes)) {
                    System.out.println("\nError: on GRID topology, NUMBER_OF_NODES should be the square of a natural number");
                    System.exit(1);
                }
                for (int i = 0; i < inputVariables.numNodes; ++i) {
                    outputVariables.nodePosX[i] = (double)(i % n) * inputVariables.grid;
                    outputVariables.nodePosY[i] = (double)(i / n) * inputVariables.grid;
                }
                break;
            }
            case 2: {
                int n = (int)Math.sqrt(inputVariables.numNodes);
                if ((double)n != Math.sqrt(inputVariables.numNodes)) {
                    System.out.println("\nError: on UNIFORM topology, NUMBER_OF_NODES should be the square of a natural number");
                    System.exit(1);
                }
                if (inputVariables.Xterr <= 0.0 | inputVariables.Yterr <= 0.0) {
                    System.out.println("\nError: values of TERRAIN_DIMENSIONS must be positive");
                    System.exit(1);
                }
                if (inputVariables.Xterr != inputVariables.Yterr) {
                    System.out.println("\nError: values of TERRAIN_DIMENSIONS_X and TERRAIN_DIMENSIONS_Y must be equal");
                    System.exit(1);
                }
                double d = Math.sqrt(inputVariables.area / (double)inputVariables.numNodes);
                int n2 = n;
                if (d < inputVariables.d0 * 1.4) {
                    System.out.println("\nError: on UNIFORM topology, density is too high, increase physical terrain");
                    System.exit(1);
                }
                for (int i = 0; i < inputVariables.numNodes; ++i) {
                    outputVariables.nodePosX[i] = (double)(i % n2) * d + random.nextDouble() * d;
                    outputVariables.nodePosY[i] = (double)(i / n2) * d + random.nextDouble() * d;
                    boolean bl = true;
                    while (bl) {
                        int n3;
                        for (n3 = 0; n3 < i; ++n3) {
                            double d2 = outputVariables.nodePosX[i] - outputVariables.nodePosX[n3];
                            double d3 = outputVariables.nodePosY[i] - outputVariables.nodePosY[n3];
                            double d4 = Math.pow(d2 * d2 + d3 * d3, 0.5);
                            if (!(d4 < inputVariables.d0)) continue;
                            outputVariables.nodePosX[i] = (double)(i % n2) * d + random.nextDouble() * d;
                            outputVariables.nodePosY[i] = (double)(i / n2) * d + random.nextDouble() * d;
                            bl = true;
                            break;
                        }
                        if (n3 != i) continue;
                        bl = false;
                    }
                }
                break;
            }
            case 3: {
                double d;
                if (inputVariables.Xterr <= 0.0 | inputVariables.Yterr <= 0.0) {
                    System.out.println("\nError: values of TERRAIN_DIMENSIONS must be positive");
                    System.exit(1);
                }
                if ((d = Math.sqrt(inputVariables.area / (double)inputVariables.numNodes)) < inputVariables.d0 * 1.4) {
                    System.out.println("\nError: on RANDOM topology, density is too high, increase physical terrain");
                    System.exit(1);
                }
                for (int i = 0; i < inputVariables.numNodes; ++i) {
                    outputVariables.nodePosX[i] = random.nextDouble() * inputVariables.Xterr;
                    outputVariables.nodePosY[i] = random.nextDouble() * inputVariables.Yterr;
                    boolean bl = true;
                    while (bl) {
                        int n;
                        for (n = 0; n < i; ++n) {
                            double d5 = outputVariables.nodePosX[i] - outputVariables.nodePosX[n];
                            double d6 = outputVariables.nodePosY[i] - outputVariables.nodePosY[n];
                            double d7 = Math.pow(d5 * d5 + d6 * d6, 0.5);
                            if (!(d7 < inputVariables.d0)) continue;
                            outputVariables.nodePosX[i] = random.nextDouble() * inputVariables.Xterr;
                            outputVariables.nodePosY[i] = random.nextDouble() * inputVariables.Yterr;
                            bl = true;
                            break;
                        }
                        if (n != i) continue;
                        bl = false;
                    }
                }
                break;
            }
            case 4: {
                LinkLayerModel.readTopologyFile(inputVariables.topFile, outputVariables);
                LinkLayerModel.correctTopology(inputVariables, outputVariables);
                break;
            }
            default: {
                System.out.println("\nError: topology is not correct, please check TOPOLOGY in the configuration file");
                System.exit(1);
            }
        }
        return true;
    }

    protected static boolean correctTopology(InputVariables inputVariables, OutputVariables outputVariables) {
        Random random = new Random();
        for (int i = 0; i < inputVariables.numNodes; ++i) {
            for (int j = i + 1; j < inputVariables.numNodes; ++j) {
                double d = outputVariables.nodePosX[i] - outputVariables.nodePosX[j];
                double d2 = outputVariables.nodePosY[i] - outputVariables.nodePosY[j];
                double d3 = Math.pow(d * d + d2 * d2, 0.5);
                if (!(d3 < inputVariables.d0)) continue;
                System.out.println("\nError: file " + inputVariables.topFile + " contains inter-node distances less than one.");
                System.exit(1);
            }
        }
        return true;
    }

    protected static boolean obtainRadioPtPn(InputVariables inputVariables, OutputVariables outputVariables) {
        Random random = new Random();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (inputVariables.s11 != 0.0 || inputVariables.s22 != 0.0) {
            if (inputVariables.s11 == 0.0 && inputVariables.s22 != 0.0) {
                System.out.println("\nError: symmetric links require both, S11 and S22 to be 0, not only S11.");
                System.exit(1);
            } else {
                if (inputVariables.s12 != inputVariables.s21) {
                    System.out.println("\nError: S12 and S21 must have the same value.");
                    System.exit(1);
                }
                if (Math.abs(inputVariables.s12) > Math.sqrt(inputVariables.s11 * inputVariables.s22)) {
                    System.out.println("\nError: S12 (and S21) must be less than sqrt(S11xS22).");
                    System.exit(1);
                }
                d = Math.sqrt(inputVariables.s11);
                d2 = inputVariables.s12 / Math.sqrt(inputVariables.s11);
                d3 = 0.0;
                d4 = Math.sqrt((inputVariables.s11 * inputVariables.s22 - Math.pow(inputVariables.s12, 2.0)) / inputVariables.s11);
            }
        }
        for (int i = 0; i < inputVariables.numNodes; ++i) {
            double d5 = random.nextGaussian();
            double d6 = random.nextGaussian();
            outputVariables.noisefloor[i] = inputVariables.pn + d * d5;
            outputVariables.outputpowervar[i] = d2 * d5 + d4 * d6;
        }
        return true;
    }

    protected static boolean obtainLinkGain(InputVariables inputVariables, OutputVariables outputVariables) {
        Random random = new Random();
        for (int i = 0; i < inputVariables.numNodes; ++i) {
            for (int j = i + 1; j < inputVariables.numNodes; ++j) {
                double d = outputVariables.nodePosX[i] - outputVariables.nodePosX[j];
                double d2 = outputVariables.nodePosY[i] - outputVariables.nodePosY[j];
                double d3 = Math.pow(d * d + d2 * d2, 0.5);
                double d4 = -inputVariables.pld0 - 10.0 * inputVariables.n * (Math.log(d3 / inputVariables.d0) / Math.log(10.0)) + random.nextGaussian() * inputVariables.sigma;
                outputVariables.linkGain[i][j] = outputVariables.outputpowervar[i] + d4;
                outputVariables.linkGain[j][i] = outputVariables.outputpowervar[j] + d4;
            }
        }
        return true;
    }

    protected static boolean printFile(InputVariables inputVariables, OutputVariables outputVariables) {
        int n;
        PrintStream printStream;
        FileOutputStream fileOutputStream;
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        try {
            fileOutputStream = new FileOutputStream("topology.out");
            try {
                printStream = new PrintStream(fileOutputStream);
                for (n = 0; n < inputVariables.numNodes; ++n) {
                    printStream.print(n + "\t" + decimalFormat.format(outputVariables.nodePosX[n]) + "\t" + decimalFormat.format(outputVariables.nodePosY[n]) + "\n");
                }
            }
            catch (Exception exception) {
                System.out.println("\nError : Failed to open a print stream to the linkgain file" + exception);
            }
        }
        catch (Exception exception) {
            System.out.println("\nError : Failed to open the link gain file linkgains.out:" + exception);
        }
        try {
            fileOutputStream = new FileOutputStream("linkgain.out");
            try {
                printStream = new PrintStream(fileOutputStream);
                for (n = 0; n < inputVariables.numNodes; ++n) {
                    for (int i = n + 1; i < inputVariables.numNodes; ++i) {
                        if (n == i) continue;
                        printStream.print("gain\t" + n + "\t" + i + "\t" + decimalFormat.format(outputVariables.linkGain[n][i]) + "\n");
                        printStream.print("gain\t" + i + "\t" + n + "\t" + decimalFormat.format(outputVariables.linkGain[i][n]) + "\n");
                    }
                }
                for (n = 0; n < inputVariables.numNodes; ++n) {
                    printStream.print("noise\t" + n + "\t" + decimalFormat.format(outputVariables.noisefloor[n]) + "\t" + decimalFormat.format(inputVariables.wgn) + "\n");
                }
            }
            catch (Exception exception) {
                System.out.println("\nError : Failed to open a print stream to the linkgain file" + exception);
            }
        }
        catch (Exception exception) {
            System.out.println("\nError : Failed to open the link gain file linkgains.out:" + exception);
        }
        return true;
    }

    protected static boolean readTopologyFile(String string, OutputVariables outputVariables) {
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.equals("") || string2.startsWith("%") || string2.startsWith(" ")) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
                        int n2 = Integer.parseInt(stringTokenizer.nextToken());
                        double d = Double.valueOf(stringTokenizer.nextToken());
                        double d2 = Double.valueOf(stringTokenizer.nextToken());
                        outputVariables.nodePosX[n2] = d;
                        outputVariables.nodePosY[n2] = d2;
                        ++n;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error4: " + exception);
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                System.out.println("Error5: " + exception);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Failed to Open TOPOLOGY_FILE " + string + exception);
            System.exit(1);
        }
        return true;
    }

    protected static boolean obtainNumNodes(String string, InputVariables inputVariables) {
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.equals("") || string2.startsWith("%") || string2.startsWith(" ")) continue;
                        ++n;
                    }
                    inputVariables.numNodes = n;
                }
                catch (Exception exception) {
                    System.out.println("Error4: " + exception);
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                System.out.println("Error5: " + exception);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Failed to Open TOPOLOGY_FILE " + string + exception);
            System.exit(1);
        }
        return true;
    }

    private static void usage() {
        System.err.println("usage: net.tinyos.sim.LinkLayerModel <config file>");
    }
}

