/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.swing.ImageIcon;
import net.tinyos.mviz.DDocument;
import net.tinyos.mviz.DMoteModelListener;

class DMoteModel
implements Serializable {
    public static final int VALUE = 0;
    public static final int MOTION = 1;
    public static final int ANY = 1;
    public DDocument root;
    private transient ArrayList listeners;
    protected int x;
    protected int y;
    protected int id;
    protected float[] values;
    protected Color[] colors;
    protected int[] sizes;
    protected int SHAPE_SIZE_MAX = 100;
    protected int COLOR_MAX = 230;

    public DMoteModel(int n, int n2, int n3, float[] fArray, DDocument dDocument) {
        int n4;
        this.root = dDocument;
        this.x = n2;
        this.y = n3;
        this.id = n;
        fArray = new float[dDocument.sensed_motes.size()];
        this.colors = new Color[dDocument.sensed_motes.size()];
        this.sizes = new int[dDocument.sensed_motes.size()];
        for (n4 = 0; n4 < fArray.length; ++n4) {
            this.colors[n4] = this.setColor(fArray[n4]);
        }
        for (n4 = 0; n4 < fArray.length; ++n4) {
            this.sizes[n4] = this.setShapeSize(fArray[n4]);
        }
        this.listeners = null;
    }

    public DMoteModel(DDocument dDocument, int n, String string) {
    }

    public DMoteModel(int n, Random random, DDocument dDocument) {
        this.root = dDocument;
        this.id = n;
        this.x = 20 + random.nextInt(dDocument.canvas.getWidth() - 20);
        this.y = 20 + random.nextInt(dDocument.canvas.getHeight() - 20);
        this.values = new float[dDocument.sensed_motes.size()];
        this.colors = new Color[dDocument.sensed_motes.size()];
        this.sizes = new int[dDocument.sensed_motes.size()];
        for (int i = 0; i < dDocument.sensed_motes.size(); ++i) {
            this.values[i] = random.nextFloat() * 1000.0f;
            this.colors[i] = this.setColor(this.values[i]);
            this.sizes[i] = this.setShapeSize(this.values[i]);
        }
        this.listeners = null;
    }

    public int getId() {
        return this.id;
    }

    public Color setColor(float f) {
        int n = (int)f % this.COLOR_MAX;
        return new Color(n + 15, n, n + 25);
    }

    public int setShapeSize(float f) {
        return this.SHAPE_SIZE_MAX;
    }

    public float getValue(int n) {
        if (this.values.length <= n) {
            return 0.0f;
        }
        return this.values[n];
    }

    public boolean setMoteValue(String string, int n) {
        int n2 = this.root.sensed_motes.indexOf(string);
        if (n2 < 0) {
            return false;
        }
        this.colors[n2] = this.setColor(n);
        this.setValue(n2, n);
        return true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public ImageIcon getIcon() {
        return this.root.icon;
    }

    public void setValue(int n, float f) {
        this.values[n] = f;
        this.fireChanges();
    }

    public void applyDeltas(int n, int n2) {
        this.x += n;
        this.y += n2;
        this.fireChanges();
    }

    public Image getImage() {
        return this.root.image;
    }

    public int getWidth(int n) {
        return this.getIcon().getImage().getWidth(this.root);
    }

    public int getHeight(int n) {
        return this.getIcon().getImage().getHeight(this.root);
    }

    public int getLeft() {
        return this.getLocX() - this.getWidth(0) / 2;
    }

    public int getTop() {
        return this.getLocY() - this.getHeight(0) / 2;
    }

    public int getLocX() {
        return this.x;
    }

    public int getLocY() {
        return this.y;
    }

    public Color getColor(int n) {
        return this.colors[n];
    }

    public void addListener(DMoteModelListener dMoteModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != dMoteModelListener) continue;
            return;
        }
        this.listeners.add(dMoteModelListener);
    }

    public void removeListener(DMoteModelListener dMoteModelListener) {
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != dMoteModelListener) continue;
            iterator.remove();
            return;
        }
    }

    protected void fireChanges() {
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((DMoteModelListener)iterator.next()).shapeChanged(this, 1);
        }
    }

    public void requestRepaint() {
        this.fireChanges();
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.fireChanges();
    }

    public boolean equals(Object object) {
        DMoteModel dMoteModel;
        return object instanceof DMoteModel && (dMoteModel = (DMoteModel)object).getId() == this.getId();
    }
}

