
[//000000001]: # (fileutil::magic::cgen \- file utilities)
[//000000002]: # (Generated from file 'cgen\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (fileutil::magic::cgen\(n\) 1\.2\.0 tcllib "file utilities")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

fileutil::magic::cgen \- Generator core for compiler of magic\(5\) files

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [COMMANDS](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [See Also](#seealso)

  - [Keywords](#keywords)

  - [Category](#category)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require fileutil::magic::cgen ?1\.2\.0?  
package require fileutil::magic::rt ?1\.2\.0?  
package require struct::tree  
package require struct::list  

[__::fileutil::magic::cgen::2tree__ *script*](#1)  
[__::fileutil::magic::cgen::treedump__ *tree*](#2)  
[__::fileutil::magic::cgen::treegen__ *tree* *node*](#3)  

# <a name='description'></a>DESCRIPTION

This package provides the generator backend for a compiler of magic\(5\) files
into recognizers based on the __[fileutil::magic::rt](rtcore\.md)__
recognizer runtime package\. For the compiler frontend using this generator see
the package __[fileutil::magic::cfront](cfront\.md)__\.

# <a name='section2'></a>COMMANDS

  - <a name='1'></a>__::fileutil::magic::cgen::2tree__ *script*

    This command converts the recognizer specified by the *script* into a tree
    and returns the object command of that tree as its result\. It uses the
    package __[struct::tree](\.\./struct/struct\_tree\.md)__ for the tree\.

    The *script* is in the format specified by magic\(5\)\.

  - <a name='2'></a>__::fileutil::magic::cgen::treedump__ *tree*

    This command takes a *tree* as generated by
    __::fileutil::magic::cgen::2tree__ and returns a string encoding the
    tree for human consumption, to aid in debugging\.

  - <a name='3'></a>__::fileutil::magic::cgen::treegen__ *tree* *node*

    This command takes a *tree* as generated by
    __::fileutil::magic::cgen::2tree__ and returns a Tcl script, the
    recognizer for the file types represented by the sub\-tree rooted at the
    *node*\. The generated script makes extensive use of the commands provided
    by the recognizer runtime package
    __[fileutil::magic::rt](rtcore\.md)__ to perform its duties\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *fileutil :: magic* of the
[Tcllib Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report
any ideas for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='seealso'></a>SEE ALSO

file\(1\), [fileutil](\.\./fileutil/fileutil\.md), magic\(5\)

# <a name='keywords'></a>KEYWORDS

[file recognition](\.\./\.\./\.\./\.\./index\.md\#file\_recognition), [file
type](\.\./\.\./\.\./\.\./index\.md\#file\_type), [file
utilities](\.\./\.\./\.\./\.\./index\.md\#file\_utilities),
[mime](\.\./\.\./\.\./\.\./index\.md\#mime), [type](\.\./\.\./\.\./\.\./index\.md\#type)

# <a name='category'></a>CATEGORY

Programming tools
