from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_find_abbreviations = _Mock()

_get_min_max_value = _Mock()

_matches = _Mock()

_widget_abbrev = _Mock()

_widget_abbrev_single_value = _Mock()

_widget_from_abbrev = _Mock()

_widgets_from_abbreviations = _Mock()

_yield_abbreviations_for_parameter = _Mock()

clear_output = _Mock()

display = _Mock()

get_ipython = _Mock()

getcallargs = _Mock()

interact = _Mock()

interactive = _Mock()

print_function = _Mock()

signature = _Mock()

string_types = _Mock()



class Any(_Mock):
  pass
  info_text = 'any value'

class CheckboxWidget(_Mock):
  pass


class ContainerWidget(_Mock):
  pass


class DOMWidget(_Mock):
  pass


class DropdownWidget(_Mock):
  pass


class FloatSliderWidget(_Mock):
  pass


class HasTraits(_Mock):
  pass


class IntSliderWidget(_Mock):
  pass


class Parameter(_Mock):
  pass


class TextWidget(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class Widget(_Mock):
  pass


class empty(_Mock):
  pass


class fixed(_Mock):
  pass


class unicode_type(_Mock):
  pass


