C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    *****************
                     SUBROUTINE MOBLIM
C                    *****************
C
C     -------------------------------------------------------------
     *(NDIM,NPOINS,NBCOUS,NBICOR,NCOUPS,NCBORS,VCOUPS,NREFS,COORDS,
     * NODESS,VFCOUS,NELESS,NDMASS)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------  AFFECTATION DES CONDITIONS AUX LIMITES DANS          *
C                 LE CAS DES SOLIDES MOBILES                           *
C                 On affecte une conditions a tous les noeuds          *
C                 couples qui n'ont pas de correspondant a ce moment la*
C                                                                      *
C      SOUS PROGRAMME UTILISATEUR                                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NDIM    !   E  ! D  ! DIMENSION DU PROBLEME                    !
C   !   NPOINS  !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE             !
C   !   NBCOUS  !   E  ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES         !
C   !   NBICOR  !   E  ! D  ! NOMBRE D'INFOS POUR LES CORRESPONDANT    !
C   !   NCBORS  !  TE  ! D  ! NUMERO DE L'ELEMENT FLUIDE CORRESPONDANT !
C   !   VCOUPS  !  TR  ! R  ! CL SUR LES NOEUDS SOLIDES COUPLES        !
C   !   NREFS   !  TE  ! D  ! REFERENCES NOEUDS SOLIDES                !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ----
C                                     
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  :  
C
C***********************************************************************
C
	IMPLICIT NONE
C
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "mobil.h"
#include "nlofes.h"
#include "syrthu.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NDIM,NPOINS,NBCOUS,NBICOR
      INTEGER NCOUPS(NBCOUS),NCBORS(NBCOUS,NBICOR),NREFS(NPOINS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),VCOUPS(NBCOUS,2)
      INTEGER NELESS,NDMASS
      INTEGER NODESS(NELESS,NDMASS)
      DOUBLE PRECISION VFCOUS(NELESS,NDMASS,2)
C
C..Variables internes
      INTEGER N,M,NL,NLC
C
C***********************************************************************
C
C ====================================
C   INITIALISATION : NE PAS MODIFIER
C ====================================
C
C     1.1- Conditions aux limites par noeud
C     -------------------------------------
C
      IF (.NOT.LCFACE) THEN
C
        DO 100 N=1,NBCOUS
C         Si le noeud n'a pas de correspondant
          IF (NCBORS(N,1).EQ.-1) THEN
             VCOUPS(N,1) = TMOB
             VCOUPS(N,2) = XLMOB
          ENDIF
  100   CONTINUE
C
C     1.2- Conditions aux limites par face
C     ------------------------------------
C
      ELSE
C
        DO 120 N=1,NELESS
          DO 121 M=1,NDMASS
C
C           Numero local du noeud et de son correspondant
            NL  = NODESS(N,M)
            NLC = NCBORS(NL,1)
            IF (NLC.EQ.-1) THEN
               VFCOUS(N,M,1) = TMOB
               VFCOUS(N,M,2) = XLMOB
            ENDIF      
C
  121     CONTINUE
  120   CONTINUE
C
C
      ENDIF
C
C
C ====================================================
C   INTERVENTION UTILISATEUR A PARTIR DE CETTE LIGNE
C ====================================================
C
C     Pour stopper l'execution proprement en cas de probleme
C     mettre LSTOPS a "TRUE" dans vos tests
C     LSTOPS = .FALSE.
C
C     1- Si les conditions aux limites sont imposees sur les noeuds
C     -------------------------------------------------------------
C
CUTI  IF (.NOT. LCFACE) THEN
C
CUTI  DO 200 N=1,NBCOUS
C       Si le noeud n'a pas de correspondant
CUTI    IF (NCBORS(N,1).EQ.-1) THEN
C
C         Numero global du noeud
CUTI      NG = NCOUPS(N)
C
C         Coordonnees du noeud
CUTI      X = COORDS(NG,1)
CUTI      Y = COORDS(NG,2)
CUTI      IF (NDIM.EQ.3) Z = COORDS(NG,3)
C  
C         Numero de reference du noeud
CUTI      NUMREF = NREFS(NG)
C
C         --> CL : temperature exterieure
CUTI      VCOUPS(N,1) = TMOB
C         --> CL : coefficient d'echange
CUTI      VCOUPS(N,2) = XLMOB
C
CUTI    ENDIF
CU200 CONTINUE
C
CUTI  ENDIF
C
C     3- Si les conditions aux limites sont imposees sur les faces
C     ------------------------------------------------------------
C
CUTI  IF (LCFACE) THEN
C
C       Pour chaque facette et pour chaque noeud de la facette
CUTI    DO 300 N=1,NELESS
CUTI      DO 310 M=1,NDMASS
C
C           Num local du noeud et de son correspondant
CUTI        NL  = NODESS(N,M)
CUTI        NLC = NCBORS(NL,1)
C           Numero global du noeud
CUTI        NG  = NCOUPS(NL)
C
C           Si le noeud n'a pas de correspondant
CUTI        IF (NLC.EQ.-1) THEN
C             Coordonnees du noeud
CUTI          X = COORDS(NG,1)
CUTI          Y = COORDS(NG,2)
CUTI          IF (NDIM.EQ.3) Z = COORDS(NG,3)
C  
C             Numero de reference du noeud
CUTI          NUMREF = NREFS(NG)
C
C         --> CL : temperature exterieure
CUTI          VFCOUS(N,M,1) = TMOB
C         --> CL : coefficient d'echange
CUTI          VFCOUS(N,M,2) = XLMOB
CUTI        ENDIF      
C
CU310     CONTINUE
CU300   CONTINUE
C
CUTI  ENDIF
C
C ====================================================
C                  FIN
C ====================================================
C
C       IMPRESSIONS POUR CONTROLE
C       -------------------------
        IF (NBLBLA.GE.10 .AND. .NOT. LCFACE) THEN
          WRITE(NFECRA,4010)
          DO N=1,NBCOUS
             WRITE(NFECRA,4020) N,VCOUPS(N,1),VCOUPS(N,2)
          ENDDO
        ELSE
          WRITE(NFECRA,4030)
          DO N=1,NELESS
             WRITE(NFECRA,4040) N,VFCOUS(N,1,1),VFCOUS(N,1,2)
          ENDDO
        ENDIF
C
C-------
C FORMAT
C-------
C
 4010 FORMAT(/,' *** MOBLIM : PASSAGE DES DONNEES DU FLUIDE',
     &         ' VERS LE SOLIDE  (vcoups final)',/,
     &          5X,' N solide      T        h')
 4020 FORMAT(8X,I4,6X,2G13.7)
 4030 FORMAT(/,' *** MOBLIM : PASSAGE DES DONNEES DU FLUIDE',
     &         ' VERS LE SOLIDE  (vfcous(1) final)',/,
     &          5X,' N solide      T        h')
 4040 FORMAT(5X,3X,I4,6X,G13.7,3X,G13.7)
C
C        
      RETURN
      END

