C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=LIMRAY,SSI=0
                        SUBROUTINE LIMRAY
C                       *****************
C
C      ------------------------------------------------------------
     * (NDIM,NELRAY,NPOINR,
     *  NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,
     *  NODRAY,NRFRAY,NGFFIR,NGFTIR,NGFPER,NGFPEF,
     *  COORAY,EMISSI,TEMRAY,FIRAY,PHFRAF,PHFRAE,VFIRAY)
C      ------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            INITIALISATION DES CONDITIONS AUX LIMITES DE RAYONNEMENT  *
C            TRANSPARENT CONFINE SUR LE MAILLAGE DE RAYONNEMENT        * 
C                                                                      *
C Attention : Toutes les grandeurs entrees par l'utilisateur le sont   *
C             au niveau des faces                                      *
C                                                                      *
C             (Sous-programme utilisateur)                             *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NELRAY   !  E ! D  ! NOMBRE DE FACES DU MAILLAGE DE RAYONNEMENT   !
C !  NPOINR   !  E ! D  ! NOMBRE DE NOEUD DU MAILLAGE DE RAYONNEMENT   !
C !  SPECTL   ! TR ! R  ! BORNES DE CHAQUE BANDE SPECTRALE             !
C !  NRFRAY   ! TE ! D  ! REFERENCES DES FACES DU MAILLAGE DE RAYONNT  ! 
C !  COORAY   ! TR ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE DE RAYONNT!
C !  NODRAY   ! TE ! D  ! CONNECTIVITE DU MAILLAGE DE RAYONNEMENT      !
C !  EMISSI   ! TE ! D  ! EMISSIVITE DE FACETTE POUR CHAQUE BANDE      !
C !  TEMRAY   ! TR ! D  ! TEMPERATURE DE LA FACE DE RAYONNT A L'ETAPE N!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "divct.h"
#include "rayonn.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NELRAY,NPOINR
      INTEGER NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA
      INTEGER NGFFIR(NFFIRA),NGFTIR(NFTIRA)
      INTEGER NGFPER(NFPERA),NGFPEF(NFCFRA)
      INTEGER NRFRAY(NELRAY),NODRAY(NELRAY,NDIM)
      DOUBLE PRECISION COORAY(NPOINR,NDIM),TEMRAY(NELRAY)
      DOUBLE PRECISION EMISSI(NELRAY,2,NBANDE),FIRAY(NELRAY,NBANDE)
      DOUBLE PRECISION PHFRAF(NFCFRA,4),PHFRAE(NFPERA,4)
      DOUBLE PRECISION VFIRAY(NFFIRA,NBANDE,2)
C
C
C.. Variables internes
      INTEGER N,NUMNO,NUMREF,I,NGFAC
      DOUBLE PRECISION T,XX1,YY1,ZZ1
C
      LOGICAL LVERIF
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
C
C***********************************************************************
C
C     INTERVENTION UTILISATEUR A PARTIR DE CETTE LIGNE 
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
C     Temps courant sur le solide
CUTI  T = TEMPSS
C
C     ================================================================
C     1- INITIALISATION DES BANDES SPECTRALES 
C     ================================================================
C     Definition des bandes spectrales si besoin est
C     Le nombre de bandes spectrales,NBANDE est defini dans le fichier
C     de mots-cles Syrthes.ray
C     Exemple : si le nombre de bandes (NBANDE) vaut 2, avec en metres
C               Premiere bande lambda_1 = 0     , lambda_2 = 5.e-6 (m)
C               Deuxieme bande lambda_1 = 5.e-6 , lambda_2 = 1.
CUTI          SPECTL(1,1) = 0
CUTI          SPECTL(1,2) = 5.e-6 
CUTI          SPECTL(2,1) = 5.e-6  
CUTI          SPECTL(2,2) = 1.
C 
C     ================================================================
C     2- INITIALISATION DE l'EMISSIVITE POUR LE RAYONNEMENT
C     ================================================================
C
C     Exemple ...
C
CUTI  DO N=1,NELRAY
C
C        References de la face
CUTI     NUMREF = NRFRAY(N)
C
C        Coordonnees des noeuds de la face 
CUTI     XX1 = COORAY(NODRAY(N,1),1)
CUTI     YY1 = COORAY(NODRAY(N,1),2)
CUTI     IF(NDIM.EQ.3) ZZ1 = COORAY(NODRAY(N,1),3)
C        ...
C
C        Temperature de la face de rayonnement
CUTI     TTFAC = TEMRAY(N)
C
C        Exemple
C        Si la face porte la reference 3, l'emissivite vaut
C              0.7   pour la premiere bande
C              0.95  pour la deuxieme bande
C        sinon, elle vaut 0.5 (elle peut eventuellement dependre de la
C        temperature de la face calculee precedement (TTFAC)
C
CUTI     IF (NUMREF.EQ.3) THEN
CUTI        EMISSI(N,1,1) = 0.7
CUTI        EMISSI(N,1,2) = 0.95
CUTI     ELSE
CUTI        EMISSI(N,1,1) = 0.5
CUTI        EMISSI(N,1,2) = 0.5
CUTI     ENDIF
C
CUTI  ENDDO
C
C     ================================================================
C     3- INITIALISATION DES TEMPERATURES DE FACES IMPOSEE 
C     ================================================================
C
CUTI  DO N=1,NFTIRA
C
C        Numero global de la face
CUTI     NGFAC = NGFTIR(N)
C        Reference de la face
CUTI     NUMREF = NRFRAY(NGFAC)
C
C        Coordonnees des noeuds de la face 
CUTI     XX1 = COORAY(NODRAY(NGFAC,1),1)
CUTI     YY1 = COORAY(NODRAY(NGFAC,1),2)
CUTI     IF(NDIM.EQ.3) ZZ1 = COORAY(NODRAY(NGFAC,1),3)
C        ...
C
C        Exemple
C        Attention : La temperature de la face de rayonnement est en degre C
C        La references 5 designe une entree T = 30 degre C
C        La references 6 designe une sortie T = 50 degre C
C
CUTI     IF ( NUMREF .EQ. 5 ) THEN
CUTI        TEMRAY(NGFAC) = 30.
CUTI     ELSEIF ( NUMREF .EQ. 6 ) THEN
CUTI        TEMRAY(NGFAC) = 50.
CUTI     ENDIF
C
CUTI  ENDDO
C
C     ================================================================
C     4- INITIALISATION DES FACES A FLUX IMPOSE PAR BANDE
C     ================================================================
C
CUTI  DO N=1,NFFIRA
C
C        Numero global de la face
CUTI     NGFAC = NGFFIR(N)
C        References de la face
CUTI     NUMREF = NRFRAY(NGFAC)
C
C        Coordonnees des noeuds de la face 
CUTI     XX1 = COORAY(NODRAY(NGFAC,1),1)
CUTI     YY1 = COORAY(NODRAY(NGFAC,1),2)
CUTI     IF(NDIM.EQ.3) ZZ1 = COORAY(NODRAY(NGFAC,1),3)
C        ...
C
C        Exemple
C        On a une seule bande spectrale --> NUMBAN = 1
C        Si la reference de la face vaut 7 on a une paroi adiabatique
C        Si la reference de la face vaut 3 on a un flux de 500 W/m2
C    
CUTI     NUMBAN = 1     
C
CUTI     IF ( NUMREF .EQ. 7 ) THEN
CUTI        VFIRAY(N,NUMBAN,1) = 0.
CUTI     ELSEIF ( NUMREF .EQ. 3 ) THEN
CUTI        VFIRAY(N,NUMBAN,1) = 500.
CUTI     ENDIF
C
CUTI  ENDDO
C
C
C     ================================================================
C     5- INITIALISATION DES PROPRIETES DE PAROI EQUIVALENTE 
C        COUPLEE AU FLUIDE (attention sans solide)
C     ================================================================
C        On indique pour chaque face de ce type :                   
C               PHFRAF(..,1)  est   la conductivite du materiau         
C               PHFRAF(..,2)  est   l'epaisseur du materiau             
C               PHFRAF(..,3)  est   la temperature exterieure           
C               PHFRAF(..,4)  est   le coefficient d'echange exterieur  
C                                                                       
C         Attention : Toutes les grandeurs entrees par l'utilisateur 
C                     le sont au niveau des faces                  
C
CUTI  DO N=1,NFCFRA
C
C        Numero global de la face
CUTI     NGFAC = NGFPEF(N)
C        References de la face
CUTI     NUMREF = NRFRAY(NGFAC)
C
C        Coordonnees des noeuds de la face 
CUTI     XX1 = COORAY(NODRAY(NGFAC,1),1)
CUTI     YY1 = COORAY(NODRAY(NGFAC,1),2)
CUTI     IF(NDIM.EQ.3) ZZ1 = COORAY(NODRAY(NGFAC,1),3)
C        ...
C
C        Exemple
C        Si la references 5 designe une paroi equivalente, ayant pour
C        caracteristiques : 
C                           Conductivite : 10 W/M/K
C                           Epaisseur    : 1 cm
C                           Temp ext     : -10. degres C
C                           H ext        :  200
C
CUTI     IF (NUMREF.EQ.5) THEN
CUTI        PHFRAF(N,1) = 10.
CUTI        PHFRAF(N,2) = 0.01
CUTI        PHFRAF(N,3) = -10.
CUTI        PHFRAF(N,4) = 200.
CUTI     ENDIF
C
C
CUTI  ENDDO
C
C     ================================================================
C     6- INITIALISATION DES PROPRIETES DE PAROI EQUIVALENTE 
C        DES FACES DE RAYONNEMENT ISOLEES
C        (ni couple au solide ni au fluide)
C     ================================================================
C        On indique pour chaque face de ce type :                   
C               PHFRAE(..,1)  est   la conductivite du materiau         
C               PHFRAE(..,2)  est   l'epaisseur du materiau             
C               PHFRAE(..,3)  est   la temperature exterieure           
C               PHFRAE(..,4)  est   le coefficient d'echange exterieur  
C                                                                       
C         Attention : Toutes les grandeurs entrees par l'utilisateur 
C                     le sont au niveau des faces                                       
C
CUTI  DO N=1,NFPERA
C
C        Numero global de la face
CUTI     NGFAC = NGFPER(N)
C        References de la face
CUTI     NUMREF = NRFRAY(NGFAC)
C
C        Coordonnees des noeuds de la face 
CUTI     XX1 = COORAY(NODRAY(NGFAC,1),1)
CUTI     YY1 = COORAY(NODRAY(NGFAC,1),2)
CUTI     IF(NDIM.EQ.3) ZZ1 = COORAY(NODRAY(NGFAC,1),3)
C        ...
C
C        Exemple
C        Si la references 12 designe une paroi equivalente, ayant pour
C        caracteristiques : 
C                           Conductivite : 10 W/M/K
C                           Epaisseur    : 1 cm
C                           Temp ext     : 100. degres C
C                           H ext        : 10
C
CUTI     IF (NUMREF.EQ.12) THEN
CUTI        PHFRAE(N,1) = 10.
CUTI        PHFRAE(N,2) = 0.01
CUTI        PHFRAE(N,3) = 100.
CUTI        PHFRAE(N,4) = 10.
CUTI     ENDIF
C
C
CUTI   ENDDO
C
C                   FIN INTERVENTION UTILISATEUR
C                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
C
C***********************************************************************
C
C     7- IMPRESSION DE CONTROLE 
C     =========================
C     (il suffit de mettre LVERIF = .TRUE. en debut de programme)
C
      IF (LVERIF) THEN
C
         WRITE(NFECRA,7000) 
C
         IF (NBANDE .GT. 1) THEN
            WRITE(NFECRA,7100) NBANDE
            DO 7110 N=1,NBANDE
                WRITE(NFECRA,7120) SPECTL(N,1),SPECTL(N,2)
 7110       CONTINUE
         ENDIF
C
         DO 7200 N=1,NBANDE
            WRITE(NFECRA,7210) N
            WRITE(NFECRA,7220) 
            WRITE(NFECRA,7230) ( I,EMISSI(I,1,N),I=1,NELRAY )
 7200    CONTINUE
C
C
         WRITE(NFECRA,7300) NFTIRA
         WRITE(NFECRA,7310) 
         WRITE(NFECRA,7320) ( NGFTIR(I),TEMRAY(NGFTIR(I)),I=1,NFTIRA )
C
C
         WRITE(NFECRA,7410) NFFIRA
         DO 7400 N=1,NBANDE
            WRITE(NFECRA,7415) N
            WRITE(NFECRA,7420) 
            WRITE(NFECRA,7430) (NGFFIR(I),FIRAY(NGFFIR(I),N),I=1,NFFIRA)
 7400    CONTINUE
C
C
         WRITE(NFECRA,7500) NFCFRA
         WRITE(NFECRA,7510) 
         DO 7530 N=1,NFCFRA
            NGFAC = NGFPEF(N) 
            WRITE(NFECRA,7520) N,PHFRAF(NGFAC,1),PHFRAF(NGFAC,2),
     &                         PHFRAF(NGFAC,3),PHFRAF(NGFAC,4)
 7530    CONTINUE
C
C
         WRITE(NFECRA,7600) NFPERA
         WRITE(NFECRA,7610) 
         DO 7630 N=1,NFPERA
            NGFAC = NGFPER(N) 
            WRITE(NFECRA,7620) N,PHFRAE(NGFAC,1),PHFRAE(NGFAC,2),
     &                         PHFRAE(NGFAC,3),PHFRAE(NGFAC,4)
 7630    CONTINUE
C
      ENDIF
C
C--------
C FORMATS
C--------
C
 7000 FORMAT(/,'  *** LIMRAY : IMPRESSION DES CONDITIONS AUX LIMITES',
     &          ' DE TYPE RAYONNEMENT TRANSPARENT CONFINE')
 7100 FORMAT(/,' Nombre de bandes spectrales definies',I2)
 7120 FORMAT(/,' Bande spectrale :',I2,'   Lamda_1 = ',E13.5,
     &                                 '   Lamda_2 = ',E13.5) 
 7210 FORMAT(/,' Valeur des emissivites pour la bande : ',I2)
 7220 FORMAT(/,' Numero de la facette - valeur de l''emissivite ')
 7230 FORMAT('(',I6,' - ',G10.3,')')
 7300 FORMAT(/,' Nombre de facette avec temperature imposee : ',I5)
 7310 FORMAT(/,' Numero de la facette - valeur de la',
     &         ' temperature imposee')
 7320 FORMAT('(',I6,' - ',G10.3,')')
 7410 FORMAT(/,' Nombre de facette avec Flux impose : ',I5)
 7415 FORMAT(/,' Valeur des flux imposes pour la bande : ',I2)
 7420 FORMAT(/,' Numero de la facette - valeur du flux impose')
 7430 FORMAT('(',I6,' - ',G10.3,')')
 7500 FORMAT(/,' Nombre de facette paroi equivalente couple au',
     &         ' fluide : ',I5)
 7510 FORMAT(/,' Face   -   Conductivite  -  Epaisseur  -  ',
     &      'Temp exterieure  -  Coef d''echange exterieur')
 7520 FORMAT(I6,20X,G10.3,20X,G10.3,20X,G10.3,20X,G10.3)
 7600 FORMAT(/,' Nombre de facette paroi equivalente isolee : ',I5)
 7610 FORMAT(/,' Face   -   Conductivite  -  Epaisseur  -  ',
     &      'Temp exterieure  -  Coef d''echange exterieur')
 7620 FORMAT(I6,20X,G10.3,20X,G10.3,20X,G10.3,20X,G10.3)
C
C----
C FIN
C----
      END
