C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LIMNUF
C                       *****************
C
C      ----------------------------------------
     * (NCOUPF,NBCOUF,NRAPF,NBRAF,NREFF,NPOINF,
     *  NBFILS,NWMAIL,NWDN,NWDRN,NWNCF1,NWNRF1)
C      ----------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA NUMEROTATION LOCALE DES NOEUDS        *
C            FLUIDES COUPLES                                           * 
C            --> INITIALISATION DE NCOUPF(..,1)                        *
C            --> INITIALISATION DE NRAPF(..,1)                         *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !NCOUPF(.,1)! TE ! R  ! Numero glob fluide des noeuds fluides couples!
C !           !    !    ! NCOUPF(.,2) est initialise dans NULOCF       !
C !  NBCOUF   !  E ! D  ! Nombre de noeuds fluides couples             !
C ! NRAPF(.,1)! TE ! R  ! Num glob fluide noeuds fluides non couples + !
C !           !    !    ! rayt. NRAPF(.,2) est initialise dans NULOCF  !
C !   NBRAF   !  E ! D  ! Nombre de noeuds fluides non couples + rayt  !
C !  NREFF    ! TE ! D  ! References des noeuds fluides                !
C !  NPOINF   !  E ! D  ! Nombre de noeuds du maillage fluides         !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "xrefer.h"
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NBCOUF,NCOUPF(NBCOUF,2),NBRAF,NRAPF(NBRAF,2)
      INTEGER NPOINF,NREFF(NPOINF)
      INTEGER NBFILS,NWMAIL,NWDN,NWDRN,NWNCF1,NWNRF1
C
C.. Variables internes
      INTEGER NUMREF,N,N1
      INTEGER NCOU,NRA
      LOGICAL ERR
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      DO 1 N=NWDN,NWDN+NWNCF1-1
        NCOUPF(N,1) = 0
        NCOUPF(N,2) = 0
    1 CONTINUE
C
      DO 2 N=NWDRN,NWDRN+NWNRF1-1
        NRAPF(N,1) = 0
        NRAPF(N,2) = 0
    2 CONTINUE
C
      NCOU = NWDN-1
      NRA  = NWDRN-1
C
C     2- COMPTE DES NOEUDS 
C     ====================
C
      DO 200 N=1,NPOINF
C
        NUMREF = NREFF(N)
C
        DO 210 N1=1,NRFMAX
C
           IF (IREFFC(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NCOU = NCOU + 1
              NCOUPF(NCOU,1) = N
           ENDIF
C
           IF (IREFRF(N1).NE.0 .AND. NUMREF.EQ.N1) THEN 
              NRA = NRA + 1
              NRAPF(NRA,1) = N
           ENDIF
C
  210   CONTINUE
  200  CONTINUE
C
C
C     3- CONTROLE DES DIMENSIONS
C     ==========================
C
      ERR = .FALSE.
C
      IF (NWMAIL.EQ.NBFILS .AND. NCOU.NE.NBCOUF) THEN
         WRITE(NFECRA,4000) 'noeuds fluides couples',NCOU,NBCOUF
         ERR = .TRUE.
      ENDIF
C
      IF (NWMAIL.EQ.NBFILS .AND. NRA.NE.NBRAF) THEN
         WRITE(NFECRA,4000) 'noeuds fluides non couples + rayt',
     *                       NCOU,NBCOUF
         ERR = .TRUE.
      ENDIF
C
C     4- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.GT.0) WRITE(NFECRA,4005) NWMAIL,NCOU-NWDN+1
C
      IF (NBLBLA.GE.3) THEN
        IF (NBCOUF.GT.0) THEN
          WRITE(NFECRA,4010) 
          WRITE(NFECRA,4001) (NCOUPF(N,1),N=NWDN,NWDN+NWNCF1-1)
        ENDIF
      ENDIF
C
      IF (NBLBLA.GT.0) WRITE(NFECRA,4015) NWMAIL,NRA-NWDRN+1
C
      IF (NBLBLA.GE.3) THEN
        IF (NBCOUF.GT.0) THEN
          WRITE(NFECRA,4020) 
          WRITE(NFECRA,4001) (NRAPF(N,1),N=NWDRN,NWDRN+NWNRF1-1)
        ENDIF
      ENDIF
C
C
C     6- ARRET DU PROGRAMME EN CAS D'ERREUR DE DIMENSION
C     ==================================================
      IF (ERR) STOP

C--------
C FORMATS
C--------
C
 3000 FORMAT(' %% ERREUR LIMNUF : incoherence sur les ',A30,/,
     &       '                    On en compte :',I9,/,
     &       '                    Il y en a ',I9,' de declares')
 4000 FORMAT(/,' %% ERREUR LIMNUF : incoherence sur les ',A,/,
     &       '                    On en compte :',I9,/,
     &       '                    Il y en a ',I9,' de declare(e)s')
 4005 FORMAT(/,' *** LIMNUF : Maillage fluide ',I3,/,
     &         '              Nombre de noeuds fluides couples :',I6)
 4001 FORMAT(12I6)
 4010 FORMAT(/,'  Liste des noeuds fluides couples :',/)
 4015 FORMAT(/,' *** LIMNUF : Maillage fluide ',I3,/,
     *         '              Nombre de noeuds fluides non couples',
     *         ' soumis au rayonnement :',I6)
 4020 FORMAT(/,'  Liste des noeuds fluides non couples soumis ',
     *         'au rayonnement :',/)
C
C----
C FIN
C----
      END
