C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECME2
C                       *****************
C
C     ----------------------------------------------------------------
     *(NDIM,NPOINS,NELEMS,NBFACE,NN,IREF,INOEUD,IFACE,IELT,ITRMED)
C     ----------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             1ere LECTURE DU MAILLAGE ELEMENTS FINIS                  *
C             --> STRUCTURE DE DONNEE ISSUE DE MED                     *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "xrefer.h"
#ifdef MED
#include "med.hf"
#endif
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NPOINS,NELEMS,NBFACE,NN
      INTEGER IREF(NPOINS),INOEUD(NELEMS*NN),IFACE(NELEMS*NBFACE)
      INTEGER IELT(NELEMS)
CMED20      INTEGER ITRMED(NN,NELEMS)
      INTEGER ITRMED(NELEMS,NN)
C
#ifdef MED
C.. Variables internes
      INTEGER I,J,NBFAM,IDIM,IRET,NBATT
      INTEGER NB,NGRO,NUMFAM,IFAN(NRFMAX),IFAE(NRFMAX),NBIDON
      CHARACTER*32 NOM,NOMFAM
cc      CHARACTER*80 GRO(5)
      LOGICAL LFAE
      CHARACTER*200 ATDES0(1),ATDES2(4),ATDES3(5)
      INTEGER ATIDE0(1),ATIDE2(4),ATIDE3(5)
      INTEGER ATVAL0(1),ATVAL2(4),ATVAL3(5)
      character*200  attdes(6)    
      character*80 gro(6)       
      integer attval(6),attide(6),natt
C
C***********************************************************************
C
C     lecture du nom du maillage
      CALL EFMAAI(NFSGCT,1,NOM,IDIM,IRET)
C
C     lecture de la connectivite
      IF (NDIM.EQ.2) THEN
CMED20        CALL EFCONL(NFSGCT,NOM,NDIM,ITRMED,NELEMS,
CMED20     *              MED_MAILLE,MED_TRIA6,MED_NOD,IRET)
        CALL EFCONL(NFSGCT,NOM,NDIM,ITRMED,MED_NO_INTERLACE,NBIDON,0,
     *              MED_MAILLE,MED_TRIA6,MED_NOD,IRET)
      ELSEIF (NDIM.EQ.3) THEN
CMED20        CALL EFCONL(NFSGCT,NOM,NDIM,ITRMED,NELEMS,
CMED20     *              MED_MAILLE,MED_TETRA10,MED_NOD,IRET)
        CALL EFCONL(NFSGCT,NOM,NDIM,ITRMED,MED_NO_INTERLACE,NBIDON,0,
     *              MED_MAILLE,MED_TETRA10,MED_NOD,IRET)
      ENDIF
C
      DO J=1,NN
        DO I=1,NELEMS
CMED20           INOEUD((J-1)*NELEMS+I)=ITRMED(J,I)
          INOEUD((J-1)*NELEMS+I)=ITRMED(I,J)
        ENDDO
      ENDDO
C
C     lecture des numeros de famille des noeuds
      CALL EFFAML(NFSGCT,NOM,IREF,NPOINS,MED_NOEUD,0,IRET)
C
C     lecture des numeros de famille des elements
      IF (NDIM.EQ.2) THEN
         CALL EFFAML(NFSGCT,NOM,IELT,NELEMS,MED_MAILLE,MED_TRIA6,IRET)
      ELSEIF (NDIM.EQ.3) THEN
         CALL EFFAML(NFSGCT,NOM,IELT,NELEMS,MED_MAILLE,MED_TETRA10,IRET)
      ENDIF
C
C     nombre de familles
      CALL EFNFAM(NFSGCT,NOM,0,0,NBFAM,IRET)
C
C      
C     lecture des familles
      LFAE=.FALSE.
      DO I=1,NBFAM
        CALL EFNFAM(NFSGCT,NOM,I,MED_ATTR,NBATT,IRET)
        IF (NBATT.EQ.1) THEN
           CALL EFFAMI(NFSGCT,NOM,I,NOMFAM,NUMFAM,
     *                 ATIDE0,ATVAL0,ATDES0,NB,GRO,NGRO,IRET)
           IF (NUMFAM.GT.0) THEN          ! famille de noeud
             IFAN(NUMFAM)=ATVAL0(1)
           ELSEIF (NUMFAM.LT.0) THEN      ! famille d'element
             LFAE=.TRUE.
             IFAE(-NUMFAM)=ATVAL0(1)
           ENDIF
        ELSEIF (NBATT.EQ.4) THEN
           CALL EFFAMI(NFSGCT,NOM,I,NOMFAM,NUMFAM,
     *                 ATIDE2,ATVAL2,ATDES2,NB,GRO,NGRO,IRET)
           IELT(-NUMFAM)=ATVAL2(1)
           IFACE(-NUMFAM)=ATVAL2(2)
           IFACE(NELEMS-NUMFAM)=ATVAL2(3)
           IFACE(2*NELEMS-NUMFAM)=ATVAL2(4)
        ELSEIF (NBATT.EQ.5) THEN
           CALL EFFAMI(NFSGCT,NOM,I,NOMFAM,NUMFAM,
     *                 ATIDE3,ATVAL3,ATDES3,NB,GRO,NGRO,IRET)
           IELT(-NUMFAM)=ATVAL3(1)
           IFACE(-NUMFAM)=ATVAL3(2)
           IFACE(NELEMS-NUMFAM)=ATVAL3(3)
           IFACE(2*NELEMS-NUMFAM)=ATVAL3(4)
           IFACE(3*NELEMS-NUMFAM)=ATVAL3(5)
        ENDIF
      ENDDO
C
C     On remet d'aplomb les references des noeuds
      DO I=1,NPOINS
        IREF(I)=IFAN(IREF(I))
      ENDDO
C
C     Quand il n'y a pas de references de face on remet d'aplomb
C     les references des elements
      IF (LFAE) THEN
        DO I=1,NELEMS
          IELT(I)=IFAE(-IELT(I))
        ENDDO
      ENDIF
C
cc        CALL INREFA (NDIM,NDIELE,NELEMS,NBNO,NBFACE,INOEUD,IFACE,
cc     *               NPOINS,IREF)
C
#endif
      END
