CHANGELOG for 5.0.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 5.0 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v5.0.0...v5.0.1

* 5.0.10 (2020-06-12)

 * bug #37227 [DependencyInjection][CheckTypeDeclarationsPass] Handle unresolved parameters pointing to environment variables (fancyweb)
 * bug #37103 [Form] switch the context when validating nested forms (xabbuh)
 * bug #37182 [HttpKernel] Fix regression where Store does not return response body correctly (mpdude)
 * bug #37193 [DependencyInjection][CheckTypeDeclarationsPass] Always resolve parameters (fancyweb)
 * bug #37191 [HttpClient] fix offset computation for data chunks (nicolas-grekas)
 * bug #37177 [Ldap] fix refreshUser() ignoring extra_fields (arkste)
 * bug #37181 [Mailer] Remove an internal annot (fabpot)
 * bug #36913 [FrameworkBundle] fix type annotation on ControllerTrait::addFlash() (ThomasLandauer)
 * bug #37162 [Mailer] added the reply-to addresses to the API SES transport request. (ribeiropaulor)
 * bug #37167 [Mime] use fromString when creating a new Address (fabpot)
 * bug #37169 [Cache] fix forward compatibility with Doctrine DBAL 3 (xabbuh)
 * bug #37159 [Mailer] Fixed generator bug when creating multiple transports using Transport::fromDsn (atailouloute)
 * bug #37048 [HttpClient] fix monitoring timeouts when other streams are active (nicolas-grekas)
 * bug #37085 [Form] properly cascade validation to child forms (xabbuh)
 * bug #37095 [PhpUnitBridge] Fix undefined index when output of "composer show" cannot be parsed (nicolas-grekas)
 * bug #37092 [PhpUnitBridge] fix undefined var on version 3.4 (nicolas-grekas)
 * bug #37065 [HttpClient] Throw JsonException instead of TransportException on empty response in Response::toArray() (jeroennoten)
 * bug #37077 [WebProfilerBundle] Move ajax clear event listener initialization on loadToolbar (Bruno BOUTAREL)
 * bug #37049 [Serializer] take into account the context when preserving empty array objects (xabbuh)

* 5.0.9 (2020-05-31)

 * bug #37008 [Security] Fixed AbstractToken::hasUserChanged() (wouterj)
 * bug #36894 [Validator] never directly validate Existence (Required/Optional) constraints (xabbuh)
 * bug #37007 [Console] Fix QuestionHelper::disableStty() (chalasr)
 * bug #36865 [Form] validate subforms in all validation groups (xabbuh)
 * bug #36907 Fixes sprintf(): Too few arguments in form transformer (pedrocasado)
 * bug #36868 [Validator] Use Mime component to determine mime type for file validator (pierredup)
 * bug #37000 Add meaningful message when using ProcessHelper and Process is not installed (l-vo)
 * bug #36995 [TwigBridge] fix fallback html-to-txt body converter (nicolas-grekas)
 * bug #36993 [ErrorHandler] fix setting $trace to null in FatalError (nicolas-grekas)
 * bug #36987 Handle fetch mode deprecation of DBAL 2.11. (derrabus)
 * bug #36974 [Security] Fixed handling of CSRF logout error (wouterj)
 * bug #36947 [Mime] Allow email message to have "To", "Cc", or "Bcc" header to be valid (Ernest Hymel)
 * bug #36914 Parse and render anonymous classes correctly on php 8 (derrabus)
 * bug #36921 [OptionsResolver][Serializer] Remove calls to deprecated ReflectionParameter::getClass() (derrabus)
 * bug #36920 [VarDumper] fix PHP 8 support (nicolas-grekas)
 * bug #36917 [Cache] Accessing undefined constants raises an Error in php8 (derrabus)
 * bug #36891 Address deprecation of ReflectionType::getClass() (derrabus)
 * bug #36899 [VarDumper] ReflectionFunction::isDisabled() is deprecated (derrabus)
 * bug #36905 [Validator] Catch expected ValueError (derrabus)
 * bug #36915 [DomCrawler] Catch expected ValueError (derrabus)
 * bug #36908 [Cache][HttpClient] Made method signatures compatible with their corresponding traits (derrabus)
 * bug #36906 [DomCrawler] Catch expected ValueError (derrabus)
 * bug #36904 [PropertyAccess] Parse php 8 TypeErrors correctly (derrabus)
 * bug #36839 [BrowserKit] Raw body with custom Content-Type header (azhurb)
 * bug #36896 [Config] Removed implicit cast of ReflectionProperty to string (derrabus)
 * bug #35944 [Security/Core] Fix wrong roles comparison (thlbaut)
 * bug #36882 [PhpUnitBridge] fix installing under PHP >= 8 (nicolas-grekas)
 * bug #36833 [HttpKernel] Fix that the `Store` would not save responses with the X-Content-Digest header present (mpdude)
 * bug #36867 [PhpUnitBridge] fix bad detection of unsilenced deprecations (nicolas-grekas)
 * bug #36862 [Security] Unserialize $parentData, if needed, to avoid errors (rfaivre)
 * bug #36855 [HttpKernel] Fix error logger when stderr is redirected to /dev/null (fabpot)
 * bug #36838 [HttpKernel] Bring back the debug toolbar (derrabus)
 * bug #36592 [BrowserKit] Allow Referer set by history to be overridden (Slamdunk)
 * bug #36823 [HttpClient] fix PHP warning + accept status code >= 600 (nicolas-grekas)
 * bug #36824 [Security/Core] fix compat of `NativePasswordEncoder` with pre-PHP74 values of `PASSWORD_*` consts (nicolas-grekas)
 * bug #36811 [DependencyInjection] Fix register event listeners compiler pass (X-Coder264)
 * bug #36789 Change priority of KernelEvents::RESPONSE subscriber (marcw)
 * bug #36794 [Serializer] fix issue with PHP 8 (nicolas-grekas)
 * bug #36786 [WebProfiler] Remove 'none' when appending CSP tokens (ndench)
 * bug #36743 [Yaml] Fix escaped quotes in quoted multi-line string (ossinkine)
 * bug #36777 [TwigBundle] FormExtension does not have a constructor anymore since sf 4.0 (Tobion)
 * bug #36716 [Mime] handle passing custom mime types as string (mcneely)
 * bug #36747 Queue name is a required parameter (theravel)
 * bug #36751 [Mime] fix bad method call on `EmailAddressContains` (Kocal)
 * bug #36696 [Console] don't check tty on stdin, it breaks with "data lost during stream conversion" (nicolas-grekas)
 * bug #36569 [PhpUnitBridge] Mark parent class also covered in CoverageListener (lyrixx)
 * bug #36690 [Yaml] prevent notice for invalid octal numbers on PHP 7.4 (xabbuh)
 * bug #36590 [Console] Default hidden question to 1 attempt for non-tty session (ostrolucky)
 * bug #36497 [Filesystem] Handle paths on different drives (crishoj)
 * bug #36678 [WebProfiler] Do not add src-elem CSP directives if they do not exist (ndench)
 * bug #36501 [DX] Show the ParseException message in all YAML file loaders (fancyweb)
 * bug #36683 [Yaml] fix parse error when unindented collections contain a comment (wdiesveld)
 * bug #36672 [Validator] Skip validation when email is an empty object (acrobat)
 * bug #36673 [PhpUnitBridge] fix PHP 5.3 compat again (nicolas-grekas)
 * bug #36505 [Translation] Fix for translation:update command updating ICU messages (artemoliynyk)
 * bug #36627 [Validator] fix lazy property usage. (bendavies)
 * bug #36601 [Serializer] do not transform empty \Traversable to Array (soyuka)
 * bug #36606 [Cache] Fixed not supported Redis eviction policies (SerheyDolgushev)
 * bug #36625 [PhpUnitBridge] fix compat with PHP 5.3 (nicolas-grekas)

* 5.0.8 (2020-04-28)

 * bug #36536 [Cache] Allow invalidateTags calls to be traced by data collector (l-vo)
 * bug #36566 [PhpUnitBridge] Use COMPOSER_BINARY env var if available (fancyweb)
 * bug #36560 [YAML] escape DEL(\x7f) (sdkawata)
 * bug #36539 [PhpUnitBridge] fix compatibility with phpunit 9 (garak)
 * bug #36555 [Cache] skip APCu in chains when the backend is disabled (nicolas-grekas)
 * bug #36523 [Form] apply automatically step=1 for datetime-local input (ottaviano)
 * bug #36519 [FrameworkBundle] debug:autowiring: Fix wrong display when using class_alias (weaverryan)
 * bug #36454 [DependencyInjection][ServiceSubscriber] Support late aliases (fancyweb)
 * bug #36162 [Profiler] Fix profiler nullable string type (mRoca)
 * bug #36498 [Security/Core] fix escape for username in LdapBindAuthenticationProvider.php (stoccc)
 * bug #36506 [FrameworkBundle] Fix session.attribute_bag service definition (fancyweb)
 * bug #36500 [Routing][PrefixTrait] Add the _locale requirement (fancyweb)
 * bug #36457 [Cache] CacheItem with tag is never a hit after expired (alexander-schranz, nicolas-grekas)
 * bug #36490 [HttpFoundation] workaround PHP bug in the session module (nicolas-grekas)
 * bug #36483 [SecurityBundle] fix accepting env vars in remember-me configurations (zek)
 * bug #36343 [Form] Fixed handling groups sequence validation (HeahDude)
 * bug #36463 [Mime] Ensure proper line-ending for SMIME (sstok)
 * bug #36460 [Cache] Avoid memory leak in TraceableAdapter::reset() (lyrixx)
 * bug #36467 Mailer from sender fixes (fabpot)
 * bug #36408 [PhpUnitBridge] add PolyfillTestCaseTrait::expectExceptionMessageMatches to provide FC with recent phpunit versions (soyuka)
 * bug #36447 Remove return type for Twig function workflow_metadata() (gisostallenberg)
 * bug #36449 [Messenger] Make sure redis transports are initialized correctly (Seldaek)
 * bug #36411 [Form] RepeatedType should always have inner types mapped (biozshock)
 * bug #36441 [DI] fix loading defaults when using the PHP-DSL (nicolas-grekas)
 * bug #36434 [HttpKernel] silence E_NOTICE triggered since PHP 7.4 (xabbuh)
 * bug #36365 [Validator] Fixed default group for nested composite constraints (HeahDude)
 * bug #36422 [HttpClient] fix HTTP/2 support on non-SSL connections - CurlHttpClient only (nicolas-grekas)
 * bug #36417 Force ping after transport exception (oesteve)
 * bug #35591 [Validator] do not merge constraints within interfaces (greedyivan)
 * bug #36377 [HttpClient] Fix scoped client without query option configuration (X-Coder264)
 * bug #36387 [DI] fix detecting short service syntax in yaml (nicolas-grekas)
 * bug #36392 [DI] add missing property declarations in InlineServiceConfigurator (nicolas-grekas)
 * bug #36400 Allowing empty secrets to be set (weaverryan)
 * bug #36380 [Process] Fixed input/output error on PHP 7.4 (mbardelmeijer)
 * bug #36376 [Workflow] Use a strict comparison when retrieving raw marking in MarkingStore (lyrixx)
 * bug #36375 [Workflow] Use a strict comparison when retrieving raw marking in MarkingStore (lyrixx)
 * bug #36305 [PropertyInfo][ReflectionExtractor] Check the array mutator prefixes last when the property is singular (fancyweb)
 * bug #35656 [HttpFoundation] Fixed session migration with custom cookie lifetime (Guite)
 * bug #36342 [HttpKernel][FrameworkBundle] fix compat with Debug component (nicolas-grekas)
 * bug #36315 [WebProfilerBundle] Support for Content Security Policy style-src-elem and script-src-elem in WebProfiler (ampaze)
 * bug #36286 [Validator] Allow URL-encoded special characters in basic auth part of URLs (cweiske)
 * bug #36335 [Security] Track session usage whenever a new token is set (wouterj)
 * bug #36332 [Serializer] Fix unitialized properties (from PHP 7.4.2) when serializing context for the cache key (alanpoulain)
 * bug #36338 [MonologBridge] Fix $level type (fancyweb)
 * bug #36337 [MonologBridge] Fix $level type (fancyweb)
 * bug #36223 [Security][Http][SwitchUserListener] Ignore all non existent username protection errors (fancyweb)
 * bug #36239 [HttpKernel][LoggerDataCollector] Prevent keys collisions in the sanitized logs processing (fancyweb)
 * bug #36245 [Validator] Fixed calling getters before resolving groups (HeahDude)
 * bug #36265 Fix the reporting of deprecations in twig:lint (stof)
 * bug #36283 [Security] forward multiple attributes voting flag (xabbuh)

* 5.0.7 (2020-03-30)

 * security #cve-2020-5255 [HttpFoundation] Do not set the default Content-Type based on the Accept header (yceruto)
 * security #cve-2020-5275 [Security] Fix access_control behavior with unanimous decision strategy (chalasr)
 * bug #36262 [DI] fix generating TypedReference from PriorityTaggedServiceTrait (nicolas-grekas)
 * bug #36252 [Security/Http] Allow setting cookie security settings for delete_cookies (wouterj)
 * bug #36261 [FrameworkBundle] revert to legacy wiring of the session when circular refs are detected (nicolas-grekas)
 * bug #36259 [DomCrawler] Fix BC break in assertions breaking Panther (dunglas)
 * bug #36181 [BrowserKit] fixed missing post request parameters in file uploads (codebay)
 * bug #36216 [Validator] Assert Valid with many groups (phucwan91)
 * bug #36222 [Console] Fix OutputStream for PHP 7.4 (guillbdx)

* 5.0.6 (2020-03-27)

 * bug #36169 [HttpKernel] fix locking for PHP 7.4+ (nicolas-grekas)
 * bug #36175 [Security/Http] Remember me: allow to set the samesite cookie flag (dunglas)
 * bug #36173 [Http Foundation] Fix clear cookie samesite (guillbdx)
 * bug #36176 [Security] Check if firewall is stateless before checking for session/previous session (koenreiniers)
 * bug #36149 [Form] Support customized intl php.ini settings (jorrit)
 * bug #36172 [Debug] fix for PHP 7.3.16+/7.4.4+ (nicolas-grekas)
 * bug #36151 [Security] Fixed hardcoded value of SODIUM_CRYPTO_PWHASH_MEMLIMIT_INTERACTIVE (lyrixx)
 * bug #36141 Prevent warning in proc_open() (BenMorel)
 * bug #36143 [FrameworkBundle] Fix Router Cache (guillbdx)
 * bug #36103 [DI] fix preloading script generation (nicolas-grekas)
 * bug #36118 [Security/Http] don't require the session to be started when tracking its id (nicolas-grekas)
 * bug #36108 [DI] Fix CheckTypeDeclarationPass (guillbdx)
 * bug #36121 [VarDumper] fix side-effect by not using mt_rand() (nicolas-grekas)
 * bug #36073 [PropertyAccess][DX] Improved errors when reading uninitialized properties (HeahDude)
 * bug #36063 [FrameworkBundle] start session on flashbag injection (William Arslett)
 * bug #36031 [Console] Fallback to default answers when unable to read input (ostrolucky)
 * bug #36083 [DI][Form] Fixed test suite (TimeType changes & unresolved merge conflict) (wouterj)
 * bug #36026 [Mime] Fix boundary header (guillbdx)
 * bug #36020 [Form] ignore microseconds submitted by Edge (xabbuh)
 * bug #36038 [HttpClient] disable debug log with curl 7.64.0 (nicolas-grekas)
 * bug #36041 fix import from config file using type: glob (Tobion)
 * bug #35987 [DoctrineBridge][DoctrineExtractor] Fix wrong guessed type for "json" type (fancyweb)
 * bug #35949 [DI] Fix container lint command when a synthetic service is used in an expression (HypeMC)
 * bug #36023 [HttpClient] fix requests to hosts that idn_to_ascii() cannot handle (nicolas-grekas)
 * bug #35938 [Form] Handle false as empty value on expanded choices (fancyweb)
 * bug #36030 [SecurityBundle] Minor fix in LDAP config tree builder (HeahDude)
 * bug #36017 [HttpKernel] Fix support for single-colon syntax for controllers (nicolas-grekas)
 * bug #35993 Remove int return type from FlattenException::getCode (wucdbm)
 * bug #36004 [Yaml] fix dumping strings containing CRs (xabbuh)
 * bug #35982 [DI] Fix XmlFileLoader bad error message (przemyslaw-bogusz)
 * bug #35957 [DI] ignore extra tags added by autoconfiguration in PriorityTaggedServiceTrait (nicolas-grekas)
 * bug #35937 Revert "bug symfony#28179 [DomCrawler] Skip disabled fields processing in Form" (dmaicher)
 * bug #35928 [Routing] Prevent localized routes _locale default & requirement from being overridden (fancyweb)
 * bug #35912 [FrameworkBundle] register only existing transport factories (xabbuh)
 * bug #35899 [DomCrawler] prevent deprecation being triggered from assertion (xabbuh)
 * bug #35910 [SecurityBundle] Minor fixes in configuration tree builder (HeahDude)

* 5.0.5 (2020-02-29)

 * bug #35781 [Form] NumberToLocalizedStringTransformer return int if scale = 0 (VincentLanglet)
 * bug #35846 [Serializer] prevent method calls on null values (xabbuh)
 * bug #35897 [FrameworkBundle] add missing Messenger options to XML schema definition (xabbuh)
 * bug #35870 [ErrorHandler] fix parsing static return type on interface method annotation (alekitto)
 * bug #35839 [Security] Allow switching to another user when already switched (chalasr)
 * bug #35851 [DoctrineBridge] Use new Types::* constants and support new json types (fancyweb)
 * bug #35841 [Notifier] Dispatch message event in null transport (jschaedl)
 * bug #35716 [PhpUnitBridge] Fix compatibility to PHPUnit 9 (Benjamin)
 * bug #35803 [Cache] Fix versioned namespace atomic clears (trvrnrth)
 * bug #35817 [DoctrineBridge] Use new Types::* constants and support new json type (fancyweb)
 * bug #35832 [Debug][ErrorHandler] improved deprecation notices for methods new args and return type (HeahDude)
 * bug #35827 [BrowserKit] Nested file array prevents uploading file (afilina)
 * bug #35826 [Notifier] Add correct tags for NullTransportFactory (jschaedl)
 * bug #35830 [FrameworkBundle] Skip notifiers tags in UnusedTagsPass (chalasr)
 * bug #35707 [ExpressionLanguage] Fixed collisions of character operators with object properties (Andrej-in-ua)
 * bug #35794 [DoctrineBridge][DoctrineExtractor] Fix indexBy with custom and some core types (fancyweb)
 * bug #35787 [PhpUnitBridge] Use trait instead of extending deprecated class (marcello-moenkemeyer)
 * bug #35792 [Security] Prevent TypeError in case RememberMetoken has no attached user (nikophil)
 * bug #35735 [Routing] Add locale requirement for localized routes (mtarld)
 * bug #35772 [Config] don't throw on missing excluded paths (nicolas-grekas)
 * bug #35774 [Ldap] force default network timeout (nicolas-grekas)
 * bug #35702 [VarDumper] fixed DateCaster not displaying additional fields (Makdessi Alex)
 * bug #35722 [HttpKernel] Set previous exception when rethrown from controller resolver (danut007ro)
 * bug #35714 [HttpClient] Correctly remove trace level options for HttpCache (aschempp)
 * bug #35718 [HttpKernel] fix registering DebugHandlersListener regardless of the PHP_SAPI (nicolas-grekas)
 * bug #35728 Add missing autoload calls (greg0ire)
 * bug #35693 [Finder] Fix unix root dir issue (chr-hertel)
 * bug #35709 [HttpFoundation] fix not sending Content-Type header for 204 responses (Tobion)
 * bug #35710 [ErrorHandler] silence warning when zend.assertions=-1 (nicolas-grekas)
 * bug #35676 [Console] Handle zero row count in appendRow() for Table (Adam Prickett)
 * bug #35696 [Console] Don't load same-namespace alternatives on exact match (chalasr)
 * bug #35674 [HttpClient] fix getting response content after its destructor throwed an HttpExceptionInterface (nicolas-grekas)
 * bug #35672 [HttpClient] fix HttpClientDataCollector when handling canceled responses (thematchless)
 * bug #35641 [Process] throw when PhpProcess::fromShellCommandLine() is used (Guikingone)
 * bug #35645 [ErrorHandler] Never throw on warnings triggered by assert() and set assert.exception=1 in Debug::enable() (nicolas-grekas)
 * bug #35633 [Mailer] Do not ping the SMTP server before sending every message (micheh)
 * bug #33897 [Console] Consider STDIN interactive (ostrolucky)
 * bug #35605 [HttpFoundation][FrameworkBundle] fix support for samesite in session cookies (fabpot)
 * bug #35609 [DoctrineBridge] Fixed submitting ids with query limit or offset (HeahDude)
 * bug #35616 [Workflow] Make method signature compatible with 4.4 (pbowyer)
 * bug #35597 [PHPunit bridge] Provide current file as file path (greg0ire)
 * bug #33960 [DI] Unknown env prefix not recognized as such (ro0NL)
 * bug #35342 [DI] Fix support for multiple tags for locators and iterators (Alexandre Parent)
 * bug #33820 [PhpUnitBridge] Fix some errors when using serialized deprecations (l-vo)
 * bug #35553 Fix HTTP client config handling (julienfalque)
 * bug #35588 [ErrorHandler] Escape variable in Exception template (jderusse)
 * bug #35583 Add missing use statements (fabpot)
 * bug #35582 Missing use statement 4.4 (fabpot)
 * bug #34123 [Form] Fix handling of empty_data's \Closure value in Date/Time form types (yceruto)
 * bug #35537 [Config][XmlReferenceDumper] Prevent potential \TypeError (fancyweb)
 * bug #35227 [Mailer] Fix broken mandrill http send for recipients with names (vilius-g)
 * bug #35430 [Translation] prefer intl domain when adding messages to catalogue (Guite)
 * bug #35497 Fail on empty password verification (without warning on any implementation) (Stefan Kruppa)
 * bug #35546 [Validator] check for __get method existence if property is uninitialized (alekitto)
 * bug #35332 [Yaml][Inline] Fail properly on empty object tag and empty const tag (fancyweb)
 * bug #35489 [PhpUnitBridge] Fix running skipped tests expecting only deprecations (chalasr)
 * bug #35161 [FrameworkBundle] Check non-null type for numeric type (Arman-Hosseini)
 * bug #34059 [DomCrawler] Skip disabled fields processing in Form (sbogx)
 * bug #34114 [Console] SymonfyStyle - Check value isset to avoid PHP notice (leevigraham)
 * bug #35557 [Config] dont catch instances of Error (nicolas-grekas)
 * bug #35562 [HttpClient] fix HttpClientDataCollector when handling canceled responses (nicolas-grekas)

* 5.0.4 (2020-01-31)

 * bug #35530 [HttpClient] Fix regex bearer (noniagriconomie)
 * bug #35532 [Validator] fix access to uninitialized property when getting value (greedyivan)
 * bug #35486 [Translator] Default value for 'sort' option in translation:update should be 'asc' (versgui)
 * bug #35305 [HttpKernel] Fix stale-if-error behavior, add tests (mpdude)
 * bug #34808 [PhpUnitBridge] Properly handle phpunit arguments for configuration file (biozshock)
 * bug #35517 [Intl] Provide more locale translations (ro0NL)
 * bug #35518 [Mailer] Fix STARTTLS support for Postmark and Mandrill (fabpot)
 * bug #35480 [Messenger] Check for all serialization exceptions during message dec… (Patrick Berenschot)
 * bug #35502 [Messenger] Fix bug when using single route with XML config (Nyholm)
 * bug #35438 [SecurityBundle] fix ldap_bind service arguments (Ioni14)
 * bug #35429 [DI]  CheckTypeDeclarationsPass now checks if value is type of parameter type  (pfazzi)
 * bug #35464 [ErrorHandler] Add debug argument to decide whether debug page is shown or not (yceruto)
 * bug #35423 Fixes a runtime error when accessing the cache panel (DamienHarper)
 * bug #35428 [Cache] fix checking for igbinary availability (nicolas-grekas)
 * bug #35424 [HttpKernel] Check if lock can be released (sjadema)

* 5.0.3 (2020-01-21)

 * bug #35364 [Yaml] Throw on unquoted exclamation mark (fancyweb)
 * bug #35065 [Security] Use supportsClass in addition to UnsupportedUserException (linaori)
 * bug #35351 Revert #34797 "Fixed translations file dumper behavior" and fix #34713 (yceruto)
 * bug #35356 [Filesystem] chown and chgrp should also accept int as owner and group (Slamdunk)
 * bug #35335 [Security] Fix RememberMe with null password (jderusse)
 * bug #35339 [String] add missing encoding when calling mb_ord() (nicolas-grekas)
 * bug #35355 [DI] Fix EnvVar not loaded when Loader requires an env var (jderusse)
 * bug #35343 [Security] Fix RememberMe with null password (jderusse)
 * bug #34223 [DI] Suggest typed argument when binding fails with untyped argument (gudfar)
 * bug #35323 [FrameworkBundle] Set booted flag to false when test kernel is unset (thiagocordeiro)
 * bug #35324 [HttpClient] Fix strict parsing of response status codes (Armando-Walmeric)
 * bug #35318 [Yaml] fix PHP const mapping keys using the inline notation (xabbuh)
 * bug #35306 [FrameworkBundle] Make sure one can use fragments.hinclude_default_template (Nyholm)
 * bug #35304 [HttpKernel] Fix that no-cache MUST revalidate with the origin (mpdude)
 * bug #35299 Avoid `stale-if-error` in FrameworkBundle's HttpCache if kernel.debug = true (mpdude)
 * bug #35240 [SecurityBundle] Fix collecting traceable listeners info on lazy firewalls (chalasr)
 * bug #35151 [DI] deferred exceptions in ResolveParameterPlaceHoldersPass (Islam93)
 * bug #35290 [Filesystem][FilesystemCommonTrait] Use a dedicated directory when there are no namespace (fancyweb)
 * bug #35099 [FrameworkBundle] Do not throw exception on value generate key (jderusse)
 * bug #35278 [EventDispatcher] expand listener in place (xabbuh)
 * bug #35269 [HttpKernel][FileLocator] Fix deprecation message (fancyweb)
 * bug #35254 [PHPUnit-Bridge] Fail-fast in simple-phpunit if one of the passthru() commands fails (mpdude)
 * bug #35261 [Routing] Fix using a custom matcher & generator dumper class (fancyweb)
 * bug #34643 [Dotenv] Fixed infinite loop with missing quote followed by quoted value (naitsirch)
 * bug #35239 [Security\Http] Prevent canceled remember-me cookie from being accepted (chalasr)
 * bug #35267 [Debug] fix ClassNotFoundFatalErrorHandler (nicolas-grekas)
 * bug #35252 [Serializer] Fix cache in MetadataAwareNameConverter (bastnic)
 * bug #35200 [TwigBridge] do not render preferred choices as selected (xabbuh)
 * bug #35243 [HttpKernel] release lock explicitly (nicolas-grekas)
 * bug #35193 [TwigBridge] button_widget now has its title attr translated even if its label = null or false (stephen-lewis)
 * bug #35219 [PhpUnitBridge] When using phpenv + phpenv-composer plugin, composer executable is wrapped into a bash script (oleg-andreyev)
 * bug #35150 [Messenger] Added check if json_encode succeeded (toooni)
 * bug #35137 [Messenger] Added check if json_encode succeeded (toooni)
 * bug #35170 [FrameworkBundle][TranslationUpdateCommand] Do not output positive feedback on stderr (fancyweb)
 * bug #35245 [HttpClient] fix exception in case of PSR17 discovery failure (nicolas-grekas)
 * bug #35244 [Cache] fix processing chain adapter based cache pool (xabbuh)
 * bug #35247 [FrameworkBundle][ContainerLintCommand] Only skip .errored. services (fancyweb)
 * bug #35225 [DependencyInjection] Handle ServiceClosureArgument for callable in container linting (shieldo)
 * bug #35223 [HttpClient] Don't read from the network faster than the CPU can deal with (nicolas-grekas)
 * bug #35214 [DI] DecoratorServicePass should keep container.service_locator on the decorated definition (malarzm)
 * bug #35209 [HttpClient] fix support for non-blocking resource streams (nicolas-grekas)
 * bug #35210 [HttpClient] NativeHttpClient should not send >1.1 protocol version (nicolas-grekas)
 * bug #35162 [Mailer] Make sure you can pass custom headers to Mailgun (Nyholm)
 * bug #33672 [Mailer] Remove line breaks in email attachment content (Stuart Fyfe)
 * bug #35101 [Routing] Fix i18n routing when the url contains the locale (fancyweb)
 * bug #35124 [TwigBridge][Form] Added missing help messages in form themes (cmen)
 * bug #35195 [HttpClient] fix casting responses to PHP streams (nicolas-grekas)
 * bug #35168 [HttpClient] fix capturing SSL certificates with NativeHttpClient (nicolas-grekas)
 * bug #35134 [PropertyInfo] Fix BC issue in phpDoc Reflection library (jaapio)
 * bug #35184  [Mailer] Payload sent to Sendgrid doesn't include names (versgui)
 * bug #35173 [Mailer][MailchimpBridge] Fix missing attachments when sending via Mandrill API (vilius-g)
 * bug #35172 [Mailer][MailchimpBridge] Fix incorrect sender address when sender has name (vilius-g)
 * bug #35125 [Translator] fix performance issue in MessageCatalogue and catalogue operations (ArtemBrovko)
 * bug #35120 [HttpClient] fix scheduling pending NativeResponse (nicolas-grekas)
 * bug #35117 [Cache] do not overwrite variable value (xabbuh)
 * bug #35113 [VarDumper] Fix "Undefined index: argv" when using CliContextProvider (xepozz)
 * bug #34673 Migrate server:log command away from WebServerBundle (jderusse)
 * bug #35103 [Translation] Use `locale_parse` for computing fallback locales (alanpoulain)
 * bug #35060 [Security] Fix missing defaults for auto-migrating encoders (chalasr)
 * bug #35067 [DependencyInjection][CheckTypeDeclarationsPass] Handle \Closure for callable (fancyweb)
 * bug #35094 [Console] Fix filtering out identical alternatives when there is a command loader (fancyweb)

* 5.0.2 (2019-12-19)

 * bug #35051 [DependencyInjection] Fix binding tagged services to containers (nicolas-grekas)
 * bug #35039 [DI] skip looking for config class when the extension class is anonymous (nicolas-grekas)
 * bug #35049 [ProxyManager] fix generating proxies for root-namespaced classes (nicolas-grekas)
 * bug #35022 [Dotenv] FIX missing getenv (mccullagh)
 * bug #35023 [HttpKernel] ignore failures generated by opcache.restrict_api (nicolas-grekas)
 * bug #35024 [HttpFoundation] fix pdo session handler for sqlsrv (azjezz)
 * bug #35025 [HttpClient][Psr18Client] Remove Psr18ExceptionTrait (fancyweb)
 * bug #35028 [TwigBridge] Fix invalid typehint for subject in is_granted Twig function (emodric)
 * bug #35015 [Config] fix perf of glob discovery when GLOB_BRACE is not available (nicolas-grekas)
 * bug #35014 [HttpClient] make pushed responses retry-able (nicolas-grekas)
 * bug #35010 [VarDumper] ignore failing __debugInfo() (nicolas-grekas)
 * bug #34998 [DI] fix auto-binding service providers to their service subscribers (nicolas-grekas)
 * bug #34954 [Mailer] Fixed undefined index when sending via Mandrill API (wulff)
 * bug #33670 [DI] Service locators can't be decorated (malarzm)
 * bug #35000 [Console][SymfonyQuestionHelper] Handle multibytes question choices keys and custom prompt (fancyweb)
 * bug #35005 [HttpClient] force HTTP/1.1 when NTLM auth is used (nicolas-grekas)
 * bug #34707 [Validation][FrameworkBundle] Allow EnableAutoMapping to work without auto-mapping namespaces (ogizanagi)
 * bug #34996 Fix displaying anonymous classes on PHP 7.4 (nicolas-grekas)
 * bug #29839 [Validator] fix comparisons with null values at property paths (xabbuh)
 * bug #34900 [DoctrineBridge] Fixed submitting invalid ids when using queries with limit (HeahDude)
 * bug #34791 [Serializer] Skip uninitialized (PHP 7.4) properties in PropertyNormalizer and ObjectNormalizer (vudaltsov)
 * bug #34956 [Messenger][AMQP] Use delivery_mode=2 by default (lyrixx)
 * bug #34915 [FrameworkBundle] Fix invalid Windows path normalization in TemplateNameParser (mvorisek)
 * bug #34981 stop using deprecated Doctrine persistence classes (xabbuh)
 * bug #34904 [Validator][ConstraintValidator] Safe fail on invalid timezones (fancyweb)
 * bug #34935 [FrameworkBundle][DependencyInjection] Skip removed ids in the lint container command and its associated pass (fancyweb)
 * bug #34957 [Security] Revert "AbstractAuthenticationListener.php error instead info" (larzuk91)
 * bug #34922 [FrameworkBundle][Secrets] Hook configured local dotenv file (fancyweb)
 * bug #34967 [HttpFoundation] fix redis multi host dsn not recognized (Jan Christoph Beyer)
 * bug #34963 [Lock] fix constructor argument type declaration (xabbuh)
 * bug #34955 Require doctrine/persistence ^1.3 (nicolas-grekas)
 * bug #34923 [DI] Fix support for immutable setters in CallTrait (Lctrs)
 * bug #34878 [TwigBundle] fix broken FilesystemLoader::exists() with Twig 3 (dpesch)
 * bug #34921 [HttpFoundation] Removed "Content-Type" from the preferred format guessing mechanism (yceruto)
 * bug #34886 [HttpKernel] fix triggering deprecation in file locator (xabbuh)
 * bug #34918 [Translation] fix memoryleak in PhpFileLoader (nicolas-grekas)
 * bug #34920 [Routing] fix memoryleak when loading compiled routes (nicolas-grekas)
 * bug #34787 [Cache] Propagate expiry when syncing items in ChainAdapter (trvrnrth)
 * bug #34694 [Validator] Fix auto-mapping constraints should not be validated (ogizanagi)
 * bug #34848 [Process] change the syntax of portable command lines (nicolas-grekas)
 * bug #34862 [FrameworkBundle][ContainerLintCommand] Reinitialize bundles when the container is reprepared (fancyweb)
 * bug #34896 [Cache] fix memory leak when using PhpFilesAdapter (nicolas-grekas)
 * bug #34438 [HttpFoundation] Use `Cache-Control: must-revalidate` only if explicit lifetime has been given (mpdude)
 * bug #34449 [Yaml] Implement multiline string as scalar block for tagged values (natepage)
 * bug #34601 [MonologBridge] Fix debug processor datetime type (mRoca)
 * bug #34842 [ExpressionLanguage] Process division by zero (tigr1991)
 * bug #34902 [PropertyAccess] forward caught exception (xabbuh)
 * bug #34903 Fixing bad order of operations with null coalescing operator (weaverryan)
 * bug #34888 [TwigBundle] add tags before processing them (xabbuh)
 * bug #34760 [Mailer] Fix SMTP Authentication when using STARTTLS (DjLeChuck)
 * bug #34762 [Config] never try loading failed classes twice with ClassExistenceResource (nicolas-grekas)
 * bug #34783 [DependencyInjection] Handle env var placeholders in CheckTypeDeclarationsPass (fancyweb)
 * bug #34839 [Cache] fix memory leak when using PhpArrayAdapter (nicolas-grekas)
 * bug #34801 [String] implement __sleep()/__wakeup() on strings (nicolas-grekas)
 * bug #34782 [String] inline Latin-ASCII rules (nicolas-grekas)
 * bug #34812 [Yaml] fix parsing negative octal numbers (xabbuh)
 * bug #34854 [Messenger] gracefully handle missing event dispatchers (xabbuh)
 * bug #34802 [Security] Check UserInterface::getPassword is not null before calling needsRehash (dbrekelmans)
 * bug #34788 [SecurityBundle] Properly escape regex in AddSessionDomainConstraintPass (fancyweb)
 * bug #34859 [SecurityBundle] Fix TokenStorage::reset not called in stateless firewall (jderusse)
 * bug #34827 [HttpFoundation] get currently session.gc_maxlifetime if ttl doesnt exists (rafaeltovar)
 * bug #34755 [FrameworkBundle] resolve service locators in `debug:*` commands (nicolas-grekas)
 * bug #34832 [Validator] Allow underscore character "_" in URL username and password (romainneutron)
 * bug #34765 [DoctrineBridge] Removed QueryBuilder type hint in getLoader() (HeahDude)
 * bug #34811 [TwigBridge] Update bootstrap_4_layout.html.twig missing switch-custom label (sabruss)
 * bug #34820 [FrameworkBundle][SodiumVault] Create secrets directory only when it is used (fancyweb)
 * bug #34776 [DI] fix resolving bindings for named TypedReference (nicolas-grekas)
 * bug #34794 [DependencyInjection] Resolve expressions in CheckTypeDeclarationsPass (fancyweb)
 * bug #34795 [Routing][ObjectLoader] Remove forgotten deprecation after merge (fancyweb)
 * bug #34797 [Translation] Fix FileDumper behavior (yceruto)
 * bug #34738 [SecurityBundle] Passwords are not encoded when algorithm set to "true" (nieuwenhuisen)
 * bug #34759 [SecurityBundle] Fix switch_user provider configuration handling (fancyweb)
 * bug #34779 [Security] do not validate passwords when the hash is null (xabbuh)
 * bug #34786 [SecurityBundle] Use config variable in AnonymousFactory (martijnboers)
 * bug #34784 [FrameworkBundle] Set the parameter bag as resolved in ContainerLintCommand (fancyweb)
 * bug #34763 [Security/Core] Fix checking for SHA256/SHA512 passwords (David Brooks)
 * bug #34757 [DI] Fix making the container path-independent when the app is in /app (nicolas-grekas)

* 5.0.1 (2019-12-01)

 * bug #34732 [DependencyInjection][Xml] Fix the attribute 'tag' is not allowed in 'bind' tag (tienvx)
 * bug #34729 [DI] auto-register singly implemented interfaces by default (nicolas-grekas)
 * bug #34728 [DI] fix overriding existing services with aliases for singly-implemented interfaces (nicolas-grekas)
 * bug #34649 more robust initialization from request (dbu)
 * bug #34715 [TwigBundle] remove service when base class is missing (xabbuh)
 * bug #34600 [DoctrineBridge] do not depend on the QueryBuilder from the ORM (xabbuh)
 * bug #34627 [Security/Http] call auth listeners/guards eagerly when they "support" the request (nicolas-grekas)
 * bug #34671 [Security] Fix clearing remember-me cookie after deauthentication (chalasr)
 * bug #34711 Fix the translation commands when a template contains a syntax error (fabpot)
 * bug #34032 [Mime] Fixing multidimensional array structure with FormDataPart (jvahldick)
 * bug #34697 [MonologBridge] Fix compatibility of ServerLogHandler with Monolog 2 (jderusse)
 * bug #34560 [Config][ReflectionClassResource] Handle parameters with undefined constant as their default values (fancyweb)
 * bug #34695 [Config] don't break on virtual stack frames in ClassExistenceResource (nicolas-grekas)
 * bug #34716 [DependencyInjection] fix dumping number-like string parameters (xabbuh)
 * bug #34558 [Console] Fix autocomplete multibyte input support (fancyweb)
 * bug #34130 [Console] Fix commands description with numeric namespaces (fancyweb)
 * bug #34562 [DI] Skip unknown method calls for factories in check types pass (fancyweb)
 * bug #34677 [EventDispatcher] Better error reporting when arguments to dispatch() are swapped (rimas-kudelis)
 * bug #33573 [TwigBridge] Add row_attr to all form themes (fancyweb)
 * bug #34019 [Serializer] CsvEncoder::NO_HEADERS_KEY ignored when used in constructor (Dario Savella)
 * bug #34083 [Form] Keep preferred_choices order for choice groups (vilius-g)
 * bug #34091 [Debug] work around failing chdir() on Darwin (mary2501)
 * bug #34305 [PhpUnitBridge] Read configuration CLI directive (ro0NL)
 * bug #34490 [Serializer] Fix MetadataAwareNameConverter usage with string group (antograssiot)
 * bug #34632 [Console] Fix trying to access array offset on value of type int (Tavafi)
 * bug #34669 [HttpClient] turn exception into log when the request has no content-type (nicolas-grekas)
 * bug #34662 [HttpKernel] Support typehint to deprecated FlattenException in controller (andrew-demb)
 * bug #34619 Restores preview mode support for Html and Serializer error renderers (yceruto)
 * bug #34636 [VarDumper] notice on potential undefined index (sylvainmetayer)
 * bug #34668 [Cache] Make sure we get the correct number of values from redis::mget() (thePanz)
 * bug #34621 [Routing] Continue supporting single colon in object route loaders (fancyweb)
 * bug #34554 [HttpClient] Fix early cleanup of pushed HTTP/2 responses (lyrixx)
 * bug #34607 [HttpKernel] Ability to define multiple kernel.reset tags (rmikalkenas)
 * bug #34599 [Mailer][Mailchimp Bridge] Throwing undefined index _id when setting message id (monteiro)
 * bug #34569 [Workflow] Apply the same logic of precedence between the apply() and the buildTransitionBlockerList() method (lyrixx)
 * bug #34580 [HttpKernel] Don't cache "not-fresh" state (nicolas-grekas)
 * bug #34577 [FrameworkBundle][Cache] Don't deep-merge cache pools configuration (alxndrbauer)
 * bug #34515 [DependencyInjection] definitions are valid objects (xabbuh)
 * bug #34536 [SecurityBundle] Don't require a user provider for the anonymous listener (chalasr)
 * bug #34533 [Monolog Bridge] Fixed accessing static property as non static. (Sander-Toonen)
 * bug #34502 [FrameworkBundle][ContainerLint] Keep "removing" compiler passes (fancyweb)
 * bug #34552 [Dotenv] don't fail when referenced env var does not exist (xabbuh)
 * bug #34546 [Serializer] Add DateTimeZoneNormalizer into Dependency Injection (jewome62)
 * bug #34547 [Messenger] Error when specified default bus is not among the configured (vudaltsov)
 * bug #34513 [Validator] remove return type declaration from __sleep() (xabbuh)
 * bug #34551 [Security] SwitchUser is broken when the User Provider always returns a valid user (tucksaun)
 * bug #34570 [FrameworkBundle][Notifier] Fixing notifier email definition without mailer (chr-hertel)
 * bug #34385 Avoid empty "If-Modified-Since" header in validation request (mpdude)
 * bug #34458 [Validator] ConstraintValidatorTestCase: add missing return value to mocked validate method calls (ogizanagi)
 * bug #34516 [HttpKernel] drop return type declaration (xabbuh)
 * bug #34474 [Messenger] Ignore stamps in in-memory transport (tienvx)

* 5.0.0 (2019-11-21)

 * bug #34464 [Form] group constraints when calling the validator (nicolas-grekas)
 * bug #34451 [DependencyInjection] Fix dumping multiple deprecated aliases (shyim)
 * bug #34448 [Form] allow button names to start with uppercase letter (xabbuh)
 * bug #34434 [Routing] Fix ContainerLoader and ObjectLoaderTest (fancyweb)
 * bug #34428 [Security] Fix best encoder not wired using migrate_from (chalasr)

* 5.0.0-RC1 (2019-11-17)

 * bug #34419 [Cache] Disable igbinary on PHP >= 7.4 (nicolas-grekas)
 * bug #34347 [Messenger] Perform no deep merging of bus middleware (vudaltsov)
 * bug #34366 [HttpFoundation] Allow redirecting to URLs that contain a semicolon (JayBizzle)
 * feature #34405 [HttpFoundation] Added possibility to configure expiration time in redis session handler (mantulo)
 * bug #34397 [FrameworkBundle] Remove project dir from Translator cache vary scanned directories (fancyweb)
 * bug #34384 [DoctrineBridge] Improve queries parameters display in Profiler (fancyweb)
 * bug #34408 [Cache] catch exceptions when using PDO directly (xabbuh)
 * bug #34411 [HttpKernel] Flatten "exception" controller argument if not typed (chalasr)
 * bug #34410 [HttpFoundation] Fix MySQL column type definition. (jbroutier)
 * bug #34403 [Cache] Redis Tag Aware warn on wrong eviction policy (andrerom)
 * bug #34400 [HttpKernel] collect bundle classes, not paths (nicolas-grekas)
 * bug #34398 [Config] fix id-generation for GlobResource (nicolas-grekas)
 * bug #34404 [HttpClient] fix HttpClientDataCollector (nicolas-grekas)
 * bug #34396 [Finder] Allow ssh2 stream wrapper for sftp (damienalexandre)
 * bug #34383 [DI] Use reproducible entropy to generate env placeholders (nicolas-grekas)
 * bug #34389 [WebProfilerBundle] add FrameworkBundle requirement (xabbuh)
 * bug #34381 [WebProfilerBundle] Require symfony/twig-bundle (fancyweb)
 * bug #34358  [Security] always check the token on non-lazy firewalls  (nicolas-grekas, lyrixx)
 * bug #34390 [FrameworkBundle] fix wiring of httplug client (nicolas-grekas)
 * bug #34369 [FrameworkBundle] Disallow WebProfilerBundle < 4.4 (derrabus)
 * bug #34370 [DI] fix detecting singly implemented interfaces (nicolas-grekas)

* 5.0.0-BETA2 (2019-11-13)

 * bug #34344 [Console] Constant STDOUT might be undefined (nicolas-grekas)
 * bug #34348 [Serializer] Fix ProblemNormalizer signature mismatch (chalasr)
 * security #cve-2019-18886 [Security\Core] throw AccessDeniedException when switch user fails (nicolas-grekas)
 * security #cve-2019-18888 [Mime] fix guessing mime-types of files with leading dash (nicolas-grekas)
 * security #cve-2019-11325 [VarExporter] fix exporting some strings (nicolas-grekas)
 * security #cve-2019-18889 [Cache] forbid serializing AbstractAdapter and TagAwareAdapter instances (nicolas-grekas)
 * security #cve-2019-18888 [HttpFoundation] fix guessing mime-types of files with leading dash (nicolas-grekas)
 * security #cve-2019-18887 [HttpKernel] Use constant time comparison in UriSigner (stof)

* 5.0.0-BETA1 (2019-11-12)

 * feature #34333 Revert "feature #34329 [ExpressionLanguage] add XOR operator (ottaviano)" (nicolas-grekas)
 * feature #34332 Allow \Throwable $previous everywhere (fancyweb)
 * feature #34329 [ExpressionLanguage] add XOR operator (ottaviano)
 * feature #34312 [ErrorHandler] merge and remove the ErrorRenderer component (nicolas-grekas, yceruto)
 * feature #34309 [HttpKernel] make ExceptionEvent able to propagate any throwable (nicolas-grekas)
 * feature #33497 [Contracts] Add parameter type declarations to contracts (derrabus)
 * feature #34139 [Security] Add migrating encoder configuration (chalasr)
 * feature #32194 [HttpFoundation] Add a way to anonymize IPs (Seldaek)
 * feature #34252 [Console] Add support for NO_COLOR env var (Seldaek)
 * feature #34295 [DI][FrameworkBundle] add EnvVarLoaderInterface - remove SecretEnvVarProcessor (nicolas-grekas)
 * feature #31310 [DependencyInjection] Added option `ignore_errors: not_found` for imported config files (pulzarraider)
 * feature #34216 [HttpClient] allow arbitrary JSON values in requests (pschultz)
 * feature #31977 Add handling for delayed message to redis transport (alexander-schranz)
 * feature #34217 [Messenger] use events consistently in worker (Tobion)
 * feature #33065 Deprecate things that prevent \Throwable from bubbling down (fancyweb)
 * feature #34184 [VarDumper] display the method we're in when dumping stack traces (nicolas-grekas)
 * feature #33732 [Console] Rename some methods related to redraw frequency (javiereguiluz)
 * feature #31587 [Routing][Config] Allow patterns of resources to be excluded from config loading (tristanbes)
 * feature #32256 [DI] Add compiler pass and command to check that services wiring matches type declarations (alcalyn, GuilhemN, nicolas-grekas)
 * feature #32061 Add new Form WeekType (dFayet)
 * feature #33954 Form theme: support Bootstrap 4 custom switches (romaricdrigon)
 * feature #33854 [DI] Add ability to choose behavior of decorations on non existent decorated services (mtarld)
 * feature #34185 [Messenger]  extract worker logic to listener and get rid of SendersLocatorInterface::getSenderByAlias (Tobion)
 * feature #34156 Adding DoctrineClearEntityManagerWorkerSubscriber to reset EM in worker (weaverryan)
 * feature #34133 [Cache] add DeflateMarshaller - remove phpredis compression (nicolas-grekas)
 * feature #34177 [HttpFoundation][FrameworkBundle] allow configuring the session handler with a DSN (nicolas-grekas)
 * feature #32107 [Validator] Add AutoMapping constraint to enable or disable auto-validation (dunglas)
 * feature #34170 Re-allow to use "tagged" in service definitions (dunglas)
 * feature #34043 [Lock] Add missing lock connection string in FrameworkExtension (jderusse)
 * feature #34057 [Lock][Cache] Allows URL DSN in PDO adapters (jderusse)
 * feature #34151 [DomCrawler] normalizeWhitespace should be true by default (dunglas)
 * feature #34020 [Security] Allow to stick to a specific password hashing algorithm (chalasr)
 * feature #34141 Slack notifier actions (fabpot)
 * feature #34131 [FrameworkBundle] Remove suffix convention when using env vars to override secrets from the vault (nicolas-grekas)
 * feature #34051 [HttpClient] allow option "buffer" to be a stream resource (nicolas-grekas)
 * feature #34028 [ExpressionLanguage][Lexer] Exponential format for number (tigr1991)
 * feature #34069 [Messenger] Removing "sync" transport and replacing it with config trick (weaverryan)
 * feature #34014 [DI] made the `env(base64:...)` processor able to decode base64url (nicolas-grekas)
 * feature #34044 [HttpClient] Add a canceled state to the ResponseInterface (Toflar)
 * feature #33997 [FrameworkBundle] Add `secrets:*` commands and `env(secret:...)` processor to deal with secrets seamlessly (Tobion, jderusse, nicolas-grekas)
 * feature #34013 [DI] add `LazyString` for lazy computation of string values injected into services (nicolas-grekas)
 * feature #33961 [TwigBridge] Add show-deprecations option to the lint:twig command (yceruto)
 * feature #33973 [HttpClient] add HttpClient::createForBaseUri() (nicolas-grekas)
 * feature #33980 [HttpClient] try using php-http/discovery when nyholm/psr7 is not installed (nicolas-grekas)
 * feature #33967 [Mailer] Add Message-Id to SentMessage when sending an email (fabpot)
 * feature #33896 [Serializer][CSV] Add context options to handle BOM (malarzm)
 * feature #33883 [Mailer] added ReplyTo option for PostmarkApiTransport (pierregaste)
 * feature #33053 [ErrorHandler] Rework fatal errors (fancyweb)
 * feature #33939 [Cache] add TagAwareMarshaller to optimize data storage when using AbstractTagAwareAdapter (nicolas-grekas)
 * feature #33941 Keeping backward compatibility with legacy FlattenException usage (yceruto)
 * feature #33851 [EventDispatcher] Allow to omit the event name when registering listeners (derrabus)
 * feature #33461 [Cache] Improve RedisTagAwareAdapter invalidation logic & requirements (andrerom)
 * feature #33779 [DI] enable improved syntax for defining method calls in Yaml (nicolas-grekas)
 * feature #33743 [HttpClient] Async HTTPlug client (Nyholm)
 * feature #33856 [Messenger] Allow to configure the db index on Redis transport (chalasr)
 * feature #33881 [VarDumper] Added a support for casting Ramsey/Uuid (lyrixx)
 * feature #33687 Notifier Component (fabpot)
 * feature #33861 [CssSelector] Support *:only-of-type (jakzal)
 * feature #33793 [EventDispatcher] A compiler pass for aliased userland events (derrabus)
 * feature #33791 [Form] Added CountryType option for using alpha3 country codes (creiner)
 * feature #33628 [DependencyInjection] added Ability to define a priority method for tagged service (lyrixx)
 * feature #33768 [String] Introduce a locale-aware Slugger in the String component (tgalopin)
 * feature #33775 [Console] Add deprecation message for non-int statusCode (jschaedl)
 * feature #33783 [WebProfilerBundle] Try to display the most useful panel by default (fancyweb)
 * feature #33701 [HttpKernel] wrap compilation of the container in an opportunistic lock (nicolas-grekas)
 * feature #33789 [Serializer] Deprecate the XmlEncoder::TYPE_CASE_ATTRIBUTES constant (pierredup)
 * feature #31446 [VarDumper] Output the location of calls to dump()  (ktherage)
 * feature #33412 [Console] Do not leak hidden console commands (m-vo)
 * feature #33676 [Security] add "anonymous: lazy" mode to firewalls (nicolas-grekas)
 * feature #32440 [DomCrawler] add a normalizeWhitespace argument to text() method (Simperfit)
 * feature #33148 [Intl] Excludes locale from language codes (split localized language names) (ro0NL)
 * feature #31202 [FrameworkBundle] WebTestCase KernelBrowser::getContainer null return type (Simperfit)
 * feature #33038 [ErrorHandler] Forward \Throwable (fancyweb)
 * feature #33574 [Http][DI] Replace REMOTE_ADDR in trusted proxies with the current REMOTE_ADDR (mcfedr)
 * feature #33553 [String] a new component for object-oriented strings management with an abstract unit system (nicolas-grekas, hhamon, gharlan)
 * feature #33113 [Messenger][DX] Display real handler if handler is wrapped (DavidBadura)
 * feature #33128 [FrameworkBundle] Sort tagged services (krome162504)
 * feature #33658 [Yaml] fix parsing inline YAML spanning multiple lines (xabbuh)
 * feature #33698 [HttpKernel] compress files generated by the profiler (nicolas-grekas)
 * feature #33317 [Messenger] Added support for `from_transport` attribute on `messenger.message_handler` tag (ruudk)
 * feature #33584 [Security] Deprecate isGranted()/decide() on more than one attribute (wouterj)
 * feature #33663 [Security] Make stateful firewalls turn responses private only when needed (nicolas-grekas)
 * feature #33609 [Form][SubmitType] Add "validate" option (fancyweb)
 * feature #33621 Revert "feature #33507 [WebProfiler] Deprecated intercept_redirects in 4.4 (dorumd)" (lyrixx)
 * feature #33635 [FrameworkBundle] Cleanup (yceruto)
 * feature #33605 [Twig] Add NotificationEmail (fabpot)
 * feature #33623 [DependencyInjection] Allow binding iterable and tagged services (lyrixx)
 * feature #33507 [WebProfiler] Deprecated intercept_redirects in 4.4 (dorumd)
 * feature #33579 Adding .gitattributes to remove Tests directory from "dist" (Nyholm)
 * feature #33562 [Mailer] rename SmtpEnvelope to Envelope (xabbuh)
 * feature #33565 [Mailer] Rename an exception class (fabpot)
 * feature #33516 [Cache] Added reserved characters constant for CacheItem (andyexeter)
 * feature #33503 [SecurityBundle] Move Anonymous DI integration to new AnonymousFactory (wouterj)
 * feature #33535 [WebProfilerBundle] Assign automatic colors to custom Stopwatch categories (javiereguiluz)
 * feature #32565 [HttpClient] Allow enabling buffering conditionally with a Closure (rjwebdev)
 * feature #32032 [DI] generate preload.php file for PHP 7.4 in cache folder (nicolas-grekas)
 * feature #33117 [FrameworkBundle] Added --sort option for TranslationUpdateCommand (k0d3r1s)
 * feature #32832 [Serializer] Allow multi-dimenstion object array in AbstractObjectNormalizer (alediator)
 * feature #33189 New welcome page on startup for 4.4 LTS & 5.0 (yceruto)
 * feature #33295 [OptionsResolver] Display full nested option hierarchy in exceptions (fancyweb)
 * feature #33486 [VarDumper] Display fully qualified title (pavinthan, nicolas-grekas)
 * feature #33496 Deprecated not passing dash symbol (-) to STDIN commands (yceruto)
 * feature #32742 [Console] Added support for definition list and horizontal table  (lyrixx)
 * feature #33494 [Mailer] Change DSN syntax (fabpot)
 * feature #33471 [Mailer] Check email validity before opening an SMTP connection (fabpot)
 * feature #31177 #21571 Comparing roles to detected that users has changed (oleg-andreyev)
 * feature #33459 [Validator] Deprecated CacheInterface in favor of PSR-6 (derrabus)
 * feature #33271 Added new ErrorController + Preview and enabling there the error renderer mechanism (yceruto)
 * feature #33454 [Mailer] Improve an exception when trying to send a RawMessage without an Envelope (fabpot)
 * feature #33327 [ErrorHandler] Registering basic exception handler for late failures (yceruto)
 * feature #33446 [TwigBridge] lint all templates from configured Twig paths if no argument was provided (yceruto)
 * feature #33409 [Mailer] Add support for multiple mailers (fabpot)
 * feature #33424 [Mailer] Change the DSN semantics (fabpot)
 * feature #33352 [Security] drop support for non-boolean return values from checkCredentials() (xabbuh)
 * feature #33319 Allow configuring class names through methods instead of class parameters in Doctrine extensions (alcaeus)
 * feature #33283 [ErrorHandler] make DebugClassLoader able to add return type declarations (nicolas-grekas)
 * feature #33323 [TwigBridge] Throw an exception when one uses email as a context variable in a TemplatedEmail (fabpot)
 * feature #33308 [SecurityGuard] Deprecate returning non-boolean values from checkCredentials() (derrabus)
 * feature #33217 [FrameworkBundle][DX] Improving the redirect config when using RedirectController (yceruto)
 * feature #33015 [HttpClient] Added TraceableHttpClient and WebProfiler panel (jeremyFreeAgent)
 * feature #33091 [Mime] Add Address::fromString (gisostallenberg)
 * feature #33144 [DomCrawler] Added Crawler::matches(), ::closest(), ::outerHtml() (lyrixx)
 * feature #33152 Mark all dispatched event classes as final (Tobion)
 * feature #33258 [HttpKernel] deprecate global dir to load resources from (Tobion)
 * feature #33272 [Translation] deprecate support for null locales (xabbuh)
 * feature #33269 [TwigBridge] Mark all classes extending twig as @final (fabpot)
 * feature #33270 [Mime] Remove NamedAddress (fabpot)
 * feature #33169 [HttpFoundation] Precalculate session expiry timestamp (azjezz)
 * feature #33237 [Mailer] Remove the auth mode DSN option and support in the eSMTP transport (fabpot)
 * feature #33233 [Mailer] Simplify the way TLS/SSL/STARTTLS work (fabpot)
 * feature #32360 [Monolog] Added ElasticsearchLogstashHandler (lyrixx)
 * feature #32489 [Messenger] Allow exchange type headers binding (CedrickOka)
 * feature #32783 [Messenger] InMemoryTransport handle acknowledged and rejected messages (tienvx)
 * feature #33098 added `Process::getLastOutputTime()` method (connorhu)
 * feature #33155 [ErrorHandler] Added call() method utility to turns any PHP error into \ErrorException (yceruto)
 * feature #33203 [Mailer] Add support for the queued flag in the EmailCount assertion (fabpot)
 * feature #30323 [ErrorHandler] trigger deprecation in DebugClassLoader when child class misses a return type (fancyweb, nicolas-grekas)
 * feature #33137 [DI] deprecate support for non-object services (nicolas-grekas)
 * feature #32845 [HttpKernel][FrameworkBundle] Add alternative convention for bundle directories (yceruto)
 * feature #32548 [Translation] XliffLintCommand: allow .xliff file extension (codegain)
 * feature #28363 [Serializer] Encode empty objects as objects, not arrays (mcfedr)
 * feature #33122 [WebLink] implement PSR-13 directly (nicolas-grekas)
 * feature #33078 Add compatibility trait for PHPUnit constraint classes (alcaeus)
 * feature #32988 [Intl] Support ISO 3166-1 Alpha-3 country codes (terjebraten-certua)
 * feature #32598 [FrameworkBundle][Routing] Private service route loaders (fancyweb)
 * feature #32486 [DoctrineBridge] Invokable event listeners (fancyweb)
 * feature #31083 [Validator] Allow objects implementing __toString() to be used as violation messages (mdlutz24)
 * feature #32122 [HttpFoundation] deprecate HeaderBag::get() returning an array and add all($key) instead (Simperfit)
 * feature #32807 [HttpClient] add "max_duration" option (fancyweb)
 * feature #31546 [Dotenv] Use default value when referenced variable is not set (j92)
 * feature #32930 [Mailer][Mime] Add PHPUnit constraints and assertions for the Mailer (fabpot)
 * feature #32912 [Mailer] Add support for the profiler (fabpot)
 * feature #32940 [PhpUnitBridge] Add polyfill for PhpUnit namespace (jderusse)
 * feature #31843 [Security] add support for opportunistic password migrations (nicolas-grekas)
 * feature #32824 [Ldap] Add security LdapUser and provider (chalasr)
 * feature #32922 [PhpUnitBridge] make the bridge act as a polyfill for newest PHPUnit features (nicolas-grekas)
 * feature #32927 [Mailer] Add message events logger (fabpot)
 * feature #32916 [Mailer] Add a name to the transports (fabpot)
 * feature #32917 [Mime] Add AbstractPart::asDebugString() (fabpot)
 * feature #32543 [FrameworkBundle] add config translator cache_dir (Raulnet)
 * feature #32669 [Yaml] Add flag to dump NULL as ~ (OskarStark)
 * feature #32896 [Mailer] added debug info to TransportExceptionInterface (fabpot)
 * feature #32817 [DoctrineBridge] Deprecate RegistryInterface (Koc)
 * feature #32504 [ErrorRenderer] Add DebugCommand for easy debugging and testing (yceruto)
 * feature #32581 [DI] Allow dumping the container in one file instead of many files (nicolas-grekas)
 * feature #32762 [Form][DX] derive default timezone from reference_date option when possible (yceruto)
 * feature #32745 [Messenger][Profiler] Attempt to give more useful source info when using HandleTrait (ogizanagi)
 * feature #32680 [Messenger][Profiler] Collect the stamps at the end of dispatch (ogizanagi)
 * feature #32683 [VarDumper] added support for Imagine/Image (lyrixx)
 * feature #32749 [Mailer] Make transport factory test case public (Koc)
 * feature #32718 [Form] use a reference date to handle times during DST (xabbuh)
 * feature #32637 [ErrorHandler] Decouple from ErrorRenderer component (yceruto)
 * feature #32609 [Mailer][DX][RFC] Rename mailer bridge transport classes (Koc)
 * feature #32587 [Form][Validator] Generate accept attribute with file constraint and mime types option (Coosos)
 * feature #32658 [Form] repeat preferred choices in list of all choices (Seb33300, xabbuh)
 * feature #32698 [WebProfilerBundle] mark all classes as internal (Tobion)
 * feature #32695 [WebProfilerBundle] Decoupling TwigBundle and using the new ErrorRenderer mechanism (yceruto)
 * feature #31398 [TwigBundle] Deprecating error templates for non-html formats and using ErrorRenderer as fallback (yceruto)
 * feature #32582 [Routing] Deprecate ServiceRouterLoader and ObjectRouteLoader in favor of ContainerLoader and ObjectLoader (fancyweb)
 * feature #32661 [ErrorRenderer] Improving the exception page provided by HtmlErrorRenderer (yceruto)
 * feature #32332 [DI] Move non removing compiler passes to after removing passes (alexpott)
 * feature #32475 [Process] Deprecate Process::inheritEnvironmentVariables() (ogizanagi)
 * feature #32583 [Mailer] Logger vs debug mailer (fabpot)
 * feature #32471 Add a new ErrorHandler component (mirror of the Debug component) (yceruto)
 * feature #32463 [VarDumper] Allow to configure VarDumperTestTrait casters & flags (ogizanagi)
 * feature #31946 [Mailer] Extract transport factory and allow create custom transports (Koc)
 * feature #31194 [PropertyAccess] Improve errors when trying to find a writable property (pierredup)
 * feature #32435 [Validator] Add a new constraint message when there is both min and max (Lctrs)
 * feature #32470 Rename ErrorCatcher to ErrorRenderer (rendering part only) (yceruto)
 * feature #32462 [WebProfilerBundle] Deprecating templateExists method (yceruto)
 * feature #32458 Remove support for Twig 1.x (fabpot)
 * feature #32446 [Lock] rename and deprecate Factory into LockFactory (Simperfit)
 * feature #31975 Dynamic bundle assets (garak)
 * feature #32429 [VarDumper] Let browsers trigger their own search on double CMD/CTRL + F (ogizanagi)
 * feature #32198 [Lock] Split "StoreInterface" into multiple interfaces with less responsibility (Simperfit)
 * feature #31511 [Validator] Allow to use property paths to get limits in range constraint (Lctrs)
 * feature #32424 [Console] don't redraw progress bar more than every 100ms by default (nicolas-grekas)
 * feature #27905 [MonologBridge] Monolog 2 compatibility (derrabus)
 * feature #32418 [Console] Added Application::reset() (lyrixx)
 * feature #31217 [WebserverBundle] Deprecate the bundle in favor of symfony local server (Simperfit)
 * feature #31554 [SECURITY] AbstractAuthenticationListener.php error instead info. Rebase of #28462 (berezuev)
 * feature #32284 [Cache] Add argument $prefix to AdapterInterface::clear() (nicolas-grekas)
 * feature #32423 [ServerBundle] Display all logs by default (lyrixx)
 * feature #26339 [Console] Add ProgressBar::preventRedrawFasterThan() and forceRedrawSlowerThan() methods (ostrolucky)
 * feature #31269 [Translator] Dump native plural formats to po files (Stadly)
 * feature #31560 [Ldap][Security] LdapBindAuthenticationProvider does not bind before search query (Simperfit)
 * feature #31626 [Console] allow answer to be trimmed by adding a flag (Simperfit)
 * feature #31876 [WebProfilerBundle] Add clear button to ajax tab (Matts)
 * feature #32415 [Translation] deprecate passing a null locale (Simperfit)
 * feature #32290 [HttpClient] Add $response->toStream() to cast responses to regular PHP streams (nicolas-grekas)
 * feature #32402  [Intl] Exclude root language (ro0NL)
 * feature #32295 [FrameworkBundle] Add autowiring alias for PSR-14 (nicolas-grekas)
 * feature #32390 [DependencyInjection] Deprecated passing Parameter instances as class name to Definition (derrabus)
 * feature #32106 [FrameworkBundle] Use default_locale as default value for translator.fallbacks (dunglas)
 * feature #32294 [FrameworkBundle] Allow creating chained cache pools by providing several adapters (nicolas-grekas)
 * feature #32373 [Validator] Change Length::$allowEmptyString default to false & make it optional (ogizanagi)
 * feature #32207 [FrameworkBundle] Allow to use the BrowserKit assertions with Panther and API Platform's test client (dunglas)
 * feature #32344 [HttpFoundation][HttpKernel] Improving the request/response format autodetection (yceruto)
 * feature #32231 [HttpClient] Add support for NTLM authentication (nicolas-grekas)
 * feature #32265 [Validator] deprecate non-string constraint violation codes (xabbuh)
 * feature #31528 [Validator] Add a Length::$allowEmptyString option to reject empty strings (ogizanagi)
 * feature #32081 [WIP][Mailer] Overwrite envelope sender and recipients from config (Devristo)
 * feature #32255 [HttpFoundation] Drop support for ApacheRequest (lyrixx)
 * feature #31825 [Messenger] Added support for auto trimming of redis streams (Toflar)
 * feature #32277 Remove @experimental annotations (fabpot)
 * feature #30981 [Mime] S/MIME Support (sstok)
 * feature #32180 [Lock] add an InvalidTTLException to be more accurate (Simperfit)
 * feature #32241 [PropertyAccess] Deprecate null as allowed value for defaultLifetime argument in createCache method (jschaedl)
 * feature #32221 [ErrorCatcher] Make IDEs and static analysis tools happy (fabpot)
 * feature #32227 Rename the ErrorHandler component to ErrorCatcher (fabpot)
 * feature #31065 Add ErrorHandler component (yceruto)
 * feature #32126 [Process] Allow writing portable "prepared" command lines (Simperfit)
 * feature #31996  Add return types in final classes (dFayet)
 * feature #31532 [Ldap] Add users extraFields in ldap component (Simperfit)
 * feature #32104 Add autowiring for HTTPlug (nicolas-grekas)
 * feature #32130 [Form] deprecate int/float for string input in NumberType (xabbuh)
 * feature #31547 [Ldap] Add exception for mapping ldap errors (Simperfit)
 * feature #31764 [FrameworkBundle] add attribute stamps (walidboughdiri)
 * feature #32059 [PhpUnitBridge] Bump PHPUnit 7+8 (ro0NL)
 * feature #32041 [Validator] Deprecate unused arg in ExpressionValidator (ogizanagi)
 * feature #31287 [Config] Introduce find method in ArrayNodeDefinition to ease configuration tree manipulation (jschaedl)
 * feature #31959 [DomCrawler][Feature][DX] Add Form::getName() method (JustBlackBird)
 * feature #32026 [VarDumper] caster for HttpClient's response dumps all info (nicolas-grekas)
 * feature #31976 [HttpClient] add HttplugClient for compat with libs that need httplug v1 or v2 (nicolas-grekas)
 * feature #31956 [Mailer] Changed EventDispatcherInterface dependency from Component to Contracts (Koc)
 * feature #31980 [HttpClient] make Psr18Client implement relevant PSR-17 factories (nicolas-grekas)
 * feature #31919 [WebProfilerBundle] Select default theme based on user preferences (javiereguiluz)
 * feature #31451 [FrameworkBundle] Allow dots in translation domains (jschaedl)
 * feature #31321 [DI] deprecates tag !tagged in favor of !tagged_iterator (jschaedl)
 * feature #31658 [HTTP Foundation] Deprecate passing argument to method Request::isMethodSafe() (dFayet)
 * feature #31597 [Security] add MigratingPasswordEncoder (nicolas-grekas)
 * feature #31351 [Validator] Improve TypeValidator to handle array of types (jschaedl)
 * feature #31526 [Validator] Add compared value path to violation parameters (ogizanagi)
 * feature #31514 Add exception as HTML comment to beginning and end of `exception_full.html.twig` (ruudk)
 * feature #31739 [FrameworkBundle] Add missing BC layer for deprecated ControllerNameParser injections (chalasr)
 * feature #31831 [HttpClient] add $response->cancel() (nicolas-grekas)
 * feature #31334 [Messenger] Add clear Entity Manager middleware (Koc)
 * feature #31800 Removed support for PHP templating everywhere (yceruto)
 * feature #31594 [Security] add PasswordEncoderInterface::needsRehash() (nicolas-grekas)
 * feature #31821 [FrameworkBundle][TwigBundle] Add missing deprecations for PHP templating layer (yceruto)
 * feature #31509 [Monolog] Setup the LoggerProcessor after all other processor (lyrixx)
 * feature #31777 [Form] remove deprecated date types options handling (xabbuh)
 * feature #31785 [Messenger] Deprecate passing a bus locator to ConsumeMessagesCommand's constructor (chalasr)
 * feature #31700 [MonologBridge] RouteProcessor class is now final to ease the the removal of deprecated event (Simperfit)
 * feature #31732 [HttpKernel] Make DebugHandlersListener internal (chalasr)
 * feature #31539 [HttpKernel] Add lts config (noniagriconomie)
 * feature #31437 [Cache] Add Redis Sentinel support (StephenClouse)
 * feature #31543 [DI] deprecate short callables in yaml (nicolas-grekas)

