/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSet20;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.InternalDriver;

public abstract class Driver20
extends InternalDriver
implements Driver {
    private static final String[] BOOLEAN_CHOICES = new String[]{"false", "true"};
    private Class antiGCDriverManager;

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        AutoloadedDriver.registerDriverModule(this);
        this.antiGCDriverManager = DriverManager.class;
    }

    public void stop() {
        super.stop();
        AutoloadedDriver.unregisterDriverModule();
    }

    public abstract Connection getNewNestedConnection(EmbedConnection var1);

    public abstract EmbedConnection getNewEmbedConnection(String var1, Properties var2) throws SQLException;

    public abstract PreparedStatement newEmbedPreparedStatement(EmbedConnection var1, String var2, boolean var3, int var4, int var5, int var6, int var7, int[] var8, String[] var9) throws SQLException;

    public abstract CallableStatement newEmbedCallableStatement(EmbedConnection var1, String var2, int var3, int var4, int var5) throws SQLException;

    public EmbedResultSet newEmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) throws SQLException {
        return new EmbedResultSet20(embedConnection, resultSet, bl, embedStatement, bl2);
    }

    public abstract BrokeredConnection newBrokeredConnection(BrokeredConnectionControl var1);

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (properties != null && Boolean.valueOf(properties.getProperty("shutdown")).booleanValue()) {
            return new DriverPropertyInfo[0];
        }
        String string2 = InternalDriver.getDatabaseName(string, properties);
        FormatableProperties formatableProperties = this.getAttributes(string, properties);
        properties = null;
        boolean bl = Boolean.valueOf(formatableProperties.getProperty("dataEncryption"));
        String string3 = formatableProperties.getProperty("bootPassword");
        if (string2.length() == 0 || (bl = string3 == null)) {
            String[][] stringArrayArray = new String[][]{{"databaseName", "J004"}, {"encryptionProvider", "J016"}, {"encryptionAlgorithm", "J017"}, {"encryptionKeyLength", "J018"}, {"encryptionKey", "J019"}, {"territory", "J021"}, {"collation", "J031"}, {"user", "J022"}, {"logDevice", "J025"}, {"rollForwardRecoveryFrom", "J028"}, {"createFrom", "J029"}, {"restoreFrom", "J030"}};
            String[][] stringArrayArray2 = new String[][]{{"shutdown", "J005"}, {"create", "J007"}, {"dataEncryption", "J010"}, {"upgrade", "J013"}};
            String[][] stringArrayArray3 = new String[][]{{"bootPassword", "J020"}, {"password", "J023"}};
            DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArrayArray.length + stringArrayArray2.length + stringArrayArray3.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArrayArray.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray[n2][0], formatableProperties.getProperty(stringArrayArray[n2][0]));
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray[n2][1]);
                ++n2;
                ++n;
            }
            driverPropertyInfoArray[0].choices = Monitor.getMonitor().getServiceList("org.apache.derby.database.Database");
            driverPropertyInfoArray[0].value = string2;
            n2 = 0;
            while (n2 < stringArrayArray3.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray3[n2][0], formatableProperties.getProperty(stringArrayArray3[n2][0]) == null ? "" : "****");
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray3[n2][1]);
                ++n2;
                ++n;
            }
            n2 = 0;
            while (n2 < stringArrayArray2.length) {
                driverPropertyInfoArray[n] = new DriverPropertyInfo(stringArrayArray2[n2][0], Boolean.valueOf(formatableProperties == null ? "" : formatableProperties.getProperty(stringArrayArray2[n2][0])).toString());
                driverPropertyInfoArray[n].description = MessageService.getTextMessage(stringArrayArray2[n2][1]);
                driverPropertyInfoArray[n].choices = BOOLEAN_CHOICES;
                ++n2;
                ++n;
            }
            return driverPropertyInfoArray;
        }
        return new DriverPropertyInfo[0];
    }
}

