/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SETTINGSDIALOG_H
#define _SC_SETTINGSDIALOG_H

// sc
class SettingsInfo;
class SettingsWidget;
class SettingsLvi;

// qt
#include <QtGui/QDialog>
class QTreeWidget;
class QTreeWidgetItem;
class QGroupBox;
class QStackedWidget;
class QPushButton;

// sys
#include <map>


class SettingsDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  SettingsDialog( const QString& title, QWidget *parent=0 );
  virtual ~SettingsDialog();

  void addSettingsInfo( SettingsInfo* info, const QString& parentTitle = "" );
  void addSettingsWidget( const QString& settingsId, SettingsWidget* sw );

private slots:
  void itemClicked( QTreeWidgetItem* item, int col );

  void ok();
  void apply();
  void cancel();

  void modified();

private:
  bool isModified();

  QTreeWidget*    _categories;
  QStackedWidget* _stack;
  QGroupBox*      _box; 

  SettingsInfo* _curInfo;

  typedef std::map<QString,SettingsWidget*> Widgets;
  Widgets       _widgets;

  typedef std::map<QString,SettingsLvi*>    Lvis;
  Lvis          _lvis;

  QPushButton*  _ok;
  QPushButton*  _apply;
};

#endif // _SC_SETTINGSDIALOG_H
