/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_53 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 27393, "epsg", 27393,
        "NGO 1948 (Oslo) / NGO zone III", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=637");
    add_proj4text (p, 1,
        "7492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.");
    add_proj4text (p, 2,
        "889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone III\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10");
    add_srs_wkt (p, 4,
        ".7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AU");
    add_srs_wkt (p, 6,
        "THORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merc");
    add_srs_wkt (p, 7,
        "ator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",0],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"27393\"]]");
    p = add_epsg_def_ex (filter, first, last, 27394, "epsg", 27394,
        "NGO 1948 (Oslo) / NGO zone IV", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=2.5 +k=1 +x_0=0 +y_0=0 +a=6");
    add_proj4text (p, 1,
        "377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,");
    add_proj4text (p, 2,
        "7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone IV\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.");
    add_srs_wkt (p, 4,
        "7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",2.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"27394\"]]");
    p = add_epsg_def_ex (filter, first, last, 27395, "epsg", 27395,
        "NGO 1948 (Oslo) / NGO zone V", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.166666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone V\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7");
    add_srs_wkt (p, 4,
        "229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",6.16666666666667],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"27395\"]]");
    p = add_epsg_def_ex (filter, first, last, 27396, "epsg", 27396,
        "NGO 1948 (Oslo) / NGO zone VI", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VI\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.");
    add_srs_wkt (p, 4,
        "7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",10.1666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27396\"]]");
    p = add_epsg_def_ex (filter, first, last, 27397, "epsg", 27397,
        "NGO 1948 (Oslo) / NGO zone VII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VII\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10");
    add_srs_wkt (p, 4,
        ".7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AU");
    add_srs_wkt (p, 6,
        "THORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Merc");
    add_srs_wkt (p, 7,
        "ator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",14.1666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27397\"]]");
    p = add_epsg_def_ex (filter, first, last, 27398, "epsg", 27398,
        "NGO 1948 (Oslo) / NGO zone VIII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.33333333333333 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VIII\",GEOGCS[\"NGO ");
    add_srs_wkt (p, 1,
        "1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel ");
    add_srs_wkt (p, 2,
        "Modified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7005\"]],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",1");
    add_srs_wkt (p, 4,
        "0.7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",18.3333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"27398\"]]");
    p = add_epsg_def_ex (filter, first, last, 27429, "epsg", 27429,
        "Datum 73 / UTM zone 29N", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-223.237,110.193");
    add_proj4text (p, 1,
        ",36.649,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / UTM zone 29N\",GEOGCS[\"Datum 73\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Datum_73\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27429\"]]");
    p = add_epsg_def_ex (filter, first, last, 27492, "epsg", 27492,
        "Datum 73 / Modified Portuguese Grid", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",39.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-8.13190611111111],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",180.598],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",-86.99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27493\"]]");
    p = add_epsg_def_ex (filter, first, last, 27493, "epsg", 27493,
        "Datum 73 / Modified Portuguese Grid", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",39.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-8.13190611111111],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",180.598],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",-86.99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27493\"]]");
    p = add_epsg_def_ex (filter, first, last, 27500, "epsg", 27500,
        "ATF (Paris) / Nord de Guerre", 0, 0,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=5.399999999999999 +k_0=0.99950908 +x_0=500000");
    add_proj4text (p, 2,
        " +y_0=300000 +a=6376523 +b=6355862.933255573 +pm=2.33720");
    add_proj4text (p, 3,
        "8333333333 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATF (Paris) / Nord de Guerre\",GEOGCS[\"ATF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Ancienne_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Plessis 1817\",6376523,308.64,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901\"]],PRIMEM[\"Pa");
    add_srs_wkt (p, 4,
        "ris RGS\",2.33720833333333,AUTHORITY[\"EPSG\",\"8914\"]]");
    add_srs_wkt (p, 5,
        ",UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "105\"]],AUTHORITY[\"EPSG\",\"4901\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",55],PARAMETER[\"central_meridian\",6],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.99950908],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27500\"]]");
    p = add_epsg_def_ex (filter, first, last, 27561, "epsg", 27561,
        "NTF (Paris) / Lambert Nord France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Nord France\",GEOGCS[\"NT");
    add_srs_wkt (p, 1,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 2,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 3,
        "293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",55],PARAMETER[\"central_meridian\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999877341],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",600000],PARAMETER[\"false_northing\",200000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27561\"]]");
    p = add_epsg_def_ex (filter, first, last, 27562, "epsg", 27562,
        "NTF (Paris) / Lambert Centre France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Centre France\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",52],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.99987742],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",600000],PARAMETER[\"false_northing\",200000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27562\"]]");
    p = add_epsg_def_ex (filter, first, last, 27563, "epsg", 27563,
        "NTF (Paris) / Lambert Sud France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Sud France\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "93627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",49],PARAMETER[\"central_meridian\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999877499],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",600000],PARAMETER[\"false_northing\",200000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27563\"]]");
    p = add_epsg_def_ex (filter, first, last, 27564, "epsg", 27564,
        "NTF (Paris) / Lambert Corse", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Corse\",GEOGCS[\"NTF (Par");
    add_srs_wkt (p, 1,
        "is)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293627");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6807");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"89");
    add_srs_wkt (p, 5,
        "03\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",46.85],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99994471],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",234.358],PARAMETER[\"false_northing\",185861.369],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27564\"]]");
    p = add_epsg_def_ex (filter, first, last, 27571, "epsg", 27571,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 3,
        "7,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"680");
    add_srs_wkt (p, 4,
        "7\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",55],PARAMETER[\"central_meridian\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.999877341],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",600000],PARAMETER[\"false_northing\",1200000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"275");
    add_srs_wkt (p, 13,
        "71\"]]");
    p = add_epsg_def_ex (filter, first, last, 27572, "epsg", 27572,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",52],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99987742],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",600000],PARAMETER[\"false_northing\",2200000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"275");
    add_srs_wkt (p, 13,
        "72\"]]");
    p = add_epsg_def_ex (filter, first, last, 27573, "epsg", 27573,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 1,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",49],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.999877499],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",600000],PARAMETER[\"false_northing\",3200000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "7573\"]]");
    p = add_epsg_def_ex (filter, first, last, 27574, "epsg", 27574,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",46.85],PARAMETER[\"central_meridian\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.99994471],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",234.358],PARAMETER[\"false_northing\",4185861.369");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27574\"]]");
    p = add_epsg_def_ex (filter, first, last, 27581, "epsg", 27581,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 3,
        "7,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"680");
    add_srs_wkt (p, 4,
        "7\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",55],PARAMETER[\"central_meridian\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.999877341],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",600000],PARAMETER[\"false_northing\",1200000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"275");
    add_srs_wkt (p, 13,
        "71\"]]");
    p = add_epsg_def_ex (filter, first, last, 27582, "epsg", 27582,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",52],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99987742],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",600000],PARAMETER[\"false_northing\",2200000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"275");
    add_srs_wkt (p, 13,
        "72\"]]");
    p = add_epsg_def_ex (filter, first, last, 27583, "epsg", 27583,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 1,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",49],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.999877499],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",600000],PARAMETER[\"false_northing\",3200000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "7573\"]]");
    p = add_epsg_def_ex (filter, first, last, 27584, "epsg", 27584,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 4,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",46.85],PARAMETER[\"central_meridian\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.99994471],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",234.358],PARAMETER[\"false_northing\",4185861.369");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"27574\"]]");
    p = add_epsg_def_ex (filter, first, last, 27591, "epsg", 27591,
        "NTF (Paris) / Lambert Nord France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Nord France\",GEOGCS[\"NT");
    add_srs_wkt (p, 1,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 2,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 3,
        "293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",55],PARAMETER[\"central_meridian\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999877341],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",600000],PARAMETER[\"false_northing\",200000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27561\"]]");
    p = add_epsg_def_ex (filter, first, last, 27592, "epsg", 27592,
        "NTF (Paris) / Lambert Centre France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Centre France\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",52],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.99987742],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",600000],PARAMETER[\"false_northing\",200000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27562\"]]");
    p = add_epsg_def_ex (filter, first, last, 27593, "epsg", 27593,
        "NTF (Paris) / Lambert Sud France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Sud France\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "93627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",49],PARAMETER[\"central_meridian\",0],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.999877499],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",600000],PARAMETER[\"false_northing\",200000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27563\"]]");
    p = add_epsg_def_ex (filter, first, last, 27594, "epsg", 27594,
        "NTF (Paris) / Lambert Corse", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Corse\",GEOGCS[\"NTF (Par");
    add_srs_wkt (p, 1,
        "is)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293627");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6807");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"89");
    add_srs_wkt (p, 5,
        "03\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",46.85],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99994471],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",234.358],PARAMETER[\"false_northing\",185861.369],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27564\"]]");
    p = add_epsg_def_ex (filter, first, last, 27700, "epsg", 27700,
        "OSGB 1936 / British National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "OSGB_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +ellps=airy +towgs84=446.448,-125.157,5");
    add_proj4text (p, 2,
        "42.06,0.15,0.247,0.842,-20.489 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"OSGB 1936 / British National Grid\",GEOGCS[\"OS");
    add_srs_wkt (p, 1,
        "GB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy 1830\",637");
    add_srs_wkt (p, 2,
        "7563.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6277\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4277");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",49],PARAMETER[\"central_meridian\",-2]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996012717],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",400000],PARAMETER[\"false_northing\",-1000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"27700\"]]");
    p = add_epsg_def_ex (filter, first, last, 28191, "epsg", 28191,
        "Palestine 1923 / Palestine Grid", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=126867.909 +a=6378300.789 +b=6");
    add_proj4text (p, 2,
        "356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.001,-4");
    add_proj4text (p, 3,
        ".42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Grid\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.466315538981,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"6281\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Soldner\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",31.7340969444444],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",35.2120805555556],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",170251.555],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"28191\"]]");
    p = add_epsg_def_ex (filter, first, last, 28192, "epsg", 28192,
        "Palestine 1923 / Palestine Belt", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73409694444445 +lon_0=35.212080555");
    add_proj4text (p, 1,
        "55556 +k=1 +x_0=170251.555 +y_0=1126867.909 +a=6378300.7");
    add_proj4text (p, 2,
        "89 +b=6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8");
    add_proj4text (p, 3,
        ".001,-4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Belt\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.466315538981,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"6281\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",31.7340969444444");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",35.2120805555556],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",170");
    add_srs_wkt (p, 10,
        "251.555],PARAMETER[\"false_northing\",1126867.909],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "8192\"]]");
    p = add_epsg_def_ex (filter, first, last, 28193, "epsg", 28193,
        "Palestine 1923 / Israeli CS Grid", 0, 0,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=1126867.909 +a=6378300.789 +b=");
    add_proj4text (p, 2,
        "6356566.435 +towgs84=-275.7224,94.7824,340.8944,-8.001,-");
    add_proj4text (p, 3,
        "4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Israeli CS Grid\",GEOGCS[\"Pal");
    add_srs_wkt (p, 1,
        "estine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1880 (Benoit)\",6378300.789,293.466315538981,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"6281\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Soldn");
    add_srs_wkt (p, 7,
        "er\"],PARAMETER[\"latitude_of_origin\",31.7340969444444]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",35.2120805555556],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",170251.555],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",1126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"28193\"]]");
    p = add_epsg_def_ex (filter, first, last, 28232, "epsg", 28232,
        "Pointe Noire / UTM zone 32S", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Congo_1960_Pointe_Noire", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 1,
        "84=-148,51,-291,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pointe Noire / UTM zone 32S\",GEOGCS[\"Pointe N");
    add_srs_wkt (p, 1,
        "oire\",DATUM[\"Congo_1960_Pointe_Noire\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6282\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4282\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",9],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"28232\"]]");
    p = add_epsg_def_ex (filter, first, last, 28348, "epsg", 28348,
        "GDA94 / MGA zone 48", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 48\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28348\"]]");
    p = add_epsg_def_ex (filter, first, last, 28349, "epsg", 28349,
        "GDA94 / MGA zone 49", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 49\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28349\"]]");
    p = add_epsg_def_ex (filter, first, last, 28350, "epsg", 28350,
        "GDA94 / MGA zone 50", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 50\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28350\"]]");
    p = add_epsg_def_ex (filter, first, last, 28351, "epsg", 28351,
        "GDA94 / MGA zone 51", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 51\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28351\"]]");
    p = add_epsg_def_ex (filter, first, last, 28352, "epsg", 28352,
        "GDA94 / MGA zone 52", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 52\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28352\"]]");
    p = add_epsg_def_ex (filter, first, last, 28353, "epsg", 28353,
        "GDA94 / MGA zone 53", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 53\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28353\"]]");
    p = add_epsg_def_ex (filter, first, last, 28354, "epsg", 28354,
        "GDA94 / MGA zone 54", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 54\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28354\"]]");
    p = add_epsg_def_ex (filter, first, last, 28355, "epsg", 28355,
        "GDA94 / MGA zone 55", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 55\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28355\"]]");
    p = add_epsg_def_ex (filter, first, last, 28356, "epsg", 28356,
        "GDA94 / MGA zone 56", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 56\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28356\"]]");
    p = add_epsg_def_ex (filter, first, last, 28357, "epsg", 28357,
        "GDA94 / MGA zone 57", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 57\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28357\"]]");
    p = add_epsg_def_ex (filter, first, last, 28358, "epsg", 28358,
        "GDA94 / MGA zone 58", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 58\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"28358\"]]");
    p = add_epsg_def_ex (filter, first, last, 28402, "epsg", 28402,
        "Pulkovo 1942(58) / Gauss-Kruger zone 2", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 2\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",2500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3833\"]]");
    p = add_epsg_def_ex (filter, first, last, 28403, "epsg", 28403,
        "Pulkovo 1942(58) / Gauss-Kruger zone 3", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 3\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",3500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3333\"]]");
    p = add_epsg_def_ex (filter, first, last, 28404, "epsg", 28404,
        "Pulkovo 1942 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28404\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28405, "epsg", 28405,
        "Pulkovo 1942 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28405\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28406, "epsg", 28406,
        "Pulkovo 1942 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28406\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28407, "epsg", 28407,
        "Pulkovo 1942 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",7500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28407\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28408, "epsg", 28408,
        "Pulkovo 1942 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",8500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28408\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28409, "epsg", 28409,
        "Pulkovo 1942 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",9500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28409\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28410, "epsg", 28410,
        "Pulkovo 1942 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",10500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28410");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28411, "epsg", 28411,
        "Pulkovo 1942 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28411");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28412, "epsg", 28412,
        "Pulkovo 1942 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",12500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28412");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28413, "epsg", 28413,
        "Pulkovo 1942 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28413");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28414, "epsg", 28414,
        "Pulkovo 1942 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28414");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28415, "epsg", 28415,
        "Pulkovo 1942 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28415");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28416, "epsg", 28416,
        "Pulkovo 1942 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28416");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28417, "epsg", 28417,
        "Pulkovo 1942 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"28417");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 28418, "epsg", 28418,
        "Pulkovo 1942 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2841");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 28419, "epsg", 28419,
        "Pulkovo 1942 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2841");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 28420, "epsg", 28420,
        "Pulkovo 1942 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 28421, "epsg", 28421,
        "Pulkovo 1942 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 28422, "epsg", 28422,
        "Pulkovo 1942 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 28423, "epsg", 28423,
        "Pulkovo 1942 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 28424, "epsg", 28424,
        "Pulkovo 1942 / Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",24500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 28425, "epsg", 28425,
        "Pulkovo 1942 / Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",25500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 28426, "epsg", 28426,
        "Pulkovo 1942 / Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",26500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 28427, "epsg", 28427,
        "Pulkovo 1942 / Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",27500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 28428, "epsg", 28428,
        "Pulkovo 1942 / Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",28500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 28429, "epsg", 28429,
        "Pulkovo 1942 / Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",29500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2842");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 28430, "epsg", 28430,
        "Pulkovo 1942 / Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",30500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2843");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 28431, "epsg", 28431,
        "Pulkovo 1942 / Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",31500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2843");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 28432, "epsg", 28432,
        "Pulkovo 1942 / Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",32500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2843");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 28462, "epsg", 28462,
        "Pulkovo 1942 / Gauss-Kruger CM 9E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +e");
    add_proj4text (p, 1,
        "llps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.1");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 9E (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"2492\"]]");
    p = add_epsg_def_ex (filter, first, last, 28463, "epsg", 28463,
        "Pulkovo 1942 / Gauss-Kruger CM 15E (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 15E (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4284\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"2493\"]]");
    p = add_epsg_def_ex (filter, first, last, 28464, "epsg", 28464,
        "Pulkovo 1942 / Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 21E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2494\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28465, "epsg", 28465,
        "Pulkovo 1942 / Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 27E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2495\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28466, "epsg", 28466,
        "Pulkovo 1942 / Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 33E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2496\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28467, "epsg", 28467,
        "Pulkovo 1942 / Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 39E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2497\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28468, "epsg", 28468,
        "Pulkovo 1942 / Gauss-Kruger CM 45E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 45E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2498\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28469, "epsg", 28469,
        "Pulkovo 1942 / Gauss-Kruger CM 51E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 51E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2499\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28470, "epsg", 28470,
        "Pulkovo 1942 / Gauss-Kruger CM 57E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 57E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2500\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28471, "epsg", 28471,
        "Pulkovo 1942 / Gauss-Kruger CM 63E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 63E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2501\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28472, "epsg", 28472,
        "Pulkovo 1942 / Gauss-Kruger CM 69E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 69E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2502\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28473, "epsg", 28473,
        "Pulkovo 1942 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 75E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2503\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28474, "epsg", 28474,
        "Pulkovo 1942 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 81E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2504\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28475, "epsg", 28475,
        "Pulkovo 1942 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 87E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2505\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28476, "epsg", 28476,
        "Pulkovo 1942 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 93E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2506\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28477, "epsg", 28477,
        "Pulkovo 1942 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 99E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2507\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 28478, "epsg", 28478,
        "Pulkovo 1942 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2508\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28479, "epsg", 28479,
        "Pulkovo 1942 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2509\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28480, "epsg", 28480,
        "Pulkovo 1942 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2510\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28481, "epsg", 28481,
        "Pulkovo 1942 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2511\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28482, "epsg", 28482,
        "Pulkovo 1942 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2512\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28483, "epsg", 28483,
        "Pulkovo 1942 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2513\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28484, "epsg", 28484,
        "Pulkovo 1942 / Gauss-Kruger CM 141E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 141E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2514\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28485, "epsg", 28485,
        "Pulkovo 1942 / Gauss-Kruger CM 147E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 147E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2515\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28486, "epsg", 28486,
        "Pulkovo 1942 / Gauss-Kruger CM 153E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 153E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2516\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28487, "epsg", 28487,
        "Pulkovo 1942 / Gauss-Kruger CM 159E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 159E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2517\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28488, "epsg", 28488,
        "Pulkovo 1942 / Gauss-Kruger CM 165E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 165E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2518\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 28489, "epsg", 28489,
        "Pulkovo 1942 / Gauss-Kruger CM 171E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger CM 171E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2519\"");
    add_srs_wkt (p, 12,
        "]]");
}

#endif /* full EPSG initialization enabled/disabled */

