/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_28 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 21419, "epsg", 21419,
        "Beijing 1954 / Gauss-Kruger zone 19");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",111],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",19500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"21419\"]]");
    p = add_epsg_def (filter, first, last, 21420, "epsg", 21420,
        "Beijing 1954 / Gauss-Kruger zone 20");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",117],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",20500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"21420\"]]");
    p = add_epsg_def (filter, first, last, 21421, "epsg", 21421,
        "Beijing 1954 / Gauss-Kruger zone 21");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",123],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",21500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"21421\"]]");
    p = add_epsg_def (filter, first, last, 21422, "epsg", 21422,
        "Beijing 1954 / Gauss-Kruger zone 22");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",129],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",22500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"21422\"]]");
    p = add_epsg_def (filter, first, last, 21423, "epsg", 21423,
        "Beijing 1954 / Gauss-Kruger zone 23");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",135],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",23500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"21423\"]]");
    p = add_epsg_def (filter, first, last, 21453, "epsg", 21453,
        "Beijing 1954 / Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 75E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",75],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"21453\"]]");
    p = add_epsg_def (filter, first, last, 21454, "epsg", 21454,
        "Beijing 1954 / Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 81E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",81],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"21454\"]]");
    p = add_epsg_def (filter, first, last, 21455, "epsg", 21455,
        "Beijing 1954 / Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 87E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",87],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"21455\"]]");
    p = add_epsg_def (filter, first, last, 21456, "epsg", 21456,
        "Beijing 1954 / Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 93E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",93],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"21456\"]]");
    p = add_epsg_def (filter, first, last, 21457, "epsg", 21457,
        "Beijing 1954 / Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 99E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",99],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"21457\"]]");
    p = add_epsg_def (filter, first, last, 21458, "epsg", 21458,
        "Beijing 1954 / Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",105],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21458\"]]");
    p = add_epsg_def (filter, first, last, 21459, "epsg", 21459,
        "Beijing 1954 / Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",111],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21459\"]]");
    p = add_epsg_def (filter, first, last, 21460, "epsg", 21460,
        "Beijing 1954 / Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",117],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21460\"]]");
    p = add_epsg_def (filter, first, last, 21461, "epsg", 21461,
        "Beijing 1954 / Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",123],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21461\"]]");
    p = add_epsg_def (filter, first, last, 21462, "epsg", 21462,
        "Beijing 1954 / Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",129],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21462\"]]");
    p = add_epsg_def (filter, first, last, 21463, "epsg", 21463,
        "Beijing 1954 / Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",135],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"21463\"]]");
    p = add_epsg_def (filter, first, last, 21473, "epsg", 21473,
        "Beijing 1954 / Gauss-Kruger 13N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 13N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",75],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"21473\"]]");
    p = add_epsg_def (filter, first, last, 21474, "epsg", 21474,
        "Beijing 1954 / Gauss-Kruger 14N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 14N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",81],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"21474\"]]");
    p = add_epsg_def (filter, first, last, 21475, "epsg", 21475,
        "Beijing 1954 / Gauss-Kruger 15N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 15N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",87],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"21475\"]]");
    p = add_epsg_def (filter, first, last, 21476, "epsg", 21476,
        "Beijing 1954 / Gauss-Kruger 16N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 16N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",93],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"21476\"]]");
    p = add_epsg_def (filter, first, last, 21477, "epsg", 21477,
        "Beijing 1954 / Gauss-Kruger 17N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 17N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",99],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"21477\"]]");
    p = add_epsg_def (filter, first, last, 21478, "epsg", 21478,
        "Beijing 1954 / Gauss-Kruger 18N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 18N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",105],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"21478\"]]");
    p = add_epsg_def (filter, first, last, 21479, "epsg", 21479,
        "Beijing 1954 / Gauss-Kruger 19N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 19N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",111],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"21479\"]]");
    p = add_epsg_def (filter, first, last, 21480, "epsg", 21480,
        "Beijing 1954 / Gauss-Kruger 20N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 20N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",117],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"21480\"]]");
    p = add_epsg_def (filter, first, last, 21481, "epsg", 21481,
        "Beijing 1954 / Gauss-Kruger 21N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 21N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",123],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"21481\"]]");
    p = add_epsg_def (filter, first, last, 21482, "epsg", 21482,
        "Beijing 1954 / Gauss-Kruger 22N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 22N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",129],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"21482\"]]");
    p = add_epsg_def (filter, first, last, 21483, "epsg", 21483,
        "Beijing 1954 / Gauss-Kruger 23N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger 23N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4214\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",135],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",E");
    add_srs_wkt (p, 12,
        "AST],AUTHORITY[\"EPSG\",\"21483\"]]");
    p = add_epsg_def (filter, first, last, 21500, "epsg", 21500,
        "Belge 1950 (Brussels) / Belge Lambert 50");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=90 +lon_0=0 +x_0=150000 +y_0=5400000 +ellps=i");
    add_proj4text (p, 2,
        "ntl +pm=brussels +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Belge 1950 (Brussels) / Belge Lambert 50\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Belge 1950 (Brussels)\",DATUM[\"Reseau_National_Bel");
    add_srs_wkt (p, 2,
        "ge_1950_Brussels\",SPHEROID[\"International 1924\",63783");
    add_srs_wkt (p, 3,
        "88,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6809\"]],PRIMEM[\"Brussels\",4.367975,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8910\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4809\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"sta");
    add_srs_wkt (p, 8,
        "ndard_parallel_1\",49.83333333333334],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_2\",51.16666666666666],PARAMETER[\"latitude_");
    add_srs_wkt (p, 10,
        "of_origin\",90],PARAMETER[\"central_meridian\",0],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",150000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",5400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"21500\"]]");
    p = add_epsg_def (filter, first, last, 21780, "epsg", 21780,
        "Bern 1898 (Bern) / LV03C");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=0 +k_0=1 +x");
    add_proj4text (p, 1,
        "_0=0 +y_0=0 +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,");
    add_proj4text (p, 2,
        "0,0 +pm=bern +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bern 1898 (Bern) / LV03C\",GEOGCS[\"Bern 1898 (");
    add_srs_wkt (p, 1,
        "Bern)\",DATUM[\"CH1903_Bern\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[674.4,15.1,405.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6801");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Bern\",7.439583333333333,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8907\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4801\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_center\",46.95240555555556],PARAMETER[\"longitude_of_");
    add_srs_wkt (p, 9,
        "center\",0],PARAMETER[\"azimuth\",90],PARAMETER[\"rectif");
    add_srs_wkt (p, 10,
        "ied_grid_angle\",90],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY[\"EPSG\",\"21780\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 21781, "epsg", 21781,
        "CH1903 / LV03");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
        "333333 +k_0=1 +x_0=600000 +y_0=200000 +ellps=bessel +tow");
    add_proj4text (p, 2,
        "gs84=674.4,15.1,405.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CH1903 / LV03\",GEOGCS[\"CH1903\",DATUM[\"CH190");
    add_srs_wkt (p, 1,
        "3\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[674.4,15.1,405.3,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6149\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4149\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_center\",46.95240555555556],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"longitude_of_center\",7.439583333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"azimuth\",90],PARAMETER[\"rectified_grid_angle\",90]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",600000],PARAMETER[\"false_northing\",200000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",NORTH],AUTHORITY[\"EPSG\",\"21781\"]]");
    p = add_epsg_def (filter, first, last, 21782, "epsg", 21782,
        "CH1903 / LV03C-G");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
        "333333 +k_0=1 +x_0=0 +y_0=0 +ellps=bessel +towgs84=674.4");
    add_proj4text (p, 2,
        ",15.1,405.3,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CH1903 / LV03C-G\",GEOGCS[\"CH1903\",DATUM[\"CH");
    add_srs_wkt (p, 1,
        "1903\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[674.4,15.1,405.3,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6149\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4149\"]],PROJECTION[\"Hotine_Oblique_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_center\",46.95240555555556],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"longitude_of_center\",7.439583333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"azimuth\",90],PARAMETER[\"rectified_grid_angle\",");
    add_srs_wkt (p, 10,
        "90],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Y\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",NORTH],AUTHORITY[\"EPSG\",\"21782\"]]");
    p = add_epsg_def (filter, first, last, 21817, "epsg", 21817,
        "Bogota 1975 / UTM zone 17N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=intl +towgs84=307,304,-318,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / UTM zone 17N (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"621");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"21817\"]]");
    p = add_epsg_def (filter, first, last, 21818, "epsg", 21818,
        "Bogota 1975 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=307,304,-318,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / UTM zone 18N\",GEOGCS[\"Bogota 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Bogota_1975\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[307");
    add_srs_wkt (p, 3,
        ",304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-75],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"21818\"]]");
    p = add_epsg_def (filter, first, last, 21891, "epsg", 21891,
        "Bogota 1975 / Colombia West zone (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia West zone (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",4.599047222222222],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 9,
        "7.08091666666667],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",1000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "21891\"]]");
    p = add_epsg_def (filter, first, last, 21892, "epsg", 21892,
        "Bogota 1975 / Colombia Bogota zone (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia Bogota zone (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",4.599047222222222],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "74.08091666666667],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",1000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"21892\"]]");
    p = add_epsg_def (filter, first, last, 21893, "epsg", 21893,
        "Bogota 1975 / Colombia East Central zone (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East Central zone (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"International 1924\",6378388,297,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7022\"]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",4.599047222222222],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-71.08091666666667],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",1000000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21893\"]]");
    p = add_epsg_def (filter, first, last, 21894, "epsg", 21894,
        "Bogota 1975 / Colombia East (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "18\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        ".599047222222222],PARAMETER[\"central_meridian\",-68.080");
    add_srs_wkt (p, 9,
        "91666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",1000000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"218");
    add_srs_wkt (p, 13,
        "94\"]]");
    p = add_epsg_def (filter, first, last, 21896, "epsg", 21896,
        "Bogota 1975 / Colombia West zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia West zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",4.599047");
    add_srs_wkt (p, 8,
        "222222222],PARAMETER[\"central_meridian\",-77.0809166666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"21896\"]]");
    p = add_epsg_def (filter, first, last, 21897, "epsg", 21897,
        "Bogota 1975 / Colombia Bogota zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia Bogota zone\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "ogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 2,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",4.5990");
    add_srs_wkt (p, 8,
        "47222222222],PARAMETER[\"central_meridian\",-74.08091666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1000000],PARAMETER[\"false_northing\",1000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"21897\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 21898, "epsg", 21898,
        "Bogota 1975 / Colombia East Central zone");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East Central zone\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[307,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "18\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        ".599047222222222],PARAMETER[\"central_meridian\",-71.080");
    add_srs_wkt (p, 9,
        "91666666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",1000000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"218");
    add_srs_wkt (p, 13,
        "98\"]]");
    p = add_epsg_def (filter, first, last, 21899, "epsg", 21899,
        "Bogota 1975 / Colombia East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East\",GEOGCS[\"Bogota 1");
    add_srs_wkt (p, 1,
        "975\",DATUM[\"Bogota_1975\",SPHEROID[\"International 192");
    add_srs_wkt (p, 2,
        "4\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[30");
    add_srs_wkt (p, 3,
        "7,304,-318,0,0,0,0],AUTHORITY[\"EPSG\",\"6218\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4218\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",4.59904722222");
    add_srs_wkt (p, 8,
        "2222],PARAMETER[\"central_meridian\",-68.08091666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",1000000],PARAMETER[\"false_northing\",1000000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"21899\"]]");
    p = add_epsg_def (filter, first, last, 22032, "epsg", 22032,
        "Camacupa / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=clrk80 +towgs84=-50.9,-");
    add_proj4text (p, 1,
        "347.6,-231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / UTM zone 32S\",GEOGCS[\"Camacupa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-50.9");
    add_srs_wkt (p, 3,
        ",-347.6,-231,0,0,0,0],AUTHORITY[\"EPSG\",\"6220\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4220\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"22032\"]]");
    p = add_epsg_def (filter, first, last, 22033, "epsg", 22033,
        "Camacupa / UTM zone 33S");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-50.9,-");
    add_proj4text (p, 1,
        "347.6,-231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / UTM zone 33S\",GEOGCS[\"Camacupa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-50.9");
    add_srs_wkt (p, 3,
        ",-347.6,-231,0,0,0,0],AUTHORITY[\"EPSG\",\"6220\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4220\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",15],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"22033\"]]");
    p = add_epsg_def (filter, first, last, 22091, "epsg", 22091,
        "Camacupa / TM 11.30 SE");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / TM 11.30 SE\",GEOGCS[\"Camacupa\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.");
    add_srs_wkt (p, 2,
        "145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-50.9,");
    add_srs_wkt (p, 3,
        "-347.6,-231,0,0,0,0],AUTHORITY[\"EPSG\",\"6220\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4220\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",11.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"22091\"]]");
    p = add_epsg_def (filter, first, last, 22092, "epsg", 22092,
        "Camacupa / TM 12 SE");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa / TM 12 SE\",GEOGCS[\"Camacupa\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Camacupa\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-50.9,-34");
    add_srs_wkt (p, 3,
        "7.6,-231,0,0,0,0],AUTHORITY[\"EPSG\",\"6220\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4220\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",12],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"22092\"]]");
    p = add_epsg_def (filter, first, last, 22171, "epsg", 22171,
        "POSGAR 98 / Argentina 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 1\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-72],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",1500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22171\"]]");
    p = add_epsg_def (filter, first, last, 22172, "epsg", 22172,
        "POSGAR 98 / Argentina 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 2\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",2500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22172\"]]");
    p = add_epsg_def (filter, first, last, 22173, "epsg", 22173,
        "POSGAR 98 / Argentina 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 3\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-66],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",3500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22173\"]]");
    p = add_epsg_def (filter, first, last, 22174, "epsg", 22174,
        "POSGAR 98 / Argentina 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 4\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",4500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22174\"]]");
    p = add_epsg_def (filter, first, last, 22175, "epsg", 22175,
        "POSGAR 98 / Argentina 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 5\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-60],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",5500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22175\"]]");
    p = add_epsg_def (filter, first, last, 22176, "epsg", 22176,
        "POSGAR 98 / Argentina 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 6\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",6500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22176\"]]");
    p = add_epsg_def (filter, first, last, 22177, "epsg", 22177,
        "POSGAR 98 / Argentina 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 7\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-54],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",7500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22177\"]]");
    p = add_epsg_def (filter, first, last, 22181, "epsg", 22181,
        "POSGAR 94 / Argentina 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 1\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-72],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",1500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"22181\"]]");
    p = add_epsg_def (filter, first, last, 22182, "epsg", 22182,
        "POSGAR 94 / Argentina 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 2\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",2500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"22182\"]]");
    p = add_epsg_def (filter, first, last, 22183, "epsg", 22183,
        "POSGAR 94 / Argentina 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 3\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-66],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",3500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"22183\"]]");
    p = add_epsg_def (filter, first, last, 22184, "epsg", 22184,
        "POSGAR 94 / Argentina 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 4\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",4500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"22184\"]]");
    p = add_epsg_def (filter, first, last, 22185, "epsg", 22185,
        "POSGAR 94 / Argentina 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 5\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-60],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",5500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"22185\"]]");
    p = add_epsg_def (filter, first, last, 22186, "epsg", 22186,
        "POSGAR 94 / Argentina 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 6\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",6500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"22186\"]]");
    p = add_epsg_def (filter, first, last, 22187, "epsg", 22187,
        "POSGAR 94 / Argentina 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 7\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-54],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",7500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"22187\"]]");
    p = add_epsg_def (filter, first, last, 22191, "epsg", 22191,
        "Campo Inchauspe / Argentina 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 1\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-72],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",1500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"22191\"]]");
    p = add_epsg_def (filter, first, last, 22192, "epsg", 22192,
        "Campo Inchauspe / Argentina 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 2\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",2500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"22192\"]]");
    p = add_epsg_def (filter, first, last, 22193, "epsg", 22193,
        "Campo Inchauspe / Argentina 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 3\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-66],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",3500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"22193\"]]");
    p = add_epsg_def (filter, first, last, 22194, "epsg", 22194,
        "Campo Inchauspe / Argentina 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 4\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",4500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"22194\"]]");
    p = add_epsg_def (filter, first, last, 22195, "epsg", 22195,
        "Campo Inchauspe / Argentina 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 5\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-60],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",5500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"22195\"]]");
    p = add_epsg_def (filter, first, last, 22196, "epsg", 22196,
        "Campo Inchauspe / Argentina 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 6\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",6500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"22196\"]]");
    p = add_epsg_def (filter, first, last, 22197, "epsg", 22197,
        "Campo Inchauspe / Argentina 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 7\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-54],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",7500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"22197\"]]");
    p = add_epsg_def (filter, first, last, 22234, "epsg", 22234,
        "Cape / UTM zone 34S");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 34S\",GEOGCS[\"Cape\",DATUM[\"C");
    add_srs_wkt (p, 1,
        "ape\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.145,293.466");
    add_srs_wkt (p, 2,
        "3077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-29");
    add_srs_wkt (p, 3,
        "2,0,0,0,0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4222\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",21],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22234\"]]");
    p = add_epsg_def (filter, first, last, 22235, "epsg", 22235,
        "Cape / UTM zone 35S");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 35S\",GEOGCS[\"Cape\",DATUM[\"C");
    add_srs_wkt (p, 1,
        "ape\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.145,293.466");
    add_srs_wkt (p, 2,
        "3077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-29");
    add_srs_wkt (p, 3,
        "2,0,0,0,0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4222\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",27],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"22235\"]]");
    p = add_epsg_def (filter, first, last, 22236, "epsg", 22236,
        "Cape / UTM zone 36S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 36S (deprecated)\",GEOGCS[\"Cap");
    add_srs_wkt (p, 1,
        "e\",DATUM[\"Cape\",SPHEROID[\"Clarke 1880 (Arc)\",637824");
    add_srs_wkt (p, 2,
        "9.145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-136,-108,-292,0,0,0,0],AUTHORITY[\"EPSG\",\"6222\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",33],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"22236\"]]");
    p = add_epsg_def (filter, first, last, 22275, "epsg", 22275,
        "Cape / Lo15");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo15\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",15],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22275");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22277, "epsg", 22277,
        "Cape / Lo17");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo17\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",17],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22277");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22279, "epsg", 22279,
        "Cape / Lo19");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo19\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",19],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22279");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22281, "epsg", 22281,
        "Cape / Lo21");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo21\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",21],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22281");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22283, "epsg", 22283,
        "Cape / Lo23");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo23\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",23],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22283");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22285, "epsg", 22285,
        "Cape / Lo25");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo25\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",25],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22285");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22287, "epsg", 22287,
        "Cape / Lo27");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo27\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",27],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22287");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22289, "epsg", 22289,
        "Cape / Lo29");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo29\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",29],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22289");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22291, "epsg", 22291,
        "Cape / Lo31");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo31\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",31],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22291");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22293, "epsg", 22293,
        "Cape / Lo33");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo33\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",33],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22293");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22332, "epsg", 22332,
        "Carthage / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +datum=carthage +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / UTM zone 32N\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"22332\"]]");
    p = add_epsg_def (filter, first, last, 22391, "epsg", 22391,
        "Carthage / Nord Tunisie");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=9.9 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +datum=carthage +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / Nord Tunisie\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",36]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",9.9],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999625544],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"22391\"]]");
    p = add_epsg_def (filter, first, last, 22392, "epsg", 22392,
        "Carthage / Sud Tunisie");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=9.9 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +datum=carthage +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / Sud Tunisie\",GEOGCS[\"Carthage\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.");
    add_srs_wkt (p, 2,
        "2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",33.");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"central_meridian\",9.9],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999625769],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"22392\"]]");
    p = add_epsg_def (filter, first, last, 22521, "epsg", 22521,
        "Corrego Alegre 1970-72 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 21S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-57]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22521\"]]");
    p = add_epsg_def (filter, first, last, 22522, "epsg", 22522,
        "Corrego Alegre 1970-72 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 22S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-51]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22522\"]]");
    p = add_epsg_def (filter, first, last, 22523, "epsg", 22523,
        "Corrego Alegre 1970-72 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 23S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-45]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22523\"]]");
    p = add_epsg_def (filter, first, last, 22524, "epsg", 22524,
        "Corrego Alegre 1970-72 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 24S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-39]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22524\"]]");
    p = add_epsg_def (filter, first, last, 22525, "epsg", 22525,
        "Corrego Alegre 1970-72 / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 25S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-33]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22525\"]]");
    p = add_epsg_def (filter, first, last, 22700, "epsg", 22700,
        "Deir ez Zor / Levant Zone");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.");
    add_proj4text (p, 1,
        "9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Levant Zone\",GEOGCS[\"Deir ez Zo");
    add_srs_wkt (p, 1,
        "r\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 1880 (IGN)\"");
    add_srs_wkt (p, 2,
        ",6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-190.421,8.532,238.69,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6227\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4227\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",34.65],PARAMETER[\"central_meridian\",37");
    add_srs_wkt (p, 9,
        ".35],PARAMETER[\"scale_factor\",0.9996256],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",300000],PARAMETER[\"false_northing\",3000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22700");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22770, "epsg", 22770,
        "Deir ez Zor / Syria Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.");
    add_proj4text (p, 1,
        "9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Syria Lambert\",GEOGCS[\"Deir ez ");
    add_srs_wkt (p, 1,
        "Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 1880 (IGN)");
    add_srs_wkt (p, 2,
        "\",6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-190.421,8.532,238.69,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6227\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4227\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",34.65],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",37.35],PARAMETER[\"scale_factor\",0.9996256],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",300000],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22");
    add_srs_wkt (p, 13,
        "770\"]]");
    p = add_epsg_def (filter, first, last, 22780, "epsg", 22780,
        "Deir ez Zor / Levant Stereographic");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=34.2 +lon_0=39.15 +k=0.9995341 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532");
    add_proj4text (p, 2,
        ",238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Levant Stereographic\",GEOGCS[\"D");
    add_srs_wkt (p, 1,
        "eir ez Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 2,
        "0 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7011\"]],TOWGS84[-190.421,8.532,238.69,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6227\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4227");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",34.2],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",39.15],PARAMETER[\"scale_factor\",0.9995341],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22780\"]]");
    p = add_epsg_def (filter, first, last, 22832, "epsg", 22832,
        "Douala / UTM zone 32N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Douala / UTM zone 32N (deprecated)\",GEOGCS[\"D");
    add_srs_wkt (p, 1,
        "ouala\",DATUM[\"Douala\",SPHEROID[\"Clarke 1880 (IGN)\",");
    add_srs_wkt (p, 2,
        "6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6228\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4228\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "22832\"]]");
    p = add_epsg_def (filter, first, last, 22991, "epsg", 22991,
        "Egypt 1907 / Blue Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=35 +k=1 +x_0=300000 +y_0=11");
    add_proj4text (p, 1,
        "00000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Blue Belt\",GEOGCS[\"Egypt 1907\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,2");
    add_srs_wkt (p, 2,
        "98.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-130,110,-13,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",30],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",35],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",300000],PARAMETER[\"false_northing\",110");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"22991\"]]");
    p = add_epsg_def (filter, first, last, 22992, "epsg", 22992,
        "Egypt 1907 / Red Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=81");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Red Belt\",GEOGCS[\"Egypt 1907\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,29");
    add_srs_wkt (p, 2,
        "8.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-130,110,-13,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",30],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",31],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",615000],PARAMETER[\"false_northing\",810");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"22992\"]]");
    p = add_epsg_def (filter, first, last, 22993, "epsg", 22993,
        "Egypt 1907 / Purple Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=20");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Purple Belt\",GEOGCS[\"Egypt 1907\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,");
    add_srs_wkt (p, 2,
        "298.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-130,110,-13");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",700000],PARAMETER[\"false_northing\",2");
    add_srs_wkt (p, 10,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"22993\"]]");
    p = add_epsg_def (filter, first, last, 22994, "epsg", 22994,
        "Egypt 1907 / Extended Purple Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=12");
    add_proj4text (p, 1,
        "00000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Extended Purple Belt\",GEOGCS[\"Eg");
    add_srs_wkt (p, 1,
        "ypt 1907\",DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\"");
    add_srs_wkt (p, 2,
        ",6378200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-13");
    add_srs_wkt (p, 3,
        "0,110,-13,0,0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",27],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",700000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",1200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"22994\"]]");
    p = add_epsg_def (filter, first, last, 23028, "epsg", 23028,
        "ED50 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 28N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-15],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23028\"]]");
    p = add_epsg_def (filter, first, last, 23029, "epsg", 23029,
        "ED50 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 29N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-9],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23029\"]]");
    p = add_epsg_def (filter, first, last, 23030, "epsg", 23030,
        "ED50 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 30N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-3],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23030\"]]");
    p = add_epsg_def (filter, first, last, 23031, "epsg", 23031,
        "ED50 / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 31N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",3],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"23031\"]]");
    p = add_epsg_def (filter, first, last, 23032, "epsg", 23032,
        "ED50 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 32N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",9],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"23032\"]]");
    p = add_epsg_def (filter, first, last, 23033, "epsg", 23033,
        "ED50 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 33N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",15],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23033\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

