-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Ada.Text_IO;

package Wrap is
   --  Copies SimpLine to the given File, wrapping the output
   --  at or near 80 columns, splitting onto multiple lines
   --  as needed.  A line may be wrapped at any of the following
   --  characters: ' ', '(', ')', '[', or ']'
   procedure CopyAndMaybeWrapLine (File     : in Ada.Text_IO.File_Type;
                                   SimpLine : in String);

end Wrap;
