3.4 Opakowane Sample

# Opakowane Sample

Korzystając z obwiedni ADSR możliwa jest również modyfikacja *czasu trwania* 
oraz *amplitudy* sampli. Jednakże działanie jest w tym przypadku trochę 
inne niż w przypadku syntezatorów. Obwiednie sampli pozwalają Ci tylko 
na zmniejszanie amplitudy oraz czasu trwania sampla - natomiast nigdy 
nie jest możliwe zwiększanie wartości tych parametrów. Sampel przestanie 
grać gdy się skończy lub gdy zakończy się obwiednia - obojętne co skończy 
się szybciej. Jeśli więc użyjesz bardzo długiego parametru `release:`, 
to nie spowoduje to, że wydłuży się czas odtwarzania sampla.

## Obwiednie Amen

Wróćmy do naszego sprawdzonego kolegi Amen Break:

```
sample :loop_amen
```

Bez podawania żadnych parametrów słyszymy całego sampla na pełnej 
głośności. Jeśli chcemy aby dźwięk pojawiał się stopniowo przez 
1 sekundę możemy użyć parametru `attack:`:

```
sample :loop_amen, attack: 1
```

Jeśli chcemy aby wejście trwało krócej wystarczy, że użyjemy krótszej 
wartości dla fazy ataku:

```
sample :loop_amen, attack: 0.3
```

## Automatyczne Podtrzymanie (Auto Sustain)

Miejsce, w kórym zachowanie obwiedni ADSR dla sampli różni się od obwiedni 
dla syntezatorów jest wartość parametru *sustain*. Domyśnie w obwiedni 
syntezatorów, parametr fazy podtrzymania domyślnie otrzymuje wartość 0, 
o ile nie zmienimy jej ręcznie. W przypadku sampli, faza podtrzymania 
domyślnie otrzymuje wartość *automagiczną* - czas potrzebny na odtworzenie 
pozostałej części sampla. Jest to właśnie przyczyną dla której słyszymy 
całego sampla kiedy nie ustawimy żadnej wartości dla fazy podtrzymania. 
Jeśli domyślne wartości dla parametrów ataku, opadania, podtrzymania 
i zanikania były ustawione na 0 nigdy nie usłyszelibyśmy nawet jednego 
piknięcia. Sonic Pi sam oblicza jak długi jest czas trwania sampla, 
obcina fazy ataku, opadania oraz zanikania i używa wyniku jako czasu 
dla fazy podtrzymania. Jeśli wartości podane dla ataku, opadania lub zanikania 
po zsumowaniu dają wartość większą od czasu trwania sampla, to faza 
podtrzymania otrzymuje po prostu wartość 0.

## Płynne Zanikanie (Fade Outs)

Aby to zbadać, przyjrzyjmy się bardziej szczegółowo naszej pętli Amen Loop. 
Jeśli zapytamy Sonic Pi o to jak długo trwa ten sampel:

```
print sample_duration :loop_amen
```

To wyświetli liczbę `1.753310657596372` i jest ona długością sampla wyrażoną 
w sekundach. Dla wygody zaogrąglijmy ją tutaj do wartości `1.75`. Teraz, 
jeśli ustawimy fazę zanikania (release) na wartość `0.75` to wydarzy się 
coś niespodziewanego: 

```
sample :loop_amen, release: 0.75
```

Pierwsza sekunda sampla zostanie zagrana z pełną amplitudą po czym zacznie 
stopniowo zanikać przez okres 0.75 sekundy. To jest właśnie *auto sustain* 
w akcji (automatyczne ustawianie czasu trwania dla fazy podtrzymania). 
Domyślnie, faza zanikania (release) zawsze działa (jest ustawiana) od końca 
sampla. Jeśli nasz sample trwałby 10.75 sekundy, to najpierw pierwszye 
10 sekund zostałoby zagrane z pełną amplitudą, po czym zaczęłoby się 
stopniowe zanikanie (fade out), trwające przez 0.75s.

Zapamiętaj: domyślnie, faza zanikania (`release:`) wchodzi pod koniec 
sampla.

## Wejście i Wyjście (Fade In i Fade Out)

Możemy używać jednocześnie parametrów dla ustawiania fazy ataku `attack:` 
oraz fazy zanikania `release:` z wykorzystaniem automatycznego ustawiania 
fazy podtrzymania (sustain) aby użyć stopniowego pojawienia się i stopniowego 
zanikania przez cały czas trwania sampla: 

```
sample :loop_amen, attack: 0.75, release: 0.75
```

Jako, że pełny czas trwania naszego sampla to 1.75s, a nasze fazy ataku 
i zanikania dają w sumie 1.5 s, to czas trwania fazy podtrzymania (sustain) 
automagicznie ustawia się na wartość 0.25s. Pozwala nam to na łatwe tworzenie 
łagodnych wejść i wyjść w samplach.

## Sprecyzowana faza podtrzymania (sustain)

Możemy bardzo łatwo przywrócić normalne zachowanie ADSR znane z syntezatorów 
poprze manualne ustawienie wartości parametru `sustain:` na wartość 0:

We can easily get back to our normal synth ADSR behaviour by manually
setting `sustain:` to a value such as 0:

```
sample :loop_amen, sustain: 0, release: 0.75
```

Teraz nasz sampel zostanie zagrany tylko przez 0.75 sekundy w sumie. 
Używająć domyślnych wartości dla parametrów ataku `attack:` i opadania 
`decay:` na poziomie 0, sampel przeskakuje bezpośrednio do pełnej amplitudy, 
przechodzi w fazę podtrzymania na 0s po czym zanika z powrotem do 
amplitudy równej zero przy czym czas zanikania to 0.75s.

## Talerze perkusyjne

Możemy wykorzystać to zachowania aby uzyskać dobry efekt sprawiając, że 
sample trwające dłużej będą krótsze, bardziej perkusyjne. Przyjrzyjmy 
się samplowi `:drum_cymbal_open`: 

```
sample :drum_cymbal_open
```

Słyszysz dźwięk talerza, który brzmi przez chwilę. Możemy jednak 
skorzystać z naszej obwiedni aby sprawić by ten dźwięk stał się bardziej 
perkusyjny: 

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0, release: 0.1
```

Następnie możesz spróbować zasymulować uderzenie w talerz i stłumienie go 
poprzez zwiększenie wartości parametru podtrzymania: 

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0.3, release: 0.1
```

A teraz spróbuj się pobawić nakładająć obwiednie na sample. Próbuj zmieniać 
wartości różnych parametrów obwiedni aby otrzymać ciekawe rezultaty.
