#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Sun Mar 23 02:03:52 2014 by generateDS.py version 2.12b.
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = list(range(3))
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, str) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, str) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class pluginDef(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, plugin=None, valueOf_=None):
        self.plugin = _cast(None, plugin)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if pluginDef.subclass:
            return pluginDef.subclass(*args_, **kwargs_)
        else:
            return pluginDef(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_plugin(self): return self.plugin
    def set_plugin(self, plugin): self.plugin = plugin
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_pluginType(self, value):
        # Validate type pluginType, a restriction on xsd:string.
        pass
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pluginDef', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pluginDef')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pluginDef', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pluginDef'):
        if self.plugin is not None and 'plugin' not in already_processed:
            already_processed.add('plugin')
            outfile.write(' plugin=%s' % (quote_attrib(self.plugin), ))
    def exportChildren(self, outfile, level, namespace_='', name_='pluginDef', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='pluginDef'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.plugin is not None and 'plugin' not in already_processed:
            already_processed.add('plugin')
            showIndent(outfile, level)
            outfile.write('plugin="%s",\n' % (self.plugin,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('plugin', node)
        if value is not None and 'plugin' not in already_processed:
            already_processed.add('plugin')
            self.plugin = value
            self.validate_pluginType(self.plugin)    # validate type pluginType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class pluginDef


class emptyType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, all=None):
        self.all = _cast(float, all)
        pass
    def factory(*args_, **kwargs_):
        if emptyType.subclass:
            return emptyType.subclass(*args_, **kwargs_)
        else:
            return emptyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_all(self): return self.all
    def set_all(self, all): self.all = all
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='emptyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='emptyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='emptyType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='emptyType'):
        if self.all is not None and 'all' not in already_processed:
            already_processed.add('all')
            outfile.write(' all="%s"' % self.gds_format_double(self.all, input_name='all'))
    def exportChildren(self, outfile, level, namespace_='', name_='emptyType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='emptyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.all is not None and 'all' not in already_processed:
            already_processed.add('all')
            showIndent(outfile, level)
            outfile.write('all=%e,\n' % (self.all,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('all', node)
        if value is not None and 'all' not in already_processed:
            already_processed.add('all')
            try:
                self.all = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (all): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class emptyType


class vector(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vectorSize=1, vectorFile=None, all=False, vectorPlugin=None, valueOf_=None):
        self.vectorSize = _cast(int, vectorSize)
        self.vectorFile = _cast(None, vectorFile)
        self.all = _cast(bool, all)
        self.vectorPlugin = _cast(None, vectorPlugin)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if vector.subclass:
            return vector.subclass(*args_, **kwargs_)
        else:
            return vector(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vectorSize(self): return self.vectorSize
    def set_vectorSize(self, vectorSize): self.vectorSize = vectorSize
    def get_vectorFile(self): return self.vectorFile
    def set_vectorFile(self, vectorFile): self.vectorFile = vectorFile
    def get_all(self): return self.all
    def set_all(self, all): self.all = all
    def get_vectorPlugin(self): return self.vectorPlugin
    def set_vectorPlugin(self, vectorPlugin): self.vectorPlugin = vectorPlugin
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_pluginType(self, value):
        # Validate type pluginType, a restriction on xsd:string.
        pass
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vector', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vector')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='vector', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vector'):
        if self.vectorSize is not None and 'vectorSize' not in already_processed:
            already_processed.add('vectorSize')
            outfile.write(' vectorSize="%s"' % self.gds_format_integer(self.vectorSize, input_name='vectorSize'))
        if self.vectorFile is not None and 'vectorFile' not in already_processed:
            already_processed.add('vectorFile')
            outfile.write(' vectorFile=%s' % (self.gds_format_string(quote_attrib(self.vectorFile).encode(ExternalEncoding), input_name='vectorFile'), ))
        if self.all is not None and 'all' not in already_processed:
            already_processed.add('all')
            outfile.write(' all="%s"' % self.gds_format_boolean(self.all, input_name='all'))
        if self.vectorPlugin is not None and 'vectorPlugin' not in already_processed:
            already_processed.add('vectorPlugin')
            outfile.write(' vectorPlugin=%s' % (quote_attrib(self.vectorPlugin), ))
    def exportChildren(self, outfile, level, namespace_='', name_='vector', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='vector'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vectorSize is not None and 'vectorSize' not in already_processed:
            already_processed.add('vectorSize')
            showIndent(outfile, level)
            outfile.write('vectorSize=%d,\n' % (self.vectorSize,))
        if self.vectorFile is not None and 'vectorFile' not in already_processed:
            already_processed.add('vectorFile')
            showIndent(outfile, level)
            outfile.write('vectorFile="%s",\n' % (self.vectorFile,))
        if self.all is not None and 'all' not in already_processed:
            already_processed.add('all')
            showIndent(outfile, level)
            outfile.write('all=%s,\n' % (self.all,))
        if self.vectorPlugin is not None and 'vectorPlugin' not in already_processed:
            already_processed.add('vectorPlugin')
            showIndent(outfile, level)
            outfile.write('vectorPlugin="%s",\n' % (self.vectorPlugin,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vectorSize', node)
        if value is not None and 'vectorSize' not in already_processed:
            already_processed.add('vectorSize')
            try:
                self.vectorSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.vectorSize < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('vectorFile', node)
        if value is not None and 'vectorFile' not in already_processed:
            already_processed.add('vectorFile')
            self.vectorFile = value
        value = find_attr_value_('all', node)
        if value is not None and 'all' not in already_processed:
            already_processed.add('all')
            if value in ('true', '1'):
                self.all = True
            elif value in ('false', '0'):
                self.all = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('vectorPlugin', node)
        if value is not None and 'vectorPlugin' not in already_processed:
            already_processed.add('vectorPlugin')
            self.vectorPlugin = value
            self.validate_pluginType(self.vectorPlugin)    # validate type pluginType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class vector


class matrix(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, matrixColSize=None, matrixFile=None, matrixPlugin=None, matrixRowSize=None, row=None):
        self.matrixColSize = _cast(int, matrixColSize)
        self.matrixFile = _cast(None, matrixFile)
        self.matrixPlugin = _cast(None, matrixPlugin)
        self.matrixRowSize = _cast(int, matrixRowSize)
        if row is None:
            self.row = []
        else:
            self.row = row
    def factory(*args_, **kwargs_):
        if matrix.subclass:
            return matrix.subclass(*args_, **kwargs_)
        else:
            return matrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_matrixColSize(self): return self.matrixColSize
    def set_matrixColSize(self, matrixColSize): self.matrixColSize = matrixColSize
    def get_matrixFile(self): return self.matrixFile
    def set_matrixFile(self, matrixFile): self.matrixFile = matrixFile
    def get_matrixPlugin(self): return self.matrixPlugin
    def set_matrixPlugin(self, matrixPlugin): self.matrixPlugin = matrixPlugin
    def get_matrixRowSize(self): return self.matrixRowSize
    def set_matrixRowSize(self, matrixRowSize): self.matrixRowSize = matrixRowSize
    def validate_doubleList(self, value):
        # Validate type doubleList, a restriction on xsd:double.
        pass
    def validate_pluginType(self, value):
        # Validate type pluginType, a restriction on xsd:string.
        pass
    def hasContent_(self):
        if (
            self.row
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='matrix', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='matrix')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='matrix', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='matrix'):
        if self.matrixColSize is not None and 'matrixColSize' not in already_processed:
            already_processed.add('matrixColSize')
            outfile.write(' matrixColSize="%s"' % self.gds_format_integer(self.matrixColSize, input_name='matrixColSize'))
        if self.matrixFile is not None and 'matrixFile' not in already_processed:
            already_processed.add('matrixFile')
            outfile.write(' matrixFile=%s' % (self.gds_format_string(quote_attrib(self.matrixFile).encode(ExternalEncoding), input_name='matrixFile'), ))
        if self.matrixPlugin is not None and 'matrixPlugin' not in already_processed:
            already_processed.add('matrixPlugin')
            outfile.write(' matrixPlugin=%s' % (quote_attrib(self.matrixPlugin), ))
        if self.matrixRowSize is not None and 'matrixRowSize' not in already_processed:
            already_processed.add('matrixRowSize')
            outfile.write(' matrixRowSize="%s"' % self.gds_format_integer(self.matrixRowSize, input_name='matrixRowSize'))
    def exportChildren(self, outfile, level, namespace_='', name_='matrix', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for row_ in self.row:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srow>%s</%srow>%s' % (namespace_, self.gds_format_double_list(row_, input_name='row'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='matrix'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.matrixColSize is not None and 'matrixColSize' not in already_processed:
            already_processed.add('matrixColSize')
            showIndent(outfile, level)
            outfile.write('matrixColSize=%d,\n' % (self.matrixColSize,))
        if self.matrixFile is not None and 'matrixFile' not in already_processed:
            already_processed.add('matrixFile')
            showIndent(outfile, level)
            outfile.write('matrixFile="%s",\n' % (self.matrixFile,))
        if self.matrixPlugin is not None and 'matrixPlugin' not in already_processed:
            already_processed.add('matrixPlugin')
            showIndent(outfile, level)
            outfile.write('matrixPlugin="%s",\n' % (self.matrixPlugin,))
        if self.matrixRowSize is not None and 'matrixRowSize' not in already_processed:
            already_processed.add('matrixRowSize')
            showIndent(outfile, level)
            outfile.write('matrixRowSize=%d,\n' % (self.matrixRowSize,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('%e,\n' % row_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('matrixColSize', node)
        if value is not None and 'matrixColSize' not in already_processed:
            already_processed.add('matrixColSize')
            try:
                self.matrixColSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.matrixColSize < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('matrixFile', node)
        if value is not None and 'matrixFile' not in already_processed:
            already_processed.add('matrixFile')
            self.matrixFile = value
        value = find_attr_value_('matrixPlugin', node)
        if value is not None and 'matrixPlugin' not in already_processed:
            already_processed.add('matrixPlugin')
            self.matrixPlugin = value
            self.validate_pluginType(self.matrixPlugin)    # validate type pluginType
        value = find_attr_value_('matrixRowSize', node)
        if value is not None and 'matrixRowSize' not in already_processed:
            already_processed.add('matrixRowSize')
            try:
                self.matrixRowSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.matrixRowSize < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            row_ = child_.text
            row_ = self.gds_validate_double_list(row_, node, 'row')
            self.row.append(row_.split())
            self.row = self.row
            self.validate_doubleList(self.row)    # validate type doubleList
# end class matrix


class listOfMatrices(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, number=None, matrix=None):
        self.number = _cast(int, number)
        if matrix is None:
            self.matrix = []
        else:
            self.matrix = matrix
    def factory(*args_, **kwargs_):
        if listOfMatrices.subclass:
            return listOfMatrices.subclass(*args_, **kwargs_)
        else:
            return listOfMatrices(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def add_matrix(self, value): self.matrix.append(value)
    def insert_matrix(self, index, value): self.matrix[index] = value
    def get_number(self): return self.number
    def set_number(self, number): self.number = number
    def hasContent_(self):
        if (
            self.matrix
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='listOfMatrices', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='listOfMatrices')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='listOfMatrices', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='listOfMatrices'):
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            outfile.write(' number="%s"' % self.gds_format_integer(self.number, input_name='number'))
    def exportChildren(self, outfile, level, namespace_='', name_='listOfMatrices', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for matrix_ in self.matrix:
            matrix_.export(outfile, level, namespace_, name_='matrix', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='listOfMatrices'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            showIndent(outfile, level)
            outfile.write('number=%d,\n' % (self.number,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('matrix=[\n')
        level += 1
        for matrix_ in self.matrix:
            showIndent(outfile, level)
            outfile.write('model_.matrix(\n')
            matrix_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.add('number')
            try:
                self.number = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.number < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'matrix':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.matrix.append(obj_)
# end class listOfMatrices


class matrixData(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, matrixColSize=None, matrixRowSize=None, row=None):
        self.matrixColSize = _cast(int, matrixColSize)
        self.matrixRowSize = _cast(int, matrixRowSize)
        if row is None:
            self.row = []
        else:
            self.row = row
    def factory(*args_, **kwargs_):
        if matrixData.subclass:
            return matrixData.subclass(*args_, **kwargs_)
        else:
            return matrixData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_matrixColSize(self): return self.matrixColSize
    def set_matrixColSize(self, matrixColSize): self.matrixColSize = matrixColSize
    def get_matrixRowSize(self): return self.matrixRowSize
    def set_matrixRowSize(self, matrixRowSize): self.matrixRowSize = matrixRowSize
    def validate_doubleList(self, value):
        # Validate type doubleList, a restriction on xsd:double.
        pass
    def hasContent_(self):
        if (
            self.row
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='matrixData', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='matrixData')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='matrixData', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='matrixData'):
        if self.matrixColSize is not None and 'matrixColSize' not in already_processed:
            already_processed.add('matrixColSize')
            outfile.write(' matrixColSize="%s"' % self.gds_format_integer(self.matrixColSize, input_name='matrixColSize'))
        if self.matrixRowSize is not None and 'matrixRowSize' not in already_processed:
            already_processed.add('matrixRowSize')
            outfile.write(' matrixRowSize="%s"' % self.gds_format_integer(self.matrixRowSize, input_name='matrixRowSize'))
    def exportChildren(self, outfile, level, namespace_='', name_='matrixData', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for row_ in self.row:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srow>%s</%srow>%s' % (namespace_, self.gds_format_double_list(row_, input_name='row'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='matrixData'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.matrixColSize is not None and 'matrixColSize' not in already_processed:
            already_processed.add('matrixColSize')
            showIndent(outfile, level)
            outfile.write('matrixColSize=%d,\n' % (self.matrixColSize,))
        if self.matrixRowSize is not None and 'matrixRowSize' not in already_processed:
            already_processed.add('matrixRowSize')
            showIndent(outfile, level)
            outfile.write('matrixRowSize=%d,\n' % (self.matrixRowSize,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('%e,\n' % row_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('matrixColSize', node)
        if value is not None and 'matrixColSize' not in already_processed:
            already_processed.add('matrixColSize')
            try:
                self.matrixColSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.matrixColSize < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('matrixRowSize', node)
        if value is not None and 'matrixRowSize' not in already_processed:
            already_processed.add('matrixRowSize')
            try:
                self.matrixRowSize = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.matrixRowSize < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            row_ = child_.text
            row_ = self.gds_validate_double_list(row_, node, 'row')
            self.row.append(row_)
            self.row = self.row.split()
            self.validate_doubleList(self.row)    # validate type doubleList
# end class matrixData


class matrixPlugin(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, matrixPlugin=None):
        self.matrixPlugin = _cast(None, matrixPlugin)
        pass
    def factory(*args_, **kwargs_):
        if matrixPlugin.subclass:
            return matrixPlugin.subclass(*args_, **kwargs_)
        else:
            return matrixPlugin(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_matrixPlugin(self): return self.matrixPlugin
    def set_matrixPlugin(self, matrixPlugin): self.matrixPlugin = matrixPlugin
    def validate_pluginType(self, value):
        # Validate type pluginType, a restriction on xsd:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='matrixPlugin', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='matrixPlugin')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='matrixPlugin', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='matrixPlugin'):
        if self.matrixPlugin is not None and 'matrixPlugin' not in already_processed:
            already_processed.add('matrixPlugin')
            outfile.write(' matrixPlugin=%s' % (quote_attrib(self.matrixPlugin), ))
    def exportChildren(self, outfile, level, namespace_='', name_='matrixPlugin', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='matrixPlugin'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.matrixPlugin is not None and 'matrixPlugin' not in already_processed:
            already_processed.add('matrixPlugin')
            showIndent(outfile, level)
            outfile.write('matrixPlugin="%s",\n' % (self.matrixPlugin,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('matrixPlugin', node)
        if value is not None and 'matrixPlugin' not in already_processed:
            already_processed.add('matrixPlugin')
            self.matrixPlugin = value
            self.validate_pluginType(self.matrixPlugin)    # validate type pluginType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class matrixPlugin


class matrixFile(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, matrixFile=None):
        self.matrixFile = _cast(None, matrixFile)
        pass
    def factory(*args_, **kwargs_):
        if matrixFile.subclass:
            return matrixFile.subclass(*args_, **kwargs_)
        else:
            return matrixFile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_matrixFile(self): return self.matrixFile
    def set_matrixFile(self, matrixFile): self.matrixFile = matrixFile
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='matrixFile', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='matrixFile')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='matrixFile', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='matrixFile'):
        if self.matrixFile is not None and 'matrixFile' not in already_processed:
            already_processed.add('matrixFile')
            outfile.write(' matrixFile=%s' % (self.gds_format_string(quote_attrib(self.matrixFile).encode(ExternalEncoding), input_name='matrixFile'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='matrixFile', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='matrixFile'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.matrixFile is not None and 'matrixFile' not in already_processed:
            already_processed.add('matrixFile')
            showIndent(outfile, level)
            outfile.write('matrixFile="%s",\n' % (self.matrixFile,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('matrixFile', node)
        if value is not None and 'matrixFile' not in already_processed:
            already_processed.add('matrixFile')
            self.matrixFile = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class matrixFile


class OSI(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DS_Concerned=None, Interactions_Concerned=None, extensiontype_=None):
        self.DS_Concerned = DS_Concerned
        self.Interactions_Concerned = Interactions_Concerned
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if OSI.subclass:
            return OSI.subclass(*args_, **kwargs_)
        else:
            return OSI(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DS_Concerned(self): return self.DS_Concerned
    def set_DS_Concerned(self, DS_Concerned): self.DS_Concerned = DS_Concerned
    def get_Interactions_Concerned(self): return self.Interactions_Concerned
    def set_Interactions_Concerned(self, Interactions_Concerned): self.Interactions_Concerned = Interactions_Concerned
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_strList(self, value):
        # Validate type strList, a restriction on xsd:string.
        pass
    def hasContent_(self):
        if (
            self.DS_Concerned is not None or
            self.Interactions_Concerned is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OSI', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OSI')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OSI', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OSI'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OSI', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DS_Concerned is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDS_Concerned>%s</%sDS_Concerned>%s' % (namespace_, self.gds_format_string(quote_xml(' '.join(self.DS_Concerned)).encode(ExternalEncoding), input_name='DS_Concerned'), namespace_, eol_))
        if self.Interactions_Concerned is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInteractions_Concerned>%s</%sInteractions_Concerned>%s' % (namespace_, self.gds_format_string(quote_xml(' '.join(self.Interactions_Concerned)).encode(ExternalEncoding), input_name='Interactions_Concerned'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='OSI'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DS_Concerned is not None:
            showIndent(outfile, level)
            if self.DS_Concerned:
                outfile.write('DS_Concerned=%s,\n' % quote_python(' '.join(self.DS_Concerned)).encode(ExternalEncoding))
            else:
                outfile.write('DS_Concerned=None,\n')
        if self.Interactions_Concerned is not None:
            showIndent(outfile, level)
            if self.Interactions_Concerned:
                outfile.write('Interactions_Concerned=%s,\n' % quote_python(' '.join(self.Interactions_Concerned)).encode(ExternalEncoding))
            else:
                outfile.write('Interactions_Concerned=None,\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DS_Concerned':
            DS_Concerned_ = child_.text
            self.DS_Concerned = DS_Concerned_
            self.DS_Concerned = self.DS_Concerned.split()
            self.validate_strList(self.DS_Concerned)    # validate type strList
        elif nodeName_ == 'Interactions_Concerned':
            Interactions_Concerned_ = child_.text
            self.Interactions_Concerned = Interactions_Concerned_
            self.Interactions_Concerned = self.Interactions_Concerned.split()
            self.validate_strList(self.Interactions_Concerned)    # validate type strList
# end class OSI


class NSL(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, size=None, extensiontype_=None):
        self.size = _cast(int, size)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if NSL.subclass:
            return NSL.subclass(*args_, **kwargs_)
        else:
            return NSL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NSL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NSL')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NSL', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NSL'):
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size="%s"' % self.gds_format_integer(self.size, input_name='size'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='NSL', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='NSL'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % (self.size,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            try:
                self.size = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.size <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class NSL


class OSNSP(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, StorageType=None, Id=None, NonSmoothSolver=None, extensiontype_=None):
        self.StorageType = _cast(int, StorageType)
        self.Id = _cast(None, Id)
        self.NonSmoothSolver = NonSmoothSolver
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if OSNSP.subclass:
            return OSNSP.subclass(*args_, **kwargs_)
        else:
            return OSNSP(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_NonSmoothSolver(self): return self.NonSmoothSolver
    def set_NonSmoothSolver(self, NonSmoothSolver): self.NonSmoothSolver = NonSmoothSolver
    def get_StorageType(self): return self.StorageType
    def set_StorageType(self, StorageType): self.StorageType = StorageType
    def get_Id(self): return self.Id
    def set_Id(self, Id): self.Id = Id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.NonSmoothSolver is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OSNSP', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OSNSP')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OSNSP', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OSNSP'):
        if self.StorageType is not None and 'StorageType' not in already_processed:
            already_processed.add('StorageType')
            outfile.write(' StorageType="%s"' % self.gds_format_integer(self.StorageType, input_name='StorageType'))
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            outfile.write(' Id=%s' % (self.gds_format_string(quote_attrib(self.Id).encode(ExternalEncoding), input_name='Id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='OSNSP', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.NonSmoothSolver is not None:
            self.NonSmoothSolver.export(outfile, level, namespace_, name_='NonSmoothSolver', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OSNSP'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.StorageType is not None and 'StorageType' not in already_processed:
            already_processed.add('StorageType')
            showIndent(outfile, level)
            outfile.write('StorageType=%d,\n' % (self.StorageType,))
        if self.Id is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            showIndent(outfile, level)
            outfile.write('Id="%s",\n' % (self.Id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.NonSmoothSolver is not None:
            showIndent(outfile, level)
            outfile.write('NonSmoothSolver=model_.NonSmoothSolver(\n')
            self.NonSmoothSolver.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('StorageType', node)
        if value is not None and 'StorageType' not in already_processed:
            already_processed.add('StorageType')
            try:
                self.StorageType = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.StorageType < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('Id', node)
        if value is not None and 'Id' not in already_processed:
            already_processed.add('Id')
            self.Id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'NonSmoothSolver':
            obj_ = NonSmoothSolver.factory()
            obj_.build(child_)
            self.NonSmoothSolver = obj_
# end class OSNSP


class ModelTime(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, t0=None, T=None):
        self.t0 = t0
        self.T = T
    def factory(*args_, **kwargs_):
        if ModelTime.subclass:
            return ModelTime.subclass(*args_, **kwargs_)
        else:
            return ModelTime(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_t0(self): return self.t0
    def set_t0(self, t0): self.t0 = t0
    def get_T(self): return self.T
    def set_T(self, T): self.T = T
    def validate_positiveDouble(self, value):
        # Validate type positiveDouble, a restriction on xsd:double.
        pass
    def hasContent_(self):
        if (
            self.t0 is not None or
            self.T is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ModelTime', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ModelTime')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ModelTime', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ModelTime'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ModelTime', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.t0 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%st0>%s</%st0>%s' % (namespace_, self.gds_format_double(self.t0, input_name='t0'), namespace_, eol_))
        if self.T is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sT>%s</%sT>%s' % (namespace_, self.gds_format_double(self.T, input_name='T'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ModelTime'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.t0 is not None:
            showIndent(outfile, level)
            outfile.write('t0=%e,\n' % self.t0)
        if self.T is not None:
            showIndent(outfile, level)
            outfile.write('T=%e,\n' % self.T)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 't0':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 't0')
            self.t0 = fval_
            self.validate_positiveDouble(self.t0)    # validate type positiveDouble
        elif nodeName_ == 'T':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'T')
            self.T = fval_
            self.validate_positiveDouble(self.T)    # validate type positiveDouble
# end class ModelTime


class BoundaryCondition(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Linear=None, NLinear=None, Periodic=None):
        self.Linear = Linear
        self.NLinear = NLinear
        self.Periodic = Periodic
    def factory(*args_, **kwargs_):
        if BoundaryCondition.subclass:
            return BoundaryCondition.subclass(*args_, **kwargs_)
        else:
            return BoundaryCondition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Linear(self): return self.Linear
    def set_Linear(self, Linear): self.Linear = Linear
    def get_NLinear(self): return self.NLinear
    def set_NLinear(self, NLinear): self.NLinear = NLinear
    def get_Periodic(self): return self.Periodic
    def set_Periodic(self, Periodic): self.Periodic = Periodic
    def hasContent_(self):
        if (
            self.Linear is not None or
            self.NLinear is not None or
            self.Periodic is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BoundaryCondition', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BoundaryCondition')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BoundaryCondition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BoundaryCondition'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BoundaryCondition', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Linear is not None:
            self.Linear.export(outfile, level, namespace_, name_='Linear', pretty_print=pretty_print)
        if self.NLinear is not None:
            self.NLinear.export(outfile, level, namespace_, name_='NLinear', pretty_print=pretty_print)
        if self.Periodic is not None:
            self.Periodic.export(outfile, level, namespace_, name_='Periodic', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BoundaryCondition'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Linear is not None:
            showIndent(outfile, level)
            outfile.write('Linear=model_.LinearType(\n')
            self.Linear.exportLiteral(outfile, level, name_='Linear')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.NLinear is not None:
            showIndent(outfile, level)
            outfile.write('NLinear=model_.NLinearType(\n')
            self.NLinear.exportLiteral(outfile, level, name_='NLinear')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Periodic is not None:
            showIndent(outfile, level)
            outfile.write('Periodic=model_.PeriodicType(\n')
            self.Periodic.exportLiteral(outfile, level, name_='Periodic')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Linear':
            obj_ = LinearType.factory()
            obj_.build(child_)
            self.Linear = obj_
        elif nodeName_ == 'NLinear':
            obj_ = NLinearType.factory()
            obj_.build(child_)
            self.NLinear = obj_
        elif nodeName_ == 'Periodic':
            obj_ = PeriodicType.factory()
            obj_.build(child_)
            self.Periodic = obj_
# end class BoundaryCondition


class NonSmoothSolver(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, iparam=None, dparam=None):
        self.Name = _cast(None, Name)
        self.iparam = iparam
        self.dparam = dparam
    def factory(*args_, **kwargs_):
        if NonSmoothSolver.subclass:
            return NonSmoothSolver.subclass(*args_, **kwargs_)
        else:
            return NonSmoothSolver(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_iparam(self): return self.iparam
    def set_iparam(self, iparam): self.iparam = iparam
    def get_dparam(self): return self.dparam
    def set_dparam(self, dparam): self.dparam = dparam
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.iparam is not None or
            self.dparam is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NonSmoothSolver', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NonSmoothSolver')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NonSmoothSolver', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NonSmoothSolver'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='NonSmoothSolver', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.iparam is not None:
            self.iparam.export(outfile, level, namespace_, name_='iparam', pretty_print=pretty_print)
        if self.dparam is not None:
            self.dparam.export(outfile, level, namespace_, name_='dparam', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NonSmoothSolver'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            showIndent(outfile, level)
            outfile.write('Name="%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.iparam is not None:
            showIndent(outfile, level)
            outfile.write('iparam=model_.vector(\n')
            self.iparam.exportLiteral(outfile, level, name_='iparam')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dparam is not None:
            showIndent(outfile, level)
            outfile.write('dparam=model_.vector(\n')
            self.dparam.exportLiteral(outfile, level, name_='dparam')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'iparam':
            obj_ = vector.factory()
            obj_.build(child_)
            self.iparam = obj_
        elif nodeName_ == 'dparam':
            obj_ = vector.factory()
            obj_.build(child_)
            self.dparam = obj_
# end class NonSmoothSolver


class index_list(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, all='false', indexList=None):
        self.all = _cast(None, all)
        if indexList is None:
            self.indexList = []
        else:
            self.indexList = indexList
    def factory(*args_, **kwargs_):
        if index_list.subclass:
            return index_list.subclass(*args_, **kwargs_)
        else:
            return index_list(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_indexList(self): return self.indexList
    def set_indexList(self, indexList): self.indexList = indexList
    def add_indexList(self, value): self.indexList.append(value)
    def insert_indexList(self, index, value): self.indexList[index] = value
    def get_all(self): return self.all
    def set_all(self, all): self.all = all
    def validate_boolean(self, value):
        # Validate type boolean, a restriction on xsd:boolean.
        pass
    def hasContent_(self):
        if (
            self.indexList
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='index_list', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='index_list')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='index_list', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='index_list'):
        if self.all is not None and 'all' not in already_processed:
            already_processed.add('all')
            outfile.write(' all=%s' % (quote_attrib(self.all), ))
    def exportChildren(self, outfile, level, namespace_='', name_='index_list', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for indexList_ in self.indexList:
            indexList_.export(outfile, level, namespace_, name_='indexList', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='index_list'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.all is not None and 'all' not in already_processed:
            already_processed.add('all')
            showIndent(outfile, level)
            outfile.write('all=%s,\n' % (self.all,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('indexList=[\n')
        level += 1
        for indexList_ in self.indexList:
            showIndent(outfile, level)
            outfile.write('model_.vector(\n')
            indexList_.exportLiteral(outfile, level, name_='vector')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('all', node)
        if value is not None and 'all' not in already_processed:
            already_processed.add('all')
            if value in ('true', '1'):
                self.all = True
            elif value in ('false', '0'):
                self.all = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_boolean(self.all)    # validate type boolean
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'indexList':
            obj_ = vector.factory()
            obj_.build(child_)
            self.indexList.append(obj_)
# end class index_list


class SiconosModel(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Title=None, Author=None, Description=None, Date=None, SchemaXML=None, Time=None, NSDS=None, Simulation=None):
        self.Title = Title
        self.Author = Author
        self.Description = Description
        self.Date = Date
        self.SchemaXML = SchemaXML
        self.Time = Time
        self.NSDS = NSDS
        self.Simulation = Simulation
    def factory(*args_, **kwargs_):
        if SiconosModel.subclass:
            return SiconosModel.subclass(*args_, **kwargs_)
        else:
            return SiconosModel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def get_Author(self): return self.Author
    def set_Author(self, Author): self.Author = Author
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_SchemaXML(self): return self.SchemaXML
    def set_SchemaXML(self, SchemaXML): self.SchemaXML = SchemaXML
    def get_Time(self): return self.Time
    def set_Time(self, Time): self.Time = Time
    def get_NSDS(self): return self.NSDS
    def set_NSDS(self, NSDS): self.NSDS = NSDS
    def get_Simulation(self): return self.Simulation
    def set_Simulation(self, Simulation): self.Simulation = Simulation
    def hasContent_(self):
        if (
            self.Title is not None or
            self.Author is not None or
            self.Description is not None or
            self.Date is not None or
            self.SchemaXML is not None or
            self.Time is not None or
            self.NSDS is not None or
            self.Simulation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SiconosModel', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SiconosModel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SiconosModel', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SiconosModel'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SiconosModel', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTitle>%s</%sTitle>%s' % (namespace_, self.gds_format_string(quote_xml(self.Title).encode(ExternalEncoding), input_name='Title'), namespace_, eol_))
        if self.Author is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAuthor>%s</%sAuthor>%s' % (namespace_, self.gds_format_string(quote_xml(self.Author).encode(ExternalEncoding), input_name='Author'), namespace_, eol_))
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.Date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDate>%s</%sDate>%s' % (namespace_, self.gds_format_string(quote_xml(self.Date).encode(ExternalEncoding), input_name='Date'), namespace_, eol_))
        if self.SchemaXML is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSchemaXML>%s</%sSchemaXML>%s' % (namespace_, self.gds_format_string(quote_xml(self.SchemaXML).encode(ExternalEncoding), input_name='SchemaXML'), namespace_, eol_))
        if self.Time is not None:
            self.Time.export(outfile, level, namespace_, name_='Time', pretty_print=pretty_print)
        if self.NSDS is not None:
            self.NSDS.export(outfile, level, namespace_, name_='NSDS', pretty_print=pretty_print)
        if self.Simulation is not None:
            self.Simulation.export(outfile, level, namespace_, name_='Simulation', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SiconosModel'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Title is not None:
            showIndent(outfile, level)
            outfile.write('Title=%s,\n' % quote_python(self.Title).encode(ExternalEncoding))
        if self.Author is not None:
            showIndent(outfile, level)
            outfile.write('Author=%s,\n' % quote_python(self.Author).encode(ExternalEncoding))
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Date is not None:
            showIndent(outfile, level)
            outfile.write('Date=%s,\n' % quote_python(self.Date).encode(ExternalEncoding))
        if self.SchemaXML is not None:
            showIndent(outfile, level)
            outfile.write('SchemaXML=%s,\n' % quote_python(self.SchemaXML).encode(ExternalEncoding))
        if self.Time is not None:
            showIndent(outfile, level)
            outfile.write('Time=model_.ModelTime(\n')
            self.Time.exportLiteral(outfile, level, name_='Time')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.NSDS is not None:
            showIndent(outfile, level)
            outfile.write('NSDS=model_.NSDSType(\n')
            self.NSDS.exportLiteral(outfile, level, name_='NSDS')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Simulation is not None:
            showIndent(outfile, level)
            outfile.write('Simulation=model_.SimulationType(\n')
            self.Simulation.exportLiteral(outfile, level, name_='Simulation')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Author':
            Author_ = child_.text
            Author_ = self.gds_validate_string(Author_, node, 'Author')
            self.Author = Author_
        elif nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Date':
            Date_ = child_.text
            Date_ = self.gds_validate_string(Date_, node, 'Date')
            self.Date = Date_
        elif nodeName_ == 'SchemaXML':
            SchemaXML_ = child_.text
            SchemaXML_ = self.gds_validate_string(SchemaXML_, node, 'SchemaXML')
            self.SchemaXML = SchemaXML_
        elif nodeName_ == 'Time':
            obj_ = ModelTime.factory()
            obj_.build(child_)
            self.Time = obj_
        elif nodeName_ == 'NSDS':
            obj_ = NSDSType.factory()
            obj_.build(child_)
            self.NSDS = obj_
        elif nodeName_ == 'Simulation':
            obj_ = SimulationType.factory()
            obj_.build(child_)
            self.Simulation = obj_
# end class SiconosModel


class LinearType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Omega=None, Omega0=None, OmegaT=None):
        self.Omega = Omega
        self.Omega0 = Omega0
        self.OmegaT = OmegaT
    def factory(*args_, **kwargs_):
        if LinearType.subclass:
            return LinearType.subclass(*args_, **kwargs_)
        else:
            return LinearType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Omega(self): return self.Omega
    def set_Omega(self, Omega): self.Omega = Omega
    def get_Omega0(self): return self.Omega0
    def set_Omega0(self, Omega0): self.Omega0 = Omega0
    def get_OmegaT(self): return self.OmegaT
    def set_OmegaT(self, OmegaT): self.OmegaT = OmegaT
    def hasContent_(self):
        if (
            self.Omega is not None or
            self.Omega0 is not None or
            self.OmegaT is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinearType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinearType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LinearType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinearType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LinearType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Omega is not None:
            self.Omega.export(outfile, level, namespace_, name_='Omega', pretty_print=pretty_print)
        if self.Omega0 is not None:
            self.Omega0.export(outfile, level, namespace_, name_='Omega0', pretty_print=pretty_print)
        if self.OmegaT is not None:
            self.OmegaT.export(outfile, level, namespace_, name_='OmegaT', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LinearType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Omega is not None:
            showIndent(outfile, level)
            outfile.write('Omega=model_.vector(\n')
            self.Omega.exportLiteral(outfile, level, name_='Omega')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Omega0 is not None:
            showIndent(outfile, level)
            outfile.write('Omega0=model_.matrix(\n')
            self.Omega0.exportLiteral(outfile, level, name_='Omega0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OmegaT is not None:
            showIndent(outfile, level)
            outfile.write('OmegaT=model_.matrix(\n')
            self.OmegaT.exportLiteral(outfile, level, name_='OmegaT')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Omega':
            obj_ = vector.factory()
            obj_.build(child_)
            self.Omega = obj_
        elif nodeName_ == 'Omega0':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.Omega0 = obj_
        elif nodeName_ == 'OmegaT':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.OmegaT = obj_
# end class LinearType


class NLinearType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, empty1=None):
        self.empty1 = empty1
    def factory(*args_, **kwargs_):
        if NLinearType.subclass:
            return NLinearType.subclass(*args_, **kwargs_)
        else:
            return NLinearType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_empty1(self): return self.empty1
    def set_empty1(self, empty1): self.empty1 = empty1
    def validate_positiveDouble(self, value):
        # Validate type positiveDouble, a restriction on xsd:double.
        pass
    def hasContent_(self):
        if (
            self.empty1 is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NLinearType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NLinearType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NLinearType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NLinearType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='NLinearType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.empty1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sempty1>%s</%sempty1>%s' % (namespace_, self.gds_format_double(self.empty1, input_name='empty1'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NLinearType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.empty1 is not None:
            showIndent(outfile, level)
            outfile.write('empty1=%e,\n' % self.empty1)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'empty1':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'empty1')
            self.empty1 = fval_
            self.validate_positiveDouble(self.empty1)    # validate type positiveDouble
# end class NLinearType


class PeriodicType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, empty2=None):
        self.empty2 = empty2
    def factory(*args_, **kwargs_):
        if PeriodicType.subclass:
            return PeriodicType.subclass(*args_, **kwargs_)
        else:
            return PeriodicType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_empty2(self): return self.empty2
    def set_empty2(self, empty2): self.empty2 = empty2
    def validate_positiveDouble(self, value):
        # Validate type positiveDouble, a restriction on xsd:double.
        pass
    def hasContent_(self):
        if (
            self.empty2 is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PeriodicType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PeriodicType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PeriodicType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PeriodicType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='PeriodicType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.empty2 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sempty2>%s</%sempty2>%s' % (namespace_, self.gds_format_double(self.empty2, input_name='empty2'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='PeriodicType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.empty2 is not None:
            showIndent(outfile, level)
            outfile.write('empty2=%e,\n' % self.empty2)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'empty2':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'empty2')
            self.empty2 = fval_
            self.validate_positiveDouble(self.empty2)    # validate type positiveDouble
# end class PeriodicType


class NSDSType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, bvp=None, DS_LMGC90=None, DS_Definition=None, Interaction_Definition=None):
        self.bvp = _cast(None, bvp)
        self.DS_LMGC90 = DS_LMGC90
        self.DS_Definition = DS_Definition
        self.Interaction_Definition = Interaction_Definition
    def factory(*args_, **kwargs_):
        if NSDSType.subclass:
            return NSDSType.subclass(*args_, **kwargs_)
        else:
            return NSDSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DS_LMGC90(self): return self.DS_LMGC90
    def set_DS_LMGC90(self, DS_LMGC90): self.DS_LMGC90 = DS_LMGC90
    def get_DS_Definition(self): return self.DS_Definition
    def set_DS_Definition(self, DS_Definition): self.DS_Definition = DS_Definition
    def get_Interaction_Definition(self): return self.Interaction_Definition
    def set_Interaction_Definition(self, Interaction_Definition): self.Interaction_Definition = Interaction_Definition
    def get_bvp(self): return self.bvp
    def set_bvp(self, bvp): self.bvp = bvp
    def validate_boolean(self, value):
        # Validate type boolean, a restriction on xsd:boolean.
        pass
    def hasContent_(self):
        if (
            self.DS_LMGC90 is not None or
            self.DS_Definition is not None or
            self.Interaction_Definition is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NSDSType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NSDSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NSDSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NSDSType'):
        if self.bvp is not None and 'bvp' not in already_processed:
            already_processed.add('bvp')
            outfile.write(' bvp=%s' % (quote_attrib(self.bvp), ))
    def exportChildren(self, outfile, level, namespace_='', name_='NSDSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DS_LMGC90 is not None:
            self.DS_LMGC90.export(outfile, level, namespace_, name_='DS_LMGC90', pretty_print=pretty_print)
        if self.DS_Definition is not None:
            self.DS_Definition.export(outfile, level, namespace_, name_='DS_Definition', pretty_print=pretty_print)
        if self.Interaction_Definition is not None:
            self.Interaction_Definition.export(outfile, level, namespace_, name_='Interaction_Definition', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NSDSType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.bvp is not None and 'bvp' not in already_processed:
            already_processed.add('bvp')
            showIndent(outfile, level)
            outfile.write('bvp=%s,\n' % (self.bvp,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DS_LMGC90 is not None:
            showIndent(outfile, level)
            outfile.write('DS_LMGC90=model_.DS_LMGC90Type(\n')
            self.DS_LMGC90.exportLiteral(outfile, level, name_='DS_LMGC90')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.DS_Definition is not None:
            showIndent(outfile, level)
            outfile.write('DS_Definition=model_.DS_DefinitionType(\n')
            self.DS_Definition.exportLiteral(outfile, level, name_='DS_Definition')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Interaction_Definition is not None:
            showIndent(outfile, level)
            outfile.write('Interaction_Definition=model_.Interaction_DefinitionType(\n')
            self.Interaction_Definition.exportLiteral(outfile, level, name_='Interaction_Definition')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('bvp', node)
        if value is not None and 'bvp' not in already_processed:
            already_processed.add('bvp')
            if value in ('true', '1'):
                self.bvp = True
            elif value in ('false', '0'):
                self.bvp = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
            self.validate_boolean(self.bvp)    # validate type boolean
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DS_LMGC90':
            obj_ = DS_LMGC90Type.factory()
            obj_.build(child_)
            self.DS_LMGC90 = obj_
        elif nodeName_ == 'DS_Definition':
            obj_ = DS_DefinitionType.factory()
            obj_.build(child_)
            self.DS_Definition = obj_
        elif nodeName_ == 'Interaction_Definition':
            obj_ = Interaction_DefinitionType.factory()
            obj_.build(child_)
            self.Interaction_Definition = obj_
# end class NSDSType


class DS_LMGC90Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, empty=None):
        self.empty = empty
    def factory(*args_, **kwargs_):
        if DS_LMGC90Type.subclass:
            return DS_LMGC90Type.subclass(*args_, **kwargs_)
        else:
            return DS_LMGC90Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_empty(self): return self.empty
    def set_empty(self, empty): self.empty = empty
    def hasContent_(self):
        if (
            self.empty is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DS_LMGC90Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DS_LMGC90Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DS_LMGC90Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DS_LMGC90Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DS_LMGC90Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.empty is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sempty>%s</%sempty>%s' % (namespace_, self.gds_format_string(quote_xml(self.empty).encode(ExternalEncoding), input_name='empty'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='DS_LMGC90Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.empty is not None:
            showIndent(outfile, level)
            outfile.write('empty=%s,\n' % quote_python(self.empty).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'empty':
            empty_ = child_.text
            empty_ = self.gds_validate_string(empty_, node, 'empty')
            self.empty = empty_
# end class DS_LMGC90Type


class DS_DefinitionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, FirstOrderNonLinearDS=None, FirstOrderLinearDS=None, FirstOrderLinearTIDS=None, LagrangianDS=None, LagrangianLinearTIDS=None):
        if FirstOrderNonLinearDS is None:
            self.FirstOrderNonLinearDS = []
        else:
            self.FirstOrderNonLinearDS = FirstOrderNonLinearDS
        if FirstOrderLinearDS is None:
            self.FirstOrderLinearDS = []
        else:
            self.FirstOrderLinearDS = FirstOrderLinearDS
        if FirstOrderLinearTIDS is None:
            self.FirstOrderLinearTIDS = []
        else:
            self.FirstOrderLinearTIDS = FirstOrderLinearTIDS
        if LagrangianDS is None:
            self.LagrangianDS = []
        else:
            self.LagrangianDS = LagrangianDS
        if LagrangianLinearTIDS is None:
            self.LagrangianLinearTIDS = []
        else:
            self.LagrangianLinearTIDS = LagrangianLinearTIDS
    def factory(*args_, **kwargs_):
        if DS_DefinitionType.subclass:
            return DS_DefinitionType.subclass(*args_, **kwargs_)
        else:
            return DS_DefinitionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_FirstOrderNonLinearDS(self): return self.FirstOrderNonLinearDS
    def set_FirstOrderNonLinearDS(self, FirstOrderNonLinearDS): self.FirstOrderNonLinearDS = FirstOrderNonLinearDS
    def add_FirstOrderNonLinearDS(self, value): self.FirstOrderNonLinearDS.append(value)
    def insert_FirstOrderNonLinearDS(self, index, value): self.FirstOrderNonLinearDS[index] = value
    def get_FirstOrderLinearDS(self): return self.FirstOrderLinearDS
    def set_FirstOrderLinearDS(self, FirstOrderLinearDS): self.FirstOrderLinearDS = FirstOrderLinearDS
    def add_FirstOrderLinearDS(self, value): self.FirstOrderLinearDS.append(value)
    def insert_FirstOrderLinearDS(self, index, value): self.FirstOrderLinearDS[index] = value
    def get_FirstOrderLinearTIDS(self): return self.FirstOrderLinearTIDS
    def set_FirstOrderLinearTIDS(self, FirstOrderLinearTIDS): self.FirstOrderLinearTIDS = FirstOrderLinearTIDS
    def add_FirstOrderLinearTIDS(self, value): self.FirstOrderLinearTIDS.append(value)
    def insert_FirstOrderLinearTIDS(self, index, value): self.FirstOrderLinearTIDS[index] = value
    def get_LagrangianDS(self): return self.LagrangianDS
    def set_LagrangianDS(self, LagrangianDS): self.LagrangianDS = LagrangianDS
    def add_LagrangianDS(self, value): self.LagrangianDS.append(value)
    def insert_LagrangianDS(self, index, value): self.LagrangianDS[index] = value
    def get_LagrangianLinearTIDS(self): return self.LagrangianLinearTIDS
    def set_LagrangianLinearTIDS(self, LagrangianLinearTIDS): self.LagrangianLinearTIDS = LagrangianLinearTIDS
    def add_LagrangianLinearTIDS(self, value): self.LagrangianLinearTIDS.append(value)
    def insert_LagrangianLinearTIDS(self, index, value): self.LagrangianLinearTIDS[index] = value
    def hasContent_(self):
        if (
            self.FirstOrderNonLinearDS or
            self.FirstOrderLinearDS or
            self.FirstOrderLinearTIDS or
            self.LagrangianDS or
            self.LagrangianLinearTIDS
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DS_DefinitionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DS_DefinitionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DS_DefinitionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DS_DefinitionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='DS_DefinitionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for FirstOrderNonLinearDS_ in self.FirstOrderNonLinearDS:
            FirstOrderNonLinearDS_.export(outfile, level, namespace_, name_='FirstOrderNonLinearDS', pretty_print=pretty_print)
        for FirstOrderLinearDS_ in self.FirstOrderLinearDS:
            FirstOrderLinearDS_.export(outfile, level, namespace_, name_='FirstOrderLinearDS', pretty_print=pretty_print)
        for FirstOrderLinearTIDS_ in self.FirstOrderLinearTIDS:
            FirstOrderLinearTIDS_.export(outfile, level, namespace_, name_='FirstOrderLinearTIDS', pretty_print=pretty_print)
        for LagrangianDS_ in self.LagrangianDS:
            LagrangianDS_.export(outfile, level, namespace_, name_='LagrangianDS', pretty_print=pretty_print)
        for LagrangianLinearTIDS_ in self.LagrangianLinearTIDS:
            LagrangianLinearTIDS_.export(outfile, level, namespace_, name_='LagrangianLinearTIDS', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DS_DefinitionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('FirstOrderNonLinearDS=[\n')
        level += 1
        for FirstOrderNonLinearDS_ in self.FirstOrderNonLinearDS:
            showIndent(outfile, level)
            outfile.write('model_.FirstOrderNonLinearDSType(\n')
            FirstOrderNonLinearDS_.exportLiteral(outfile, level, name_='FirstOrderNonLinearDSType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('FirstOrderLinearDS=[\n')
        level += 1
        for FirstOrderLinearDS_ in self.FirstOrderLinearDS:
            showIndent(outfile, level)
            outfile.write('model_.FirstOrderLinearDSType(\n')
            FirstOrderLinearDS_.exportLiteral(outfile, level, name_='FirstOrderLinearDSType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('FirstOrderLinearTIDS=[\n')
        level += 1
        for FirstOrderLinearTIDS_ in self.FirstOrderLinearTIDS:
            showIndent(outfile, level)
            outfile.write('model_.FirstOrderLinearTIDSType(\n')
            FirstOrderLinearTIDS_.exportLiteral(outfile, level, name_='FirstOrderLinearTIDSType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('LagrangianDS=[\n')
        level += 1
        for LagrangianDS_ in self.LagrangianDS:
            showIndent(outfile, level)
            outfile.write('model_.LagrangianDSType(\n')
            LagrangianDS_.exportLiteral(outfile, level, name_='LagrangianDSType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('LagrangianLinearTIDS=[\n')
        level += 1
        for LagrangianLinearTIDS_ in self.LagrangianLinearTIDS:
            showIndent(outfile, level)
            outfile.write('model_.LagrangianLinearTIDSType(\n')
            LagrangianLinearTIDS_.exportLiteral(outfile, level, name_='LagrangianLinearTIDSType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'FirstOrderNonLinearDS':
            obj_ = FirstOrderNonLinearDSType.factory()
            obj_.build(child_)
            self.FirstOrderNonLinearDS.append(obj_)
        elif nodeName_ == 'FirstOrderLinearDS':
            obj_ = FirstOrderLinearDSType.factory()
            obj_.build(child_)
            self.FirstOrderLinearDS.append(obj_)
        elif nodeName_ == 'FirstOrderLinearTIDS':
            obj_ = FirstOrderLinearTIDSType.factory()
            obj_.build(child_)
            self.FirstOrderLinearTIDS.append(obj_)
        elif nodeName_ == 'LagrangianDS':
            obj_ = LagrangianDSType.factory()
            obj_.build(child_)
            self.LagrangianDS.append(obj_)
        elif nodeName_ == 'LagrangianLinearTIDS':
            obj_ = LagrangianLinearTIDSType.factory()
            obj_.build(child_)
            self.LagrangianLinearTIDS.append(obj_)
# end class DS_DefinitionType


class FirstOrderNonLinearDSType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, x0=None, M=None, f=None, Jacobianfx=None):
        self.Name = _cast(None, Name)
        self.x0 = x0
        self.M = M
        self.f = f
        self.Jacobianfx = Jacobianfx
    def factory(*args_, **kwargs_):
        if FirstOrderNonLinearDSType.subclass:
            return FirstOrderNonLinearDSType.subclass(*args_, **kwargs_)
        else:
            return FirstOrderNonLinearDSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x0(self): return self.x0
    def set_x0(self, x0): self.x0 = x0
    def get_M(self): return self.M
    def set_M(self, M): self.M = M
    def get_f(self): return self.f
    def set_f(self, f): self.f = f
    def get_Jacobianfx(self): return self.Jacobianfx
    def set_Jacobianfx(self, Jacobianfx): self.Jacobianfx = Jacobianfx
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.x0 is not None or
            self.M is not None or
            self.f is not None or
            self.Jacobianfx is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirstOrderNonLinearDSType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirstOrderNonLinearDSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirstOrderNonLinearDSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirstOrderNonLinearDSType'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FirstOrderNonLinearDSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x0 is not None:
            self.x0.export(outfile, level, namespace_, name_='x0', pretty_print=pretty_print)
        if self.M is not None:
            self.M.export(outfile, level, namespace_, name_='M', pretty_print=pretty_print)
        if self.f is not None:
            self.f.export(outfile, level, namespace_, name_='f', pretty_print=pretty_print)
        if self.Jacobianfx is not None:
            self.Jacobianfx.export(outfile, level, namespace_, name_='Jacobianfx', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FirstOrderNonLinearDSType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            showIndent(outfile, level)
            outfile.write('Name="%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.x0 is not None:
            showIndent(outfile, level)
            outfile.write('x0=model_.vector(\n')
            self.x0.exportLiteral(outfile, level, name_='x0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.M is not None:
            showIndent(outfile, level)
            outfile.write('M=model_.matrix(\n')
            self.M.exportLiteral(outfile, level, name_='M')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.f is not None:
            showIndent(outfile, level)
            outfile.write('f=model_.vector(\n')
            self.f.exportLiteral(outfile, level, name_='f')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Jacobianfx is not None:
            showIndent(outfile, level)
            outfile.write('Jacobianfx=model_.matrix(\n')
            self.Jacobianfx.exportLiteral(outfile, level, name_='Jacobianfx')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x0':
            obj_ = vector.factory()
            obj_.build(child_)
            self.x0 = obj_
        elif nodeName_ == 'M':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.M = obj_
        elif nodeName_ == 'f':
            obj_ = vector.factory()
            obj_.build(child_)
            self.f = obj_
        elif nodeName_ == 'Jacobianfx':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.Jacobianfx = obj_
# end class FirstOrderNonLinearDSType


class FirstOrderLinearDSType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, x0=None, A=None, b=None, M=None):
        self.Name = _cast(None, Name)
        self.x0 = x0
        self.A = A
        self.b = b
        self.M = M
    def factory(*args_, **kwargs_):
        if FirstOrderLinearDSType.subclass:
            return FirstOrderLinearDSType.subclass(*args_, **kwargs_)
        else:
            return FirstOrderLinearDSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x0(self): return self.x0
    def set_x0(self, x0): self.x0 = x0
    def get_A(self): return self.A
    def set_A(self, A): self.A = A
    def get_b(self): return self.b
    def set_b(self, b): self.b = b
    def get_M(self): return self.M
    def set_M(self, M): self.M = M
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.x0 is not None or
            self.A is not None or
            self.b is not None or
            self.M is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirstOrderLinearDSType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirstOrderLinearDSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirstOrderLinearDSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirstOrderLinearDSType'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FirstOrderLinearDSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x0 is not None:
            self.x0.export(outfile, level, namespace_, name_='x0', pretty_print=pretty_print)
        if self.A is not None:
            self.A.export(outfile, level, namespace_, name_='A', pretty_print=pretty_print)
        if self.b is not None:
            self.b.export(outfile, level, namespace_, name_='b', pretty_print=pretty_print)
        if self.M is not None:
            self.M.export(outfile, level, namespace_, name_='M', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FirstOrderLinearDSType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            showIndent(outfile, level)
            outfile.write('Name="%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.x0 is not None:
            showIndent(outfile, level)
            outfile.write('x0=model_.vector(\n')
            self.x0.exportLiteral(outfile, level, name_='x0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.A is not None:
            showIndent(outfile, level)
            outfile.write('A=model_.matrix(\n')
            self.A.exportLiteral(outfile, level, name_='A')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.b is not None:
            showIndent(outfile, level)
            outfile.write('b=model_.vector(\n')
            self.b.exportLiteral(outfile, level, name_='b')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.M is not None:
            showIndent(outfile, level)
            outfile.write('M=model_.matrix(\n')
            self.M.exportLiteral(outfile, level, name_='M')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x0':
            obj_ = vector.factory()
            obj_.build(child_)
            self.x0 = obj_
        elif nodeName_ == 'A':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.A = obj_
        elif nodeName_ == 'b':
            obj_ = vector.factory()
            obj_.build(child_)
            self.b = obj_
        elif nodeName_ == 'M':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.M = obj_
# end class FirstOrderLinearDSType


class FirstOrderLinearTIDSType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, x0=None, A=None, M=None, b=None):
        self.Name = _cast(None, Name)
        self.x0 = x0
        self.A = A
        self.M = M
        self.b = b
    def factory(*args_, **kwargs_):
        if FirstOrderLinearTIDSType.subclass:
            return FirstOrderLinearTIDSType.subclass(*args_, **kwargs_)
        else:
            return FirstOrderLinearTIDSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x0(self): return self.x0
    def set_x0(self, x0): self.x0 = x0
    def get_A(self): return self.A
    def set_A(self, A): self.A = A
    def get_M(self): return self.M
    def set_M(self, M): self.M = M
    def get_b(self): return self.b
    def set_b(self, b): self.b = b
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.x0 is not None or
            self.A is not None or
            self.M is not None or
            self.b is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirstOrderLinearTIDSType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirstOrderLinearTIDSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirstOrderLinearTIDSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirstOrderLinearTIDSType'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FirstOrderLinearTIDSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x0 is not None:
            self.x0.export(outfile, level, namespace_, name_='x0', pretty_print=pretty_print)
        if self.A is not None:
            self.A.export(outfile, level, namespace_, name_='A', pretty_print=pretty_print)
        if self.M is not None:
            self.M.export(outfile, level, namespace_, name_='M', pretty_print=pretty_print)
        if self.b is not None:
            self.b.export(outfile, level, namespace_, name_='b', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FirstOrderLinearTIDSType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            showIndent(outfile, level)
            outfile.write('Name="%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.x0 is not None:
            showIndent(outfile, level)
            outfile.write('x0=model_.vector(\n')
            self.x0.exportLiteral(outfile, level, name_='x0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.A is not None:
            showIndent(outfile, level)
            outfile.write('A=model_.matrix(\n')
            self.A.exportLiteral(outfile, level, name_='A')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.M is not None:
            showIndent(outfile, level)
            outfile.write('M=model_.matrix(\n')
            self.M.exportLiteral(outfile, level, name_='M')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.b is not None:
            showIndent(outfile, level)
            outfile.write('b=model_.vector(\n')
            self.b.exportLiteral(outfile, level, name_='b')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x0':
            obj_ = vector.factory()
            obj_.build(child_)
            self.x0 = obj_
        elif nodeName_ == 'A':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.A = obj_
        elif nodeName_ == 'M':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.M = obj_
        elif nodeName_ == 'b':
            obj_ = vector.factory()
            obj_.build(child_)
            self.b = obj_
# end class FirstOrderLinearTIDSType


class LagrangianDSType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, q0=None, Velocity0=None, Mass=None, FInt=None, FExt=None, FGyr=None, JacobianQFInt=None, JacobianVelocityFInt=None, JacobianQFGyr=None, JacobianVelocityFGyr=None):
        self.Name = _cast(None, Name)
        self.q0 = q0
        self.Velocity0 = Velocity0
        self.Mass = Mass
        self.FInt = FInt
        self.FExt = FExt
        self.FGyr = FGyr
        self.JacobianQFInt = JacobianQFInt
        self.JacobianVelocityFInt = JacobianVelocityFInt
        self.JacobianQFGyr = JacobianQFGyr
        self.JacobianVelocityFGyr = JacobianVelocityFGyr
    def factory(*args_, **kwargs_):
        if LagrangianDSType.subclass:
            return LagrangianDSType.subclass(*args_, **kwargs_)
        else:
            return LagrangianDSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_q0(self): return self.q0
    def set_q0(self, q0): self.q0 = q0
    def get_Velocity0(self): return self.Velocity0
    def set_Velocity0(self, Velocity0): self.Velocity0 = Velocity0
    def get_Mass(self): return self.Mass
    def set_Mass(self, Mass): self.Mass = Mass
    def get_FInt(self): return self.FInt
    def set_FInt(self, FInt): self.FInt = FInt
    def get_FExt(self): return self.FExt
    def set_FExt(self, FExt): self.FExt = FExt
    def get_FGyr(self): return self.FGyr
    def set_FGyr(self, FGyr): self.FGyr = FGyr
    def get_JacobianQFInt(self): return self.JacobianQFInt
    def set_JacobianQFInt(self, JacobianQFInt): self.JacobianQFInt = JacobianQFInt
    def get_JacobianVelocityFInt(self): return self.JacobianVelocityFInt
    def set_JacobianVelocityFInt(self, JacobianVelocityFInt): self.JacobianVelocityFInt = JacobianVelocityFInt
    def get_JacobianQFGyr(self): return self.JacobianQFGyr
    def set_JacobianQFGyr(self, JacobianQFGyr): self.JacobianQFGyr = JacobianQFGyr
    def get_JacobianVelocityFGyr(self): return self.JacobianVelocityFGyr
    def set_JacobianVelocityFGyr(self, JacobianVelocityFGyr): self.JacobianVelocityFGyr = JacobianVelocityFGyr
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.q0 is not None or
            self.Velocity0 is not None or
            self.Mass is not None or
            self.FInt is not None or
            self.FExt is not None or
            self.FGyr is not None or
            self.JacobianQFInt is not None or
            self.JacobianVelocityFInt is not None or
            self.JacobianQFGyr is not None or
            self.JacobianVelocityFGyr is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LagrangianDSType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LagrangianDSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LagrangianDSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LagrangianDSType'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LagrangianDSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.q0 is not None:
            self.q0.export(outfile, level, namespace_, name_='q0', pretty_print=pretty_print)
        if self.Velocity0 is not None:
            self.Velocity0.export(outfile, level, namespace_, name_='Velocity0', pretty_print=pretty_print)
        if self.Mass is not None:
            self.Mass.export(outfile, level, namespace_, name_='Mass', pretty_print=pretty_print)
        if self.FInt is not None:
            self.FInt.export(outfile, level, namespace_, name_='FInt', pretty_print=pretty_print)
        if self.FExt is not None:
            self.FExt.export(outfile, level, namespace_, name_='FExt', pretty_print=pretty_print)
        if self.FGyr is not None:
            self.FGyr.export(outfile, level, namespace_, name_='FGyr', pretty_print=pretty_print)
        if self.JacobianQFInt is not None:
            self.JacobianQFInt.export(outfile, level, namespace_, name_='JacobianQFInt', pretty_print=pretty_print)
        if self.JacobianVelocityFInt is not None:
            self.JacobianVelocityFInt.export(outfile, level, namespace_, name_='JacobianVelocityFInt', pretty_print=pretty_print)
        if self.JacobianQFGyr is not None:
            self.JacobianQFGyr.export(outfile, level, namespace_, name_='JacobianQFGyr', pretty_print=pretty_print)
        if self.JacobianVelocityFGyr is not None:
            self.JacobianVelocityFGyr.export(outfile, level, namespace_, name_='JacobianVelocityFGyr', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LagrangianDSType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            showIndent(outfile, level)
            outfile.write('Name="%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.q0 is not None:
            showIndent(outfile, level)
            outfile.write('q0=model_.vector(\n')
            self.q0.exportLiteral(outfile, level, name_='q0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Velocity0 is not None:
            showIndent(outfile, level)
            outfile.write('Velocity0=model_.vector(\n')
            self.Velocity0.exportLiteral(outfile, level, name_='Velocity0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Mass is not None:
            showIndent(outfile, level)
            outfile.write('Mass=model_.matrix(\n')
            self.Mass.exportLiteral(outfile, level, name_='Mass')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FInt is not None:
            showIndent(outfile, level)
            outfile.write('FInt=model_.vector(\n')
            self.FInt.exportLiteral(outfile, level, name_='FInt')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FExt is not None:
            showIndent(outfile, level)
            outfile.write('FExt=model_.vector(\n')
            self.FExt.exportLiteral(outfile, level, name_='FExt')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FGyr is not None:
            showIndent(outfile, level)
            outfile.write('FGyr=model_.vector(\n')
            self.FGyr.exportLiteral(outfile, level, name_='FGyr')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.JacobianQFInt is not None:
            showIndent(outfile, level)
            outfile.write('JacobianQFInt=model_.matrix(\n')
            self.JacobianQFInt.exportLiteral(outfile, level, name_='JacobianQFInt')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.JacobianVelocityFInt is not None:
            showIndent(outfile, level)
            outfile.write('JacobianVelocityFInt=model_.matrix(\n')
            self.JacobianVelocityFInt.exportLiteral(outfile, level, name_='JacobianVelocityFInt')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.JacobianQFGyr is not None:
            showIndent(outfile, level)
            outfile.write('JacobianQFGyr=model_.matrix(\n')
            self.JacobianQFGyr.exportLiteral(outfile, level, name_='JacobianQFGyr')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.JacobianVelocityFGyr is not None:
            showIndent(outfile, level)
            outfile.write('JacobianVelocityFGyr=model_.matrix(\n')
            self.JacobianVelocityFGyr.exportLiteral(outfile, level, name_='JacobianVelocityFGyr')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'q0':
            obj_ = vector.factory()
            obj_.build(child_)
            self.q0 = obj_
        elif nodeName_ == 'Velocity0':
            obj_ = vector.factory()
            obj_.build(child_)
            self.Velocity0 = obj_
        elif nodeName_ == 'Mass':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.Mass = obj_
        elif nodeName_ == 'FInt':
            obj_ = vector.factory()
            obj_.build(child_)
            self.FInt = obj_
        elif nodeName_ == 'FExt':
            obj_ = vector.factory()
            obj_.build(child_)
            self.FExt = obj_
        elif nodeName_ == 'FGyr':
            obj_ = vector.factory()
            obj_.build(child_)
            self.FGyr = obj_
        elif nodeName_ == 'JacobianQFInt':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.JacobianQFInt = obj_
        elif nodeName_ == 'JacobianVelocityFInt':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.JacobianVelocityFInt = obj_
        elif nodeName_ == 'JacobianQFGyr':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.JacobianQFGyr = obj_
        elif nodeName_ == 'JacobianVelocityFGyr':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.JacobianVelocityFGyr = obj_
# end class LagrangianDSType


class LagrangianLinearTIDSType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, q0=None, Velocity0=None, Mass=None, FExt=None, K=None, C=None):
        self.Name = _cast(None, Name)
        self.q0 = q0
        self.Velocity0 = Velocity0
        self.Mass = Mass
        self.FExt = FExt
        self.K = K
        self.C = C
    def factory(*args_, **kwargs_):
        if LagrangianLinearTIDSType.subclass:
            return LagrangianLinearTIDSType.subclass(*args_, **kwargs_)
        else:
            return LagrangianLinearTIDSType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_q0(self): return self.q0
    def set_q0(self, q0): self.q0 = q0
    def get_Velocity0(self): return self.Velocity0
    def set_Velocity0(self, Velocity0): self.Velocity0 = Velocity0
    def get_Mass(self): return self.Mass
    def set_Mass(self, Mass): self.Mass = Mass
    def get_FExt(self): return self.FExt
    def set_FExt(self, FExt): self.FExt = FExt
    def get_K(self): return self.K
    def set_K(self, K): self.K = K
    def get_C(self): return self.C
    def set_C(self, C): self.C = C
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def hasContent_(self):
        if (
            self.q0 is not None or
            self.Velocity0 is not None or
            self.Mass is not None or
            self.FExt is not None or
            self.K is not None or
            self.C is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LagrangianLinearTIDSType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LagrangianLinearTIDSType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LagrangianLinearTIDSType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LagrangianLinearTIDSType'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LagrangianLinearTIDSType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.q0 is not None:
            self.q0.export(outfile, level, namespace_, name_='q0', pretty_print=pretty_print)
        if self.Velocity0 is not None:
            self.Velocity0.export(outfile, level, namespace_, name_='Velocity0', pretty_print=pretty_print)
        if self.Mass is not None:
            self.Mass.export(outfile, level, namespace_, name_='Mass', pretty_print=pretty_print)
        if self.FExt is not None:
            self.FExt.export(outfile, level, namespace_, name_='FExt', pretty_print=pretty_print)
        if self.K is not None:
            self.K.export(outfile, level, namespace_, name_='K', pretty_print=pretty_print)
        if self.C is not None:
            self.C.export(outfile, level, namespace_, name_='C', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LagrangianLinearTIDSType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            showIndent(outfile, level)
            outfile.write('Name="%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.q0 is not None:
            showIndent(outfile, level)
            outfile.write('q0=model_.vector(\n')
            self.q0.exportLiteral(outfile, level, name_='q0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Velocity0 is not None:
            showIndent(outfile, level)
            outfile.write('Velocity0=model_.vector(\n')
            self.Velocity0.exportLiteral(outfile, level, name_='Velocity0')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Mass is not None:
            showIndent(outfile, level)
            outfile.write('Mass=model_.matrix(\n')
            self.Mass.exportLiteral(outfile, level, name_='Mass')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FExt is not None:
            showIndent(outfile, level)
            outfile.write('FExt=model_.vector(\n')
            self.FExt.exportLiteral(outfile, level, name_='FExt')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.K is not None:
            showIndent(outfile, level)
            outfile.write('K=model_.matrix(\n')
            self.K.exportLiteral(outfile, level, name_='K')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.C is not None:
            showIndent(outfile, level)
            outfile.write('C=model_.matrix(\n')
            self.C.exportLiteral(outfile, level, name_='C')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'q0':
            obj_ = vector.factory()
            obj_.build(child_)
            self.q0 = obj_
        elif nodeName_ == 'Velocity0':
            obj_ = vector.factory()
            obj_.build(child_)
            self.Velocity0 = obj_
        elif nodeName_ == 'Mass':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.Mass = obj_
        elif nodeName_ == 'FExt':
            obj_ = vector.factory()
            obj_.build(child_)
            self.FExt = obj_
        elif nodeName_ == 'K':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.K = obj_
        elif nodeName_ == 'C':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.C = obj_
# end class LagrangianLinearTIDSType


class Interaction_DefinitionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Interaction=None):
        if Interaction is None:
            self.Interaction = []
        else:
            self.Interaction = Interaction
    def factory(*args_, **kwargs_):
        if Interaction_DefinitionType.subclass:
            return Interaction_DefinitionType.subclass(*args_, **kwargs_)
        else:
            return Interaction_DefinitionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Interaction(self): return self.Interaction
    def set_Interaction(self, Interaction): self.Interaction = Interaction
    def add_Interaction(self, value): self.Interaction.append(value)
    def insert_Interaction(self, index, value): self.Interaction[index] = value
    def hasContent_(self):
        if (
            self.Interaction
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Interaction_DefinitionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Interaction_DefinitionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Interaction_DefinitionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Interaction_DefinitionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Interaction_DefinitionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Interaction_ in self.Interaction:
            Interaction_.export(outfile, level, namespace_, name_='Interaction', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Interaction_DefinitionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Interaction=[\n')
        level += 1
        for Interaction_ in self.Interaction:
            showIndent(outfile, level)
            outfile.write('model_.InteractionType(\n')
            Interaction_.exportLiteral(outfile, level, name_='InteractionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Interaction':
            obj_ = InteractionType.factory()
            obj_.build(child_)
            self.Interaction.append(obj_)
# end class Interaction_DefinitionType


class InteractionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, size=None, DS_Concerned=None, Interaction_Content=None):
        self.Name = _cast(None, Name)
        self.size = _cast(int, size)
        self.DS_Concerned = DS_Concerned
        self.Interaction_Content = Interaction_Content
    def factory(*args_, **kwargs_):
        if InteractionType.subclass:
            return InteractionType.subclass(*args_, **kwargs_)
        else:
            return InteractionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DS_Concerned(self): return self.DS_Concerned
    def set_DS_Concerned(self, DS_Concerned): self.DS_Concerned = DS_Concerned
    def get_Interaction_Content(self): return self.Interaction_Content
    def set_Interaction_Content(self, Interaction_Content): self.Interaction_Content = Interaction_Content
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def validate_strList(self, value):
        # Validate type strList, a restriction on xsd:string.
        pass
    def hasContent_(self):
        if (
            self.DS_Concerned is not None or
            self.Interaction_Content is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InteractionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InteractionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='InteractionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InteractionType'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size="%s"' % self.gds_format_integer(self.size, input_name='size'))
    def exportChildren(self, outfile, level, namespace_='', name_='InteractionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DS_Concerned is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDS_Concerned>%s</%sDS_Concerned>%s' % (namespace_, self.gds_format_string(quote_xml(' '.join(self.DS_Concerned)).encode(ExternalEncoding), input_name='DS_Concerned'), namespace_, eol_))
        if self.Interaction_Content is not None:
            self.Interaction_Content.export(outfile, level, namespace_, name_='Interaction_Content', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='InteractionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            showIndent(outfile, level)
            outfile.write('Name="%s",\n' % (self.Name,))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % (self.size,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.DS_Concerned is not None:
            showIndent(outfile, level)
            if self.DS_Concerned:
                outfile.write('DS_Concerned=%s,\n' % quote_python(' '.join(self.DS_Concerned)).encode(ExternalEncoding))
            else:
                outfile.write('DS_Concerned=None,\n')
        if self.Interaction_Content is not None:
            showIndent(outfile, level)
            outfile.write('Interaction_Content=model_.Interaction_ContentType(\n')
            self.Interaction_Content.exportLiteral(outfile, level, name_='Interaction_Content')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.add('Name')
            self.Name = value
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            try:
                self.size = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.size <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DS_Concerned':
            DS_Concerned_ = child_.text
            self.DS_Concerned = DS_Concerned_
            self.DS_Concerned = self.DS_Concerned.split()
            self.validate_strList(self.DS_Concerned)    # validate type strList
        elif nodeName_ == 'Interaction_Content':
            obj_ = Interaction_ContentType.factory()
            obj_.build(child_)
            self.Interaction_Content = obj_
# end class InteractionType


class Interaction_ContentType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, FirstOrderR=None, FirstOrderLinearR=None, FirstOrderLinearTIR=None, LagrangianCompliantR=None, LagrangianRheonomousR=None, LagrangianScleronomousR=None, LagrangianLinearTIR=None, RelayNSL=None, NewtonImpactNSL=None, NewtonImpactFrictionNSL=None, ComplementarityConditionNSL=None):
        self.FirstOrderR = FirstOrderR
        self.FirstOrderLinearR = FirstOrderLinearR
        self.FirstOrderLinearTIR = FirstOrderLinearTIR
        self.LagrangianCompliantR = LagrangianCompliantR
        self.LagrangianRheonomousR = LagrangianRheonomousR
        self.LagrangianScleronomousR = LagrangianScleronomousR
        self.LagrangianLinearTIR = LagrangianLinearTIR
        self.RelayNSL = RelayNSL
        self.NewtonImpactNSL = NewtonImpactNSL
        self.NewtonImpactFrictionNSL = NewtonImpactFrictionNSL
        self.ComplementarityConditionNSL = ComplementarityConditionNSL
    def factory(*args_, **kwargs_):
        if Interaction_ContentType.subclass:
            return Interaction_ContentType.subclass(*args_, **kwargs_)
        else:
            return Interaction_ContentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_FirstOrderR(self): return self.FirstOrderR
    def set_FirstOrderR(self, FirstOrderR): self.FirstOrderR = FirstOrderR
    def get_FirstOrderLinearR(self): return self.FirstOrderLinearR
    def set_FirstOrderLinearR(self, FirstOrderLinearR): self.FirstOrderLinearR = FirstOrderLinearR
    def get_FirstOrderLinearTIR(self): return self.FirstOrderLinearTIR
    def set_FirstOrderLinearTIR(self, FirstOrderLinearTIR): self.FirstOrderLinearTIR = FirstOrderLinearTIR
    def get_LagrangianCompliantR(self): return self.LagrangianCompliantR
    def set_LagrangianCompliantR(self, LagrangianCompliantR): self.LagrangianCompliantR = LagrangianCompliantR
    def get_LagrangianRheonomousR(self): return self.LagrangianRheonomousR
    def set_LagrangianRheonomousR(self, LagrangianRheonomousR): self.LagrangianRheonomousR = LagrangianRheonomousR
    def get_LagrangianScleronomousR(self): return self.LagrangianScleronomousR
    def set_LagrangianScleronomousR(self, LagrangianScleronomousR): self.LagrangianScleronomousR = LagrangianScleronomousR
    def get_LagrangianLinearTIR(self): return self.LagrangianLinearTIR
    def set_LagrangianLinearTIR(self, LagrangianLinearTIR): self.LagrangianLinearTIR = LagrangianLinearTIR
    def get_RelayNSL(self): return self.RelayNSL
    def set_RelayNSL(self, RelayNSL): self.RelayNSL = RelayNSL
    def get_NewtonImpactNSL(self): return self.NewtonImpactNSL
    def set_NewtonImpactNSL(self, NewtonImpactNSL): self.NewtonImpactNSL = NewtonImpactNSL
    def get_NewtonImpactFrictionNSL(self): return self.NewtonImpactFrictionNSL
    def set_NewtonImpactFrictionNSL(self, NewtonImpactFrictionNSL): self.NewtonImpactFrictionNSL = NewtonImpactFrictionNSL
    def get_ComplementarityConditionNSL(self): return self.ComplementarityConditionNSL
    def set_ComplementarityConditionNSL(self, ComplementarityConditionNSL): self.ComplementarityConditionNSL = ComplementarityConditionNSL
    def hasContent_(self):
        if (
            self.FirstOrderR is not None or
            self.FirstOrderLinearR is not None or
            self.FirstOrderLinearTIR is not None or
            self.LagrangianCompliantR is not None or
            self.LagrangianRheonomousR is not None or
            self.LagrangianScleronomousR is not None or
            self.LagrangianLinearTIR is not None or
            self.RelayNSL is not None or
            self.NewtonImpactNSL is not None or
            self.NewtonImpactFrictionNSL is not None or
            self.ComplementarityConditionNSL is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Interaction_ContentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Interaction_ContentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Interaction_ContentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Interaction_ContentType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Interaction_ContentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.FirstOrderR is not None:
            self.FirstOrderR.export(outfile, level, namespace_, name_='FirstOrderR', pretty_print=pretty_print)
        if self.FirstOrderLinearR is not None:
            self.FirstOrderLinearR.export(outfile, level, namespace_, name_='FirstOrderLinearR', pretty_print=pretty_print)
        if self.FirstOrderLinearTIR is not None:
            self.FirstOrderLinearTIR.export(outfile, level, namespace_, name_='FirstOrderLinearTIR', pretty_print=pretty_print)
        if self.LagrangianCompliantR is not None:
            self.LagrangianCompliantR.export(outfile, level, namespace_, name_='LagrangianCompliantR', pretty_print=pretty_print)
        if self.LagrangianRheonomousR is not None:
            self.LagrangianRheonomousR.export(outfile, level, namespace_, name_='LagrangianRheonomousR', pretty_print=pretty_print)
        if self.LagrangianScleronomousR is not None:
            self.LagrangianScleronomousR.export(outfile, level, namespace_, name_='LagrangianScleronomousR', pretty_print=pretty_print)
        if self.LagrangianLinearTIR is not None:
            self.LagrangianLinearTIR.export(outfile, level, namespace_, name_='LagrangianLinearTIR', pretty_print=pretty_print)
        if self.RelayNSL is not None:
            self.RelayNSL.export(outfile, level, namespace_, name_='RelayNSL', pretty_print=pretty_print)
        if self.NewtonImpactNSL is not None:
            self.NewtonImpactNSL.export(outfile, level, namespace_, name_='NewtonImpactNSL', pretty_print=pretty_print)
        if self.NewtonImpactFrictionNSL is not None:
            self.NewtonImpactFrictionNSL.export(outfile, level, namespace_, name_='NewtonImpactFrictionNSL', pretty_print=pretty_print)
        if self.ComplementarityConditionNSL is not None:
            self.ComplementarityConditionNSL.export(outfile, level, namespace_, name_='ComplementarityConditionNSL', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Interaction_ContentType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.FirstOrderR is not None:
            showIndent(outfile, level)
            outfile.write('FirstOrderR=model_.FirstOrderRType(\n')
            self.FirstOrderR.exportLiteral(outfile, level, name_='FirstOrderR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FirstOrderLinearR is not None:
            showIndent(outfile, level)
            outfile.write('FirstOrderLinearR=model_.FirstOrderLinearRType(\n')
            self.FirstOrderLinearR.exportLiteral(outfile, level, name_='FirstOrderLinearR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FirstOrderLinearTIR is not None:
            showIndent(outfile, level)
            outfile.write('FirstOrderLinearTIR=model_.FirstOrderLinearTIRType(\n')
            self.FirstOrderLinearTIR.exportLiteral(outfile, level, name_='FirstOrderLinearTIR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.LagrangianCompliantR is not None:
            showIndent(outfile, level)
            outfile.write('LagrangianCompliantR=model_.LagrangianCompliantRType(\n')
            self.LagrangianCompliantR.exportLiteral(outfile, level, name_='LagrangianCompliantR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.LagrangianRheonomousR is not None:
            showIndent(outfile, level)
            outfile.write('LagrangianRheonomousR=model_.LagrangianRheonomousRType(\n')
            self.LagrangianRheonomousR.exportLiteral(outfile, level, name_='LagrangianRheonomousR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.LagrangianScleronomousR is not None:
            showIndent(outfile, level)
            outfile.write('LagrangianScleronomousR=model_.LagrangianScleronomousRType(\n')
            self.LagrangianScleronomousR.exportLiteral(outfile, level, name_='LagrangianScleronomousR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.LagrangianLinearTIR is not None:
            showIndent(outfile, level)
            outfile.write('LagrangianLinearTIR=model_.LagrangianLinearTIRType(\n')
            self.LagrangianLinearTIR.exportLiteral(outfile, level, name_='LagrangianLinearTIR')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.RelayNSL is not None:
            showIndent(outfile, level)
            outfile.write('RelayNSL=model_.RelayNSLType(\n')
            self.RelayNSL.exportLiteral(outfile, level, name_='RelayNSL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.NewtonImpactNSL is not None:
            showIndent(outfile, level)
            outfile.write('NewtonImpactNSL=model_.NewtonImpactNSLType(\n')
            self.NewtonImpactNSL.exportLiteral(outfile, level, name_='NewtonImpactNSL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.NewtonImpactFrictionNSL is not None:
            showIndent(outfile, level)
            outfile.write('NewtonImpactFrictionNSL=model_.NewtonImpactFrictionNSLType(\n')
            self.NewtonImpactFrictionNSL.exportLiteral(outfile, level, name_='NewtonImpactFrictionNSL')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ComplementarityConditionNSL is not None:
            showIndent(outfile, level)
            outfile.write('ComplementarityConditionNSL=model_.ComplementarityConditionNSLType(\n')
            self.ComplementarityConditionNSL.exportLiteral(outfile, level, name_='ComplementarityConditionNSL')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'FirstOrderR':
            obj_ = FirstOrderRType.factory()
            obj_.build(child_)
            self.FirstOrderR = obj_
        elif nodeName_ == 'FirstOrderLinearR':
            obj_ = FirstOrderLinearRType.factory()
            obj_.build(child_)
            self.FirstOrderLinearR = obj_
        elif nodeName_ == 'FirstOrderLinearTIR':
            obj_ = FirstOrderLinearTIRType.factory()
            obj_.build(child_)
            self.FirstOrderLinearTIR = obj_
        elif nodeName_ == 'LagrangianCompliantR':
            obj_ = LagrangianCompliantRType.factory()
            obj_.build(child_)
            self.LagrangianCompliantR = obj_
        elif nodeName_ == 'LagrangianRheonomousR':
            obj_ = LagrangianRheonomousRType.factory()
            obj_.build(child_)
            self.LagrangianRheonomousR = obj_
        elif nodeName_ == 'LagrangianScleronomousR':
            obj_ = LagrangianScleronomousRType.factory()
            obj_.build(child_)
            self.LagrangianScleronomousR = obj_
        elif nodeName_ == 'LagrangianLinearTIR':
            obj_ = LagrangianLinearTIRType.factory()
            obj_.build(child_)
            self.LagrangianLinearTIR = obj_
        elif nodeName_ == 'RelayNSL':
            obj_ = RelayNSLType.factory()
            obj_.build(child_)
            self.RelayNSL = obj_
        elif nodeName_ == 'NewtonImpactNSL':
            obj_ = NewtonImpactNSLType.factory()
            obj_.build(child_)
            self.NewtonImpactNSL = obj_
        elif nodeName_ == 'NewtonImpactFrictionNSL':
            obj_ = NewtonImpactFrictionNSLType.factory()
            obj_.build(child_)
            self.NewtonImpactFrictionNSL = obj_
        elif nodeName_ == 'ComplementarityConditionNSL':
            obj_ = ComplementarityConditionNSLType.factory()
            obj_.build(child_)
            self.ComplementarityConditionNSL = obj_
# end class Interaction_ContentType


class FirstOrderRType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_='Undefined', h=None, g=None, jacobianG=None, jacobianH=None):
        self.type_ = _cast(None, type_)
        self.h = h
        self.g = g
        self.jacobianG = jacobianG
        self.jacobianH = jacobianH
    def factory(*args_, **kwargs_):
        if FirstOrderRType.subclass:
            return FirstOrderRType.subclass(*args_, **kwargs_)
        else:
            return FirstOrderRType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_h(self): return self.h
    def set_h(self, h): self.h = h
    def get_g(self): return self.g
    def set_g(self, g): self.g = g
    def get_jacobianG(self): return self.jacobianG
    def set_jacobianG(self, jacobianG): self.jacobianG = jacobianG
    def get_jacobianH(self): return self.jacobianH
    def set_jacobianH(self, jacobianH): self.jacobianH = jacobianH
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.h is not None or
            self.g is not None or
            self.jacobianG is not None or
            self.jacobianH is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirstOrderRType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirstOrderRType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirstOrderRType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirstOrderRType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FirstOrderRType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.h is not None:
            self.h.export(outfile, level, namespace_, name_='h', pretty_print=pretty_print)
        if self.g is not None:
            self.g.export(outfile, level, namespace_, name_='g', pretty_print=pretty_print)
        if self.jacobianG is not None:
            self.jacobianG.export(outfile, level, namespace_, name_='jacobianG', pretty_print=pretty_print)
        if self.jacobianH is not None:
            self.jacobianH.export(outfile, level, namespace_, name_='jacobianH', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FirstOrderRType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.h is not None:
            showIndent(outfile, level)
            outfile.write('h=model_.pluginDef(\n')
            self.h.exportLiteral(outfile, level, name_='h')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.g is not None:
            showIndent(outfile, level)
            outfile.write('g=model_.pluginDef(\n')
            self.g.exportLiteral(outfile, level, name_='g')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.jacobianG is not None:
            showIndent(outfile, level)
            outfile.write('jacobianG=model_.listOfMatrices(\n')
            self.jacobianG.exportLiteral(outfile, level, name_='jacobianG')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.jacobianH is not None:
            showIndent(outfile, level)
            outfile.write('jacobianH=model_.listOfMatrices(\n')
            self.jacobianH.exportLiteral(outfile, level, name_='jacobianH')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'h':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.h = obj_
        elif nodeName_ == 'g':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.g = obj_
        elif nodeName_ == 'jacobianG':
            obj_ = listOfMatrices.factory()
            obj_.build(child_)
            self.jacobianG = obj_
        elif nodeName_ == 'jacobianH':
            obj_ = listOfMatrices.factory()
            obj_.build(child_)
            self.jacobianH = obj_
# end class FirstOrderRType


class FirstOrderLinearRType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, C=None, D=None, F=None, e=None, B=None):
        self.C = C
        self.D = D
        self.F = F
        self.e = e
        self.B = B
    def factory(*args_, **kwargs_):
        if FirstOrderLinearRType.subclass:
            return FirstOrderLinearRType.subclass(*args_, **kwargs_)
        else:
            return FirstOrderLinearRType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_C(self): return self.C
    def set_C(self, C): self.C = C
    def get_D(self): return self.D
    def set_D(self, D): self.D = D
    def get_F(self): return self.F
    def set_F(self, F): self.F = F
    def get_e(self): return self.e
    def set_e(self, e): self.e = e
    def get_B(self): return self.B
    def set_B(self, B): self.B = B
    def hasContent_(self):
        if (
            self.C is not None or
            self.D is not None or
            self.F is not None or
            self.e is not None or
            self.B is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirstOrderLinearRType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirstOrderLinearRType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirstOrderLinearRType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirstOrderLinearRType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='FirstOrderLinearRType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.C is not None:
            self.C.export(outfile, level, namespace_, name_='C', pretty_print=pretty_print)
        if self.D is not None:
            self.D.export(outfile, level, namespace_, name_='D', pretty_print=pretty_print)
        if self.F is not None:
            self.F.export(outfile, level, namespace_, name_='F', pretty_print=pretty_print)
        if self.e is not None:
            self.e.export(outfile, level, namespace_, name_='e', pretty_print=pretty_print)
        if self.B is not None:
            self.B.export(outfile, level, namespace_, name_='B', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FirstOrderLinearRType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.C is not None:
            showIndent(outfile, level)
            outfile.write('C=model_.matrix(\n')
            self.C.exportLiteral(outfile, level, name_='C')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.D is not None:
            showIndent(outfile, level)
            outfile.write('D=model_.matrix(\n')
            self.D.exportLiteral(outfile, level, name_='D')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.F is not None:
            showIndent(outfile, level)
            outfile.write('F=model_.matrix(\n')
            self.F.exportLiteral(outfile, level, name_='F')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e is not None:
            showIndent(outfile, level)
            outfile.write('e=model_.vector(\n')
            self.e.exportLiteral(outfile, level, name_='e')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.B is not None:
            showIndent(outfile, level)
            outfile.write('B=model_.matrix(\n')
            self.B.exportLiteral(outfile, level, name_='B')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'C':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.C = obj_
        elif nodeName_ == 'D':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.D = obj_
        elif nodeName_ == 'F':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.F = obj_
        elif nodeName_ == 'e':
            obj_ = vector.factory()
            obj_.build(child_)
            self.e = obj_
        elif nodeName_ == 'B':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.B = obj_
# end class FirstOrderLinearRType


class FirstOrderLinearTIRType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, C=None, D=None, F=None, e=None, B=None):
        self.C = C
        self.D = D
        self.F = F
        self.e = e
        self.B = B
    def factory(*args_, **kwargs_):
        if FirstOrderLinearTIRType.subclass:
            return FirstOrderLinearTIRType.subclass(*args_, **kwargs_)
        else:
            return FirstOrderLinearTIRType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_C(self): return self.C
    def set_C(self, C): self.C = C
    def get_D(self): return self.D
    def set_D(self, D): self.D = D
    def get_F(self): return self.F
    def set_F(self, F): self.F = F
    def get_e(self): return self.e
    def set_e(self, e): self.e = e
    def get_B(self): return self.B
    def set_B(self, B): self.B = B
    def hasContent_(self):
        if (
            self.C is not None or
            self.D is not None or
            self.F is not None or
            self.e is not None or
            self.B is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FirstOrderLinearTIRType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FirstOrderLinearTIRType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FirstOrderLinearTIRType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FirstOrderLinearTIRType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='FirstOrderLinearTIRType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.C is not None:
            self.C.export(outfile, level, namespace_, name_='C', pretty_print=pretty_print)
        if self.D is not None:
            self.D.export(outfile, level, namespace_, name_='D', pretty_print=pretty_print)
        if self.F is not None:
            self.F.export(outfile, level, namespace_, name_='F', pretty_print=pretty_print)
        if self.e is not None:
            self.e.export(outfile, level, namespace_, name_='e', pretty_print=pretty_print)
        if self.B is not None:
            self.B.export(outfile, level, namespace_, name_='B', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FirstOrderLinearTIRType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.C is not None:
            showIndent(outfile, level)
            outfile.write('C=model_.matrix(\n')
            self.C.exportLiteral(outfile, level, name_='C')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.D is not None:
            showIndent(outfile, level)
            outfile.write('D=model_.matrix(\n')
            self.D.exportLiteral(outfile, level, name_='D')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.F is not None:
            showIndent(outfile, level)
            outfile.write('F=model_.matrix(\n')
            self.F.exportLiteral(outfile, level, name_='F')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e is not None:
            showIndent(outfile, level)
            outfile.write('e=model_.vector(\n')
            self.e.exportLiteral(outfile, level, name_='e')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.B is not None:
            showIndent(outfile, level)
            outfile.write('B=model_.matrix(\n')
            self.B.exportLiteral(outfile, level, name_='B')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'C':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.C = obj_
        elif nodeName_ == 'D':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.D = obj_
        elif nodeName_ == 'F':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.F = obj_
        elif nodeName_ == 'e':
            obj_ = vector.factory()
            obj_.build(child_)
            self.e = obj_
        elif nodeName_ == 'B':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.B = obj_
# end class FirstOrderLinearTIRType


class LagrangianCompliantRType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, h=None, Jacobianhq=None, Jacobianhlambda=None):
        self.h = h
        self.Jacobianhq = Jacobianhq
        self.Jacobianhlambda = Jacobianhlambda
    def factory(*args_, **kwargs_):
        if LagrangianCompliantRType.subclass:
            return LagrangianCompliantRType.subclass(*args_, **kwargs_)
        else:
            return LagrangianCompliantRType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_h(self): return self.h
    def set_h(self, h): self.h = h
    def get_Jacobianhq(self): return self.Jacobianhq
    def set_Jacobianhq(self, Jacobianhq): self.Jacobianhq = Jacobianhq
    def get_Jacobianhlambda(self): return self.Jacobianhlambda
    def set_Jacobianhlambda(self, Jacobianhlambda): self.Jacobianhlambda = Jacobianhlambda
    def hasContent_(self):
        if (
            self.h is not None or
            self.Jacobianhq is not None or
            self.Jacobianhlambda is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LagrangianCompliantRType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LagrangianCompliantRType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LagrangianCompliantRType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LagrangianCompliantRType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LagrangianCompliantRType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.h is not None:
            self.h.export(outfile, level, namespace_, name_='h', pretty_print=pretty_print)
        if self.Jacobianhq is not None:
            self.Jacobianhq.export(outfile, level, namespace_, name_='Jacobianhq', pretty_print=pretty_print)
        if self.Jacobianhlambda is not None:
            self.Jacobianhlambda.export(outfile, level, namespace_, name_='Jacobianhlambda', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LagrangianCompliantRType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.h is not None:
            showIndent(outfile, level)
            outfile.write('h=model_.pluginDef(\n')
            self.h.exportLiteral(outfile, level, name_='h')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Jacobianhq is not None:
            showIndent(outfile, level)
            outfile.write('Jacobianhq=model_.pluginDef(\n')
            self.Jacobianhq.exportLiteral(outfile, level, name_='Jacobianhq')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Jacobianhlambda is not None:
            showIndent(outfile, level)
            outfile.write('Jacobianhlambda=model_.pluginDef(\n')
            self.Jacobianhlambda.exportLiteral(outfile, level, name_='Jacobianhlambda')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'h':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.h = obj_
        elif nodeName_ == 'Jacobianhq':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.Jacobianhq = obj_
        elif nodeName_ == 'Jacobianhlambda':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.Jacobianhlambda = obj_
# end class LagrangianCompliantRType


class LagrangianRheonomousRType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, h=None, Jacobianhq=None, JacobianDoth=None):
        self.h = h
        self.Jacobianhq = Jacobianhq
        self.JacobianDoth = JacobianDoth
    def factory(*args_, **kwargs_):
        if LagrangianRheonomousRType.subclass:
            return LagrangianRheonomousRType.subclass(*args_, **kwargs_)
        else:
            return LagrangianRheonomousRType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_h(self): return self.h
    def set_h(self, h): self.h = h
    def get_Jacobianhq(self): return self.Jacobianhq
    def set_Jacobianhq(self, Jacobianhq): self.Jacobianhq = Jacobianhq
    def get_JacobianDoth(self): return self.JacobianDoth
    def set_JacobianDoth(self, JacobianDoth): self.JacobianDoth = JacobianDoth
    def hasContent_(self):
        if (
            self.h is not None or
            self.Jacobianhq is not None or
            self.JacobianDoth is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LagrangianRheonomousRType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LagrangianRheonomousRType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LagrangianRheonomousRType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LagrangianRheonomousRType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LagrangianRheonomousRType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.h is not None:
            self.h.export(outfile, level, namespace_, name_='h', pretty_print=pretty_print)
        if self.Jacobianhq is not None:
            self.Jacobianhq.export(outfile, level, namespace_, name_='Jacobianhq', pretty_print=pretty_print)
        if self.JacobianDoth is not None:
            self.JacobianDoth.export(outfile, level, namespace_, name_='JacobianDoth', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LagrangianRheonomousRType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.h is not None:
            showIndent(outfile, level)
            outfile.write('h=model_.pluginDef(\n')
            self.h.exportLiteral(outfile, level, name_='h')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Jacobianhq is not None:
            showIndent(outfile, level)
            outfile.write('Jacobianhq=model_.pluginDef(\n')
            self.Jacobianhq.exportLiteral(outfile, level, name_='Jacobianhq')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.JacobianDoth is not None:
            showIndent(outfile, level)
            outfile.write('JacobianDoth=model_.pluginDef(\n')
            self.JacobianDoth.exportLiteral(outfile, level, name_='JacobianDoth')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'h':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.h = obj_
        elif nodeName_ == 'Jacobianhq':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.Jacobianhq = obj_
        elif nodeName_ == 'JacobianDoth':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.JacobianDoth = obj_
# end class LagrangianRheonomousRType


class LagrangianScleronomousRType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, h=None, Jacobianhq=None, JacobianDothq=None):
        self.h = h
        self.Jacobianhq = Jacobianhq
        self.JacobianDothq = JacobianDothq
    def factory(*args_, **kwargs_):
        if LagrangianScleronomousRType.subclass:
            return LagrangianScleronomousRType.subclass(*args_, **kwargs_)
        else:
            return LagrangianScleronomousRType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_h(self): return self.h
    def set_h(self, h): self.h = h
    def get_Jacobianhq(self): return self.Jacobianhq
    def set_Jacobianhq(self, Jacobianhq): self.Jacobianhq = Jacobianhq
    def get_JacobianDothq(self): return self.JacobianDothq
    def set_JacobianDothq(self, JacobianDothq): self.JacobianDothq = JacobianDothq
    def hasContent_(self):
        if (
            self.h is not None or
            self.Jacobianhq is not None or
            self.JacobianDothq is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LagrangianScleronomousRType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LagrangianScleronomousRType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LagrangianScleronomousRType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LagrangianScleronomousRType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LagrangianScleronomousRType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.h is not None:
            self.h.export(outfile, level, namespace_, name_='h', pretty_print=pretty_print)
        if self.Jacobianhq is not None:
            self.Jacobianhq.export(outfile, level, namespace_, name_='Jacobianhq', pretty_print=pretty_print)
        if self.JacobianDothq is not None:
            self.JacobianDothq.export(outfile, level, namespace_, name_='JacobianDothq', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LagrangianScleronomousRType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.h is not None:
            showIndent(outfile, level)
            outfile.write('h=model_.pluginDef(\n')
            self.h.exportLiteral(outfile, level, name_='h')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Jacobianhq is not None:
            showIndent(outfile, level)
            outfile.write('Jacobianhq=model_.pluginDef(\n')
            self.Jacobianhq.exportLiteral(outfile, level, name_='Jacobianhq')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.JacobianDothq is not None:
            showIndent(outfile, level)
            outfile.write('JacobianDothq=model_.pluginDef(\n')
            self.JacobianDothq.exportLiteral(outfile, level, name_='JacobianDothq')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'h':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.h = obj_
        elif nodeName_ == 'Jacobianhq':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.Jacobianhq = obj_
        elif nodeName_ == 'JacobianDothq':
            obj_ = pluginDef.factory()
            obj_.build(child_)
            self.JacobianDothq = obj_
# end class LagrangianScleronomousRType


class LagrangianLinearTIRType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, C=None, D=None, F=None, e=None):
        self.C = C
        self.D = D
        self.F = F
        self.e = e
    def factory(*args_, **kwargs_):
        if LagrangianLinearTIRType.subclass:
            return LagrangianLinearTIRType.subclass(*args_, **kwargs_)
        else:
            return LagrangianLinearTIRType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_C(self): return self.C
    def set_C(self, C): self.C = C
    def get_D(self): return self.D
    def set_D(self, D): self.D = D
    def get_F(self): return self.F
    def set_F(self, F): self.F = F
    def get_e(self): return self.e
    def set_e(self, e): self.e = e
    def hasContent_(self):
        if (
            self.C is not None or
            self.D is not None or
            self.F is not None or
            self.e is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LagrangianLinearTIRType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LagrangianLinearTIRType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LagrangianLinearTIRType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LagrangianLinearTIRType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='LagrangianLinearTIRType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.C is not None:
            self.C.export(outfile, level, namespace_, name_='C', pretty_print=pretty_print)
        if self.D is not None:
            self.D.export(outfile, level, namespace_, name_='D', pretty_print=pretty_print)
        if self.F is not None:
            self.F.export(outfile, level, namespace_, name_='F', pretty_print=pretty_print)
        if self.e is not None:
            self.e.export(outfile, level, namespace_, name_='e', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LagrangianLinearTIRType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.C is not None:
            showIndent(outfile, level)
            outfile.write('C=model_.matrix(\n')
            self.C.exportLiteral(outfile, level, name_='C')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.D is not None:
            showIndent(outfile, level)
            outfile.write('D=model_.matrix(\n')
            self.D.exportLiteral(outfile, level, name_='D')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.F is not None:
            showIndent(outfile, level)
            outfile.write('F=model_.matrix(\n')
            self.F.exportLiteral(outfile, level, name_='F')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.e is not None:
            showIndent(outfile, level)
            outfile.write('e=model_.vector(\n')
            self.e.exportLiteral(outfile, level, name_='e')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'C':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.C = obj_
        elif nodeName_ == 'D':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.D = obj_
        elif nodeName_ == 'F':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.F = obj_
        elif nodeName_ == 'e':
            obj_ = vector.factory()
            obj_.build(child_)
            self.e = obj_
# end class LagrangianLinearTIRType


class RelayNSLType(NSL):
    subclass = None
    superclass = NSL
    def __init__(self, size=None, ub=None, lb=None):
        super(RelayNSLType, self).__init__(size, )
        self.ub = ub
        self.lb = lb
    def factory(*args_, **kwargs_):
        if RelayNSLType.subclass:
            return RelayNSLType.subclass(*args_, **kwargs_)
        else:
            return RelayNSLType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ub(self): return self.ub
    def set_ub(self, ub): self.ub = ub
    def get_lb(self): return self.lb
    def set_lb(self, lb): self.lb = lb
    def hasContent_(self):
        if (
            self.ub is not None or
            self.lb is not None or
            super(RelayNSLType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RelayNSLType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RelayNSLType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='RelayNSLType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RelayNSLType'):
        super(RelayNSLType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RelayNSLType')
    def exportChildren(self, outfile, level, namespace_='', name_='RelayNSLType', fromsubclass_=False, pretty_print=True):
        super(RelayNSLType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ub is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sub>%s</%sub>%s' % (namespace_, self.gds_format_double(self.ub, input_name='ub'), namespace_, eol_))
        if self.lb is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slb>%s</%slb>%s' % (namespace_, self.gds_format_double(self.lb, input_name='lb'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='RelayNSLType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RelayNSLType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RelayNSLType, self).exportLiteralChildren(outfile, level, name_)
        if self.ub is not None:
            showIndent(outfile, level)
            outfile.write('ub=%e,\n' % self.ub)
        if self.lb is not None:
            showIndent(outfile, level)
            outfile.write('lb=%e,\n' % self.lb)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(RelayNSLType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ub':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'ub')
            self.ub = fval_
        elif nodeName_ == 'lb':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'lb')
            self.lb = fval_
        super(RelayNSLType, self).buildChildren(child_, node, nodeName_, True)
# end class RelayNSLType


class NewtonImpactNSLType(NSL):
    subclass = None
    superclass = NSL
    def __init__(self, size=None, e=None):
        super(NewtonImpactNSLType, self).__init__(size, )
        self.e = e
    def factory(*args_, **kwargs_):
        if NewtonImpactNSLType.subclass:
            return NewtonImpactNSLType.subclass(*args_, **kwargs_)
        else:
            return NewtonImpactNSLType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_e(self): return self.e
    def set_e(self, e): self.e = e
    def hasContent_(self):
        if (
            self.e is not None or
            super(NewtonImpactNSLType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NewtonImpactNSLType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NewtonImpactNSLType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NewtonImpactNSLType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NewtonImpactNSLType'):
        super(NewtonImpactNSLType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NewtonImpactNSLType')
    def exportChildren(self, outfile, level, namespace_='', name_='NewtonImpactNSLType', fromsubclass_=False, pretty_print=True):
        super(NewtonImpactNSLType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.e is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%se>%s</%se>%s' % (namespace_, self.gds_format_double(self.e, input_name='e'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NewtonImpactNSLType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NewtonImpactNSLType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NewtonImpactNSLType, self).exportLiteralChildren(outfile, level, name_)
        if self.e is not None:
            showIndent(outfile, level)
            outfile.write('e=%e,\n' % self.e)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NewtonImpactNSLType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'e':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'e')
            self.e = fval_
        super(NewtonImpactNSLType, self).buildChildren(child_, node, nodeName_, True)
# end class NewtonImpactNSLType


class NewtonImpactFrictionNSLType(NSL):
    subclass = None
    superclass = NSL
    def __init__(self, size=None, en=None, et=None, mu=None):
        super(NewtonImpactFrictionNSLType, self).__init__(size, )
        self.en = en
        self.et = et
        self.mu = mu
    def factory(*args_, **kwargs_):
        if NewtonImpactFrictionNSLType.subclass:
            return NewtonImpactFrictionNSLType.subclass(*args_, **kwargs_)
        else:
            return NewtonImpactFrictionNSLType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_en(self): return self.en
    def set_en(self, en): self.en = en
    def get_et(self): return self.et
    def set_et(self, et): self.et = et
    def get_mu(self): return self.mu
    def set_mu(self, mu): self.mu = mu
    def hasContent_(self):
        if (
            self.en is not None or
            self.et is not None or
            self.mu is not None or
            super(NewtonImpactFrictionNSLType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NewtonImpactFrictionNSLType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NewtonImpactFrictionNSLType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NewtonImpactFrictionNSLType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NewtonImpactFrictionNSLType'):
        super(NewtonImpactFrictionNSLType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NewtonImpactFrictionNSLType')
    def exportChildren(self, outfile, level, namespace_='', name_='NewtonImpactFrictionNSLType', fromsubclass_=False, pretty_print=True):
        super(NewtonImpactFrictionNSLType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.en is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sen>%s</%sen>%s' % (namespace_, self.gds_format_double(self.en, input_name='en'), namespace_, eol_))
        if self.et is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%set>%s</%set>%s' % (namespace_, self.gds_format_double(self.et, input_name='et'), namespace_, eol_))
        if self.mu is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smu>%s</%smu>%s' % (namespace_, self.gds_format_double(self.mu, input_name='mu'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='NewtonImpactFrictionNSLType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NewtonImpactFrictionNSLType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NewtonImpactFrictionNSLType, self).exportLiteralChildren(outfile, level, name_)
        if self.en is not None:
            showIndent(outfile, level)
            outfile.write('en=%e,\n' % self.en)
        if self.et is not None:
            showIndent(outfile, level)
            outfile.write('et=%e,\n' % self.et)
        if self.mu is not None:
            showIndent(outfile, level)
            outfile.write('mu=%e,\n' % self.mu)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NewtonImpactFrictionNSLType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'en':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'en')
            self.en = fval_
        elif nodeName_ == 'et':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'et')
            self.et = fval_
        elif nodeName_ == 'mu':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'mu')
            self.mu = fval_
        super(NewtonImpactFrictionNSLType, self).buildChildren(child_, node, nodeName_, True)
# end class NewtonImpactFrictionNSLType


class ComplementarityConditionNSLType(NSL):
    subclass = None
    superclass = NSL
    def __init__(self, size=None):
        super(ComplementarityConditionNSLType, self).__init__(size, )
        pass
    def factory(*args_, **kwargs_):
        if ComplementarityConditionNSLType.subclass:
            return ComplementarityConditionNSLType.subclass(*args_, **kwargs_)
        else:
            return ComplementarityConditionNSLType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ComplementarityConditionNSLType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ComplementarityConditionNSLType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ComplementarityConditionNSLType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ComplementarityConditionNSLType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ComplementarityConditionNSLType'):
        super(ComplementarityConditionNSLType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ComplementarityConditionNSLType')
    def exportChildren(self, outfile, level, namespace_='', name_='ComplementarityConditionNSLType', fromsubclass_=False, pretty_print=True):
        super(ComplementarityConditionNSLType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='ComplementarityConditionNSLType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ComplementarityConditionNSLType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ComplementarityConditionNSLType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ComplementarityConditionNSLType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ComplementarityConditionNSLType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ComplementarityConditionNSLType


class SimulationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, TimeDiscretisation=None, OneStepIntegrator_LMGC90=None, OneStepIntegrator_Definition=None, OneStepNSProblems_List=None):
        self.type_ = _cast(None, type_)
        self.TimeDiscretisation = TimeDiscretisation
        self.OneStepIntegrator_LMGC90 = OneStepIntegrator_LMGC90
        self.OneStepIntegrator_Definition = OneStepIntegrator_Definition
        self.OneStepNSProblems_List = OneStepNSProblems_List
    def factory(*args_, **kwargs_):
        if SimulationType.subclass:
            return SimulationType.subclass(*args_, **kwargs_)
        else:
            return SimulationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_TimeDiscretisation(self): return self.TimeDiscretisation
    def set_TimeDiscretisation(self, TimeDiscretisation): self.TimeDiscretisation = TimeDiscretisation
    def get_OneStepIntegrator_LMGC90(self): return self.OneStepIntegrator_LMGC90
    def set_OneStepIntegrator_LMGC90(self, OneStepIntegrator_LMGC90): self.OneStepIntegrator_LMGC90 = OneStepIntegrator_LMGC90
    def get_OneStepIntegrator_Definition(self): return self.OneStepIntegrator_Definition
    def set_OneStepIntegrator_Definition(self, OneStepIntegrator_Definition): self.OneStepIntegrator_Definition = OneStepIntegrator_Definition
    def get_OneStepNSProblems_List(self): return self.OneStepNSProblems_List
    def set_OneStepNSProblems_List(self, OneStepNSProblems_List): self.OneStepNSProblems_List = OneStepNSProblems_List
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_PossibleSimulationValues(self, value):
        # Validate type PossibleSimulationValues, a restriction on xsd:string.
        pass
    def hasContent_(self):
        if (
            self.TimeDiscretisation is not None or
            self.OneStepIntegrator_LMGC90 is not None or
            self.OneStepIntegrator_Definition is not None or
            self.OneStepNSProblems_List is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SimulationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SimulationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SimulationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SimulationType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SimulationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TimeDiscretisation is not None:
            self.TimeDiscretisation.export(outfile, level, namespace_, name_='TimeDiscretisation', pretty_print=pretty_print)
        if self.OneStepIntegrator_LMGC90 is not None:
            self.OneStepIntegrator_LMGC90.export(outfile, level, namespace_, name_='OneStepIntegrator_LMGC90', pretty_print=pretty_print)
        if self.OneStepIntegrator_Definition is not None:
            self.OneStepIntegrator_Definition.export(outfile, level, namespace_, name_='OneStepIntegrator_Definition', pretty_print=pretty_print)
        if self.OneStepNSProblems_List is not None:
            self.OneStepNSProblems_List.export(outfile, level, namespace_, name_='OneStepNSProblems_List', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SimulationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.TimeDiscretisation is not None:
            showIndent(outfile, level)
            outfile.write('TimeDiscretisation=model_.TimeDiscretisationType(\n')
            self.TimeDiscretisation.exportLiteral(outfile, level, name_='TimeDiscretisation')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OneStepIntegrator_LMGC90 is not None:
            showIndent(outfile, level)
            outfile.write('OneStepIntegrator_LMGC90=model_.OneStepIntegrator_LMGC90Type(\n')
            self.OneStepIntegrator_LMGC90.exportLiteral(outfile, level, name_='OneStepIntegrator_LMGC90')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OneStepIntegrator_Definition is not None:
            showIndent(outfile, level)
            outfile.write('OneStepIntegrator_Definition=model_.OneStepIntegrator_DefinitionType(\n')
            self.OneStepIntegrator_Definition.exportLiteral(outfile, level, name_='OneStepIntegrator_Definition')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OneStepNSProblems_List is not None:
            showIndent(outfile, level)
            outfile.write('OneStepNSProblems_List=model_.OneStepNSProblems_ListType(\n')
            self.OneStepNSProblems_List.exportLiteral(outfile, level, name_='OneStepNSProblems_List')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_PossibleSimulationValues(self.type_)    # validate type PossibleSimulationValues
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'TimeDiscretisation':
            obj_ = TimeDiscretisationType.factory()
            obj_.build(child_)
            self.TimeDiscretisation = obj_
        elif nodeName_ == 'OneStepIntegrator_LMGC90':
            obj_ = OneStepIntegrator_LMGC90Type.factory()
            obj_.build(child_)
            self.OneStepIntegrator_LMGC90 = obj_
        elif nodeName_ == 'OneStepIntegrator_Definition':
            obj_ = OneStepIntegrator_DefinitionType.factory()
            obj_.build(child_)
            self.OneStepIntegrator_Definition = obj_
        elif nodeName_ == 'OneStepNSProblems_List':
            obj_ = OneStepNSProblems_ListType.factory()
            obj_.build(child_)
            self.OneStepNSProblems_List = obj_
# end class SimulationType


class TimeDiscretisationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, tk=None, h=None, N=None):
        self.tk = tk
        self.h = h
        self.N = N
    def factory(*args_, **kwargs_):
        if TimeDiscretisationType.subclass:
            return TimeDiscretisationType.subclass(*args_, **kwargs_)
        else:
            return TimeDiscretisationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tk(self): return self.tk
    def set_tk(self, tk): self.tk = tk
    def get_h(self): return self.h
    def set_h(self, h): self.h = h
    def get_N(self): return self.N
    def set_N(self, N): self.N = N
    def validate_positiveDouble(self, value):
        # Validate type positiveDouble, a restriction on xsd:double.
        pass
    def hasContent_(self):
        if (
            self.tk is not None or
            self.h is not None or
            self.N is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimeDiscretisationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeDiscretisationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimeDiscretisationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimeDiscretisationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TimeDiscretisationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.tk is not None:
            self.tk.export(outfile, level, namespace_, name_='tk', pretty_print=pretty_print)
        if self.h is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sh>%s</%sh>%s' % (namespace_, self.gds_format_double(self.h, input_name='h'), namespace_, eol_))
        if self.N is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sN>%s</%sN>%s' % (namespace_, self.gds_format_integer(self.N, input_name='N'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TimeDiscretisationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.tk is not None:
            showIndent(outfile, level)
            outfile.write('tk=model_.vector(\n')
            self.tk.exportLiteral(outfile, level, name_='tk')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.h is not None:
            showIndent(outfile, level)
            outfile.write('h=%e,\n' % self.h)
        if self.N is not None:
            showIndent(outfile, level)
            outfile.write('N=%d,\n' % self.N)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'tk':
            obj_ = vector.factory()
            obj_.build(child_)
            self.tk = obj_
        elif nodeName_ == 'h':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'h')
            self.h = fval_
            self.validate_positiveDouble(self.h)    # validate type positiveDouble
        elif nodeName_ == 'N':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'N')
            self.N = ival_
# end class TimeDiscretisationType


class OneStepIntegrator_LMGC90Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, empty=None):
        self.empty = empty
    def factory(*args_, **kwargs_):
        if OneStepIntegrator_LMGC90Type.subclass:
            return OneStepIntegrator_LMGC90Type.subclass(*args_, **kwargs_)
        else:
            return OneStepIntegrator_LMGC90Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_empty(self): return self.empty
    def set_empty(self, empty): self.empty = empty
    def hasContent_(self):
        if (
            self.empty is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OneStepIntegrator_LMGC90Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OneStepIntegrator_LMGC90Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OneStepIntegrator_LMGC90Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OneStepIntegrator_LMGC90Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OneStepIntegrator_LMGC90Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.empty is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sempty>%s</%sempty>%s' % (namespace_, self.gds_format_string(quote_xml(self.empty).encode(ExternalEncoding), input_name='empty'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='OneStepIntegrator_LMGC90Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.empty is not None:
            showIndent(outfile, level)
            outfile.write('empty=%s,\n' % quote_python(self.empty).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'empty':
            empty_ = child_.text
            empty_ = self.gds_validate_string(empty_, node, 'empty')
            self.empty = empty_
# end class OneStepIntegrator_LMGC90Type


class OneStepIntegrator_DefinitionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, MoreauJeanOSI=None, LsodarOSI=None):
        if MoreauJeanOSI is None:
            self.MoreauJeanOSI = []
        else:
            self.MoreauJeanOSI = MoreauJeanOSI
        if LsodarOSI is None:
            self.LsodarOSI = []
        else:
            self.LsodarOSI = LsodarOSI
    def factory(*args_, **kwargs_):
        if OneStepIntegrator_DefinitionType.subclass:
            return OneStepIntegrator_DefinitionType.subclass(*args_, **kwargs_)
        else:
            return OneStepIntegrator_DefinitionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MoreauJeanOSI(self): return self.MoreauJeanOSI
    def set_MoreauJeanOSI(self, MoreauJeanOSI): self.MoreauJeanOSI = MoreauJeanOSI
    def add_MoreauJeanOSI(self, value): self.MoreauJeanOSI.append(value)
    def insert_MoreauJeanOSI(self, index, value): self.MoreauJeanOSI[index] = value
    def get_LsodarOSI(self): return self.LsodarOSI
    def set_LsodarOSI(self, LsodarOSI): self.LsodarOSI = LsodarOSI
    def add_LsodarOSI(self, value): self.LsodarOSI.append(value)
    def insert_LsodarOSI(self, index, value): self.LsodarOSI[index] = value
    def hasContent_(self):
        if (
            self.MoreauJeanOSI or
            self.LsodarOSI
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OneStepIntegrator_DefinitionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OneStepIntegrator_DefinitionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OneStepIntegrator_DefinitionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OneStepIntegrator_DefinitionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OneStepIntegrator_DefinitionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MoreauJeanOSI_ in self.MoreauJeanOSI:
            MoreauJeanOSI_.export(outfile, level, namespace_, name_='MoreauJeanOSI', pretty_print=pretty_print)
        for LsodarOSI_ in self.LsodarOSI:
            LsodarOSI_.export(outfile, level, namespace_, name_='LsodarOSI', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OneStepIntegrator_DefinitionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('MoreauJeanOSI=[\n')
        level += 1
        for MoreauJeanOSI_ in self.MoreauJeanOSI:
            showIndent(outfile, level)
            outfile.write('model_.MoreauJeanOSIType(\n')
            MoreauJeanOSI_.exportLiteral(outfile, level, name_='MoreauJeanOSIType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('LsodarOSI=[\n')
        level += 1
        for LsodarOSI_ in self.LsodarOSI:
            showIndent(outfile, level)
            outfile.write('model_.LsodarOSIType(\n')
            LsodarOSI_.exportLiteral(outfile, level, name_='LsodarOSIType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MoreauJeanOSI':
            obj_ = MoreauJeanOSIType.factory()
            obj_.build(child_)
            self.MoreauJeanOSI.append(obj_)
        elif nodeName_ == 'LsodarOSI':
            obj_ = LsodarOSIType.factory()
            obj_.build(child_)
            self.LsodarOSI.append(obj_)
# end class OneStepIntegrator_DefinitionType


class MoreauJeanOSIType(OSI):
    subclass = None
    superclass = OSI
    def __init__(self, DS_Concerned=None, Interactions_Concerned=None, Theta=None):
        super(MoreauJeanOSIType, self).__init__(DS_Concerned, Interactions_Concerned, )
        self.Theta = Theta
    def factory(*args_, **kwargs_):
        if MoreauJeanOSIType.subclass:
            return MoreauJeanOSIType.subclass(*args_, **kwargs_)
        else:
            return MoreauJeanOSIType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Theta(self): return self.Theta
    def set_Theta(self, Theta): self.Theta = Theta
    def hasContent_(self):
        if (
            self.Theta is not None or
            super(MoreauJeanOSIType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MoreauJeanOSIType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MoreauJeanOSIType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MoreauJeanOSIType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MoreauJeanOSIType'):
        super(MoreauJeanOSIType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MoreauJeanOSIType')
    def exportChildren(self, outfile, level, namespace_='', name_='MoreauJeanOSIType', fromsubclass_=False, pretty_print=True):
        super(MoreauJeanOSIType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Theta is not None:
            self.Theta.export(outfile, level, namespace_, name_='Theta', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MoreauJeanOSIType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MoreauJeanOSIType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MoreauJeanOSIType, self).exportLiteralChildren(outfile, level, name_)
        if self.Theta is not None:
            showIndent(outfile, level)
            outfile.write('Theta=model_.emptyType(\n')
            self.Theta.exportLiteral(outfile, level, name_='Theta')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MoreauJeanOSIType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Theta':
            obj_ = emptyType.factory()
            obj_.build(child_)
            self.Theta = obj_
        super(MoreauJeanOSIType, self).buildChildren(child_, node, nodeName_, True)
# end class MoreauJeanOSIType


class LsodarOSIType(OSI):
    subclass = None
    superclass = OSI
    def __init__(self, DS_Concerned=None, Interactions_Concerned=None):
        super(LsodarOSIType, self).__init__(DS_Concerned, Interactions_Concerned, )
        pass
    def factory(*args_, **kwargs_):
        if LsodarOSIType.subclass:
            return LsodarOSIType.subclass(*args_, **kwargs_)
        else:
            return LsodarOSIType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(LsodarOSIType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LsodarOSIType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LsodarOSIType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LsodarOSIType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LsodarOSIType'):
        super(LsodarOSIType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LsodarOSIType')
    def exportChildren(self, outfile, level, namespace_='', name_='LsodarOSIType', fromsubclass_=False, pretty_print=True):
        super(LsodarOSIType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LsodarOSIType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LsodarOSIType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LsodarOSIType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LsodarOSIType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LsodarOSIType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class LsodarOSIType


class OneStepNSProblems_ListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, LCP=None, FrictionContact=None, QP=None, Relay=None):
        if LCP is None:
            self.LCP = []
        else:
            self.LCP = LCP
        if FrictionContact is None:
            self.FrictionContact = []
        else:
            self.FrictionContact = FrictionContact
        if QP is None:
            self.QP = []
        else:
            self.QP = QP
        if Relay is None:
            self.Relay = []
        else:
            self.Relay = Relay
    def factory(*args_, **kwargs_):
        if OneStepNSProblems_ListType.subclass:
            return OneStepNSProblems_ListType.subclass(*args_, **kwargs_)
        else:
            return OneStepNSProblems_ListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_LCP(self): return self.LCP
    def set_LCP(self, LCP): self.LCP = LCP
    def add_LCP(self, value): self.LCP.append(value)
    def insert_LCP(self, index, value): self.LCP[index] = value
    def get_FrictionContact(self): return self.FrictionContact
    def set_FrictionContact(self, FrictionContact): self.FrictionContact = FrictionContact
    def add_FrictionContact(self, value): self.FrictionContact.append(value)
    def insert_FrictionContact(self, index, value): self.FrictionContact[index] = value
    def get_QP(self): return self.QP
    def set_QP(self, QP): self.QP = QP
    def add_QP(self, value): self.QP.append(value)
    def insert_QP(self, index, value): self.QP[index] = value
    def get_Relay(self): return self.Relay
    def set_Relay(self, Relay): self.Relay = Relay
    def add_Relay(self, value): self.Relay.append(value)
    def insert_Relay(self, index, value): self.Relay[index] = value
    def hasContent_(self):
        if (
            self.LCP or
            self.FrictionContact or
            self.QP or
            self.Relay
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OneStepNSProblems_ListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OneStepNSProblems_ListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OneStepNSProblems_ListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OneStepNSProblems_ListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OneStepNSProblems_ListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for LCP_ in self.LCP:
            LCP_.export(outfile, level, namespace_, name_='LCP', pretty_print=pretty_print)
        for FrictionContact_ in self.FrictionContact:
            FrictionContact_.export(outfile, level, namespace_, name_='FrictionContact', pretty_print=pretty_print)
        for QP_ in self.QP:
            QP_.export(outfile, level, namespace_, name_='QP', pretty_print=pretty_print)
        for Relay_ in self.Relay:
            Relay_.export(outfile, level, namespace_, name_='Relay', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OneStepNSProblems_ListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('LCP=[\n')
        level += 1
        for LCP_ in self.LCP:
            showIndent(outfile, level)
            outfile.write('model_.LCPType(\n')
            LCP_.exportLiteral(outfile, level, name_='LCPType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('FrictionContact=[\n')
        level += 1
        for FrictionContact_ in self.FrictionContact:
            showIndent(outfile, level)
            outfile.write('model_.FrictionContactType(\n')
            FrictionContact_.exportLiteral(outfile, level, name_='FrictionContactType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('QP=[\n')
        level += 1
        for QP_ in self.QP:
            showIndent(outfile, level)
            outfile.write('model_.QPType(\n')
            QP_.exportLiteral(outfile, level, name_='QPType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Relay=[\n')
        level += 1
        for Relay_ in self.Relay:
            showIndent(outfile, level)
            outfile.write('model_.RelayType(\n')
            Relay_.exportLiteral(outfile, level, name_='RelayType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'LCP':
            obj_ = LCPType.factory()
            obj_.build(child_)
            self.LCP.append(obj_)
        elif nodeName_ == 'FrictionContact':
            obj_ = FrictionContactType.factory()
            obj_.build(child_)
            self.FrictionContact.append(obj_)
        elif nodeName_ == 'QP':
            obj_ = QPType.factory()
            obj_.build(child_)
            self.QP.append(obj_)
        elif nodeName_ == 'Relay':
            obj_ = RelayType.factory()
            obj_.build(child_)
            self.Relay.append(obj_)
# end class OneStepNSProblems_ListType


class LCPType(OSNSP):
    subclass = None
    superclass = OSNSP
    def __init__(self, StorageType=None, Id=None, NonSmoothSolver=None):
        super(LCPType, self).__init__(StorageType, Id, NonSmoothSolver, )
        pass
    def factory(*args_, **kwargs_):
        if LCPType.subclass:
            return LCPType.subclass(*args_, **kwargs_)
        else:
            return LCPType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(LCPType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LCPType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LCPType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LCPType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LCPType'):
        super(LCPType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LCPType')
    def exportChildren(self, outfile, level, namespace_='', name_='LCPType', fromsubclass_=False, pretty_print=True):
        super(LCPType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LCPType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(LCPType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LCPType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LCPType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LCPType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class LCPType


class FrictionContactType(OSNSP):
    subclass = None
    superclass = OSNSP
    def __init__(self, StorageType=None, Id=None, NonSmoothSolver=None, Type=None):
        super(FrictionContactType, self).__init__(StorageType, Id, NonSmoothSolver, )
        self.Type = _cast(int, Type)
        pass
    def factory(*args_, **kwargs_):
        if FrictionContactType.subclass:
            return FrictionContactType.subclass(*args_, **kwargs_)
        else:
            return FrictionContactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def hasContent_(self):
        if (
            super(FrictionContactType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FrictionContactType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FrictionContactType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FrictionContactType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FrictionContactType'):
        super(FrictionContactType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FrictionContactType')
        if self.Type is not None and 'Type' not in already_processed:
            already_processed.add('Type')
            outfile.write(' Type="%s"' % self.gds_format_integer(self.Type, input_name='Type'))
    def exportChildren(self, outfile, level, namespace_='', name_='FrictionContactType', fromsubclass_=False, pretty_print=True):
        super(FrictionContactType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FrictionContactType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Type is not None and 'Type' not in already_processed:
            already_processed.add('Type')
            showIndent(outfile, level)
            outfile.write('Type=%d,\n' % (self.Type,))
        super(FrictionContactType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FrictionContactType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Type', node)
        if value is not None and 'Type' not in already_processed:
            already_processed.add('Type')
            try:
                self.Type = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.Type <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(FrictionContactType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FrictionContactType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FrictionContactType


class QPType(OSNSP):
    subclass = None
    superclass = OSNSP
    def __init__(self, StorageType=None, Id=None, NonSmoothSolver=None, Q=None, p=None):
        super(QPType, self).__init__(StorageType, Id, NonSmoothSolver, )
        self.Q = Q
        self.p = p
    def factory(*args_, **kwargs_):
        if QPType.subclass:
            return QPType.subclass(*args_, **kwargs_)
        else:
            return QPType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Q(self): return self.Q
    def set_Q(self, Q): self.Q = Q
    def get_p(self): return self.p
    def set_p(self, p): self.p = p
    def hasContent_(self):
        if (
            self.Q is not None or
            self.p is not None or
            super(QPType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QPType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QPType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QPType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QPType'):
        super(QPType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QPType')
    def exportChildren(self, outfile, level, namespace_='', name_='QPType', fromsubclass_=False, pretty_print=True):
        super(QPType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Q is not None:
            self.Q.export(outfile, level, namespace_, name_='Q', pretty_print=pretty_print)
        if self.p is not None:
            self.p.export(outfile, level, namespace_, name_='p', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='QPType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(QPType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QPType, self).exportLiteralChildren(outfile, level, name_)
        if self.Q is not None:
            showIndent(outfile, level)
            outfile.write('Q=model_.matrix(\n')
            self.Q.exportLiteral(outfile, level, name_='Q')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.p is not None:
            showIndent(outfile, level)
            outfile.write('p=model_.vector(\n')
            self.p.exportLiteral(outfile, level, name_='p')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(QPType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Q':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.Q = obj_
        elif nodeName_ == 'p':
            obj_ = vector.factory()
            obj_.build(child_)
            self.p = obj_
        super(QPType, self).buildChildren(child_, node, nodeName_, True)
# end class QPType


class RelayType(OSNSP):
    subclass = None
    superclass = OSNSP
    def __init__(self, StorageType=None, Id=None, NonSmoothSolver=None, M=None, q=None):
        super(RelayType, self).__init__(StorageType, Id, NonSmoothSolver, )
        self.M = M
        self.q = q
    def factory(*args_, **kwargs_):
        if RelayType.subclass:
            return RelayType.subclass(*args_, **kwargs_)
        else:
            return RelayType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_M(self): return self.M
    def set_M(self, M): self.M = M
    def get_q(self): return self.q
    def set_q(self, q): self.q = q
    def hasContent_(self):
        if (
            self.M is not None or
            self.q is not None or
            super(RelayType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RelayType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RelayType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='RelayType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RelayType'):
        super(RelayType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RelayType')
    def exportChildren(self, outfile, level, namespace_='', name_='RelayType', fromsubclass_=False, pretty_print=True):
        super(RelayType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.M is not None:
            self.M.export(outfile, level, namespace_, name_='M', pretty_print=pretty_print)
        if self.q is not None:
            self.q.export(outfile, level, namespace_, name_='q', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='RelayType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RelayType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RelayType, self).exportLiteralChildren(outfile, level, name_)
        if self.M is not None:
            showIndent(outfile, level)
            outfile.write('M=model_.matrix(\n')
            self.M.exportLiteral(outfile, level, name_='M')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.q is not None:
            showIndent(outfile, level)
            outfile.write('q=model_.vector(\n')
            self.q.exportLiteral(outfile, level, name_='q')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(RelayType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'M':
            obj_ = matrix.factory()
            obj_.build(child_)
            self.M = obj_
        elif nodeName_ == 'q':
            obj_ = vector.factory()
            obj_.build(child_)
            self.q = obj_
        super(RelayType, self).buildChildren(child_, node, nodeName_, True)
# end class RelayType


GDSClassesMapping = {
    'QP': QPType,
    'indexList': vector,
    'Velocity0': vector,
    'MoreauJeanOSI': MoreauJeanOSIType,
    'FirstOrderLinearR': FirstOrderLinearRType,
    'NewtonImpactNSL': NewtonImpactNSLType,
    'iparam': vector,
    'LsodarOSI': LsodarOSIType,
    'FGyr': vector,
    'Interaction': InteractionType,
    'LagrangianRheonomousR': LagrangianRheonomousRType,
    'LagrangianLinearTIDS': LagrangianLinearTIDSType,
    'OneStepIntegrator_LMGC90': OneStepIntegrator_LMGC90Type,
    'Theta': emptyType,
    'NSDS': NSDSType,
    'JacobianDothq': pluginDef,
    'Jacobianhq': pluginDef,
    'ComplementarityConditionNSL': ComplementarityConditionNSLType,
    'D': matrix,
    'FirstOrderLinearDS': FirstOrderLinearDSType,
    'q0': vector,
    'FirstOrderLinearTIDS': FirstOrderLinearTIDSType,
    'Linear': LinearType,
    'FirstOrderNonLinearDS': FirstOrderNonLinearDSType,
    'NewtonImpactFrictionNSL': NewtonImpactFrictionNSLType,
    'F': matrix,
    'JacobianDoth': pluginDef,
    'Omega0': matrix,
    'jacobianG': listOfMatrices,
    'Q': matrix,
    'tk': vector,
    'RelayNSL': RelayNSLType,
    'DS_Definition': DS_DefinitionType,
    'OmegaT': matrix,
    'OneStepIntegrator_Definition': OneStepIntegrator_DefinitionType,
    'Omega': vector,
    'LagrangianCompliantR': LagrangianCompliantRType,
    'A': matrix,
    'C': matrix,
    'Jacobianfx': matrix,
    'FrictionContact': FrictionContactType,
    'Interaction_Content': Interaction_ContentType,
    'Interaction_Definition': Interaction_DefinitionType,
    'FExt': vector,
    'Jacobianhlambda': pluginDef,
    'FirstOrderLinearTIR': FirstOrderLinearTIRType,
    'K': matrix,
    'M': matrix,
    'FInt': vector,
    'Simulation': SimulationType,
    'JacobianQFInt': matrix,
    'LagrangianScleronomousR': LagrangianScleronomousRType,
    'Periodic': PeriodicType,
    'Mass': matrix,
    'NLinear': NLinearType,
    'Time': ModelTime,
    'dparam': vector,
    'x0': vector,
    'DS_LMGC90': DS_LMGC90Type,
    'OneStepNSProblems_List': OneStepNSProblems_ListType,
    'LagrangianDS': LagrangianDSType,
    'Relay': RelayType,
    'JacobianQFGyr': matrix,
    'b': vector,
    'e': vector,
    'LCP': LCPType,
    'g': pluginDef,
    'f': vector,
    'h': pluginDef,
    'TimeDiscretisation': TimeDiscretisationType,
    'q': vector,
    'p': vector,
    'jacobianH': listOfMatrices,
    'LagrangianLinearTIR': LagrangianLinearTIRType,
    'FirstOrderR': FirstOrderRType,
    'B': matrix,
    'JacobianVelocityFInt': matrix,
    'JacobianVelocityFGyr': matrix,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'pluginDef'
        rootClass = pluginDef
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'pluginDef'
        rootClass = pluginDef
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from io import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    roots = get_root_tag(rootNode)
    rootClass = roots[1]
    if rootClass is None:
        rootClass = pluginDef
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_="pluginDef",
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'pluginDef'
        rootClass = pluginDef
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from SiconosXMLParser import *\n\n')
        sys.stdout.write('import SiconosXMLParser as model_\n\n')
        sys.stdout.write('rootObj = model_.rootTag(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "BoundaryCondition",
    "ComplementarityConditionNSLType",
    "DS_DefinitionType",
    "DS_LMGC90Type",
    "FirstOrderLinearDSType",
    "FirstOrderLinearRType",
    "FirstOrderLinearTIDSType",
    "FirstOrderLinearTIRType",
    "FirstOrderNonLinearDSType",
    "FirstOrderRType",
    "FrictionContactType",
    "InteractionType",
    "Interaction_ContentType",
    "Interaction_DefinitionType",
    "LCPType",
    "LagrangianCompliantRType",
    "LagrangianDSType",
    "LagrangianLinearTIDSType",
    "LagrangianLinearTIRType",
    "LagrangianRheonomousRType",
    "LagrangianScleronomousRType",
    "LinearType",
    "LsodarOSIType",
    "ModelTime",
    "MoreauJeanOSIType",
    "NLinearType",
    "NSDSType",
    "NSL",
    "NewtonImpactFrictionNSLType",
    "NewtonImpactNSLType",
    "NonSmoothSolver",
    "OSI",
    "OSNSP",
    "OneStepIntegrator_DefinitionType",
    "OneStepIntegrator_LMGC90Type",
    "OneStepNSProblems_ListType",
    "PeriodicType",
    "QPType",
    "RelayNSLType",
    "RelayType",
    "SiconosModel",
    "SimulationType",
    "TimeDiscretisationType",
    "emptyType",
    "index_list",
    "listOfMatrices",
    "matrix",
    "matrixData",
    "matrixFile",
    "matrixPlugin",
    "pluginDef",
    "vector"
]
