// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2013, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================
// Author: Jochen Singer <jochen.singer@fu-berlin.de>
// ==========================================================================
// This file coordinates the calls of tests to ensure that the sequence
// module fulfills the requirements.
// ==========================================================================
#include <seqan/basic.h>
// #include <seqan/file.h>

#include "test_sequence.h"
// #include "test_segment_beta.h"
// #include "test_string_set.h"

// SEQAN_BEGIN_TESTSUITE(test_sequence_concept)
// {
// --------------------------------------------------------------------------
// Testing Alloc Strings With Simple Types
// --------------------------------------------------------------------------
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_default_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_default_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_less);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_less);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_less);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_less);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_less);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_less);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_less);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_less);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_less);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_less);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_less);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_less);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_less);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_less_equal);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_greater);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_greater);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_greater);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_greater);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_greater);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_greater);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_greater);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_greater);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_greater);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_greater_equal);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_equal);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_equal);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_equal);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_equal);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_unequal);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_append);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_append);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_append);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_append);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_append);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_append);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_append);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_append);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_append);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_append);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_append);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_append);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_append);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_append);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_append);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_append);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_append);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_append);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_append);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_append);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_append);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_append);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_append);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_append);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_append_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_append_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_append_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_append_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_append_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_append_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_append_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_append_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_append_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_append_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_append_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_append_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_append_value);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_append_value);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_assignable);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_assignable);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_assignable);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_assignable);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_assignable);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_assignable);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_assignable);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_assignable);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_assignable);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_assignable);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_assignable);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_assignable);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_assignable);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_assignable);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_assign_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_assign_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_assign_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_assign_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_assign_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_assign_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_assign_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_assign_value);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_back);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_back);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_back);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_back);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_back);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_back);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_back);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_back);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_begin);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_begin);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_begin);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_begin);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_begin);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_begin);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_begin);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_begin);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_begin);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_begin);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_begin);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_begin);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_begin);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_begin);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_begin);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_begin);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_begin);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_begin);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_begin);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_begin_position);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_begin_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_begin_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_begin_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_begin_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_begin_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_begin_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_begin_position);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_capacity);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_capacity);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_capacity);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_capacity);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_capacity);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_capacity);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_capacity);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_capacity);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_capacity);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_capacity);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_capacity);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_capacity);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_capacity);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_capacity);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_clear);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_clear);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_clear);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_clear);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_clear);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_clear);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_clear);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_clear);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_clear);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_clear);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_clear);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_clear);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_clear);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_clear);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_clear);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_clear);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_clear);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_clear);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_clear);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_end);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_end);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_end);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_end);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_end);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_end);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_end);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_end);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_end);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_end);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_end);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_end);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_end);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_end);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_end);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_end);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_end);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_end);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_end);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_end);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_end);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_end);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_end);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_end);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_end);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_end_position);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_end_position);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_end_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_end_position);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_end_position);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_end_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_end_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_end_position);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_erase);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_erase);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_erase);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_erase);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_erase);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_erase);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_erase);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_erase);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_erase);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_erase);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_erase);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_erase);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_erase);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_erase);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_erase);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_erase);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_erase);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_erase);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_erase);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_erase);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_erase);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_erase);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_erase);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_erase);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_erase);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_erase_back);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_erase_back);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_erase_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_erase_back);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_erase_back);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_erase_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_erase_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_erase_back);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_erase_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_erase_back);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_erase_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_erase_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_erase_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_erase_back);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_front);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_front);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_front);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_front);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_front);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_front);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_front);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_front);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_front);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_front);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_front);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_front);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_front);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_front);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_front);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_front);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_front);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_front);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_front);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_front);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_front);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_front);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_front);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_front);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_front);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_get_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_get_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_get_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_get_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_get_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_get_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_get_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_get_value);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_insert);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_insert);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_insert);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_insert);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_insert);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_insert);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_insert);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_insert);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_insert);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_insert);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_insert);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_insert);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_insert);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_insert);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_insert);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_insert);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_insert);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_insert);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_insert);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_insert);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_insert);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_insert);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_insert);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_insert);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_insert_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_insert_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_insert_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_insert_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_insert_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_insert_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_insert_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_insert_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_insert_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_insert_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_insert_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_insert_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_insert_value);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_insert_value);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_iter);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_iter);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_iter);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_iter);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_iter);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_iter);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_iter);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_iter);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_iter);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_iter);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_iter);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_iter);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_iter);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_iter);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_iter);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_iter);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_iter);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_iter);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_length);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_length);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_length);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_length);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_length);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_length);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_length);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_length);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_length);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_length);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_length);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_length);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_length);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_length);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_length);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_length);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_length);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_length);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_length);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_length);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_length);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_length);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_length);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_length);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_move_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_move_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_move_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_move_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_move_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_move_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_move_value);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_move_value);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_replace);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_replace);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_replace);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_replace);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_replace);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_replace);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_replace);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_replace);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_replace);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_replace);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_replace);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_replace);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_replace);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_replace);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_replace);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_replace);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_replace);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_replace);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_replace);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_replace);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_replace);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_replace);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_replace);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_replace);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_reserve);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_reserve);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_reserve);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_reserve);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_reserve);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_reserve);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_reserve);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_reserve);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_reserve);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_reserve);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_reserve);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_reserve);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_reserve);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_reserve);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_resize);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_resize);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_resize);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_resize);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_resize);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_resize);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_resize);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_resize);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_resize);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_resize);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_resize);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_resize);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_resize);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_resize);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_resize);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_resize);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_resize);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_resize);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_swap);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_swap);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_swap);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_swap);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_swap);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_swap);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_swap);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_swap);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_swap);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_swap);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_swap);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_swap);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_swap);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_swap);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_swap);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_swap);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_swap);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_swap);
//
//     SEQAN_CALL_TEST(test_sequence_external_string_dna_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_char_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_short_value);
//     SEQAN_CALL_TEST(test_sequence_external_string_counting_char_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_dna_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_char_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_short_value);
//     SEQAN_CALL_TEST(test_sequence_mmap_string_counting_char_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_dna_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_char_value);
//     SEQAN_CALL_TEST(test_sequence_packed_string_short_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_dna_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_char_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_short_value);
//     SEQAN_CALL_TEST(test_sequence_array_string_counting_char_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_dna_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_char_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_short_value);
//     SEQAN_CALL_TEST(test_sequence_block_string_counting_char_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_dna_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_char_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_short_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_counting_char_value);
//     SEQAN_CALL_TEST(test_sequence_cstyle_string_char_value);

// --------------------------------------------------------------------------
// Testing Alloc Segments With Simple Types
// (Alloc Segments = Segments of Alloc Strings)
// --------------------------------------------------------------------------
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_infix_char_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_prefix_char_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_dna_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_short_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_counting_char_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_suffix_char_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_infix_char_copy_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_prefix_char_copy_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_short_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_counting_char_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_suffix_char_copy_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_infix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_infix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_infix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_infix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_infix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_infix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_infix_char_default_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_prefix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_prefix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_prefix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_prefix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_prefix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_prefix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_prefix_char_default_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_external_segment_suffix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_suffix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_suffix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_array_segment_suffix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_block_segment_suffix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_short_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_suffix_counting_char_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_suffix_char_default_constructible);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_dna_less);
//     SEQAN_CALL_TEST(test_sequence_external_segment_char_less);
//     SEQAN_CALL_TEST(test_sequence_external_segment_short_less);
//     SEQAN_CALL_TEST(test_sequence_external_segment_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_dna_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_char_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_short_less);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_dna_less);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_char_less);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_short_less);
//     SEQAN_CALL_TEST(test_sequence_array_segment_dna_less);
//     SEQAN_CALL_TEST(test_sequence_array_segment_char_less);
//     SEQAN_CALL_TEST(test_sequence_array_segment_short_less);
//     SEQAN_CALL_TEST(test_sequence_array_segment_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_block_segment_dna_less);
//     SEQAN_CALL_TEST(test_sequence_block_segment_char_less);
//     SEQAN_CALL_TEST(test_sequence_block_segment_short_less);
//     SEQAN_CALL_TEST(test_sequence_block_segment_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_char_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_short_less);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_counting_char_less);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_char_less);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_short_less_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_counting_char_less_equal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_char_less_equal);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_external_segment_char_greater);
//     SEQAN_CALL_TEST(test_sequence_external_segment_short_greater);
//     SEQAN_CALL_TEST(test_sequence_external_segment_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_char_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_short_greater);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_char_greater);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_short_greater);
//     SEQAN_CALL_TEST(test_sequence_array_segment_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_array_segment_char_greater);
//     SEQAN_CALL_TEST(test_sequence_array_segment_short_greater);
//     SEQAN_CALL_TEST(test_sequence_array_segment_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_block_segment_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_block_segment_char_greater);
//     SEQAN_CALL_TEST(test_sequence_block_segment_short_greater);
//     SEQAN_CALL_TEST(test_sequence_block_segment_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_char_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_short_greater);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_counting_char_greater);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_char_greater);
//
//     SEQAN_CALL_TEST(test_sequence_external_segment_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_short_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_counting_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_char_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_char_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_short_equal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_char_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_short_equal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_char_equal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_short_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_char_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_short_equal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_char_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_short_equal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_char_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_short_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_counting_char_equal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_char_equal);

//     SEQAN_CALL_TEST(test_sequence_external_segment_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_external_segment_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_mmap_segment_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_packed_segment_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_array_segment_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_block_segment_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_short_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_counting_char_unequal);
//     SEQAN_CALL_TEST(test_sequence_cstyle_segment_char_unequal);
//
//
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_constructible);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_copy_constructible);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_default_constructible);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_less);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_less_equal);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_greater);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_greater_equal);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_equal);
// //     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_unequal);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_assignable);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_end);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_front);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_length);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_replace);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_alloc_segment_dna_value);
//
// /*
//  * Not tested: append(), appendValue(), capacity(), erase(), eraseBack(),
//  * insert(), insertValue(), reserve().
//  */
//
//     // --------------------------------------------------------------------------
//     // Testing Alloc Strings With Simple Types
//     // --------------------------------------------------------------------------
//
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_copy_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_default_constructible);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_less_greater_equal);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_append);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_append_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_assign);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_assign_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_assign_value_by_id);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_begin);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_begin_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_clear);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_concat);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_end);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_end_position);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_erase);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_erase_back);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_front);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_get_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_get_value_by_id);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_infix);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_infix_with_length);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_iter);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_length);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_move_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_prefix);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_resize);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_suffix);
// //     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_swap);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_value);
//     SEQAN_CALL_TEST(test_sequence_alloc_string_set_dna_value_by_id);

// swap() is not working
/*
 * Not tested: capacity(), eraseBack(), replace(), insert(), insertValue(), replace().
 */

int main(int argc, char const ** argv) {
    seqan::TestSystem::init(argc, argv);
    return seqan::TestSystem::runAll();
}

// }
// SEQAN_END_TESTSUITE
