/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009 - DIGITEO - Vincent COUVERT
 * Copyright (C) 2010 - DIGITEO - Clement DAVID
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.txt
 *
 */
package org.scilab.modules.graph.utils;

import org.scilab.modules.localization.Messages;

/**
 * Internationalized messages for this graph
 */
public final class ScilabGraphMessages {

    public static final String COPY = Messages.gettext("Copy");
    public static final String CUT = Messages.gettext("Cut");
    public static final String GROUP = Messages.gettext("Group");
    public static final String UNGROUP = Messages.gettext("UnGroup");
    public static final String PASTE = Messages.gettext("Paste");
    public static final String REDO = Messages.gettext("Redo");
    public static final String UNDO = Messages.gettext("Undo");
    public static final String ZOOM_IN = Messages.gettext("Zoom In");
    public static final String ZOOM_OUT = Messages.gettext("Zoom Out");
    public static final String DELETE = Messages.gettext("Delete");
    public static final String SELECT_ALL = Messages.gettext("Select all");
    public static final String INVERT_SELECTION = Messages.gettext("Invert selection");
    public static final String UNTITLED = Messages.gettext("Untitled - %s");

    /** This class is a static singleton, thus it must not be instantiated */
    private ScilabGraphMessages() {
    }

}
