//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2016 - INRIA - Serge Steer
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
a=0.9;b=1;c=1;
sl=syslin("d",a,b,c);
h=ss2tf(sl);
y=flts([1 0 0 0 ],sl);
assert_checkalmostequal(y,[0 a.^(0:2)]);
y=flts([1 0 0 0 ],zpk(sl));
assert_checkalmostequal(y,[0 a.^(0:2)]);


[y,x]=flts([1 0 0 0 ],sl);
assert_checkalmostequal(y,[0 a.^(0:2)]);
assert_checkalmostequal(x,a^3);


y=flts([1 0 0 0 ],sl,1);
assert_checkalmostequal(y,[0 a.^(0:2)]+a.^(0:3));

[y,x]=flts([1 0 0 0 ],sl,1);
assert_checkalmostequal(y,[0 a.^(0:2)]+a.^(0:3));
assert_checkalmostequal(x,a^3+a^4);

y=flts([1 0 0 0 ],h);
assert_checkalmostequal(y,[0 a.^(0:2)]);

y=flts([1 0 0 0 ],zpk(h));
assert_checkalmostequal(y,[0 a.^(0:2)]);

y=flts([1 0 0 0 ],[sl;sl+1]);
assert_checkalmostequal(y,[0 a.^(0:2);1 a.^(0:2)]);

y=flts([1 0 0 0 ],[h;h+1]);
assert_checkalmostequal(y,[0 a.^(0:2);1 a.^(0:2)]);
y=flts([1 0 0 0 ],zpk([h;h+1]));
assert_checkalmostequal(y,[0 a.^(0:2);1 a.^(0:2)]);
