// ============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2011-2011 - Gsoc 2011 - Iuri SILVIO
// Copyright (C) 2017-2017 - Gsoc 2017 - Siddhartha Gairola
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================

// <-- CLI SHELL MODE -->
// ============================================================================
// Unitary tests for mxSetDimentsions mex function
// ============================================================================

cd(TMPDIR);
ilib_verbose(0);
mputl(["#include ""mex.h""";
"void mexFunction(int nlhs, mxArray *plhs[], int nrhs, mxArray *prhs[])";
"{";
"    int dims[2] = {1,3};";
"    plhs[0] = mxDuplicateArray(prhs[0]);";
"    mxSetDimensions(plhs[0], dims, 2);";
"}"],"mexsetDimensions.c");
ilib_mex_build("libmextest",["setDimensions","mexsetDimensions","cmex"], "mexsetDimensions.c",[]);
exec("loader.sce");

a = 3;
b = setDimensions(a);
assert_checkequal(size(b), [1 3]);
assert_checkequal(b(1), 3);
//checking if it works for sparse matrices
sp = sparse([1]);
c = setDimensions(sp);
assert_checkequal(size(c), [1 3]);
assert_checkequal(c(1), sparse(1));
sp2 = sparse([1 2]);
d = setDimensions(sp2);
assert_checkequal(size(d), [1 3]);
assert_checkequal(d(1,1), sparse(1));
assert_checkequal(d(1,2), sparse(2));
sp3 = sparse([1; 2; 3]);
d = setDimensions(sp2);
assert_checkequal(d(1,1), sparse(1));
assert_checkequal(d(1,2), sparse(2));
assert_checkequal(d(1,3), sparse(0));
