package net.sf.saxon.serialize;

import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.NodeName;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;


/**
  * XHTMLEmitter is an Emitter that generates XHTML output.
  * It is the same as XMLEmitter except that it follows the legacy HTML browser
  * compatibility rules: for example, generating empty elements such as [BR /], and
  * using [p][/p] for empty paragraphs rather than [p/]
  */

public class XHTMLEmitter extends XMLEmitter {

    /**
    * Table of XHTML tags that have no closing tag
    */

    static Set<String> emptyTags = new HashSet<String>(31);

    private static String[] emptyTagNames = {
        "area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"
    };

    static {
        Collections.addAll(emptyTags, emptyTagNames);
    }

    /**
    * Close an empty element tag.
    */

    protected String emptyElementTagCloser(String displayName, /*@NotNull*/ NodeName nameCode) {
        if (nameCode.isInNamespace(NamespaceConstant.XHTML) && emptyTags.contains(nameCode.getLocalPart())) {
            return " />";
        } else {
            return "></" + displayName + '>';
        }
    }

}

//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License.
//
// The Original Code is: all this file
//
// The Initial Developer of the Original Code is Saxonica Limited.
// Portions created by ___ are Copyright (C) ___. All rights reserved.
//
// Contributor(s):
//