// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <iostream>
#include <sstream>
#include <iomanip>
using namespace std;

#include "tk.h"
#include "tkWinInt.h"
#include "tkFont.h"

#include "vector.h"
#include "rotstr.h"

#define R2D(x) ((x*180)/M_PI)

void XDrawRotString(Display* display, Drawable drawable, GC gc, 
		    Vector& vv, double angle, const char* text)

{
  // assumes gc->function == GXcopy
  long angle10 = R2D(angle)*10;
  TkFont* font = (TkFont*)(gc->font);
  if (!font)
    return;

  TkWinDCState state;
  HDC hdc = TkWinGetDrawableDC(display, drawable, &state);

  // logfont
  LOGFONT logfont;
  ZeroMemory(&logfont, sizeof(logfont));
  int size = MulDiv(font->fa.size, GetDeviceCaps(hdc, LOGPIXELSY), 72);
  logfont.lfHeight = -size;
  logfont.lfWidth = 0;
  logfont.lfEscapement = angle10;
  logfont.lfOrientation = angle10;
  logfont.lfWeight = (font->fa.weight == TK_FW_NORMAL) ? FW_NORMAL : FW_BOLD;
  logfont.lfItalic = font->fa.slant;
  logfont.lfUnderline = font->fa.underline;
  logfont.lfStrikeOut = font->fa.overstrike;
  logfont.lfCharSet = DEFAULT_CHARSET;
  logfont.lfOutPrecision = OUT_TT_PRECIS;
  logfont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
  logfont.lfQuality = DEFAULT_QUALITY;
  logfont.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
  strcpy(logfont.lfFaceName, font->fa.family);

  // hfont
  HFONT hfont = CreateFontIndirect(&logfont);
  if (!hfont)
    return;
  HFONT ohfont = (HFONT)SelectObject(hdc, hfont);

  // clip
  TkpClipMask *clipPtr = (TkpClipMask*)gc->clip_mask;
  if (clipPtr && clipPtr->type == TKP_CLIP_REGION) {
    SelectClipRgn(hdc, (HRGN) clipPtr->value.region);
    OffsetClipRgn(hdc, gc->clip_x_origin, gc->clip_y_origin);
  }

  // We need a slight shift in Y, I don't know why
  Matrix mm = Translate(-vv) * 
    Rotate(-angle) * 
    Translate(0,-int(size/10.)) *
    Rotate(angle) *
    Translate(vv);
  Vector tt = vv*mm;

  // do it
  SetTextAlign(hdc, TA_LEFT | TA_BASELINE);
  SetTextColor(hdc, gc->foreground);
  SetBkMode(hdc, TRANSPARENT);
  TextOut(hdc, (int)tt[0], (int)tt[1], text, strlen(text));

  // cleanup
  SelectClipRgn(hdc, NULL);
  SelectObject(hdc, ohfont);
  DeleteObject(hfont);
  TkWinReleaseDrawableDC(drawable, hdc, &state);
}

