// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __framepseudocolor_h__
#define __framepseudocolor_h__

#include "frame.h"
#include "framepseudo.h"

class FramePseudoColor : public virtual FrameBase, public Frame, public FramePseudo {
private:
  void buildXImage(XImage* xmap, Coord::InternalSystem);

public:
  FramePseudoColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);

  void colormapCmd(int, float, float, int, unsigned short*, 
		   unsigned char*, int);
  void colormapMotionCmd(int id, float b, float c, int i, 
			 unsigned short* index, 
			 unsigned char* cells, int cnt);
  void colormapEndCmd();
};

#endif
