/***************************************************************************
 *   Copyright (C) 2005-2015 by the Quassel Project                        *
 *   devel@quassel-irc.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) version 3.                                           *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef BUFFERHOTLISTFILTER_H
#define BUFFERHOTLISTFILTER_H

#include <QSortFilterProxyModel>
#include "types.h"

class BufferHotListFilter : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    BufferHotListFilter(QAbstractItemModel *source, QObject *parent = 0);

    virtual inline int columnCount(const QModelIndex &) const { return 1; }
    BufferId hottestBuffer();
//   QVariant data(const QModelIndex &index, int role) const;

protected:
    virtual bool filterAcceptsRow(int source_row, const QModelIndex &source_parent) const;
    virtual bool lessThan(const QModelIndex &source_left, const QModelIndex &source_right) const;
};


#endif //BUFFERHOTLISTFILTER_H
