/****************************************************************************
**
** Copyright (C) 2018 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQuick module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.12
import QtQuick.Window 2.3
import TestModel 0.1

Item {
    id: root
    width: 640
    height: 450

    property alias tableView: tableView
    property Loader loader: parent

    property int statusWhenDelegate0_0Created: Loader.Null
    property int statusWhenDelegate5_5Created: Loader.Null

    property real tableViewWidthWhileBuilding: -1
    property real tableViewHeightWhileBuilding: -1

    TableView {
        id: tableView
        anchors.fill: parent
        clip: true
        delegate: tableViewDelegate
        columnSpacing: 1
        rowSpacing: 1
        model: TestModel {
            rowCount: 100
            columnCount: 100
        }
    }

    Component {
        id: tableViewDelegate
        Rectangle {
            implicitWidth: 100
            implicitHeight: 50
            color: "lightgray"
            border.width: 1

            Text {
                anchors.centerIn: parent
                text: modelData
            }

            Component.onCompleted: {
                if (row === 0 && column === 0) {
                    statusWhenDelegate0_0Created = loader.status
                    tableViewWidthWhileBuilding = tableView.width
                    tableViewHeightWhileBuilding = tableView.height
                }
                else if (row === 5 && column === 5)
                    statusWhenDelegate5_5Created = loader.status
            }
        }
    }

}
