/**************************************************************************
*   Copyright (C) 2000-2012 by Johan Maes                                 *
*   on4qz@telenet.be                                                      *
*   http://users.telenet.be/on4qz                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "soundcontrol.h"
#include "ui_soundcontrol.h"
#include "configparams.h"
#include "utils/supportfunctions.h"
#include "soundio.h"
#include <QSettings>

soundControl::soundControl(QWidget *parent) :
  QWidget(parent),
  ui(new Ui::soundControl)
{
  QStringList *inputPCMList, *outputPCMList;
  ui->setupUi(this);
  soundIOPtr->listCards(); //get input devices
  inputPCMList=soundIOPtr->getPCMNamList(true);
  ui->inputPCMNameComboBox->addItems(*inputPCMList);
  outputPCMList=soundIOPtr->getPCMNamList(false);
  ui->outputPCMNameComboBox->addItems(*outputPCMList);
  changed=false;
}


soundControl::~soundControl()
{
  delete ui;
}

void soundControl::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("Sound");
  rxClock=qSettings.value("rxclock",BASESAMPLERATE).toDouble();
  txClock=qSettings.value("txclock",BASESAMPLERATE).toDouble();
  if(fabs(1-rxClock/BASESAMPLERATE)>0.002) rxClock=BASESAMPLERATE;
  if(fabs(1-txClock/BASESAMPLERATE)>0.002) txClock=BASESAMPLERATE;
  inputAudioDeviceIndex=qSettings.value("inputAudioDeviceIndex",0).toInt();
  outputAudioDeviceIndex=qSettings.value("outputAudioDeviceIndex",0).toInt();
  soundIOPtr->soundRoutingInput=  (soundIO::edataSrc)qSettings.value("soundRoutingInput",  0 ).toInt();
  soundIOPtr->soundRoutingOutput= (soundIO::edataDst)qSettings.value("soundRoutingOutput", 0 ).toInt();
  soundIOPtr->recordingSize= qSettings.value("recordingSize", 100 ).toInt();
  qSettings.endGroup();
  setParams();
}

void soundControl::writeSettings()
{
  getParams();
  QSettings qSettings;
  qSettings.beginGroup("Sound");
  qSettings.setValue("rxclock",rxClock);
  qSettings.setValue("txclock",txClock);
  qSettings.setValue("inputAudioDeviceIndex",inputAudioDeviceIndex);
  qSettings.setValue("outputAudioDeviceIndex",outputAudioDeviceIndex);
  qSettings.setValue ("soundRoutingInput", soundIOPtr->soundRoutingInput );
  qSettings.setValue ("soundRoutingOutput",soundIOPtr->soundRoutingOutput );
  qSettings.setValue ("recordingSize",soundIOPtr->recordingSize );
  qSettings.endGroup();
}


void soundControl::setParams()
{
  setValue(rxClock,ui->inputClockLineEdit,9);
  setValue(txClock,ui->outputClockLineEdit,9);
  setIndex(inputAudioDeviceIndex,ui->inputPCMNameComboBox);
  setIndex(outputAudioDeviceIndex,ui->outputPCMNameComboBox);
  soundIOPtr->inputAudioDevice=ui->inputPCMNameComboBox->currentText();
  soundIOPtr->outputAudioDevice=ui->outputPCMNameComboBox->currentText();

  if(soundIOPtr->soundRoutingInput==soundIO::SNDINCARD) ui->inFromCard->setChecked(true);
  else if (soundIOPtr->soundRoutingInput==soundIO::SNDINFILE) ui->inFromFile->setChecked(true);
  else ui->inRecordFromCard->setChecked(true);

  if(soundIOPtr->soundRoutingOutput==soundIO::SNDOUTCARD) ui->outToCard->setChecked(true);
  else ui->outRecord->setChecked(true);
  setValue(soundIOPtr->recordingSize,ui->mbSpinBox);
}

void soundControl::getParams()
{
  changed=false;
  int savedInputIdx=inputAudioDeviceIndex;
  int savedOutputIdx=outputAudioDeviceIndex;
  getValue(rxClock,ui->inputClockLineEdit);
  getValue(txClock,ui->inputClockLineEdit);

  getIndex(inputAudioDeviceIndex,ui->inputPCMNameComboBox);
  getIndex(outputAudioDeviceIndex,ui->outputPCMNameComboBox);

  if (ui->inFromCard->isChecked()) soundIOPtr->soundRoutingInput=soundIO::SNDINCARD;
  else if(ui->inFromFile->isChecked()) soundIOPtr->soundRoutingInput=soundIO::SNDINFILE;
  else soundIOPtr->soundRoutingInput=soundIO::SNDINCARDTOFILE;

  if (ui->outToCard->isChecked()) soundIOPtr->soundRoutingOutput=soundIO::SNDOUTCARD;
  else soundIOPtr->soundRoutingOutput=soundIO::SNDOUTTOFILE;
  getValue(soundIOPtr->recordingSize,ui->mbSpinBox);
  if(savedInputIdx!=inputAudioDeviceIndex) changed=true;
  if(savedOutputIdx!=outputAudioDeviceIndex) changed=true;
}

