/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_LAP_MESG_HPP)
#define FIT_LAP_MESG_HPP

#include "fit_mesg.hpp"
#include "fit_mesg_with_event.hpp"

namespace fit
{

class LapMesg : public Mesg, public MesgWithEvent
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 MessageIndex = 254;
       static const FIT_UINT8 Timestamp = 253;
       static const FIT_UINT8 Event = 0;
       static const FIT_UINT8 EventType = 1;
       static const FIT_UINT8 StartTime = 2;
       static const FIT_UINT8 StartPositionLat = 3;
       static const FIT_UINT8 StartPositionLong = 4;
       static const FIT_UINT8 EndPositionLat = 5;
       static const FIT_UINT8 EndPositionLong = 6;
       static const FIT_UINT8 TotalElapsedTime = 7;
       static const FIT_UINT8 TotalTimerTime = 8;
       static const FIT_UINT8 TotalDistance = 9;
       static const FIT_UINT8 TotalCycles = 10;
       static const FIT_UINT8 TotalCalories = 11;
       static const FIT_UINT8 TotalFatCalories = 12;
       static const FIT_UINT8 AvgSpeed = 13;
       static const FIT_UINT8 MaxSpeed = 14;
       static const FIT_UINT8 AvgHeartRate = 15;
       static const FIT_UINT8 MaxHeartRate = 16;
       static const FIT_UINT8 AvgCadence = 17;
       static const FIT_UINT8 MaxCadence = 18;
       static const FIT_UINT8 AvgPower = 19;
       static const FIT_UINT8 MaxPower = 20;
       static const FIT_UINT8 TotalAscent = 21;
       static const FIT_UINT8 TotalDescent = 22;
       static const FIT_UINT8 Intensity = 23;
       static const FIT_UINT8 LapTrigger = 24;
       static const FIT_UINT8 Sport = 25;
       static const FIT_UINT8 EventGroup = 26;
       static const FIT_UINT8 NumLengths = 32;
       static const FIT_UINT8 NormalizedPower = 33;
       static const FIT_UINT8 LeftRightBalance = 34;
       static const FIT_UINT8 FirstLengthIndex = 35;
       static const FIT_UINT8 AvgStrokeDistance = 37;
       static const FIT_UINT8 SwimStroke = 38;
       static const FIT_UINT8 SubSport = 39;
       static const FIT_UINT8 NumActiveLengths = 40;
       static const FIT_UINT8 TotalWork = 41;
       static const FIT_UINT8 AvgAltitude = 42;
       static const FIT_UINT8 MaxAltitude = 43;
       static const FIT_UINT8 GpsAccuracy = 44;
       static const FIT_UINT8 AvgGrade = 45;
       static const FIT_UINT8 AvgPosGrade = 46;
       static const FIT_UINT8 AvgNegGrade = 47;
       static const FIT_UINT8 MaxPosGrade = 48;
       static const FIT_UINT8 MaxNegGrade = 49;
       static const FIT_UINT8 AvgTemperature = 50;
       static const FIT_UINT8 MaxTemperature = 51;
       static const FIT_UINT8 TotalMovingTime = 52;
       static const FIT_UINT8 AvgPosVerticalSpeed = 53;
       static const FIT_UINT8 AvgNegVerticalSpeed = 54;
       static const FIT_UINT8 MaxPosVerticalSpeed = 55;
       static const FIT_UINT8 MaxNegVerticalSpeed = 56;
       static const FIT_UINT8 TimeInHrZone = 57;
       static const FIT_UINT8 TimeInSpeedZone = 58;
       static const FIT_UINT8 TimeInCadenceZone = 59;
       static const FIT_UINT8 TimeInPowerZone = 60;
       static const FIT_UINT8 RepetitionNum = 61;
       static const FIT_UINT8 MinAltitude = 62;
       static const FIT_UINT8 MinHeartRate = 63;
       static const FIT_UINT8 WktStepIndex = 71;
       static const FIT_UINT8 OpponentScore = 74;
       static const FIT_UINT8 StrokeCount = 75;
       static const FIT_UINT8 ZoneCount = 76;
       static const FIT_UINT8 AvgVerticalOscillation = 77;
       static const FIT_UINT8 AvgStanceTimePercent = 78;
       static const FIT_UINT8 AvgStanceTime = 79;
       static const FIT_UINT8 AvgFractionalCadence = 80;
       static const FIT_UINT8 MaxFractionalCadence = 81;
       static const FIT_UINT8 TotalFractionalCycles = 82;
       static const FIT_UINT8 PlayerScore = 83;
       static const FIT_UINT8 AvgTotalHemoglobinConc = 84;
       static const FIT_UINT8 MinTotalHemoglobinConc = 85;
       static const FIT_UINT8 MaxTotalHemoglobinConc = 86;
       static const FIT_UINT8 AvgSaturatedHemoglobinPercent = 87;
       static const FIT_UINT8 MinSaturatedHemoglobinPercent = 88;
       static const FIT_UINT8 MaxSaturatedHemoglobinPercent = 89;
       static const FIT_UINT8 AvgLeftTorqueEffectiveness = 91;
       static const FIT_UINT8 AvgRightTorqueEffectiveness = 92;
       static const FIT_UINT8 AvgLeftPedalSmoothness = 93;
       static const FIT_UINT8 AvgRightPedalSmoothness = 94;
       static const FIT_UINT8 AvgCombinedPedalSmoothness = 95;
       static const FIT_UINT8 TimeStanding = 98;
       static const FIT_UINT8 StandCount = 99;
       static const FIT_UINT8 AvgLeftPco = 100;
       static const FIT_UINT8 AvgRightPco = 101;
       static const FIT_UINT8 AvgLeftPowerPhase = 102;
       static const FIT_UINT8 AvgLeftPowerPhasePeak = 103;
       static const FIT_UINT8 AvgRightPowerPhase = 104;
       static const FIT_UINT8 AvgRightPowerPhasePeak = 105;
       static const FIT_UINT8 AvgPowerPosition = 106;
       static const FIT_UINT8 MaxPowerPosition = 107;
       static const FIT_UINT8 AvgCadencePosition = 108;
       static const FIT_UINT8 MaxCadencePosition = 109;
       static const FIT_UINT8 EnhancedAvgSpeed = 110;
       static const FIT_UINT8 EnhancedMaxSpeed = 111;
       static const FIT_UINT8 EnhancedAvgAltitude = 112;
       static const FIT_UINT8 EnhancedMinAltitude = 113;
       static const FIT_UINT8 EnhancedMaxAltitude = 114;
       static const FIT_UINT8 AvgLevMotorPower = 115;
       static const FIT_UINT8 MaxLevMotorPower = 116;
       static const FIT_UINT8 LevBatteryConsumption = 117;
       static const FIT_UINT8 AvgVerticalRatio = 118;
       static const FIT_UINT8 AvgStanceTimeBalance = 119;
       static const FIT_UINT8 AvgStepLength = 120;
       static const FIT_UINT8 AvgVam = 121;
       static const FIT_UINT8 AvgDepth = 122;
       static const FIT_UINT8 MaxDepth = 123;
       static const FIT_UINT8 MinTemperature = 124;
       static const FIT_UINT8 EnhancedAvgRespirationRate = 136;
       static const FIT_UINT8 EnhancedMaxRespirationRate = 137;
       static const FIT_UINT8 AvgRespirationRate = 147;
       static const FIT_UINT8 MaxRespirationRate = 148;
       static const FIT_UINT8 TotalGrit = 149;
       static const FIT_UINT8 TotalFlow = 150;
       static const FIT_UINT8 JumpCount = 151;
       static const FIT_UINT8 AvgGrit = 153;
       static const FIT_UINT8 AvgFlow = 154;
       static const FIT_UINT8 TotalFractionalAscent = 156;
       static const FIT_UINT8 TotalFractionalDescent = 157;
       static const FIT_UINT8 AvgCoreTemperature = 158;
       static const FIT_UINT8 MinCoreTemperature = 159;
       static const FIT_UINT8 MaxCoreTemperature = 160;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    LapMesg(void) : Mesg(Profile::MESG_LAP)
    {
    }

    LapMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of message_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMessageIndexValid() const
    {
        const Field* field = GetField(254);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns message_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetMessageIndex(void) const
    {
        return GetFieldUINT16Value(254, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set message_index field
    ///////////////////////////////////////////////////////////////////////
    void SetMessageIndex(FIT_MESSAGE_INDEX messageIndex)
    {
        SetFieldUINT16Value(254, messageIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timestamp field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimestampValid() const
    {
        const Field* field = GetField(253);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns timestamp field
    // Units: s
    // Comment: Lap end time.
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetTimestamp(void) const
    {
        return GetFieldUINT32Value(253, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timestamp field
    // Units: s
    // Comment: Lap end time.
    ///////////////////////////////////////////////////////////////////////
    void SetTimestamp(FIT_DATE_TIME timestamp)
    {
        SetFieldUINT32Value(253, timestamp, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event field
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT GetEvent(void) const
    {
        return GetFieldENUMValue(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event field
    ///////////////////////////////////////////////////////////////////////
    void SetEvent(FIT_EVENT event)
    {
        SetFieldENUMValue(0, event, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventTypeValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT_TYPE GetEventType(void) const
    {
        return GetFieldENUMValue(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_type field
    ///////////////////////////////////////////////////////////////////////
    void SetEventType(FIT_EVENT_TYPE eventType)
    {
        SetFieldENUMValue(1, eventType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartTimeValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_time field
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetStartTime(void) const
    {
        return GetFieldUINT32Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_time field
    ///////////////////////////////////////////////////////////////////////
    void SetStartTime(FIT_DATE_TIME startTime)
    {
        SetFieldUINT32Value(2, startTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLatValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLat(void) const
    {
        return GetFieldSINT32Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLat(FIT_SINT32 startPositionLat)
    {
        SetFieldSINT32Value(3, startPositionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLongValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLong(void) const
    {
        return GetFieldSINT32Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLong(FIT_SINT32 startPositionLong)
    {
        SetFieldSINT32Value(4, startPositionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of end_position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEndPositionLatValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns end_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetEndPositionLat(void) const
    {
        return GetFieldSINT32Value(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set end_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetEndPositionLat(FIT_SINT32 endPositionLat)
    {
        SetFieldSINT32Value(5, endPositionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of end_position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEndPositionLongValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns end_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetEndPositionLong(void) const
    {
        return GetFieldSINT32Value(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set end_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetEndPositionLong(FIT_SINT32 endPositionLong)
    {
        SetFieldSINT32Value(6, endPositionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_elapsed_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalElapsedTimeValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_elapsed_time field
    // Units: s
    // Comment: Time (includes pauses)
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalElapsedTime(void) const
    {
        return GetFieldFLOAT32Value(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_elapsed_time field
    // Units: s
    // Comment: Time (includes pauses)
    ///////////////////////////////////////////////////////////////////////
    void SetTotalElapsedTime(FIT_FLOAT32 totalElapsedTime)
    {
        SetFieldFLOAT32Value(7, totalElapsedTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_timer_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalTimerTimeValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_timer_time field
    // Units: s
    // Comment: Timer Time (excludes pauses)
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalTimerTime(void) const
    {
        return GetFieldFLOAT32Value(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_timer_time field
    // Units: s
    // Comment: Timer Time (excludes pauses)
    ///////////////////////////////////////////////////////////////////////
    void SetTotalTimerTime(FIT_FLOAT32 totalTimerTime)
    {
        SetFieldFLOAT32Value(8, totalTimerTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDistanceValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalDistance(void) const
    {
        return GetFieldFLOAT32Value(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDistance(FIT_FLOAT32 totalDistance)
    {
        SetFieldFLOAT32Value(9, totalDistance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCyclesValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalCycles(void) const
    {
        return GetFieldUINT32Value(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCycles(FIT_UINT32 totalCycles)
    {
        SetFieldUINT32Value(10, totalCycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_strides field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalStridesValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns total_strides field
    // Units: strides
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalStrides(void) const
    {
        return GetFieldUINT32Value(10, 0, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_strides field
    // Units: strides
    ///////////////////////////////////////////////////////////////////////
    void SetTotalStrides(FIT_UINT32 totalStrides)
    {
        SetFieldUINT32Value(10, totalStrides, 0, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_strokes field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalStrokesValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns total_strokes field
    // Units: strokes
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalStrokes(void) const
    {
        return GetFieldUINT32Value(10, 0, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_strokes field
    // Units: strokes
    ///////////////////////////////////////////////////////////////////////
    void SetTotalStrokes(FIT_UINT32 totalStrokes)
    {
        SetFieldUINT32Value(10, totalStrokes, 0, (FIT_UINT16) Profile::LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCaloriesValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalCalories(void) const
    {
        return GetFieldUINT16Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCalories(FIT_UINT16 totalCalories)
    {
        SetFieldUINT16Value(11, totalCalories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fat_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFatCaloriesValid() const
    {
        const Field* field = GetField(12);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fat_calories field
    // Units: kcal
    // Comment: If New Leaf
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalFatCalories(void) const
    {
        return GetFieldUINT16Value(12, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fat_calories field
    // Units: kcal
    // Comment: If New Leaf
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFatCalories(FIT_UINT16 totalFatCalories)
    {
        SetFieldUINT16Value(12, totalFatCalories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgSpeedValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgSpeed(void) const
    {
        return GetFieldFLOAT32Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgSpeed(FIT_FLOAT32 avgSpeed)
    {
        SetFieldFLOAT32Value(13, avgSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxSpeedValid() const
    {
        const Field* field = GetField(14);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxSpeed(void) const
    {
        return GetFieldFLOAT32Value(14, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxSpeed(FIT_FLOAT32 maxSpeed)
    {
        SetFieldFLOAT32Value(14, maxSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgHeartRateValid() const
    {
        const Field* field = GetField(15);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgHeartRate(void) const
    {
        return GetFieldUINT8Value(15, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetAvgHeartRate(FIT_UINT8 avgHeartRate)
    {
        SetFieldUINT8Value(15, avgHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxHeartRateValid() const
    {
        const Field* field = GetField(16);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxHeartRate(void) const
    {
        return GetFieldUINT8Value(16, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetMaxHeartRate(FIT_UINT8 maxHeartRate)
    {
        SetFieldUINT8Value(16, maxHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCadenceValid() const
    {
        const Field* field = GetField(17);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_cadence field
    // Units: rpm
    // Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgCadence(void) const
    {
        return GetFieldUINT8Value(17, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_cadence field
    // Units: rpm
    // Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCadence(FIT_UINT8 avgCadence)
    {
        SetFieldUINT8Value(17, avgCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_running_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRunningCadenceValid() const
    {
        const Field* field = GetField(17);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns avg_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgRunningCadence(void) const
    {
        return GetFieldUINT8Value(17, 0, (FIT_UINT16) Profile::LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRunningCadence(FIT_UINT8 avgRunningCadence)
    {
        SetFieldUINT8Value(17, avgRunningCadence, 0, (FIT_UINT16) Profile::LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxCadenceValid() const
    {
        const Field* field = GetField(18);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxCadence(void) const
    {
        return GetFieldUINT8Value(18, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetMaxCadence(FIT_UINT8 maxCadence)
    {
        SetFieldUINT8Value(18, maxCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_running_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxRunningCadenceValid() const
    {
        const Field* field = GetField(18);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns max_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxRunningCadence(void) const
    {
        return GetFieldUINT8Value(18, 0, (FIT_UINT16) Profile::LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    void SetMaxRunningCadence(FIT_UINT8 maxRunningCadence)
    {
        SetFieldUINT8Value(18, maxRunningCadence, 0, (FIT_UINT16) Profile::LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPowerValid() const
    {
        const Field* field = GetField(19);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_power field
    // Units: watts
    // Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgPower(void) const
    {
        return GetFieldUINT16Value(19, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_power field
    // Units: watts
    // Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPower(FIT_UINT16 avgPower)
    {
        SetFieldUINT16Value(19, avgPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPowerValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxPower(void) const
    {
        return GetFieldUINT16Value(20, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPower(FIT_UINT16 maxPower)
    {
        SetFieldUINT16Value(20, maxPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_ascent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalAscentValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalAscent(void) const
    {
        return GetFieldUINT16Value(21, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalAscent(FIT_UINT16 totalAscent)
    {
        SetFieldUINT16Value(21, totalAscent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_descent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDescentValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalDescent(void) const
    {
        return GetFieldUINT16Value(22, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDescent(FIT_UINT16 totalDescent)
    {
        SetFieldUINT16Value(22, totalDescent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of intensity field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsIntensityValid() const
    {
        const Field* field = GetField(23);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns intensity field
    ///////////////////////////////////////////////////////////////////////
    FIT_INTENSITY GetIntensity(void) const
    {
        return GetFieldENUMValue(23, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set intensity field
    ///////////////////////////////////////////////////////////////////////
    void SetIntensity(FIT_INTENSITY intensity)
    {
        SetFieldENUMValue(23, intensity, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of lap_trigger field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLapTriggerValid() const
    {
        const Field* field = GetField(24);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns lap_trigger field
    ///////////////////////////////////////////////////////////////////////
    FIT_LAP_TRIGGER GetLapTrigger(void) const
    {
        return GetFieldENUMValue(24, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set lap_trigger field
    ///////////////////////////////////////////////////////////////////////
    void SetLapTrigger(FIT_LAP_TRIGGER lapTrigger)
    {
        SetFieldENUMValue(24, lapTrigger, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sport field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSportValid() const
    {
        const Field* field = GetField(25);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sport field
    ///////////////////////////////////////////////////////////////////////
    FIT_SPORT GetSport(void) const
    {
        return GetFieldENUMValue(25, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sport field
    ///////////////////////////////////////////////////////////////////////
    void SetSport(FIT_SPORT sport)
    {
        SetFieldENUMValue(25, sport, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_group field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventGroupValid() const
    {
        const Field* field = GetField(26);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_group field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetEventGroup(void) const
    {
        return GetFieldUINT8Value(26, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_group field
    ///////////////////////////////////////////////////////////////////////
    void SetEventGroup(FIT_UINT8 eventGroup)
    {
        SetFieldUINT8Value(26, eventGroup, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of num_lengths field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNumLengthsValid() const
    {
        const Field* field = GetField(32);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns num_lengths field
    // Units: lengths
    // Comment: # of lengths of swim pool
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetNumLengths(void) const
    {
        return GetFieldUINT16Value(32, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set num_lengths field
    // Units: lengths
    // Comment: # of lengths of swim pool
    ///////////////////////////////////////////////////////////////////////
    void SetNumLengths(FIT_UINT16 numLengths)
    {
        SetFieldUINT16Value(32, numLengths, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of normalized_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNormalizedPowerValid() const
    {
        const Field* field = GetField(33);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns normalized_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetNormalizedPower(void) const
    {
        return GetFieldUINT16Value(33, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set normalized_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetNormalizedPower(FIT_UINT16 normalizedPower)
    {
        SetFieldUINT16Value(33, normalizedPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_right_balance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftRightBalanceValid() const
    {
        const Field* field = GetField(34);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    FIT_LEFT_RIGHT_BALANCE_100 GetLeftRightBalance(void) const
    {
        return GetFieldUINT16Value(34, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    void SetLeftRightBalance(FIT_LEFT_RIGHT_BALANCE_100 leftRightBalance)
    {
        SetFieldUINT16Value(34, leftRightBalance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of first_length_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFirstLengthIndexValid() const
    {
        const Field* field = GetField(35);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns first_length_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetFirstLengthIndex(void) const
    {
        return GetFieldUINT16Value(35, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set first_length_index field
    ///////////////////////////////////////////////////////////////////////
    void SetFirstLengthIndex(FIT_UINT16 firstLengthIndex)
    {
        SetFieldUINT16Value(35, firstLengthIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stroke_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStrokeDistanceValid() const
    {
        const Field* field = GetField(37);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stroke_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStrokeDistance(void) const
    {
        return GetFieldFLOAT32Value(37, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stroke_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStrokeDistance(FIT_FLOAT32 avgStrokeDistance)
    {
        SetFieldFLOAT32Value(37, avgStrokeDistance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of swim_stroke field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSwimStrokeValid() const
    {
        const Field* field = GetField(38);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns swim_stroke field
    ///////////////////////////////////////////////////////////////////////
    FIT_SWIM_STROKE GetSwimStroke(void) const
    {
        return GetFieldENUMValue(38, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set swim_stroke field
    ///////////////////////////////////////////////////////////////////////
    void SetSwimStroke(FIT_SWIM_STROKE swimStroke)
    {
        SetFieldENUMValue(38, swimStroke, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sub_sport field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSubSportValid() const
    {
        const Field* field = GetField(39);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sub_sport field
    ///////////////////////////////////////////////////////////////////////
    FIT_SUB_SPORT GetSubSport(void) const
    {
        return GetFieldENUMValue(39, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sub_sport field
    ///////////////////////////////////////////////////////////////////////
    void SetSubSport(FIT_SUB_SPORT subSport)
    {
        SetFieldENUMValue(39, subSport, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of num_active_lengths field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNumActiveLengthsValid() const
    {
        const Field* field = GetField(40);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns num_active_lengths field
    // Units: lengths
    // Comment: # of active lengths of swim pool
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetNumActiveLengths(void) const
    {
        return GetFieldUINT16Value(40, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set num_active_lengths field
    // Units: lengths
    // Comment: # of active lengths of swim pool
    ///////////////////////////////////////////////////////////////////////
    void SetNumActiveLengths(FIT_UINT16 numActiveLengths)
    {
        SetFieldUINT16Value(40, numActiveLengths, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_work field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalWorkValid() const
    {
        const Field* field = GetField(41);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_work field
    // Units: J
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalWork(void) const
    {
        return GetFieldUINT32Value(41, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_work field
    // Units: J
    ///////////////////////////////////////////////////////////////////////
    void SetTotalWork(FIT_UINT32 totalWork)
    {
        SetFieldUINT32Value(41, totalWork, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgAltitudeValid() const
    {
        const Field* field = GetField(42);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgAltitude(void) const
    {
        return GetFieldFLOAT32Value(42, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetAvgAltitude(FIT_FLOAT32 avgAltitude)
    {
        SetFieldFLOAT32Value(42, avgAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxAltitudeValid() const
    {
        const Field* field = GetField(43);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxAltitude(void) const
    {
        return GetFieldFLOAT32Value(43, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetMaxAltitude(FIT_FLOAT32 maxAltitude)
    {
        SetFieldFLOAT32Value(43, maxAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gps_accuracy field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGpsAccuracyValid() const
    {
        const Field* field = GetField(44);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetGpsAccuracy(void) const
    {
        return GetFieldUINT8Value(44, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetGpsAccuracy(FIT_UINT8 gpsAccuracy)
    {
        SetFieldUINT8Value(44, gpsAccuracy, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgGradeValid() const
    {
        const Field* field = GetField(45);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgGrade(void) const
    {
        return GetFieldFLOAT32Value(45, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgGrade(FIT_FLOAT32 avgGrade)
    {
        SetFieldFLOAT32Value(45, avgGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_pos_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPosGradeValid() const
    {
        const Field* field = GetField(46);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgPosGrade(void) const
    {
        return GetFieldFLOAT32Value(46, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPosGrade(FIT_FLOAT32 avgPosGrade)
    {
        SetFieldFLOAT32Value(46, avgPosGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_neg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgNegGradeValid() const
    {
        const Field* field = GetField(47);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgNegGrade(void) const
    {
        return GetFieldFLOAT32Value(47, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgNegGrade(FIT_FLOAT32 avgNegGrade)
    {
        SetFieldFLOAT32Value(47, avgNegGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_pos_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPosGradeValid() const
    {
        const Field* field = GetField(48);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxPosGrade(void) const
    {
        return GetFieldFLOAT32Value(48, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPosGrade(FIT_FLOAT32 maxPosGrade)
    {
        SetFieldFLOAT32Value(48, maxPosGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_neg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxNegGradeValid() const
    {
        const Field* field = GetField(49);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxNegGrade(void) const
    {
        return GetFieldFLOAT32Value(49, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetMaxNegGrade(FIT_FLOAT32 maxNegGrade)
    {
        SetFieldFLOAT32Value(49, maxNegGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgTemperatureValid() const
    {
        const Field* field = GetField(50);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgTemperature(void) const
    {
        return GetFieldSINT8Value(50, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetAvgTemperature(FIT_SINT8 avgTemperature)
    {
        SetFieldSINT8Value(50, avgTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxTemperatureValid() const
    {
        const Field* field = GetField(51);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetMaxTemperature(void) const
    {
        return GetFieldSINT8Value(51, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetMaxTemperature(FIT_SINT8 maxTemperature)
    {
        SetFieldSINT8Value(51, maxTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_moving_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalMovingTimeValid() const
    {
        const Field* field = GetField(52);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalMovingTime(void) const
    {
        return GetFieldFLOAT32Value(52, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTotalMovingTime(FIT_FLOAT32 totalMovingTime)
    {
        SetFieldFLOAT32Value(52, totalMovingTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_pos_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPosVerticalSpeedValid() const
    {
        const Field* field = GetField(53);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgPosVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(53, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPosVerticalSpeed(FIT_FLOAT32 avgPosVerticalSpeed)
    {
        SetFieldFLOAT32Value(53, avgPosVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_neg_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgNegVerticalSpeedValid() const
    {
        const Field* field = GetField(54);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgNegVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(54, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgNegVerticalSpeed(FIT_FLOAT32 avgNegVerticalSpeed)
    {
        SetFieldFLOAT32Value(54, avgNegVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_pos_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPosVerticalSpeedValid() const
    {
        const Field* field = GetField(55);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxPosVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(55, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPosVerticalSpeed(FIT_FLOAT32 maxPosVerticalSpeed)
    {
        SetFieldFLOAT32Value(55, maxPosVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_neg_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxNegVerticalSpeedValid() const
    {
        const Field* field = GetField(56);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxNegVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(56, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxNegVerticalSpeed(FIT_FLOAT32 maxNegVerticalSpeed)
    {
        SetFieldFLOAT32Value(56, maxNegVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_hr_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInHrZone(void) const
    {
        return GetFieldNumValues(57, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_hr_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInHrZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(57);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_hr_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInHrZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(57, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_hr_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInHrZone(FIT_UINT8 index, FIT_FLOAT32 timeInHrZone)
    {
        SetFieldFLOAT32Value(57, timeInHrZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_speed_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInSpeedZone(void) const
    {
        return GetFieldNumValues(58, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_speed_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInSpeedZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(58);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_speed_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInSpeedZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(58, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_speed_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInSpeedZone(FIT_UINT8 index, FIT_FLOAT32 timeInSpeedZone)
    {
        SetFieldFLOAT32Value(58, timeInSpeedZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_cadence_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInCadenceZone(void) const
    {
        return GetFieldNumValues(59, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_cadence_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInCadenceZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(59);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_cadence_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInCadenceZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(59, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_cadence_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInCadenceZone(FIT_UINT8 index, FIT_FLOAT32 timeInCadenceZone)
    {
        SetFieldFLOAT32Value(59, timeInCadenceZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_power_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInPowerZone(void) const
    {
        return GetFieldNumValues(60, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_power_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInPowerZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(60);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_power_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInPowerZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(60, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_power_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInPowerZone(FIT_UINT8 index, FIT_FLOAT32 timeInPowerZone)
    {
        SetFieldFLOAT32Value(60, timeInPowerZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repetition_num field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepetitionNumValid() const
    {
        const Field* field = GetField(61);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns repetition_num field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetRepetitionNum(void) const
    {
        return GetFieldUINT16Value(61, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repetition_num field
    ///////////////////////////////////////////////////////////////////////
    void SetRepetitionNum(FIT_UINT16 repetitionNum)
    {
        SetFieldUINT16Value(61, repetitionNum, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinAltitudeValid() const
    {
        const Field* field = GetField(62);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinAltitude(void) const
    {
        return GetFieldFLOAT32Value(62, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetMinAltitude(FIT_FLOAT32 minAltitude)
    {
        SetFieldFLOAT32Value(62, minAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinHeartRateValid() const
    {
        const Field* field = GetField(63);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMinHeartRate(void) const
    {
        return GetFieldUINT8Value(63, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetMinHeartRate(FIT_UINT8 minHeartRate)
    {
        SetFieldUINT8Value(63, minHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of wkt_step_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsWktStepIndexValid() const
    {
        const Field* field = GetField(71);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns wkt_step_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetWktStepIndex(void) const
    {
        return GetFieldUINT16Value(71, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set wkt_step_index field
    ///////////////////////////////////////////////////////////////////////
    void SetWktStepIndex(FIT_MESSAGE_INDEX wktStepIndex)
    {
        SetFieldUINT16Value(71, wktStepIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of opponent_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsOpponentScoreValid() const
    {
        const Field* field = GetField(74);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns opponent_score field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetOpponentScore(void) const
    {
        return GetFieldUINT16Value(74, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set opponent_score field
    ///////////////////////////////////////////////////////////////////////
    void SetOpponentScore(FIT_UINT16 opponentScore)
    {
        SetFieldUINT16Value(74, opponentScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of stroke_count
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumStrokeCount(void) const
    {
        return GetFieldNumValues(75, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stroke_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStrokeCountValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(75);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stroke_count field
    // Units: counts
    // Comment: stroke_type enum used as the index
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetStrokeCount(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(75, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stroke_count field
    // Units: counts
    // Comment: stroke_type enum used as the index
    ///////////////////////////////////////////////////////////////////////
    void SetStrokeCount(FIT_UINT8 index, FIT_UINT16 strokeCount)
    {
        SetFieldUINT16Value(75, strokeCount, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of zone_count
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumZoneCount(void) const
    {
        return GetFieldNumValues(76, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of zone_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsZoneCountValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(76);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns zone_count field
    // Units: counts
    // Comment: zone number used as the index
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetZoneCount(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(76, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set zone_count field
    // Units: counts
    // Comment: zone number used as the index
    ///////////////////////////////////////////////////////////////////////
    void SetZoneCount(FIT_UINT8 index, FIT_UINT16 zoneCount)
    {
        SetFieldUINT16Value(76, zoneCount, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_vertical_oscillation field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgVerticalOscillationValid() const
    {
        const Field* field = GetField(77);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_vertical_oscillation field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgVerticalOscillation(void) const
    {
        return GetFieldFLOAT32Value(77, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_vertical_oscillation field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    void SetAvgVerticalOscillation(FIT_FLOAT32 avgVerticalOscillation)
    {
        SetFieldFLOAT32Value(77, avgVerticalOscillation, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stance_time_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStanceTimePercentValid() const
    {
        const Field* field = GetField(78);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stance_time_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStanceTimePercent(void) const
    {
        return GetFieldFLOAT32Value(78, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stance_time_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStanceTimePercent(FIT_FLOAT32 avgStanceTimePercent)
    {
        SetFieldFLOAT32Value(78, avgStanceTimePercent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stance_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStanceTimeValid() const
    {
        const Field* field = GetField(79);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stance_time field
    // Units: ms
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStanceTime(void) const
    {
        return GetFieldFLOAT32Value(79, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stance_time field
    // Units: ms
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStanceTime(FIT_FLOAT32 avgStanceTime)
    {
        SetFieldFLOAT32Value(79, avgStanceTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_fractional_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgFractionalCadenceValid() const
    {
        const Field* field = GetField(80);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the avg_cadence
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgFractionalCadence(void) const
    {
        return GetFieldFLOAT32Value(80, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the avg_cadence
    ///////////////////////////////////////////////////////////////////////
    void SetAvgFractionalCadence(FIT_FLOAT32 avgFractionalCadence)
    {
        SetFieldFLOAT32Value(80, avgFractionalCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_fractional_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxFractionalCadenceValid() const
    {
        const Field* field = GetField(81);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the max_cadence
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxFractionalCadence(void) const
    {
        return GetFieldFLOAT32Value(81, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the max_cadence
    ///////////////////////////////////////////////////////////////////////
    void SetMaxFractionalCadence(FIT_FLOAT32 maxFractionalCadence)
    {
        SetFieldFLOAT32Value(81, maxFractionalCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fractional_cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFractionalCyclesValid() const
    {
        const Field* field = GetField(82);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fractional_cycles field
    // Units: cycles
    // Comment: fractional part of the total_cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalFractionalCycles(void) const
    {
        return GetFieldFLOAT32Value(82, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fractional_cycles field
    // Units: cycles
    // Comment: fractional part of the total_cycles
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFractionalCycles(FIT_FLOAT32 totalFractionalCycles)
    {
        SetFieldFLOAT32Value(82, totalFractionalCycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of player_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPlayerScoreValid() const
    {
        const Field* field = GetField(83);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns player_score field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetPlayerScore(void) const
    {
        return GetFieldUINT16Value(83, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set player_score field
    ///////////////////////////////////////////////////////////////////////
    void SetPlayerScore(FIT_UINT16 playerScore)
    {
        SetFieldUINT16Value(83, playerScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_total_hemoglobin_conc
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgTotalHemoglobinConc(void) const
    {
        return GetFieldNumValues(84, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_total_hemoglobin_conc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgTotalHemoglobinConcValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(84);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Avg saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgTotalHemoglobinConc(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(84, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Avg saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetAvgTotalHemoglobinConc(FIT_UINT8 index, FIT_FLOAT32 avgTotalHemoglobinConc)
    {
        SetFieldFLOAT32Value(84, avgTotalHemoglobinConc, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of min_total_hemoglobin_conc
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMinTotalHemoglobinConc(void) const
    {
        return GetFieldNumValues(85, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_total_hemoglobin_conc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinTotalHemoglobinConcValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(85);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Min saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinTotalHemoglobinConc(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(85, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Min saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetMinTotalHemoglobinConc(FIT_UINT8 index, FIT_FLOAT32 minTotalHemoglobinConc)
    {
        SetFieldFLOAT32Value(85, minTotalHemoglobinConc, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_total_hemoglobin_conc
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxTotalHemoglobinConc(void) const
    {
        return GetFieldNumValues(86, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_total_hemoglobin_conc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxTotalHemoglobinConcValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(86);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Max saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxTotalHemoglobinConc(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(86, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Max saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetMaxTotalHemoglobinConc(FIT_UINT8 index, FIT_FLOAT32 maxTotalHemoglobinConc)
    {
        SetFieldFLOAT32Value(86, maxTotalHemoglobinConc, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_saturated_hemoglobin_percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgSaturatedHemoglobinPercent(void) const
    {
        return GetFieldNumValues(87, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_saturated_hemoglobin_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgSaturatedHemoglobinPercentValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(87);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Avg percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgSaturatedHemoglobinPercent(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(87, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Avg percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetAvgSaturatedHemoglobinPercent(FIT_UINT8 index, FIT_FLOAT32 avgSaturatedHemoglobinPercent)
    {
        SetFieldFLOAT32Value(87, avgSaturatedHemoglobinPercent, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of min_saturated_hemoglobin_percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMinSaturatedHemoglobinPercent(void) const
    {
        return GetFieldNumValues(88, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_saturated_hemoglobin_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinSaturatedHemoglobinPercentValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(88);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Min percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinSaturatedHemoglobinPercent(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(88, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Min percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetMinSaturatedHemoglobinPercent(FIT_UINT8 index, FIT_FLOAT32 minSaturatedHemoglobinPercent)
    {
        SetFieldFLOAT32Value(88, minSaturatedHemoglobinPercent, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_saturated_hemoglobin_percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxSaturatedHemoglobinPercent(void) const
    {
        return GetFieldNumValues(89, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_saturated_hemoglobin_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxSaturatedHemoglobinPercentValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(89);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Max percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxSaturatedHemoglobinPercent(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(89, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Max percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetMaxSaturatedHemoglobinPercent(FIT_UINT8 index, FIT_FLOAT32 maxSaturatedHemoglobinPercent)
    {
        SetFieldFLOAT32Value(89, maxSaturatedHemoglobinPercent, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftTorqueEffectivenessValid() const
    {
        const Field* field = GetField(91);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(91, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftTorqueEffectiveness(FIT_FLOAT32 avgLeftTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(91, avgLeftTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightTorqueEffectivenessValid() const
    {
        const Field* field = GetField(92);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(92, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightTorqueEffectiveness(FIT_FLOAT32 avgRightTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(92, avgRightTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPedalSmoothnessValid() const
    {
        const Field* field = GetField(93);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(93, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPedalSmoothness(FIT_FLOAT32 avgLeftPedalSmoothness)
    {
        SetFieldFLOAT32Value(93, avgLeftPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPedalSmoothnessValid() const
    {
        const Field* field = GetField(94);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(94, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPedalSmoothness(FIT_FLOAT32 avgRightPedalSmoothness)
    {
        SetFieldFLOAT32Value(94, avgRightPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_combined_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCombinedPedalSmoothnessValid() const
    {
        const Field* field = GetField(95);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgCombinedPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(95, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCombinedPedalSmoothness(FIT_FLOAT32 avgCombinedPedalSmoothness)
    {
        SetFieldFLOAT32Value(95, avgCombinedPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_standing field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeStandingValid() const
    {
        const Field* field = GetField(98);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_standing field
    // Units: s
    // Comment: Total time spent in the standing position
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeStanding(void) const
    {
        return GetFieldFLOAT32Value(98, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_standing field
    // Units: s
    // Comment: Total time spent in the standing position
    ///////////////////////////////////////////////////////////////////////
    void SetTimeStanding(FIT_FLOAT32 timeStanding)
    {
        SetFieldFLOAT32Value(98, timeStanding, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stand_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStandCountValid() const
    {
        const Field* field = GetField(99);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stand_count field
    // Comment: Number of transitions to the standing state
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetStandCount(void) const
    {
        return GetFieldUINT16Value(99, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stand_count field
    // Comment: Number of transitions to the standing state
    ///////////////////////////////////////////////////////////////////////
    void SetStandCount(FIT_UINT16 standCount)
    {
        SetFieldUINT16Value(99, standCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPcoValid() const
    {
        const Field* field = GetField(100);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_pco field
    // Units: mm
    // Comment: Average left platform center offset
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgLeftPco(void) const
    {
        return GetFieldSINT8Value(100, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_pco field
    // Units: mm
    // Comment: Average left platform center offset
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPco(FIT_SINT8 avgLeftPco)
    {
        SetFieldSINT8Value(100, avgLeftPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPcoValid() const
    {
        const Field* field = GetField(101);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_pco field
    // Units: mm
    // Comment: Average right platform center offset
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgRightPco(void) const
    {
        return GetFieldSINT8Value(101, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_pco field
    // Units: mm
    // Comment: Average right platform center offset
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPco(FIT_SINT8 avgRightPco)
    {
        SetFieldSINT8Value(101, avgRightPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_left_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgLeftPowerPhase(void) const
    {
        return GetFieldNumValues(102, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(102);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_power_phase field
    // Units: degrees
    // Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(102, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_power_phase field
    // Units: degrees
    // Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPowerPhase(FIT_UINT8 index, FIT_FLOAT32 avgLeftPowerPhase)
    {
        SetFieldFLOAT32Value(102, avgLeftPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_left_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgLeftPowerPhasePeak(void) const
    {
        return GetFieldNumValues(103, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(103);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_power_phase_peak field
    // Units: degrees
    // Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(103, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_power_phase_peak field
    // Units: degrees
    // Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 avgLeftPowerPhasePeak)
    {
        SetFieldFLOAT32Value(103, avgLeftPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_right_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgRightPowerPhase(void) const
    {
        return GetFieldNumValues(104, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(104);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_power_phase field
    // Units: degrees
    // Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(104, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_power_phase field
    // Units: degrees
    // Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPowerPhase(FIT_UINT8 index, FIT_FLOAT32 avgRightPowerPhase)
    {
        SetFieldFLOAT32Value(104, avgRightPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_right_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgRightPowerPhasePeak(void) const
    {
        return GetFieldNumValues(105, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(105);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_power_phase_peak field
    // Units: degrees
    // Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(105, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_power_phase_peak field
    // Units: degrees
    // Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 avgRightPowerPhasePeak)
    {
        SetFieldFLOAT32Value(105, avgRightPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_power_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgPowerPosition(void) const
    {
        return GetFieldNumValues(106, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_power_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPowerPositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(106);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_power_position field
    // Units: watts
    // Comment: Average power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgPowerPosition(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(106, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_power_position field
    // Units: watts
    // Comment: Average power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPowerPosition(FIT_UINT8 index, FIT_UINT16 avgPowerPosition)
    {
        SetFieldUINT16Value(106, avgPowerPosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_power_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxPowerPosition(void) const
    {
        return GetFieldNumValues(107, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_power_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPowerPositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(107);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_power_position field
    // Units: watts
    // Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxPowerPosition(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(107, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_power_position field
    // Units: watts
    // Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPowerPosition(FIT_UINT8 index, FIT_UINT16 maxPowerPosition)
    {
        SetFieldUINT16Value(107, maxPowerPosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_cadence_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgCadencePosition(void) const
    {
        return GetFieldNumValues(108, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_cadence_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCadencePositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(108);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_cadence_position field
    // Units: rpm
    // Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgCadencePosition(FIT_UINT8 index) const
    {
        return GetFieldUINT8Value(108, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_cadence_position field
    // Units: rpm
    // Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCadencePosition(FIT_UINT8 index, FIT_UINT8 avgCadencePosition)
    {
        SetFieldUINT8Value(108, avgCadencePosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_cadence_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxCadencePosition(void) const
    {
        return GetFieldNumValues(109, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_cadence_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxCadencePositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(109);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_cadence_position field
    // Units: rpm
    // Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxCadencePosition(FIT_UINT8 index) const
    {
        return GetFieldUINT8Value(109, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_cadence_position field
    // Units: rpm
    // Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetMaxCadencePosition(FIT_UINT8 index, FIT_UINT8 maxCadencePosition)
    {
        SetFieldUINT8Value(109, maxCadencePosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_avg_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedAvgSpeedValid() const
    {
        const Field* field = GetField(110);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedAvgSpeed(void) const
    {
        return GetFieldFLOAT32Value(110, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedAvgSpeed(FIT_FLOAT32 enhancedAvgSpeed)
    {
        SetFieldFLOAT32Value(110, enhancedAvgSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_max_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedMaxSpeedValid() const
    {
        const Field* field = GetField(111);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedMaxSpeed(void) const
    {
        return GetFieldFLOAT32Value(111, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedMaxSpeed(FIT_FLOAT32 enhancedMaxSpeed)
    {
        SetFieldFLOAT32Value(111, enhancedMaxSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_avg_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedAvgAltitudeValid() const
    {
        const Field* field = GetField(112);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedAvgAltitude(void) const
    {
        return GetFieldFLOAT32Value(112, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedAvgAltitude(FIT_FLOAT32 enhancedAvgAltitude)
    {
        SetFieldFLOAT32Value(112, enhancedAvgAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_min_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedMinAltitudeValid() const
    {
        const Field* field = GetField(113);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedMinAltitude(void) const
    {
        return GetFieldFLOAT32Value(113, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedMinAltitude(FIT_FLOAT32 enhancedMinAltitude)
    {
        SetFieldFLOAT32Value(113, enhancedMinAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_max_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedMaxAltitudeValid() const
    {
        const Field* field = GetField(114);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedMaxAltitude(void) const
    {
        return GetFieldFLOAT32Value(114, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedMaxAltitude(FIT_FLOAT32 enhancedMaxAltitude)
    {
        SetFieldFLOAT32Value(114, enhancedMaxAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_lev_motor_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLevMotorPowerValid() const
    {
        const Field* field = GetField(115);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_lev_motor_power field
    // Units: watts
    // Comment: lev average motor power during lap
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgLevMotorPower(void) const
    {
        return GetFieldUINT16Value(115, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_lev_motor_power field
    // Units: watts
    // Comment: lev average motor power during lap
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLevMotorPower(FIT_UINT16 avgLevMotorPower)
    {
        SetFieldUINT16Value(115, avgLevMotorPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_lev_motor_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxLevMotorPowerValid() const
    {
        const Field* field = GetField(116);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_lev_motor_power field
    // Units: watts
    // Comment: lev maximum motor power during lap
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxLevMotorPower(void) const
    {
        return GetFieldUINT16Value(116, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_lev_motor_power field
    // Units: watts
    // Comment: lev maximum motor power during lap
    ///////////////////////////////////////////////////////////////////////
    void SetMaxLevMotorPower(FIT_UINT16 maxLevMotorPower)
    {
        SetFieldUINT16Value(116, maxLevMotorPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of lev_battery_consumption field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLevBatteryConsumptionValid() const
    {
        const Field* field = GetField(117);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns lev_battery_consumption field
    // Units: percent
    // Comment: lev battery consumption during lap
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLevBatteryConsumption(void) const
    {
        return GetFieldFLOAT32Value(117, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set lev_battery_consumption field
    // Units: percent
    // Comment: lev battery consumption during lap
    ///////////////////////////////////////////////////////////////////////
    void SetLevBatteryConsumption(FIT_FLOAT32 levBatteryConsumption)
    {
        SetFieldFLOAT32Value(117, levBatteryConsumption, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_vertical_ratio field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgVerticalRatioValid() const
    {
        const Field* field = GetField(118);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_vertical_ratio field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgVerticalRatio(void) const
    {
        return GetFieldFLOAT32Value(118, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_vertical_ratio field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgVerticalRatio(FIT_FLOAT32 avgVerticalRatio)
    {
        SetFieldFLOAT32Value(118, avgVerticalRatio, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stance_time_balance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStanceTimeBalanceValid() const
    {
        const Field* field = GetField(119);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stance_time_balance field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStanceTimeBalance(void) const
    {
        return GetFieldFLOAT32Value(119, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stance_time_balance field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStanceTimeBalance(FIT_FLOAT32 avgStanceTimeBalance)
    {
        SetFieldFLOAT32Value(119, avgStanceTimeBalance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_step_length field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStepLengthValid() const
    {
        const Field* field = GetField(120);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_step_length field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStepLength(void) const
    {
        return GetFieldFLOAT32Value(120, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_step_length field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStepLength(FIT_FLOAT32 avgStepLength)
    {
        SetFieldFLOAT32Value(120, avgStepLength, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_vam field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgVamValid() const
    {
        const Field* field = GetField(121);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_vam field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgVam(void) const
    {
        return GetFieldFLOAT32Value(121, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_vam field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgVam(FIT_FLOAT32 avgVam)
    {
        SetFieldFLOAT32Value(121, avgVam, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgDepthValid() const
    {
        const Field* field = GetField(122);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgDepth(void) const
    {
        return GetFieldFLOAT32Value(122, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    void SetAvgDepth(FIT_FLOAT32 avgDepth)
    {
        SetFieldFLOAT32Value(122, avgDepth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxDepthValid() const
    {
        const Field* field = GetField(123);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxDepth(void) const
    {
        return GetFieldFLOAT32Value(123, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    void SetMaxDepth(FIT_FLOAT32 maxDepth)
    {
        SetFieldFLOAT32Value(123, maxDepth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinTemperatureValid() const
    {
        const Field* field = GetField(124);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetMinTemperature(void) const
    {
        return GetFieldSINT8Value(124, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetMinTemperature(FIT_SINT8 minTemperature)
    {
        SetFieldSINT8Value(124, minTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_avg_respiration_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedAvgRespirationRateValid() const
    {
        const Field* field = GetField(136);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_avg_respiration_rate field
    // Units: Breaths/min
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedAvgRespirationRate(void) const
    {
        return GetFieldFLOAT32Value(136, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_avg_respiration_rate field
    // Units: Breaths/min
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedAvgRespirationRate(FIT_FLOAT32 enhancedAvgRespirationRate)
    {
        SetFieldFLOAT32Value(136, enhancedAvgRespirationRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_max_respiration_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedMaxRespirationRateValid() const
    {
        const Field* field = GetField(137);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_max_respiration_rate field
    // Units: Breaths/min
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedMaxRespirationRate(void) const
    {
        return GetFieldFLOAT32Value(137, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_max_respiration_rate field
    // Units: Breaths/min
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedMaxRespirationRate(FIT_FLOAT32 enhancedMaxRespirationRate)
    {
        SetFieldFLOAT32Value(137, enhancedMaxRespirationRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_respiration_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRespirationRateValid() const
    {
        const Field* field = GetField(147);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_respiration_rate field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgRespirationRate(void) const
    {
        return GetFieldUINT8Value(147, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_respiration_rate field
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRespirationRate(FIT_UINT8 avgRespirationRate)
    {
        SetFieldUINT8Value(147, avgRespirationRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_respiration_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxRespirationRateValid() const
    {
        const Field* field = GetField(148);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_respiration_rate field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxRespirationRate(void) const
    {
        return GetFieldUINT8Value(148, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_respiration_rate field
    ///////////////////////////////////////////////////////////////////////
    void SetMaxRespirationRate(FIT_UINT8 maxRespirationRate)
    {
        SetFieldUINT8Value(148, maxRespirationRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_grit field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalGritValid() const
    {
        const Field* field = GetField(149);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_grit field
    // Units: kGrit
    // Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalGrit(void) const
    {
        return GetFieldFLOAT32Value(149, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_grit field
    // Units: kGrit
    // Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
    ///////////////////////////////////////////////////////////////////////
    void SetTotalGrit(FIT_FLOAT32 totalGrit)
    {
        SetFieldFLOAT32Value(149, totalGrit, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_flow field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFlowValid() const
    {
        const Field* field = GetField(150);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_flow field
    // Units: Flow
    // Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalFlow(void) const
    {
        return GetFieldFLOAT32Value(150, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_flow field
    // Units: Flow
    // Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFlow(FIT_FLOAT32 totalFlow)
    {
        SetFieldFLOAT32Value(150, totalFlow, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of jump_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsJumpCountValid() const
    {
        const Field* field = GetField(151);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns jump_count field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetJumpCount(void) const
    {
        return GetFieldUINT16Value(151, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set jump_count field
    ///////////////////////////////////////////////////////////////////////
    void SetJumpCount(FIT_UINT16 jumpCount)
    {
        SetFieldUINT16Value(151, jumpCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_grit field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgGritValid() const
    {
        const Field* field = GetField(153);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_grit field
    // Units: kGrit
    // Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgGrit(void) const
    {
        return GetFieldFLOAT32Value(153, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_grit field
    // Units: kGrit
    // Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgGrit(FIT_FLOAT32 avgGrit)
    {
        SetFieldFLOAT32Value(153, avgGrit, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_flow field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgFlowValid() const
    {
        const Field* field = GetField(154);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_flow field
    // Units: Flow
    // Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgFlow(void) const
    {
        return GetFieldFLOAT32Value(154, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_flow field
    // Units: Flow
    // Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgFlow(FIT_FLOAT32 avgFlow)
    {
        SetFieldFLOAT32Value(154, avgFlow, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fractional_ascent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFractionalAscentValid() const
    {
        const Field* field = GetField(156);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fractional_ascent field
    // Units: m
    // Comment: fractional part of total_ascent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalFractionalAscent(void) const
    {
        return GetFieldFLOAT32Value(156, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fractional_ascent field
    // Units: m
    // Comment: fractional part of total_ascent
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFractionalAscent(FIT_FLOAT32 totalFractionalAscent)
    {
        SetFieldFLOAT32Value(156, totalFractionalAscent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fractional_descent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFractionalDescentValid() const
    {
        const Field* field = GetField(157);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fractional_descent field
    // Units: m
    // Comment: fractional part of total_descent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalFractionalDescent(void) const
    {
        return GetFieldFLOAT32Value(157, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fractional_descent field
    // Units: m
    // Comment: fractional part of total_descent
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFractionalDescent(FIT_FLOAT32 totalFractionalDescent)
    {
        SetFieldFLOAT32Value(157, totalFractionalDescent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_core_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCoreTemperatureValid() const
    {
        const Field* field = GetField(158);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgCoreTemperature(void) const
    {
        return GetFieldFLOAT32Value(158, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCoreTemperature(FIT_FLOAT32 avgCoreTemperature)
    {
        SetFieldFLOAT32Value(158, avgCoreTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_core_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinCoreTemperatureValid() const
    {
        const Field* field = GetField(159);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinCoreTemperature(void) const
    {
        return GetFieldFLOAT32Value(159, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetMinCoreTemperature(FIT_FLOAT32 minCoreTemperature)
    {
        SetFieldFLOAT32Value(159, minCoreTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_core_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxCoreTemperatureValid() const
    {
        const Field* field = GetField(160);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxCoreTemperature(void) const
    {
        return GetFieldFLOAT32Value(160, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetMaxCoreTemperature(FIT_FLOAT32 maxCoreTemperature)
    {
        SetFieldFLOAT32Value(160, maxCoreTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_LAP_MESG_HPP)
