/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @summary Make sure pageSize() returns a value that is a power of two
 * @library /testlibrary
 * @modules java.base/jdk.internal.misc
 *          java.management
 * @run main PageSize
 */

import java.lang.reflect.Field;
import jdk.test.lib.*;
import sun.misc.Unsafe;
import static jdk.test.lib.Asserts.*;

public class PageSize {
    public static void main(String args[]) throws Exception {
        Unsafe unsafe = Utils.getUnsafe();
        int pageSize = unsafe.pageSize();

        for (int n = 1; n != 0; n <<= 1) {
            if (pageSize == n) {
                return;
            }
        }
        throw new RuntimeException("Expected pagesize to be a power of two, actual pagesize:" + pageSize);
    }
}
