/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <GTLCore/String.h>

#ifdef LLVM_27_OR_28
#include <llvm/System/TimeValue.h>
#else
#include <llvm/Support/TimeValue.h>
#endif

namespace shivanimator {
  class ProgressBar {

  public:

    ProgressBar(GTLCore::String title, unsigned int cptMax, unsigned int barWidth = 60);
    ~ProgressBar();

    void next();

  private:

    unsigned int m_barWidth;
    unsigned int m_cpt, m_cptMax;
    GTLCore::String m_title;
    llvm::sys::TimeValue m_time;

    void bar();

  }; // class ProgressBar
}
