/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "OpenDRIM_TCPProtocolEndpointAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_TCPProtocolEndpoint";
const string name = "IP Interface";
string systemName;

int SSH_OpenDRIM_TCPProtocolEndpoint_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_TCPProtocolEndpoint>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	//Initialize an instance
	OpenDRIM_TCPProtocolEndpoint instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);
	instance.setName(name);

	if (discriminant == "ei")
		CF_assert (SSH_OpenDRIM_TCPProtocolEndpoint_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_TCPProtocolEndpoint& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName == systemCreationClassName &&
			instance.CreationClassName == creationClassName &&
			instance.SystemName == systemName &&
			instance.Name == name)
	{
		CF_assert(SSH_OpenDRIM_TCPProtocolEndpoint_populate(instance, errorMessage));
	}
	else
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& newInstance, const OpenDRIM_TCPProtocolEndpoint& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, unsigned int& returnValue, const OpenDRIM_TCPProtocolEndpoint_RequestStateChange_In& in, OpenDRIM_TCPProtocolEndpoint_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_BroadcastReset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_TCPProtocolEndpoint_populate(OpenDRIM_TCPProtocolEndpoint& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName [KEY]
	 * [X] CreationClassName       [KEY]
	 * [X] SystemName              [KEY]
	 * [X] Name                    [KEY]
	 * [X] NameFormat
	 * [X] ProtocalIFType
	 * [X] ElementName
	 * [X] PortNumber
	 * + Other:
	 * [X] TimeOfLastStateChange
	 * [X] EnabledDefault
	 */
	
	instance.setNameFormat("network-interface-name");
	instance.setProtocolIFType(IFTYPE_TCP);

	if (instance.ProtocolIFType == IFTYPE_TCP)
		instance.setElementName("IP interface bound to a SSH session or service");

	string portNum;
	unsigned long number = 22;

	CF_getConfigItem("Port", portNum, errorMessage);

	if (strlen(portNum.c_str()) != 0)
		number = strtoul(portNum.c_str(), NULL, 10);

	instance.setPortNumber(number);
	instance.setEnabledDefault(ED_ENABLE);

	//TimeOfLastStateChange
	string modifiedTime;
	CF_assert(CF_lastModified(SSH_CONFIG_FILE, modifiedTime, errorMessage));
	instance.setTimeOfLastStateChange(modifiedTime);
	_L_;
	return OK;
}

