/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_BootOSFromFSAccess.h"

int OS_OpenDRIM_BootOSFromFS_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(OS_CIM_FileSystem_load(broker, errorMessage));
	 CF_assert(OS_OpenDRIM_OperatingSystem_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(OS_CIM_FileSystem_unload(errorMessage));
	 CF_assert(OS_OpenDRIM_OperatingSystem_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_isAssociated(const Instance& Antecedent, const Instance& Dependent, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootOSFromFS>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateAntecedents(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateAntecedents(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		OS_OpenDRIM_BootOSFromFS_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Antecedent_classnames[0], Dependent_classnames[0],
			Antecedent_role.c_str(), Dependent_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(OS_OpenDRIM_BootOSFromFS_referenceAntecedentToDependent(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootOSFromFS& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Antecedent_objectpath;
	instance.getAntecedent(Antecedent_objectpath);
	Instance Antecedent_instance;
	CF_assert(OS_OpenDRIM_BootOSFromFS_getAntecedent(broker, ctx, Antecedent_objectpath, Antecedent_instance, NULL, errorMessage));
	
	Objectpath Dependent_objectpath;
	instance.getDependent(Dependent_objectpath);
	Instance Dependent_instance;
	CF_assert(OS_OpenDRIM_BootOSFromFS_getDependent(broker, ctx, Dependent_objectpath, Dependent_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(OS_OpenDRIM_BootOSFromFS_isAssociated(Antecedent_instance, Dependent_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOSFromFS& newInstance, const OpenDRIM_BootOSFromFS& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_BootOSFromFS_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOSFromFS& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_BootOSFromFS_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOSFromFS& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_BootOSFromFS_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Dependent_instances;
	if (discriminant=="a")
		CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateDependents(broker, ctx, Dependent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateDependents(broker, ctx, Dependent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateDependents(broker, ctx, Dependent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Dependent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(OS_OpenDRIM_BootOSFromFS_isAssociated(Antecedent_instance, Dependent_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			Dependent_associatedInstances.push_back(Dependent_instances[i]);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Antecedent_instances;
	if (discriminant=="a")
		CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateAntecedents(broker, ctx, Antecedent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateAntecedents(broker, ctx, Antecedent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(OS_OpenDRIM_BootOSFromFS_enumerateAntecedents(broker, ctx, Antecedent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Antecedent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(OS_OpenDRIM_BootOSFromFS_isAssociated(Antecedent_instances[i], Dependent_instance, isAssociated, errorMessage));
		if (isAssociated)
			Antecedent_associatedInstances.push_back(Antecedent_instances[i]);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_BootOSFromFS>& OpenDRIM_BootOSFromFS_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Dependent_instances.size(); i++) {
		OpenDRIM_BootOSFromFS instance;
		instance.setAntecedent(((Instance) Antecedent_instance).getObjectpath());
		instance.setDependent(((Instance) Dependent_instances[i]).getObjectpath());
		
		OpenDRIM_BootOSFromFS_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_BootOSFromFS>& OpenDRIM_BootOSFromFS_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Antecedent_instances.size(); i++) {
		OpenDRIM_BootOSFromFS instance;
		instance.setAntecedent(((Instance) Antecedent_instances[i]).getObjectpath());
		instance.setDependent(((Instance) Dependent_instance).getObjectpath());
		
		OpenDRIM_BootOSFromFS_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_BootOSFromFS_populate(OpenDRIM_BootOSFromFS& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

