/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_BootSourceSettingAccess.h"

vector<string> InstanceID;

int Boot_OpenDRIM_BootSourceSetting_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	vector<string> output;
	
	CF_assert(CF_runCommandToLines("ls -1 /dev", output, 0, errorMessage));
	
	// FIXME: to improve
	for(unsigned int i=0;i<output.size();i++)
	{
		stringstream id(stringstream::in | stringstream::out);
		string line=output[i];
		
		if(line.length()>2 && line.find("fd")==0)
			id << "Floppy Drive " << atoi(line.substr(2).c_str());
		else if(line.length()>3 && line.find("scd")==0)
			id << "CD_ROM Drive " << atoi(line.substr(3).c_str());
		else if(line.length()==3 && (line.find("hd")==0 || line.find("sd")==0))
			id << "Hard Drive " << *line.substr(2).c_str()-'a';
		
		if(!id.str().empty()) InstanceID.push_back(id.str());
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootSourceSetting_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootSourceSetting_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootSourceSetting>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	for(unsigned int i=0;i<InstanceID.size();i++)
	{
		OpenDRIM_BootSourceSetting instance;
		instance.setInstanceID(InstanceID[i]);
	
		if(discriminant=="ei")
			CF_assert(Boot_OpenDRIM_BootSourceSetting_populate(instance,errorMessage));
	
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootSourceSetting_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootSourceSetting& instance, const char** properties, string& errorMessage) {
	_E_;
	vector<string>::size_type index;
	
	if(!CF_foundInList(instance.InstanceID, InstanceID, index))
	{
		errorMessage="No instance";
		return NOT_FOUND;
	}
	
	CF_assert(Boot_OpenDRIM_BootSourceSetting_populate(instance,errorMessage));
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootSourceSetting_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootSourceSetting& newInstance, const OpenDRIM_BootSourceSetting& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootSourceSetting_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootSourceSetting& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootSourceSetting_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootSourceSetting& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootSourceSetting_populate(OpenDRIM_BootSourceSetting& instance, string& errorMessage) {
	_E_;
	instance.setElementName(instance.InstanceID.substr(0,instance.InstanceID.find("Drive")+5)+" source setting");
	instance.setFailThroughSupported(1); // Is Supported
	_L_;
	return OK;
}

